/*______________________SOUND_FILE_C_______________________*/
/*__________audio i/o_handling_source_file_for_CERES3_________*/
/* CERES:  A combination of FFT and granular synthesis***********/ 
/* CERES2: contains modifications done at Columbia University****/
/* CERES3: CERES2 with enhanced editing *************************/
 
/*_v: 0.27a13*/
/*
-----------------------------------
source-files: ceres3.c, sound_file.c
-----------------------------------
*/
#include <stdlib.h>
#include <stdio.h>



int  setup_infile(void);
void rd_open_soundfile(char* name, int fd);
int  wr_open_soundfile(char* name, int fd);
int  rd_shiftin(float A[], int  N, int  D, short *frms, int s_p_f,char *name, 
		int fd, int *si_valid, int stereo_channel);
int  rdl_shiftin(float A[], int  N, int  D, long *frmes, int s_p_f, int b_p_s,
		char *name, int fd, int *si_valid, int stereo_channel);
int  rd_frames(char *name,int fd, short *frames, short D);
int  rdl_frames(char *name,int fd, long *frmes, int b_p_s, short D);
void close_soundfile(char* name, int fd, char type);
int  tst_open_soundfile(char* name, int fd);
int  wr_shiftout(float A[],int N,int I,int n, short *framebuf, char *name, int fd);
int  wr_frames(char *name,int fd, short *frames, short I);
int  wrl_frames(char *name,int fd, long *frames,int b_p_s, short I);
int  init_live(int size);
void shiftout_live(float *output, int Nw, int  I, int I_I, int on);
void close_live(void);



#ifndef LIBSNDFILE

#ifdef SGI
#include <dmedia/audiofile.h>
#include <dmedia/audio.h>
static  ALconfig out_c;
static  ALport out_port;
void shiftout_to_port(float A[], int  N, int I, int  Ii, int  n, ALport port);
#elif POWERPC
#include <DPTich_linux_audiofile.h>	/*tichstuff-ppc*/
#else 					
#include <audiofile.h>				/*tichstuff-ix86*/
#ifdef SGI_LIBAUDIOFILE
#define AFclosefile afCloseFile
#define AFgetchannels afGetChannels
#define AFgetcompression afGetCompression
#define AFgetfilefmt afGetFileFormat
#define AFgetframecnt afGetFrameCount
#define AFgetrate afGetRate
#define AFgetsampfmt afGetSampleFormat
#define AFinitchannels afInitChannels
#define AFinitcompression afInitCompression
#define AFinitfilefmt afInitFileFormat
#define AFinitrate afInitRate
#define AFinitsampfmt afInitSampleFormat
#define AFnewfilesetup afNewFileSetup
#define AFopenfile afOpenFile
#define AFreadframes afReadFrames
#define AFwriteframes afWriteFrames
#endif /* SGI_LIBAUDIOFILE*/
#endif /* SGI */

#ifdef MACOSX
#include "macosx_audio.h"
	AudioDeviceID audioport;
	int fragments;
	int buf_frames;
	int status;
	int sampsread, chnls, srate, t, numfram, i;
	extern short Soundfile_Create (const char*);
	extern short Soundfile_Delete (const char*);
void shiftout_to_port(float A[], int  N, int I, int  Ii, int  n, AudioDeviceID port);
#endif /* MACOSX */

static AFfilehandle infile,  outfile;
static AFfilesetup in_AFsetup,  out_AFsetup;	
AFfilehandle af_wr_open_soundfile(char* name, int fd);	

int audiofile_readInfo(int *s_p_f, int *R, int *fil_fmt, int *smp_t, int *bps,
	long *frmcnt, char* nam,  AFfilesetup a);	

static long compression;
int *vers;

#else   /* IF LIBSNDFILE */
#include <sndfile.h>
      typedef struct
       {    int      samplerate ;
            int      samples ;
            int      channels ;
            int      pcmbitwidth ;
            int      format ;
            int      sections ;
            int      seekable ;
        } SF_INFO ;

SF_INFO in_sfinfo, out_sfinfo;
static SNDFILE* infile;
static SNDFILE* outfile;

int sndfile_readInfo(int *s_p_f, int *R, int *fil_fmt, int *smp_t, int *bps,
	long *frmcnt, char* nam, int fd);	
#endif /*!LIBSNDFILE*/


int  setup_outfile(int s_p_f,int R,  int filefmt, int samp_type,int bits_per_samp);
void hack_soundinfo(int *s_p_f, int *R,  int *filefmt, int *smp_t, int *bps,
	long *frmcnt, float *dur_sec);
int reach_soundfile(int *s_p_f, int *R, int *filefmt, int *smp_t, int *bps,
	long *frmcnt, char* nam,  int fd);



/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

void hack_soundinfo(int *samps_per_frame, int *R, /*long *compression,*/
	int *filefmt, int *samp_type, int *bits_per_samp,long *framecnt,
	float *dur_in_secs)
{

  *samps_per_frame   = 1;/**/
/*  *R                 = 44100;*/
/*  *compression       = AF_COMPRESSION_NONE;*//*0*/
  *filefmt           = 2;/*AF_FILE_AIFF*/
  *bits_per_samp     = 16;/**/
  if(framecnt != NULL)
  if(dur_in_secs != NULL) *framecnt = (long)((*dur_in_secs)*(*R))+1;/**/
  if(samp_type != NULL)  *samp_type = 401/*AF_SAMPFMT_TWOSCOMP*/;

}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

int setup_infile(void)
{
/*get the name, params, test the file, get the handle, without
	returning it
	return fd if ok, else - error code
  */
return 0;
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
/*OK*/
int reach_soundfile(int *samps_per_frame, int *R, /*long *compression,*/
	int *filefmt, int *samp_type, /*int * vers,*/ int *bits_per_samp,long 
	*framecnt, char* filename, int fd)
{
#ifndef LIBSNDFILE
AFfilesetup setup = AF_NULL_FILESETUP;

printf("SF: \n");
printf("Attempting to reach %s\n",filename);
if(audiofile_readInfo(samps_per_frame, R, 
	filefmt, samp_type, bits_per_samp, 
	framecnt, filename, setup) == 0)return 0;
#else
if(sndfile_readInfo(samps_per_frame, R, 
	filefmt, samp_type, bits_per_samp, 
	framecnt, filename, fd) == 0)return 0;
#endif /*  !LIBSNDFILE */
return 1;
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
int  setup_outfile(int s_p_f,int R, /*long compr,*/ int filefmt, 
	 int samp_type,int bits_per_samp)
{
  if(filefmt == 0)filefmt = 2;
#ifndef LIBSNDFILE
  out_AFsetup=AFnewfilesetup();
  AFinitchannels(out_AFsetup, AF_DEFAULT_TRACK, 1);  /* Mono out */
  AFinitrate(out_AFsetup, AF_DEFAULT_TRACK, R);
  AFinitcompression(out_AFsetup, AF_DEFAULT_TRACK, 0/*AF_COMPRESSION_NONE*/);

#ifdef SGI
  AFinitfilefmt(out_AFsetup, filefmt);
  AFinitsampfmt(out_AFsetup, AF_DEFAULT_TRACK, samp_type, bits_per_samp);
#elif SGI_LIBAUDIOFILE
  AFinitfilefmt(out_AFsetup, filefmt);
  AFinitsampfmt(out_AFsetup, AF_DEFAULT_TRACK, samp_type, bits_per_samp);  
#else
  AFinitfilefmt(out_AFsetup, (long)filefmt);
  AFinitsampfmt(out_AFsetup, AF_DEFAULT_TRACK, (long)samp_type, (long)bits_per_samp);
#endif /* SGI */
#else  /* if LIBSNDFILE */
out_sfinfo.channels = s_p_f;
out_sfinfo.format = SF_FORMAT_AIFF;
out_sfinfo.pcmbitwidth = bits_per_samp;
#endif /* LIBSNDFILE */
return 1;
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
#ifndef LIBSNDFILE
int audiofile_readInfo(int *samps_per_frame, int *R, /*long *compression,*/
	int *filefmt, int *samp_type, /*int * vers,*/ int *bits_per_samp,long 
	*framecnt, char* filename, AFfilesetup in_AFsetup)	
{
int fmt;
# ifdef SGI_LIBAUDIOFILE
int s, b;
#else
long s, b;
#endif

AFfilehandle infile;
infile=AFopenfile(filename, "r", in_AFsetup);

if(infile == AF_NULL_FILEHANDLE){printf("NULL FILE\n");
return 0;}
  *samps_per_frame   = AFgetchannels(infile, AF_DEFAULT_TRACK);
  *R                 = (int)AFgetrate(infile, AF_DEFAULT_TRACK);
   compression       = AFgetcompression(infile, AF_DEFAULT_TRACK);
  *framecnt          = AFgetframecnt(infile,  AF_DEFAULT_TRACK);
#ifdef SGI
  *filefmt           = AFgetfilefmt(infile, vers);/**/
  AFgetsampfmt(infile, AF_DEFAULT_TRACK, samp_type, bits_per_samp);/**/
#else
/*printf("non-sgi system:\n");*/
  fmt				 = AFgetfilefmt(infile, &b);
  *filefmt           = (int)(fmt);/**/
  printf("|");
 /* *vers = (int)(b);*/
  printf("|");
  AFgetsampfmt(infile, AF_DEFAULT_TRACK, &s, &b);/**/
  printf("|");
  *samp_type = (int)(s);/* */ *bits_per_samp = (int)(b);
/*
  printf("Samples per frame: %d\n",*samps_per_frame);
  printf("Sampling Rate    : %d\n",*R);
  printf("Compression      : %d\n",compression);
  printf("Frame Count      : %d\n",*framecnt);
  printf("Vers             : %d\n",*vers);
  printf("Sample Type      : %d\n",*samp_type);
*/  printf("Bits per Sample  : %d\n",*bits_per_samp);

#endif /* ELSE */
AFclosefile(infile);
printf("AF_HANDLE: OK\n");
return 1;
}
#endif /*!LIBSNDFILE*/
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
#ifdef LIBSNDFILE
int sndfile_readInfo(int *s_p_f, int *R, int *fil_fmt, int *smp_t, int *bps,
	long *frmcnt, char* name, int fd)
{

*fil_fmt = -1;

if((infile = sf_open_read(name, &sfinfo) != (SNDFILE*)NULL){
	*bps   = in_sfinfo.pcmbitwidth;
	*frmcnt= (long)(in_sfinfo.samples);
	*s_p_f = in_sfinfo.channels;
	switch(in_sfinfo.format){
		case SF_FORMAT_AIFF: *fil_fmt = 2; break;
		case SF_FORMAT_WAV:  *fil_fmt = 4; break;
		case SF_FORMAT_AU:   *fil_fmt = 3; break;
		default: break;
		}
	sf_close(infile) ;
	}
/*
int chans;
off_t samples;
mus_sound_initialize();
fd = mus_file_open_read(name);
if (fd == -1)return 0;

*R = mus_sound_srate(name);
samples = mus_sound_samples(name);
*s_p_f= chans;
*frmcnt = mus_sound_frames(name);

*bps = mus_sound_bits_per_sample(name);
mus_sound_header_type(name);
mus_sound_data_format (name); 
*/
/*smp_t  AF_SAMPFMT_TWOSCOMP*/
/*
MUS_DATA_FORMAT_OK  MUS_BINT
MUS_HEADER_TYPE_OK   MUS_AIFF
*/
return 1;
}
#endif  /* LIBSNDFILE */
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
int rd_shiftin(float A[], int  N, int  D, short *frames, int samps_per_frame, 
	char *name, int fd, int *si_valid, int stereo)
{
    int i;
    float *Aptr = A;
	float a;
	int sampsread;
    if (*si_valid<0) *si_valid=N;
    i = N-D;
    while (i--) {
      *Aptr = *(Aptr+D);
      Aptr++;
    }
    if (*si_valid==N) {
    printf("*");
/*-*/
      sampsread=rd_frames(name, fd, frames, D);
/*-*/

      if (samps_per_frame==1) {
        *si_valid = sampsread+N-D;
        while(sampsread--) *(Aptr++) = (float) *(frames++) / 32768.0;
      } else {
      /*sampsread /= 2; */
        *si_valid = sampsread+N-D;
		if(stereo == 1)
        while(sampsread--){ 
			*(Aptr++) = (float)  *(frames++) / 32768.0;
			frames++;
			a = *(Aptr);
			}
		if(stereo == 2)
        while(sampsread--){ 
			frames++;
			*(Aptr++) = (float)  *(frames++) / 32768.0;
			a = *(Aptr);
			}
		if(stereo == 3)
        while(sampsread--){ *(Aptr++) = (float) (*(frames++) + *(frames++)) 
			/ 65536.0;
			a = *(Aptr);
			}
      }
    }
    if (*si_valid<N) {
        for (i= *si_valid; i<N; i++) A[i]=0.;
        *si_valid-=D;
    }
    return (*si_valid<=0);
}

/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
int rdl_shiftin(float A[], int  N, int  D, long *frames, int samps_per_frame, 
	int bits_per_sample, char *name, int fd, int *si_valid, int stereo)
{
    int i;
    float *Aptr = A;
	float a;
	int sampsread;
    if (*si_valid<0) *si_valid=N;
    i = N-D;
    
/*    printf("LONG\n");*/
    while (i--) {
      *Aptr = *(Aptr+D);
      Aptr++;
    }
    if (*si_valid==N) {
/*-*/
      sampsread=rdl_frames(name, fd, frames, bits_per_sample, D);
/*-*/
	if(bits_per_sample==24){
      if (samps_per_frame==1) {
        *si_valid = sampsread+N-D;
#ifdef SGI
        while(sampsread--) *(Aptr++) = (float) *(frames++) / 8388608.0;
#else
        while(sampsread--) *(Aptr++) = (float) *(frames++) / 2147483647.;
#endif
      } else {
        *si_valid = sampsread+N-D;
		if(stereo == 1)
        while(sampsread--){ 
			*(Aptr++) = (float)  *(frames++) / 8388608.0;
			frames++;
			a = *(Aptr);
			}
		if(stereo == 2)
        while(sampsread--){ 
			frames++;
			*(Aptr++) = (float)  *(frames++) / 8388608.0;
			a = *(Aptr);
			}
		if(stereo == 3)
        while(sampsread--){ *(Aptr++) = (float) (*(frames++) + *(frames++)) 
			/ 16777216.0;
			a = *(Aptr);
			}
        }
	}else{
      if (samps_per_frame==1) {
        *si_valid = sampsread+N-D;
        while(sampsread--) *(Aptr++) = (float) *(frames++) / 2147483647.;
      } else {
        *si_valid = sampsread+N-D;
		if(stereo == 1)
        while(sampsread--){ 
			*(Aptr++) = (float)  *(frames++) / 2147483647.;
			frames++;
			a = *(Aptr);
			}
		if(stereo == 2)
        while(sampsread--){ 
			frames++;
			*(Aptr++) = (float)  *(frames++) / 2147483647.;
			a = *(Aptr);
			}
		if(stereo == 3)
        while(sampsread--){ *(Aptr++) = (float) (*(frames++) + *(frames++)) 
			/ 4294967294.;
			a = *(Aptr);
			}
        }
	}

    }
    if (*si_valid<N) {
        for (i= *si_valid; i<N; i++) A[i]=0.;
        *si_valid-=D;
    }
    return (*si_valid<=0);
}


/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void rd_open_soundfile(char* name, int fd)
{
#ifdef LIBSNDFILE
;
#else
infile=AFopenfile(name, "r", in_AFsetup);
#endif  /* !LIBSNDFILE */
}

/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

int tst_open_soundfile(char* name, int fd)
{
#ifdef LIBSNDFILE
;
#else
AFfilehandle testfile;
testfile=AFopenfile(name, "r", out_AFsetup);
if(testfile != NULL){
AFclosefile(testfile);
return 1;
}
return 0;
#endif /* !LIBSNDFILE */
}

/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

int wr_open_soundfile(char* name, int fd)
{
#ifdef LIBSNDFILE
;
#else
int miscids [2];
int nmisc = 1;
int chunkID;
void *buf;
//AF_MISC_APPL
if((outfile=AFopenfile(name, "w", out_AFsetup))==NULL)return 0;
//afInitMiscIDs(out_AFsetup, int miscids[], int nmisc);
//afInitMiscType(out_AFsetup, int chunkid, AF_MISC_APPL);//for AIFF(C)
//afWriteMisc (outfile, int miscid, void *buf, int bytes);
#endif  /* !LIBSNDFILE */
return 1;
}

/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
#ifndef LIBSNDFILE
AFfilehandle af_wr_open_soundfile(char* name, int fd)
{

outfile=AFopenfile(name, "w", out_AFsetup);

return outfile;
}
#endif  /* !LIBSNDFILE */
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
int wr_shiftout(float A[],int N,int I,int n, short *framebuff, char *name, int fd)
{
    int i;
    if (n>=0) {
      for (i=0; i<I; i++) *(framebuff+i)=(short)(A[i]*32767.);
/*-*/
     wr_frames (name, fd, framebuff, I);
/*-*/
    }
    for (i=0; i<N-I; i++) A[i]=A[i+I];
    for (i=N-I; i<N; i++) A[i]=0.;

return 0;
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
int wrl_shiftout(float A[],int N,int I,int n, long *framebuff32, 
	int b_p_s, char *name, int fd)
{
    int i;
    if (n>=0) {
	  if (b_p_s == 24)
        for (i=0; i<I; i++) *(framebuff32+i)=(long)(A[i]*8388608.);
	  if (b_p_s == 32)
        for (i=0; i<I; i++) *(framebuff32+i)=(long)(A[i]*2147483647.);
/*-*/
     wrl_frames (name, fd, framebuff32, b_p_s, I);
/*-*/
    }
    for (i=0; i<N-I; i++) A[i]=A[i+I];
    for (i=N-I; i<N; i++) A[i]=0.;

return 0;
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
int wr_frames(char *name,int fd, short *framebuff, short I)
{
#ifdef LIBSNDFILE
;
#else
AFwriteframes(outfile, AF_DEFAULT_TRACK, framebuff, I);
#endif /* !LIBSNDFILE */
}

/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
int wrl_frames(char *name,int fd, long *framebuff32, int b_p_s, short I)
{
#ifdef LIBSNDFILE

#else
AFwriteframes(outfile, AF_DEFAULT_TRACK, framebuff32, I);
#endif
}

/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
int rd_frames(char *name,int fd, short *frames, short D)
{
#ifdef LIBSNDFILE
;
#else
/*printf("#");*/
return AFreadframes(infile, AF_DEFAULT_TRACK, frames, D);
#endif /* !LIBSNDFILE */
}

/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
int rdl_frames(char *name,int fd, long *frms, int bps, short D)
{
#ifdef LIBSNDFILE
return 0;
#else
return AFreadframes(infile, AF_DEFAULT_TRACK, frms, D);
#endif /* !LIBSNDFILE */
}


/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void close_soundfile(char* name, int fd, char type)
{
#ifdef LIBSNDFILE
return;
#endif/* !LIBSNDFILE */

if( type == 'i')	AFclosefile(infile);
if( type == 'o'){
	AFclosefile(outfile);
	}
}

/*_____________________________________________________________________*/
#ifndef LIBSNDFILE

#ifdef  SGI
int  init_live(int I_I)
{
  out_c = alNewConfig();
  alSetQueueSize(out_c, I_I);
  alSetSampFmt(out_c,AL_SAMPFMT_FLOAT);
  alSetChannels(out_c, 1);
  out_port =  alOpenPort("Ceres3 Preview", "w", out_c);
 if(!out_port){
	printf("Couldn't open output port: %s\n",alGetErrorString(oserror()));
	return 0;
	}
	return 1;
}
/*_____________________________________________________________________*/
void shiftout_live(float *output, int Nw, int  I, int I_I, int on)
{
shiftout_to_port(output, Nw, I, I_I, on, out_port);
}
/*_____________________________________________________________________*/
void shiftout_to_port(float A[], int  N, int I, int  Ii, int  n, ALport port)
{
    int i, i2;
	
    if (n>=0)  alWriteFrames(port,  A, I);
    
    for (i=0; i<N-Ii; i++) A[i]=A[i+Ii];
    for (i=N-Ii; i<N; i++) A[i]=0.;
}
/*_____________________________________________________________________*/
void close_live(void)
{
int j;
  j = alClosePort(out_port);
  j = alFreeConfig(out_c);
}
/*_____________________________________________________________________*/
/* END SGI */
#elif MACOSX
int  init_live(int I_I)
{

fragments = I_I*ROBUST_FACTOR;
buf_frames = I_I;
chnls = 2;
	status = open_macosx_ports(0, chnls, NULL, &audioport, VERBOSE,
		(float)srate, fragments, &buf_frames);

printf("MacOSX audio port open\n");
return 0;
}
/*_____________________________________________________________________*/
void shiftout_live(float *output, int Nw, int  I, int I_I, int on)
{
shiftout_to_port(output, Nw, I, I_I, on, audioport);
}
/*_____________________________________________________________________*/
void shiftout_to_port(float A[], int  N, int I, int  Ii, int  n, AudioDeviceID port)
{
    int i, i2;
	
    if (n>=0)  for(i2 = 0; i2 < I ; i2++)macosx_cmixplay_audio_write((short*)A);
    
    for (i=0; i<N-Ii; i++) A[i]=A[i+Ii];
    for (i=N-Ii; i<N; i++) A[i]=0.;
}

/*_____________________________________________________________________*/
void close_live(void)
{

	macosx_audio_stop(audioport);
	printf("MacOSX audio stopped\n");
	
return;
}
/*_____________________________________________________________________*/
#else  /* !SGI !MACOSX */
int  init_live(int I_I)
{
printf("Preview not implemented on this platform\n");
return 0;
}
/*_____________________________________________________________________*/
void shiftout_live(float *output, int Nw, int  I, int I_I, int on)
{
return;
}

/*_____________________________________________________________________*/
void close_live(void)
{
return;
}
#endif /*ELSE (!SGI)*/

#endif /*!LIBSNDFILE*/
/*_____________________________________________________________________*/

