#ifndef _AUDIO_PORT_H_ 
#define _AUDIO_PORT_H_ 1

/*#define MACOSX
*/
#define ROBUST_FACTOR 4
#define BUF_FRAMES 1024*2
#define VERBOSE 0



// from the "buffers.h" file
/* type of buffer used for internal buses */
#define BUFTYPE float           /* could be double some day */
typedef BUFTYPE *BufPtr;

#define OBUFTYPE float        /* could make this float ... */
#define LIMIT_OBUF_FOR_AUDIO_DEV
typedef OBUFTYPE *OBufPtr;
#define IBUFTYPE float
typedef IBUFTYPE *IBufPtr;



#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifdef MACOSX
#define Boolean Mac_Boolean /* this allows compiling of RTcmix w/X11 on OSX */
	#include <CoreAudio/AudioHardware.h>
#undef Boolean

   #define NUM_FRAGMENTS            2
   #define ZERO_FRAMES_BEFORE       0
   #define ZERO_FRAMES_AFTER        16384

   int open_macosx_ports(int in_nchans, int out_nchans,
                           AudioDeviceID *iport, AudioDeviceID *oport,
                           int verbose, float srate, int nfrags, int *nframes);
   void macosx_audio_read(void);
   void macosx_audio_write(void);
   void macosx_cmixplay_audio_write(short *buf);
   void macosx_audio_stop(AudioDeviceID oport);
#endif /* MACOSX */

#ifdef __cplusplus
} /* extern "C" */
#endif
#endif /* _AUDIO_PORT_H_ */
