/* CERES:  A combination of FFT and granular synthesis***********/ 
/* CERES2: contains modifications done at Columbia University****/
/* CERES3: CERES2 with enhanced editing *************************/
 
/*_v: 0.27a18*/ 

/*new in v. CERES3:
-----------------------------------
TODO: PREVIEW MACOSX
-----------------------------------
(v.027)
Michael Pruett's OpenSource libaudiofile support (MacOSX, LINUX)
inventor file export functionally enhanced
Sndfile-Play and PlayCurrent support added (non-SGI)
Sun/NeXT, Wave, BICSF and SoundDesigner2 supported (SGI)
22.05, 44.1k and 48k samling rates supported
24 and 32 bit files' support added
analyze stereo files supported
tichstuff support for MacOSX
scrollbar complaints in stderr fixed
audio-file and playback calls separated for portability
a nasty phase error bug in overlap-add fixed
current preview added (SGI)
Kjetil Mattheusen's fast oscbank (for non-SGI) implemented
fundamental extraction on time-segment of edit area
fallback resources fixed for sgi
fft size can be chosen from menu in the first analysis
online display & window size & overlap selection
exact arbitrary window size entry
window size entry in terms of pitch and frequency
lowest analyzed pitch GUI entry
paint interactive with edit areas
blank program startup
inaccurate filtering bug in "Paint>Keep" fixed
slow undo/redo bug in "Paint" fixed
-----------------------------------
(v. 0.26)
a default playback engine bug in 'playcurrent' fixed (r4)
file info in the "load file" box
all Transform commands are area-dependant
arbitrary playback engine choice
fft file export and import
source filter in Transform menu
warp in Transform menu
re-arrangedTracking filter
re-written NullPhase
fundamental estimation in edit menu (extract)
ask on quit option
progress-box for time-consuming tasks
complete desktop integration (SGI version)
help things rewritten
gain accepts negative values
inventor export and pbm import improved
-----------------------------------
(v. 0.25)
improved display
improved file selection
improved GUI consistency and functionallity
improved and accelerated menus
warning messagess
'New' item in File menu
undoable cut, paste & paint edits
volume and average spectrum extraction
programmable control functions
area & control-function sensitive Transform & Edit menus
new band filter, breakpoint filter, comb filter, tracking filter, 
	resonant filter, spectr.shift, spectr.shape features
time-varying band-filter files read, compatible w. SculptTool & SVP
band-filter,comb-filter and grid frequency and files also readable as pitch
improved sieve, pitch-grid, spread , blur, gain functions
fifty grid-scale presets, user defined intervals, scalable grid file import
improved and selectable phase vocoder windowing (Kaiser, Blackmann, Gauss, Welch)
improved oscillator bank resynthesizer, using control-function driven 
	variable time stretch and resynthesis treshold
choice of playback engine
play current file
export IRCAM partials,compatibility w. RTcmix, Open Music, PatchWork & SculptTool
unified source-code for SGI and LINUX
-----------------------------------
source-files: ceres3.c, sound_file.c
-----------------------------------
*/
/*
TODO:
make transform functions undoable and redoable
apply Tracking filter to IRCAM export
*/

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/dir.h>
#include <math.h>

#include <string.h>
#include <ctype.h>
#include <audiofile.h>
#include <sys/socket.h>
#include <fcntl.h>

#ifdef POWERPC
#include <DPTich_linux_audiofile.h>
#else
#include <audiofile.h>
#endif

#ifdef SGI
#include <dmedia/audio.h>
#include <sys/fpu.h>
#include <malloc.h>

#else
#define powf(num1,num2) pow(num1,num2);
#endif

#ifdef MACOSX
#include "macosx_audio.h"
#endif

#include <Xm/Xm.h>
#include <Xm/MainW.h>
#include <Xm/Display.h>
#include <Xm/RowColumn.h>
#include <Xm/Frame.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/CascadeB.h>
#include <Xm/MessageB.h>
#include <Xm/FileSB.h>
#include <Xm/DrawingA.h>
#include <Xm/Scale.h>
#include <Xm/DropSMgr.h>
/*
#include <Xm/DialogS.h>
*/
#include <Xm/SelectioB.h>
#include <Xm/BulletinB.h>
#include <Xm/TextF.h>
#include <Xm/Text.h>
#include <Xm/Label.h>
#include <Xm/ToggleB.h>
#include <Xm/Separator.h>
#include <X11/cursorfont.h>
#include <X11/keysym.h>

#define FORWARD 1
#define INVERSE 0
#define MAX_FFT_SIZE 8192
#define MAX_PAINT 10000
#define YES 1
#define NO 2

#ifdef SGI
#define MAXNODES 92
#else
#define MAXNODES 100
#endif

     #include <sys/types.h>
#ifndef MACOSX
     #include <sys/prctl.h>
#endif  


#define fvec(name, size)\
if ((name=(float *)calloc(size, sizeof(float)))==NULL) {\
  printf("Insufficient memory\n");\
}

#define ivec(name, size)\
if ((name=(int *)calloc(size, sizeof(int)))==NULL) {\
  printf("Insufficient memory\n");\
} 

#define lvec(name, size)\
if ((name=(long int*)calloc(size, sizeof(long int)))==NULL) {\
  printf("Insufficient memory\n");\
}

#define LSIZE 4097
#define FLUSH_LIST(list, count, showGC, theGC)        \
          XDrawPoints(theDisplay,XtWindow(sketchpad),showGC,list,count, \
              CoordModeOrigin);       \
          XDrawPoints(theDisplay,bitmap,theGC,list,count,     \
              CoordModeOrigin);       \
        count=0

#define ADD_POINT(xx, yy, list, count, showGC, theGC) \
      list[count].x = xx;     \
      list[count].y = yy;     \
      if (++(count)==LSIZE) { \
              FLUSH_LIST(list,count,showGC,theGC);    \
      }       


/*definitions of equal-tempered intervals 0.25b15*/
#define etm2 1.0594630943592952646
#define etM2 1.1224620483093729814
#define etm3 1.1892071150027210667
#define etM3 1.2599210498948731648
#define etP4 1.3348398541700343648
#define etA4 1.4142135623730950488
#define etP5 1.4983070768766814988
#define etm6 1.5874010519681994748
#define etM6 1.6817928305074290861
#define etm7 1.7817974362806786095
#define etM7 1.8877486253633869933
/*
#define etm2 1.0594631
#define etM2 1.1224621
#define etm3 1.1892071
#define etM3 1.2599210
#define etP4 1.3348398
#define etA4 1.4142136
#define etP5 1.4983071
#define etm6 1.5874010
#define etM6 1.6817928
#define etm7 1.7817974
#define etM7 1.8877486
*/

#ifndef SNDLIB
int wr_shiftout(float A[],int N,int I,int n, short *framebuf, char *name, int fd);
int wrl_shiftout(float A[],int N,int I,int n, long *framebuf32,  int spf, char *name, int fd);

void hack_soundinfo(int *i, int *ii, int *ll, int *iii, int *iiii,long *lll,
	float *d);
int reach_soundfile(int *i1, int *i2, int *i6, int *i3, int *i5,
	long *l3, char* c,  int fd);
int  setup_outfile(int s_p_f,int R, int filefmt, int samp_type,
	int bits_per_samp);


#endif/*!SNDLIB*/
void close_soundfile(char* name, int fd, char type);
void analyze_soundfile(char* name,int fd, int samps_per_frame, 
	int bits_per_sample,int stereo_mode);
void rd_open_soundfile(char* name, int fd);
int  tst_open_soundfile(char* name, int fd);
int  wr_open_soundfile(char* name, int fd);
int  rd_frames(char *name,int fd, short *frames, short D);
int  rd_shiftin(float A[], int  N, int  D, short* frms, int s_p_f,char *name, int fd, 
	int *si_valid, int stereo_mode);
int  rdl_shiftin(float A[], int  N, int  D, long* frms, int s_p_f, int b_p_s,char *name, 
	int fd, int *si_valid, int stereo_mode);

int  init_live(int size);
void shiftout_live(float *output, int Nw, int  I, int I_I, int on);
void close_live(void);

int mLT=1;
int mHS=1;
int mO =1;
int mN =0;
int rN =0;
int mEH=0;
int mSI=0;

Boolean firstrun = False;
Boolean fftt = TRUE;
Boolean pre_grid = True;
Boolean usr_grid = False;



static void GraphClick(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void GraphDrag(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void AreaClick(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void AreaDrag(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void Keydown(Widget w, XEvent *event, String *params, Cardinal *num_params);

#ifdef SGI
static char *fallbackResources[] = {
    "*useSchemes:     all",
    "*sgiMode:        true",
	"*schemeFileList: SgiSpec",
	"*progressBar*sgiMode: TRUE",
	"*progressBar.sliderVisual:  flat_foreground",
	"*progressBar.slidingMode:   thermometer",
	"*progressBar.slanted:       true",
	"*progressBar*foreground: SGI_DYNAMIC BasicBackground",
	"*progressBar*troughColor: SGI_DYNAMIC TextFieldBackground",
    "*useEnhancedFSB: true",
    NULL
};
#else
static char *fallbackResources[] = { NULL };
#endif

void sethotcolors(void);
static void allocateBuffers(void);
static void deallocateBuffers(void);

void setFFTRadio (int,Boolean);
void setUpWindow(int, int, int*, int*, float*);
int fix_size(char*, int , int );


  static XtActionsRec actions[]={
    {"GraphClick",  GraphClick},
    {"GraphDrag",   GraphDrag},
    {"AreaClick",   AreaClick},
    {"AreaDrag",    AreaDrag},
    {"Keydown",     Keydown},
  };


  static char drawTranslations[]=
    "<Btn2Down>:   GraphClick()\n\
     <Btn2Motion>: GraphDrag()\n\
     <Btn3Down>:   AreaClick()\n\
     <Btn3Motion>: AreaDrag()\n\
     <Key>:        Keydown()";


/* extern char *malloc(),  *calloc(); */
/***************************************************************************/
Widget progressBox, progressBar; Boolean update;
Arg args[5]; int nargs = 0;
/***************************************************************************/

Widget newButton, newForm, newOkButton, newCancelButton, newTextField, newLabel,
	newM, newMOption, newLabel1, newROption, newLabel2;
XmString newMmode,smo,noi,r44,r48,r22;
Widget loadFileBox, fileInfoRC, loadFileInfo,saveFileBox, playFileBox,
    loadSepar1,loadSepar2,loadfuncFileBox, savefuncFileBox, 
    loadareaFileBox, saveareaFileBox, tocsoundFileBox, toparmerudFileBox;
Widget tostfFileBox, toltasFileBox, topeakFileBox, imageFileBox;
Widget stfRC, stfFractionRadio, stfFullToggle, stfHalfToggle, stfThirdToggle, stfSixthToggle;
Widget imageRadio,imageToggle,imageToggleFull,imageToggleR, imageToggleG,
	imageRadio1, imageFormO, imageToggleB;
static Widget sketchpad, topLevel, dw;
Widget fftFile, fftFileBox;
Widget sshiftForm, sshiftTextfield, sshiftTextfield2, sshiftToggle1,
	sshiftToggle2,sshiftToggle3;
Widget sshape, sshapeForm, sshapeOkButton,sshapeCancelButton,sshapeToggle,
	sshapeToggle2,sshapeToggle3;
Widget mirrorForm, mirrorTextfield, mirrorTextfield2, mirrorToggle, mirrorToggle2, 
        mirrorToggle3;
Widget filterForm, filterTextfield, filterTextfield2,filterTextfield3,
	filterTextfield4;
Widget bpfilter, bpfilterForm, bpfilterOkButton, bpfilterCancelButton,
	bpfilterToggle1,bpfilterToggle2,bpfilterToggle3,bpfilterTextfield1,
	bpfilterLabel1,bpfilterToggle4;

Widget resfilter, resForm, resOkButton, resCancelButton,
	resToggle1,resToggle2,resToggle3,resTextfield1, resTextfield2,resTextfield3,
	resTextfield4,resLabel1,resLabel2,resLabel3, resLabel4;

Widget trackForm, trackOkButton, trackCancelButton, trackRadio,
	trackToggle1,trackToggle1a,trackTextfield,
	trackLabel,trackTextfield1,trackLabel1,trackTextfield2, trackLabel2, 
	trackToggle2, trackTextfield3,trackLabel3,trackTextfield4,trackLabel4,
	trackTogglephase, trackToggleinv, trackToggle_rem, trackSepar,
	trackSepar1;

Widget sourceFilter,sourceForm, sourceOkButton, sourceCancelButton,
	sourceToggle, sourceToggle2, sourceToggle3, sourceToggle4,
	sourceTextfield, sourceLabel, sourceM, sourceMOption, sourceMLabel,
    sourceSepar;



Widget gain, gainForm, gainTextfield, gainToggle, gainToggle3,
	gainOkButton, gainCancelButton, gainLabel,gainTextfield1,
	gainLabel1,gainSepar,gainToggleT;
Widget nullphase, nullphaseForm, nullphaseTextfield, nullphaseToggle1,
	nullphaseToggle2, nullphaseToggle3, nullphaseToggle4, nullphaseToggle5,
	nullphaseSepar;
Widget fileWarning, sizeWarning, csoundWarning, stfWarning, writeWarning,
	overwriteWarning, ltasWarning, undoWarning;
Widget settingsButton,settingsForm, settingsTextfield, settingsToggle1,
	settingsToggle2,settingsToggle3,interpolToggle,settingsSepar, syntTextfield,
	syntToggle,syntLabel;
Widget pitchForm, pitchTextfield, pitchTextfield2, pitchTextfield3,
         pitchToggle1;
Widget magnetForm, magnetTextfield, magnetTextfield2, magnetTextfield3, magnetTextfield4,
         magnetToggle1, magnetToggle2, magnetToggle3;
Widget sieveForm, sieveTextfield, sieveTextfield2, sieveTextfield3,
         sieveToggle1, sieveToggle2, sieveToggle3, sieveToggle4;

/**/
Widget blurForm, blurTextfield1, blurTextfield2, blurOkButton,
  blurCancelButton, blur, blurToggle1, blurLabel1, blurLabel2,
  blurTextfield3, blurLabel3, blurToggle3;
/**/
Widget combForm, combTextfield1, combTextfield2, combTextfield3, combOkButton,
  combCancelButton,comb, combToggle1, combToggle2, combLabel1, combLabel2, combLabel3,
  combToggleInv;
/**/
Widget expo, expoForm, expoTextfield, expoTextfield2, expoTextfield3, expoTextfield4, expoToggle;
Widget expoOkButton, expoCancelButton, expoLabel1, expoLabel2, expoLabel3,expoLabel4,expoToggleStrict;
/**/
Widget spread, spreadOkButton, spreadCancelButton, spreadLabel1, spreadLabel2,
  spreadLabel3, spreadForm, spreadTextfield, spreadTextfield2, spreadTextfield3,
  spreadToggle, spreadToggle2, spreadToggle3, spreadToggleStrict ;
/**/
Widget warp, warpForm, warpOkButton, warpCancelButton, warpLabel, 
warpTextfield, warpToggle, warpToggle2, warpToggle3, warpToggle4,
warpToggle5;

Widget analyForm, analyToggleHanning, analyToggleRect, analyToggleHamming,
  analyToggleBartlett, analyToggleGauss, analyToggleBlackmann, analyToggleKaiser,
  analyToggleWelch, analyToggleParzen, analyLabel1;
Widget FFTForm, FFTToggle512, FFTToggle1024, FFTToggle2048, FFTToggle4096, FFTToggle8192,
  WindowToggle512, WindowToggle1024, WindowToggle2048, WindowToggle4096, WindowToggle8192,
  WindowToggle16384, OverlapToggle2, OverlapToggle4, OverlapToggle8, OverlapToggle16, OverlapToggle32,
  FFTLabel1, FFTLabel2, FFTLabel3, FFTLabel4, FFTTextfield, winSizeTextfield, winSizeToggle,
  playSepar, playTextfield, playLabel, playSepar1, playSepar2;
Widget displayForm, displayToggleGrey, displayToggleHot, displayToggleCold,
  displayToggleFunc, displayToggleFunc2, displayToggleFunc3, displayToggleFuncAll,
  displayToggleArea, displayToggleArea2, displayToggleArea3, displayToggleAreaAll, 
  displayToggleScale, displayToggleSpots, displayToggleGrid, displayTextfield,
  spotsTextfield, allowUndoToggle, displayToggleUpdate, 
  displayToggleOverwrite,displaySepar, spotsLabel1,
  displayLabel4, displayToggleQuit;
Widget gridForm, gridTextfield, gridTextfield2, gridToggleMajor, gridToggleMinor, gridTogglePenta,
  gridToggleHarm, gridToggleMLT,gridToggleAltd, gridToggleEvenharm,
  gridToggleOddharm,  gridTogglePreset,gridToggleUser,gridToggleFile, freqFileBox, gridFileToggle, gridTogglemMinor,
  gridRadio1, gridToggle1, pgSepar,pgSepar0,pgSepar1, pgSepar2,pgSepar3, gridLabelMode, premode, usermode, filemode, modeRadio,
  gridLT,gridLTOption,gridHS,gridHSOption,gridRadio2,_1,_m2,_M2,_m3,_M3,_p4,_A4,_p5,_m6,_M6,_m7,_M7,
  gridM, gridMOption;
XmString first,second,third,fourth,fifth,sixth,seventh,lt_mode;
XmString all,even,odd,prime,nonprime,hs_mode;
XmString m_mode,trit,oct,twelfth,twoct;

XtAppContext app_context;
Widget mainWindow, menuBar, frame;
Widget fileButton, fileMenu, closeW, quit, load, loadimage, save, play, playcurrent, preview,
loadfunc, savefunc,loadarea, savearea, help, helpMenu, aboutButton, helpButton,
 creditsButton, creditsBox, temp, aboutBox, helpSepar,htmlHelpButton;

Widget quitWarning, quitOk, quitCancel;
Widget closeWarning, closeOk, closeCancel;
Widget editButton, editMenu, undo, redo, copy, cut, paste, extract,
	extractForm, extractOkButton,extractCancelButton,extractRadio,
	extractToggle1,extractToggle2,extractLabel1,extractLabel2,extractRadio2,
	extractToggle3,extractToggle4,extractToggle5,extractTextfield, 
	extractTextfield2,
	extractTextfield3, extractTextfield4, extractTextfield5,
	extractTextfield6, extractLabel3, extractLabel4,extractLabel5,
	extractLabel6,extractLabel7,extractLabel8,extractM,
	extractToggle6,extractSepar,extractSepar0,extractSepar1,
	extractSepar3,extractMOption,
    controlfunctionScaleToggle,controlfunctionShiftToggle,
	controlfunctionSlideToggle,controlfunctionRadio,
	controlfunction,controlfunctionForm,controlfunctionOkButton,
	controlfunctionCancelButton,controlfunctionTextfield,
	controlfunctionLabel,controlfunctionTextfield2,
	controlfunctionMirrorToggle,controlfunctionRetroToggle,
	controlfunctionAddToggle,controlfunctionMultToggle,
	controlfunctionResetToggle,controlfunctionReplToggle,
	controlfunctionMapToggle,controlfunctionRowCol,
	controlfunctionOption;

Widget transButton, transMenu, sieve, sshift, filter, pshift, nullphase,
  trpeaks, mirror,trackfilter;
Widget ltas, magnet, convolve;
Widget exportButton, exportMenu, exportSepar, importSepar,tocsound, toparmerud, tostf, 	
	toltas, topeak, sculpt, tofft,importButton, importMenu;
Widget sculptFileBox, sculptRowCol, sculptAL, sculptA, sculptDL, sculptD,
  /*sculptBL, sculptB,*/ sculptFJL, sculptFJ,sculptToggle;
Widget tofftFileBox;

Widget settingsButton, settingsMenu, resyntButton,
  analyButton, FFTButton, displayButton, magnetButton;
Widget analyRadio, analyOkButton, analyCancelButton;
Widget FFTRadio, FFTRadio2, FFTRadio3, FFTOkButton, FFTCancelButton,fftengToggle;
Widget pitchOkButton, pitchCancelButton, pitchLabel1, pitchLabel2, pitchLabel3;
Widget sshiftOkButton, sshiftCancelButton, sshiftLabel1, sshiftLabel2;
Widget mirrorOkButton, mirrorCancelButton, mirrorLabel1, mirrorLabel2;
Widget nullphaseOkButton, nullphaseCancelButton, nullphaseLabel1;
Widget magnetOkButton, magnetCancelButton, magnetLabel1, magnetLabel2, magnetLabel3, 
  magnetLabel4;
Widget convolveButton, convolveOkButton, convolveCancelButton, convolveForm,
  convolveRadio, convolveToggleLaplace, convolveToggleMean, 
  convolveToggleTimeMean, convolveToggleFile, convolveTextfield;
Widget sieveOkButton, sieveCancelButton, sieveLabel1, sieveLabel2, 
  sieveLabel3, sieveRadio, sieveLabel4, sieveLabel5;
Widget filterOkButton, filterCancelButton, filterLabel1, filterLabel2,
  filterLabel3, filterFilToggle, filterQToggle, filterGToggle;
Widget settingsOkButton, settingsCancelButton1, settingsLabel1,
  settingsRadio, settingsLabel2, settingsLabel3;
Widget displayLabel1, displayOkButton, displayCancelButton, colorRadio, funcRadio, 
  areaRadio;
Widget gridLabel1, gridButton, gridOkButton, gridCancelButton, gridRadio,
  freqfile;

Widget spotsButton, spotsMenu, spotsRestart, spotsKeep, spotsRemove;
Widget parmerudRowCol, parmL1, parmL2, parmL3, parmL4,
  parmT1, parmT2, parmT3, parmT4;

Widget  infoL1, infoL2, infoL3, infoStereoRadio, infoLToggle,infoRToggle,
	infoLRToggle;
int stereo;
Widget fundWarning;

static Cursor arrowCur = (int) NULL;
static Cursor pointCur = (int) NULL;

Boolean fileDirty = FALSE;


#define Pi    3.141592654
#define TwoPi 6.283185308
#define E     2.7182818285

Boolean helpOn = FALSE;
Boolean paintstuff = FALSE;
/*-*/
/*
AFfilehandle infile,  outfile;
AFfilesetup in_AFsetup,  out_AFsetup;
*/
long /*compression,*/ framecnt;
int samps_per_frame=1;
/*
#ifdef SGI
int  bits_per_samp, samp_type, filefmt;
#else
long bits_per_samp, samp_type, filefmt;
#endif
*/
int  bits_per_samp, samp_type, filefmt;

/*-*/

float  *megfreq  = NULL,        /**/
        *megamp   = NULL,        /** Enormous arrays */
        *avgamp   = NULL,        /**/
		*fundarray= NULL,
        *interpol = NULL;        /**/
int	lowest,highest;
long horiz_num=0;            /* Number of analysis frames */
float duration;              /* Duration in secs */
int numchannels;             /* Number of phase vocoder channels */
float binfreq;               /* Frequency per bin */
int theheight, thewidth, iheight, iwidth, oldheight, oldwidth;
int oldIwidth, oldIheight;
float fwidth;
int areax1=10, areay1=10, areax2=10, areay2=10;
int areax21=10, areay21=10, areax22=10, areay22=10;
int areax31=10, areay31=10, areax32=10, areay32=10;
int areat1, areat2, areaf1, areaf2;
int spotsx[MAX_PAINT], spotsy[MAX_PAINT], numspots=0;
int spotst[MAX_PAINT], spotsf[MAX_PAINT];
int kt1, kt2, kf1, kf2;
int spotsize;
int si_valid=-1;
float stretchfac=1.;

int R=44100,  D,  N,  Nw,  N2,  I, oldN, oldNw;
short int *framebuff, *frames;
long  int *framebuff32, *frames32;
int Nw2, obank=0;
int fast = 0;
float P,  synt,  *Wanal,  *Wsyn,  *input,  *buffer,  *channel,  *output;
float *tempamp, *tempfreq, *last, *this;
char the_latest[5];
char curr[100];
/*this is a hack and should actually be allocated in SaveOk*/
float lastamp[16385], lastfreq[16385];
#ifdef SGI
float index[16385];
#else
float indx[16385];
#endif
/**************************************************/
Boolean va_tstretch;

XGCValues values;
static Window theRoot, theWindow;
static Colormap theCmap;
static Display *theDisplay;
static int screen;
static Pixmap bitmap, spotsmap;
static XColor gray0, gray20, gray40, gray60, gray80, gray100; /*gray0 = black*/
static XColor darkred, red, orange, yellow, green, brown, aquamarine, mycadetblue;
static XColor midnightblue, darkblue, blue, lightblue;

/*--hacked for vers 0.14 (SJ)--*/
static XColor purple;
static XColor cyan;

static GC theGC, showGC/*, funtheGC, funshowGC*/;
static GC theGC0, theGC10, theGC20, theGC40, theGC60, theGC80, theGC100;
static GC showGC0, showGC10, showGC20, showGC40, showGC60, showGC80, showGC100;
static GC funcGC, func2GC, func3GC, func4GC,func5GC, gridGC, spotsGC,spectGC;

XFontStruct *font_info;

static int xpos[MAXNODES], xpos2[MAXNODES], xpos3[MAXNODES];
static int ypos[MAXNODES], ypos2[MAXNODES], ypos3[MAXNODES];
int numsquare=2, numsquare2=2, numsquare3=2;
int selected=0, selected2=0, selected3=0;
int funcpt, funcpt2, funcpt3;
int farge=0;
float Pinc;
float gridfreqs[500];
float gridfreqs2[8000];
float filterfreqs[100];
int numfreqs;

/*gridbox separator width*/
#ifdef SGI
int gsw = 300;
#else
int gsw = 255;
#endif

#ifdef SGI
void flush_all_underflows_to_zero()
  {
    union fpc_csr f;
    f.fc_word = get_fpc_csr();
    f.fc_struct.flush = 1;
    set_fpc_csr(f.fc_word);
  }
#endif



/*_____________________________ FFT ROUTINES____________________________ */
/* the cfft and rfft programs  given here are adapted from the 
   FORTRAN programs FOUR1 and REALFT in Press et al. (1986).
  */
/* If forward is true, rfft replaces 2*N real data points in x with
   N complex values representing the positive frequency half of their
   Fourier spectrum, with x[1] replaced with the real part of the Nyquist
   frequency value.  If forward is false, rfft expects x to contain a
   positive frequency spectrum arranged as before, and replaces it with
   2*N real values.  N MUST be a power of 2. */

rfft( x, N, forward )
float x[]; int N, forward;
{
  float         c1,c2,
                h1r,h1i,
                h2r,h2i,
                wr,wi,
                wpr,wpi,
                temp,
                theta;
  float         xr,xi;
  int           i,
                i1,i2,i3,i4,
                N2p1;
  static int    first = 1;

    theta = Pi/N;
    wr = 1.;
    wi = 0.;
    c1 = 0.5;
    if ( forward ) {
        c2 = -0.5;
        cfft( x, N, forward );
        xr = x[0];
        xi = x[1];
    } else {
        c2 = 0.5;
        theta = -theta;
        xr = x[1];
        xi = 0.;
        x[1] = 0.;
    }
#ifdef SGI
    wpr = -2.*powf( sin( 0.5*theta ), 2. );
#else
    wpr = -2.*pow( sin( 0.5*theta ), 2. );
#endif
    wpi = sin( theta );
    N2p1 = (N<<1) + 1;
    for ( i = 0; i <= N>>1; i++ ) {
        i1 = i<<1;
        i2 = i1 + 1;
        i3 = N2p1 - i2;
        i4 = i3 + 1;
        if ( i == 0 ) {
            h1r =  c1*(x[i1] + xr );
            h1i =  c1*(x[i2] - xi );
            h2r = -c2*(x[i2] + xi );
            h2i =  c2*(x[i1] - xr );
            x[i1] =  h1r + wr*h2r - wi*h2i;
            x[i2] =  h1i + wr*h2i + wi*h2r;
            xr =  h1r - wr*h2r + wi*h2i;
            xi = -h1i + wr*h2i + wi*h2r;
        } else {
            h1r =  c1*(x[i1] + x[i3] );
            h1i =  c1*(x[i2] - x[i4] );
            h2r = -c2*(x[i2] + x[i4] );
            h2i =  c2*(x[i1] - x[i3] );
            x[i1] =  h1r + wr*h2r - wi*h2i;
            x[i2] =  h1i + wr*h2i + wi*h2r;
            x[i3] =  h1r - wr*h2r + wi*h2i;
            x[i4] = -h1i + wr*h2i + wi*h2r;
        }
        wr = (temp = wr)*wpr - wi*wpi + wr;
        wi = wi*wpr + temp*wpi + wi;
    }
    if ( forward )
        x[1] = xr;
    else
        cfft( x, N, forward );
return 0;
}

/* cfft replaces float array x containing NC complex values
   (2*NC float values alternating real, imagininary, etc.)
   by its Fourier transform if forward is true, or by its
   inverse Fourier transform if forward is false, using a
   recursive Fast Fourier transform method due to Danielson
   and Lanczos.  NC MUST be a power of 2.  Based on program
   FOUR1 in Numerical Recipes: The art of Scientific  Computing.
   (Cambridge University Press, 1986 by Numerical Recipes
   Software. Used by permission*/

cfft( x, NC, forward )
float x[]; int NC, forward;
{
  float         wr,wi,
                wpr,wpi,
                theta,
                scale;
  int           mmax,
                ND,
                m,
                i,j,
                delta;

    ND = NC<<1;
    bitreverse( x, ND );
    for ( mmax = 2; mmax < ND; mmax = delta ) {
        delta = mmax<<1;
        theta = TwoPi/( forward? mmax : -mmax );
#ifdef SGI
        wpr = -2.*powf( sin( 0.5*theta ), 2. );
#else
        wpr = -2.*pow( sin( 0.5*theta ), 2. );
#endif
        wpi = sin( theta );
        wr = 1.;
        wi = 0.;
        for ( m = 0; m < mmax; m += 2 ) {
         register float rtemp, itemp;
            for ( i = m; i < ND; i += delta ) {
                j = i + mmax;
                rtemp = wr*x[j] - wi*x[j+1];
                itemp = wr*x[j+1] + wi*x[j];
                x[j] = x[i] - rtemp;
                x[j+1] = x[i+1] - itemp;
                x[i] += rtemp;
                x[i+1] += itemp;
            }
            wr = (rtemp = wr)*wpr - wi*wpi + wr;
            wi = wi*wpr + rtemp*wpi + wi;
        }
    }

/* scale output */

    scale = forward ? 1./ND : 2.;
    { register float *xi=x, *xe=x+ND;
        while ( xi < xe )
            *xi++ *= scale;
    }
return 0; 
}

/* bitreverse places float array x containing N/2 complex values
   into bit-reversed order */

bitreverse( x, N )
float x[]; int N;
{
  float         rtemp,itemp;
  int           i,j,
                m;

    for ( i = j = 0; i < N; i += 2, j += m ) {
        if ( j > i ) {
            rtemp = x[j]; itemp = x[j+1]; /* complex exchange */
            x[j] = x[i]; x[j+1] = x[i+1];
            x[i] = rtemp; x[i+1] = itemp;
        }
        for ( m = N>>1; m >= 2 && j >= m; m >>= 1 )
            j -= m;
    }
return 0;
}


/* _________________PHASE VOCODER INTERNALS _______________________*/
/* WINDOWING FUNCTIONS -as of Ceres3
 * KAISER, BESSEL helping functions
 */
/*___________float bessel_0 (float kx)___________________________________*/
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * The following code is a line-by-line C-translation  of the original 
 * FORTRAN code for modified zero-order Bessel function,  by. J.Kaiser 
 * himself (as found in Rabiner & Gold's "DSP cookbook"-Theory and  
 * Application of Digital Signal Processing - ISBN 0-13-914101-4)
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/*kx between 0. & 20.*/
float bessel_0(float bx)
{
short i;
float t, de, sde, e, by;
short m;
by=bx/2.0;
t=0.00000001;
e=1.0;
de=1.0;
for(i=1;i<=25;i++)
	{
	de=de*by/(float)i;
	sde=de*de;
	e=e+sde;
	if(e*t-sde>0.0)
	   break;
	}
bx=e;
m=i;
return bx;
}
 /* * * * * * * * * * * * * * * * * *
 *  b= 2.120 ------------->  - 30 dB
 *  b= 4.538 ------------->  - 50 dB
 *  b= 6.764 ------------->  - 70 dB
 *  b= 8.960 ------------->  - 90 dB
 * * * * * * * * * * * * * * * * * */
float kaiser( int j,int n, float b )
{
 float kx, ky;
 float w;
 ky= 2.0*((float)j+.5)/(float)(n);
 kx= b*sqrt(1.0-ky*ky);
 w= bessel_0(kx)/bessel_0(b);
/* printf("#%d\t%d\t%f\t%f\n",n,j,kx,w); */
 return w;
}
/*________________________________________________________________*/
/* *
 * make balanced pair of analysis (A) and synthesis (S) windows;
 * window lengths are Nw, FFT length is N, synthesis interpolation
 * factor is I
 */
makewindows(A, S, Nw, N, I)
    float A[], S[] ; int Nw, N, I;
{
 int i ;
 float sum, a ;




  if (XmToggleButtonGetState(analyToggleHamming)){
    for ( i = 0 ; i < Nw ; i++ )
      A[i] = S[i] = 0.54 - 0.46*cos( TwoPi*i/(Nw - 1) ) ;
		/*printf("Generating Hamming windows\n");*/
	  }
  if (XmToggleButtonGetState(analyToggleHanning)){
    for ( i = 0 ; i < Nw ; i++ )
      A[i] = S[i] = 0.5 - 0.5*cos( TwoPi*i/(Nw - 1) ) ;
		/*printf("Generating Hanning windows\n");*/
	  }
  if (XmToggleButtonGetState(analyToggleRect)){
    for ( i = 0 ; i < Nw ; i++ )
      A[i] = S[i] = 1. ;
		/*printf("Generating Rectangular windows\n");*/
	  }
  if (XmToggleButtonGetState(analyToggleBartlett)){
    for ( i = 0 ; i < Nw ; i++ )
      A[i] = S[i] = 1.-fabs(i-(Nw-1.)/2.)/((Nw-1.)/2.);
		/*printf("Generating Bartlett windows\n");*/
	  }
  if (XmToggleButtonGetState(analyToggleKaiser)){
     for(i=-1*(Nw)/2; i<(Nw)/2; i++)
      A[i+(Nw)/2] = S[i+(Nw)/2] = kaiser(i, Nw, 10.);
		/*printf("Generating Kaiser windows\n");*/
	  }
  if (XmToggleButtonGetState(analyToggleGauss)){
     for(i=-1*(Nw)/2; i<(Nw)/2; i++)
	A[i+(Nw)/2] = S[i+(Nw)/2] = exp(-1.*(float)(i*i)/(float)(Nw*Nw*.0313));
		/*printf("Generating Gauss windows\n");*/
	  }
  if (XmToggleButtonGetState(analyToggleWelch)){
    for ( i = 0 ; i < Nw ; i++ )
      A[i] = S[i] =  1.0-( (float)i-.5*(float)(Nw-1) )/(.5*(float)(Nw+1))*\
			 ( (float)i-.5*(float)(Nw-1))/(.5*(float)(Nw+1)) ;
		/*printf("Generating Welch windows\n");*/
	  }
  if (XmToggleButtonGetState(analyToggleBlackmann)){
    for ( i = 0, a = 0.; i < Nw ; i++ ){
      A[i] = S[i] =  .084037+cos(a)*\
	      (-.29145+cos(a)*(.375696+cos(a)*(-.20762+cos(a)*.041194)));
      a += TwoPi/(float)Nw;
      }
		/*printf("Generating Blackmann windows\n");*/
	  }



/*
 * when Nw > N, also apply interpolating (sinc) windows to
 * ensure that window are 0 at increments of N (the FFT length)
 * away from the center of the analysis window and of I away
 * from the center of the synthesis window
 */
    if ( Nw > N ) {
     float x ;

/*
 * take care to create symmetrical windows
 */
        x = -(Nw - 1)/2. ;
        for ( i = 0 ; i < Nw ; i++, x += 1. )
            if ( x != 0. ) {
                A[i] *= N*sin( Pi*x/N )/(Pi*x) ;
                if ( I )
                    S[i] *= I*sin( Pi*x/I )/(Pi*x) ;
            }
    }

/*
 * normalize windows for unity gain across unmodified
 * analysis-synthesis procedure
 */
    for ( sum = i = 0 ; i < Nw ; i++ )
        sum += A[i] ;

    for ( i = 0 ; i < Nw ; i++ ) {
     float afac = 2./sum ;
     float sfac = Nw > N ? 1./afac : afac ;
        A[i] *= afac ;
        S[i] *= sfac ;
    }

    if ( Nw <= N && I ) {
        for ( sum = i = 0 ; i < Nw ; i += I )
            sum += S[i]*S[i] ;
        for ( sum = 1./sum, i = 0 ; i < Nw ; i++ )
            S[i] *= sum ;
    }
/*
for ( i = 0 ; i < Nw ; i++ )
printf("%d\t%f\t%f\n", i, A[i], S[i]);
*/
return 0;
}
/* * * * * * * * * * *
 * end of modified code
 * * * * * * * * * * */
/*__________________________________________________________________*/
/*  obsoleted for portability issues and migrated to sound_file.c:rd_shiftin()
	(as of v.0.27b, S.J)
	*/
/*
int shiftin(A,  N,  D, name, fd)
float A[];
int N, D, fd;
char *name;
{
    int i;
    float *Aptr = A;
	int sampsread;
    if (si_valid<0) si_valid=N;
    i = N-D;
    while (i--) {
      *Aptr = *(Aptr+D);
      Aptr++;
    }
    if (si_valid==N) {
	  frames = framebuff;

      sampsread=AFreadframes(infile, AF_DEFAULT_TRACK, frames, D);

      if (samps_per_frame==1) {
        si_valid = sampsread+N-D;
        while(sampsread--) *(Aptr++) = (float) *(frames++) / 32768.0;
      } else {
        si_valid = sampsread+N-D;
        while(sampsread--) *(Aptr++) = (float) (*(frames++) + *(frames++)) / 65536.0;
      }
    }
    if (si_valid<N) {
        for (i=si_valid; i<N; i++) A[i]=0.;
        si_valid-=D;
    }
    return (si_valid<=0);
}
*/
/*__________________________________________________________________________*/
/*
 * multiply current input I by window W (both of length Nw);
 * using modulus arithmetic, fold and rotate windowed input
 * into output array O of (FFT) length N according to current
 * input time n
 */
void fold( I, W, Nw, O, N, n )
    float I[], W[], O[] ; int Nw, N, n ;
{

    int i;

    for ( i = 0; i < N; i++ )
        O[i] = 0.;

    while ( n < 0 )
        n += N;
    n %= N;
    for ( i = 0; i < Nw; i++ ) {
        O[n] += I[i]*W[i];
        if ( ++n == N )
            n = 0;
    }
}

/*__________________________________________________________________________*/
/* S is a spectrum in rfft format, i.e., it contains N real values
   arranged as real followed by imaginary values, except for first
   two values, which are real parts of 0 and Nyquist frequencies;
   convert first changes these into N/2+1 PAIRS of magnitude and
   phase values to be stored in output array C; the phases are then
   unwrapped and successive phase differences are used to compute
   estimates of the instantaneous frequencies for each phase vocoder
   analysis channel; decimation rate D and sampling rate R are used
   to render these frequency values directly in Hz. */

void convert( S, C, N2, D, R )
float S[], C[]; int N2, D, R;
{
  static int    first = 1;
  static float  *lastphase,
                fundamental,
                factor;
  float         phase,
                phasediff;
  int           real,
                imag,
                amp,
                freq;
  float         a,
                b;
  int           i;

/* first pass: allocate zeroed space for previous phase
   values for each channel and compute constants */

    if ( first ) {
      first = 0;
      fvec(lastphase, N2+1);
      fundamental = (float) R/(N2<<1);
      factor = R/(D*TwoPi);
    }

/* unravel rfft-format spectrum: note that N2+1 pairs of
   values are produced */
/*0,2,4,, -->re	al */
/*1,3,5,, -->imag */
/*i=0;imag=1  i=1;i mag=3;real=2*/
    for ( i = 0; i <= N2; i++ ) {
      imag = freq = ( real = amp = i<<1 ) + 1;
      a = ( i == N2 ? S[1] : S[real] );
      b = ( i == 0 || i == N2 ? 0. : S[imag] );

/* compute magnitude value from real and imaginary parts */

      C[amp] = hypot( a, b );

/* compute phase value from real and imaginary parts and take
   difference between this and previous value for each channel */

      if ( C[amp] == 0. )
        phasediff = 0.;
      else {
        phasediff = ( phase = -atan2( b, a ) ) - lastphase[i];
        lastphase[i] = phase;

/* unwrap phase differences */

        while ( phasediff > Pi )
          phasediff -= TwoPi;
        while ( phasediff < -Pi )
          phasediff += TwoPi;
      }

/* convert each phase difference to Hz (Hertz == cps) */

      C[freq] = phasediff*factor + i*fundamental;
    }
}

/*_____________________________________________________________________*/
/* oscillator bank resynthesizer for phase vocoder analyzer
  uses sum of N+1 cosinusoidal table lookup oscillators to
  compute I (interpolation factor) samples of output O
  from N+1 amplitude and frequency value-pairs in C;
  frequencies are scaled by P */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * modified for ceres3 v. 0.25b10 to accept time-varying 
 * interpolation factor
 * modified for ceres3 v. 0,25b20 to accept frequency 
 * dependent resynthesis theshold
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

void oscbank( C, N, R, I, O, P, synta/*,lastamp,lastfreq,index*/ )
float C[], O[], P, synta[]/*, *lastamp,*lastfreq,*index*/;
/* synt = Synthesis treshold */
int N, R, I;
{

  static int    NP,
                L = 8192,  /* wavetable length */
                first = 1;
  static float  Iinv,
/*
                *lastamp,
                *lastfreq,
                *index,
*/
                *table;
  /*static float  Pinc; */
  int           amp,
                freq,
                n,
                chan;

/* first pass: allocate memory to hold previous values
   of amplitude and frequency for each channel, the table
   index for each oscillator, and the table itself; also
   compute constants */

    if ( first ) {
      float     TwoPioL = TwoPi/L;

        first = 0;
/*this doesn't work... */
/*
        fvec(lastamp,N+1);
        fvec(lastfreq,N+1);
        fvec(index,N+1);
*/
        fvec(table,L);

        for ( n = 0; n < L; n++ )
            table[n] = N*cos( TwoPioL*n );

        Iinv = 1./I;
        Pinc = L/(float)R;

/*      if ( P > 1. )
            NP = N/P;
        else */
            NP = N;
    }

/* for each channel, compute I samples using linear
   interpolation on the amplitude and frequency
   control values */

    for ( chan = 0; chan < NP; chan++ ) {

      float             a,
                        ainc,
                        f,
                        finc,
                        address;

        freq = ( amp = ( chan << 1 ) ) + 1;
        C[freq] *= Pinc;
        finc = ( C[freq] - ( f = lastfreq[chan] ) )*Iinv;
/* <synt>from R. Moore's code has been replaced with more
   flexible array variable <synta[]> to allow for varying
   resynthesis treshold (SJ) */
      if (C[amp]<synta[chan]/*synt*/) C[amp] = 0.; 
        ainc = ( C[amp] - ( a = lastamp[chan] ) )*Iinv;
#ifdef SGI
        address = index[chan];
#else
        address = indx[chan];
#endif

/*printf("$ %d\t%f\n", chan, synta[chan]);*/
/* accumulate the I samples from each oscillator into
   output array O (initially assumed to be zero);
   f is frequency in Hz scaled by oscillator increment
   factor and pitch (Pinc); a is amplitude; */

         if (ainc!=0. || a !=0.) 
		 for ( n = 0; n < I; n++ ) {
            O[n] += a*table[ (int) address ];

            address += f;

            while ( address >= L )
                address -= L;

            while ( address < 0 )
                address += L;

            a += ainc;
            f += finc;
        }

/* save current values for next iteration */

        lastfreq[chan] = C[freq];
        lastamp[chan] = C[amp];
#ifdef SGI
        index[chan] = address;
#else
        indx[chan] = address;

#endif
    }
}


/*_______________________________________________________________________*/
/*_______________________________________________________________________*/
/*This is the fast oscillator bank synthesizer, contributed by Kjetil S. 
    Mattheusen. It gains cycles by  putting the float-to-int promotion
    away from innermost loop. It is reported to increase performance
    by the factor of 3 on non SGI systems. On SGI it's all the same
	(S.J.)*/
/*reported speed gains:
	38/105 -Linux, Athlon;
	40/ 57  -MacOSX, G4;
	35/31   -SGI, IRIX-6.5.14, MIPS; (slower!!!)
*/

#define MAXL (INT_MAX/2)
void oscbank_fast(
	     float C[],
	     /* synt = Synthesis treshold */
	     int N, int R, int I,
	     float O[], float P, float synta[]/*, *lastamp,*lastfreq,*index*/
	     )

{

  static int    NP,
    L = 8192,  /* wavetable length */
    first = 1;
  static float  Iinv,
    /*
     *lastamp,
     *lastfreq,
     *index,
     */
    *table;
  /*static float  Pinc; */
  int           amp,
    			freq,
    			n,
    			chan;

  int address1=0;
  int address2=0;
 printf("*"); 
  /* first pass: allocate memory to hold previous values
     of amplitude and frequency for each channel, the table
     index for each oscillator, and the table itself; also
     compute constants */
  
  if ( first ) {
    float     TwoPioL = TwoPi/L;

    first = 0;
    /*this doesn't work... */
    /*
      fvec(lastamp,N+1);
      fvec(lastfreq,N+1);
      fvec(index,N+1);
    */
    fvec(table,L);

    for ( n = 0; n < L; n++ )
      table[n] = N*cos( TwoPioL*n );

    Iinv = 1./I;
    Pinc = L/(float)R;

    /*      if ( P > 1. )
            NP = N/P;
	    else */
    NP = N;
  }

  /* for each channel, compute I samples using linear
   interpolation on the amplitude and frequency
   control values */

  for ( chan = 0; chan < NP; chan++ ) {

    float             a,
      ainc,
      f,
      finc,
      address;

    freq = ( amp = ( chan << 1 ) ) + 1;
    C[freq] *= Pinc;
    finc = ( C[freq] - ( f = lastfreq[chan] ) )*Iinv;
    /* <synt>from R. Moore's code has been replaced with more
       flexible array variable <synta[]> to allow for varying
       resynthesis treshold (SJ) */
    if (C[amp]<synta[chan]/*synt*/) C[amp] = 0.; 
    ainc = ( C[amp] - ( a = lastamp[chan] ) )*Iinv;
#ifdef SGI
    address = index[chan];
#else
    address = indx[chan];
#endif

    /*printf("$ %d\t%f\n", chan, synta[chan]);*/
    /* accumulate the I samples from each oscillator into
       output array O (initially assumed to be zero);
       f is frequency in Hz scaled by oscillator increment
       factor and pitch (Pinc); a is amplitude; */

    address1=(int)address;
    address2=(int)((address-(float)address1)*MAXL);

    if (ainc!=0. || a !=0.){
      int f1=(int)f;
      int f2=(int)(((f-(float)f1)*MAXL));
      int finc1=(int)finc;
      int finc2=(int)((finc-(float)finc1)*MAXL);

      for ( n = 0; n < I; n++ ) {
	O[n] += a*table[address1];
	
	address1+=f1;
	address2+=f2;
	
	if(address2>=MAXL){
	  address1++;
	  address2-=MAXL;
	}else{
	  if(address2<0){
	    address1--;
	    address2+=MAXL;
	  }
	}
	
	while ( address1 >= L ){
	  address1 -= L;
	}
	  
	while ( address1 < 0 ){
	  address1 += L;
	}

	a += ainc;

	f1+=finc1;
	f2+=finc2;
	if(f2>=MAXL){
	  f1++;
	  f2-=MAXL;
	}else{
	  if(f2<0){
	    f1--;
	    f2+=MAXL;
	  }
	}
      }
    }

    /* save current values for next iteration */

    lastfreq[chan] = C[freq];
    lastamp[chan] = C[amp];
#ifdef SGI
    index[chan] = (float)address1+(address2/(float)MAXL);
#else
    indx[chan] = (float)address1+(address2/(float)MAXL);
#endif

  }
}
/*________________________________________________________________________*/

/* unconvert essentially undoes what convert does, i.e., it
  turns N2+1 PAIRS of amplitude and frequency values in
  C into N2 PAIR of complex spectrum data (in rfft format)
  in output array S; sampling rate R and interpolation factor
  I are used to recompute phase values from frequencies */

void unconvert( C, S, N2, I, R, hor, j )
float C[], S[]; int N2, I, R, j, hor;
{
  static int    first = 1;
  static float  *lastphase,
                fundamental,
                factor;
  int           i,
                real,
                imag,
                amp,
                freq;
  float         mag,
                phase;

/* first pass: allocate memory and compute constants */

    if ( first ) {
        first = 0;
        fvec(lastphase,N2+1);
        fundamental = (float) R/(N2<<1);
        factor = TwoPi*I/R;
    }

/* subtract out frequencies associated with each channel,
   compute phases in terms of radians per I samples, and
   convert to complex form */

    for ( i = 0; i <= N2; i++ ) {
        imag = freq = ( real = amp = i<<1 ) + 1;
        if ( i == N2 )
            real = 1;
        mag = C[amp];
        lastphase[i] += C[freq] - i*fundamental;
        phase = lastphase[i]*factor;
        S[real] = mag*cos( phase );
        if ( i != N2 )
            S[imag] = -mag*sin( phase );
/*printf("%f\t%f\n", S[real], S[imag]);*/
    }
/*last pass: reset the last phase, or you'll get phase errors next time*/
/*this was added to the original code which did wasn't meant for
	possible multiple syntheses in one program run (S.J., Ceres3-v.0.27) */
if(j == hor - 1)
	for (i=0; i<(N2+1); i++)
	lastphase[i] = 0.;
}

/*_____________________________________________________________________*/
/*
 * input I is a folded spectrum of length N; output O and
 * synthesis window W are of length Nw--overlap-add windowed,
 * unrotated, unfolded input data into output O
 */
 overlapadd( I, N, W, O, Nw, n )
    float I[], W[], O[] ; int N, Nw, n ;
{
 int i ;
    while ( n < 0 )
        n += N ;
    n %= N ;
    for ( i = 0 ; i < Nw ; i++ ) {
        O[i] += I[n]*W[i] ;
        if ( ++n == N )
            n = 0 ;
    }
return 0;
}


/*_____________________________________________________________________*/
/*  obsoleted for portability issues and migrated to sound_file.c:wr_shiftout()
	(as of v.0.27b, S.J)
	*/
/*-
void shiftout(A,  N,  I,  n)
float A[];
int N,  I,  n;
{
    int i;

    if (n>=0) {
      for (i=0; i<I; i++) *(framebuff+i)=(short)(A[i]*32767.);

      AFwriteframes(outfile, AF_DEFAULT_TRACK, framebuff, I);

    }
    for (i=0; i<N-I; i++) A[i]=A[i+I];
    for (i=N-I; i<N; i++) A[i]=0.;
}
*/
/*_____________________________________________________________________*/
/*moved to sound_file.c*/
/*
#ifdef SGI
void shiftout_to_port(float A[], int  N, int  I, int  Ii, int  n, ALport port)
{
    int i, i2;
	
    if (n>=0)  alWriteFrames(port,  A, I);
    
    for (i=0; i<N-Ii; i++) A[i]=A[i+Ii];
    for (i=N-Ii; i<N; i++) A[i]=0.;
}
#endif
*/
/*_____________________________________________________________________*/
void rightbins()
{
   float nyquist;
   long point=0;
   int i,  j, thebin;

   nyquist=R/2.;
   for (i=0; i<horiz_num; i++) {
     for (j=0; j<numchannels; j++) tempamp[j]=0.;
     for (j=0; j<numchannels; j++) {
       if ((megfreq[point+j]>0.) && (megfreq[point+j]<nyquist)) {
       thebin=(int)(megfreq[point+j]/binfreq);
         if (megamp[point+j]>tempamp[thebin]) {
           tempamp[thebin]=megamp[point+j];
           tempfreq[thebin]=megfreq[point+j];
         }
       }
     }
     for (j=0; j<numchannels; j++) {
         megfreq[point+j]=tempfreq[j];
         megamp[point+j]=tempamp[j];
     }
     point+=numchannels;
   }
}

/*_____________________________________________________________________*/
void clipfreq()
{
  float nyquist;
  long point=0;
  int i, j, thebin;

  nyquist=R/2.;
  for (i=0; i<horiz_num; i++) {
    for (j=0; j<numchannels; j++) {
      if ((megfreq[point]<0.) || (megfreq[point]>=nyquist)) megamp[point]=0.;
      point++;
    }
  }
}

/*____________________________G.U.I. CODE______________________________*/
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
/*_________________________________________________________________*/
/*__this loads a more convenient display font (tested only on SGI)_*/

#ifdef SGI
void load_font(font_info)
XFontStruct **font_info;
{
char *fontname = "-sgi-screen-medium-r-normal--13-130-72-72-m-70-iso8859-1";
if((*font_info = XLoadQueryFont(theDisplay,fontname)) == NULL)
	{
	printf("Ceres3 cannot open %s\n",fontname);
	*font_info = XLoadQueryFont(theDisplay,"9x15");
	}
}
# endif

/*_________________________________________________________________*/
/*_________________________________________________________________*/
static Widget CreateDrawingArea(void)
{
/*
	if (sketchpad != (Widget)NULL){
		printf("Sketchpad exists\n");
		return;
		}
*/
    sketchpad = XtVaCreateManagedWidget("sketchpad",
	xmDrawingAreaWidgetClass, frame,
/*        XmNwidth,thewidth+60,
	XmNheight,theheight+60,*/
    XmNresizePolicy, XmRESIZE_ANY,
	NULL);

   theDisplay = XtDisplay(sketchpad);
   theWindow = XtWindow(sketchpad);
   screen = DefaultScreen(theDisplay);
   theRoot = RootWindowOfScreen(XtScreen(sketchpad));
   theCmap = DefaultColormap( theDisplay, DefaultScreen(theDisplay) );
/*
   bitmap = XCreatePixmap(XtDisplay(sketchpad),theRoot,thewidth+60,theheight+60,
     DefaultDepthOfScreen(XtScreen(sketchpad)));
   spotsmap = XCreatePixmap(XtDisplay(sketchpad),theRoot,thewidth+60,theheight+60,
     DefaultDepthOfScreen(XtScreen(sketchpad)));
 */
if(bitmap == NULL)
   bitmap = XCreatePixmap(XtDisplay(sketchpad),theRoot,1660,4156,
     DefaultDepthOfScreen(XtScreen(sketchpad)));
if(spotsmap == NULL)
   spotsmap = XCreatePixmap(XtDisplay(sketchpad),theRoot,1660,4156,
     DefaultDepthOfScreen(XtScreen(sketchpad)));

if( theGC== NULL)  theGC = XCreateGC( theDisplay, bitmap, 0, 0 );
if( showGC== NULL)     showGC = XCreateGC( theDisplay, theRoot, 0, 0 );
if( theGC0== NULL)    theGC0 = XCreateGC( theDisplay, bitmap, 0, 0 );
if( showGC0== NULL)   showGC0 = XCreateGC( theDisplay, theRoot, 0, 0 );
#ifdef SGI
   load_font(&font_info);
	XSetFont( theDisplay, theGC0, font_info->fid);
	XSetFont( theDisplay, showGC0, font_info->fid);
#endif
if(theGC20 == NULL)   theGC20 = XCreateGC( theDisplay, bitmap, 0, 0 );
if(showGC20 == NULL)   showGC20 = XCreateGC( theDisplay, theRoot, 0, 0 );
if(theGC40 == NULL)   theGC40 = XCreateGC( theDisplay, bitmap, 0, 0 );
if(showGC40 == NULL)   showGC40 = XCreateGC( theDisplay, theRoot, 0, 0 );
if(theGC60 == NULL)   theGC60 = XCreateGC( theDisplay, bitmap, 0, 0 );
if(showGC60 == NULL)   showGC60 = XCreateGC( theDisplay, theRoot, 0, 0 );
if(theGC80 == NULL)   theGC80 = XCreateGC( theDisplay, bitmap, 0, 0 );
if(showGC80 == NULL)   showGC80 = XCreateGC( theDisplay, theRoot, 0, 0 );
if(theGC100 == NULL)   theGC100 = XCreateGC( theDisplay, bitmap, 0, 0 );
if(showGC100 == NULL)   showGC100 = XCreateGC( theDisplay, theRoot, 0, 0 );
if(funcGC == NULL)   funcGC = XCreateGC( theDisplay, theRoot, 0, 0);
if(func2GC == NULL)   func2GC = XCreateGC( theDisplay, theRoot, 0, 0);
if(func3GC == NULL)   func3GC = XCreateGC( theDisplay, theRoot, 0, 0);
if(func4GC == NULL)   func4GC = XCreateGC( theDisplay, theRoot, 0, 0);
if(func5GC == NULL)   func5GC = XCreateGC( theDisplay, theRoot, 0, 0);
if(gridGC == NULL)   gridGC = XCreateGC( theDisplay, theRoot, 0, 0);
if(spotsGC == NULL)   spotsGC = XCreateGC( theDisplay, theRoot, 0, 0);
if(showGC10 == NULL)   showGC10 = XCreateGC( theDisplay, theRoot, 0, 0 );
if(spectGC == NULL)   spectGC = XCreateGC( theDisplay, theRoot, 0, 0 );


   XParseColor(theDisplay,theCmap,"gray0",&gray0);
   XAllocColor( theDisplay, theCmap,&gray0);
   XParseColor(theDisplay,theCmap,"gray20",&gray20);
   XAllocColor( theDisplay, theCmap,&gray20);
   XParseColor(theDisplay,theCmap,"gray40",&gray40);
   XAllocColor( theDisplay, theCmap,&gray40);
   XParseColor(theDisplay,theCmap,"gray60",&gray60);
   XAllocColor( theDisplay, theCmap,&gray60);
   XParseColor(theDisplay,theCmap,"gray80",&gray80);
   XAllocColor( theDisplay, theCmap,&gray80);
   XParseColor(theDisplay,theCmap,"gray100",&gray100);
   XAllocColor( theDisplay, theCmap,&gray100);
   XParseColor(theDisplay,theCmap,"medium aquamarine",&lightblue);
   XAllocColor( theDisplay, theCmap,&lightblue);
   XParseColor(theDisplay,theCmap,"blue",&blue);
   XAllocColor( theDisplay, theCmap,&blue);
   XParseColor(theDisplay,theCmap,"navy",&darkblue);
   XAllocColor( theDisplay, theCmap,&darkblue);
   XParseColor(theDisplay,theCmap,"midnightblue",&midnightblue);
   XAllocColor( theDisplay, theCmap,&midnightblue);
   XParseColor(theDisplay,theCmap,"yellow",&yellow);
   XAllocColor( theDisplay, theCmap,&yellow);
   XParseColor(theDisplay,theCmap,"red",&red);
   XAllocColor( theDisplay, theCmap,&red);
   XParseColor(theDisplay,theCmap,"RGBi:0.1/0.0/0.0",&darkred);
   XAllocColor( theDisplay, theCmap,&darkred);


   XParseColor(theDisplay,theCmap,"RGBi:1.0/0.2/0.0",&orange);
   XAllocColor( theDisplay, theCmap,&orange);
   XParseColor(theDisplay,theCmap,"green",&green);
   XAllocColor( theDisplay, theCmap,&green);
   XParseColor(theDisplay,theCmap,"brown",&brown);
   XAllocColor( theDisplay, theCmap,&brown);

   XParseColor(theDisplay,theCmap,"purple",&purple);
   XAllocColor( theDisplay, theCmap,&purple);

   XParseColor(theDisplay,theCmap,"cyan",&cyan);
   XAllocColor( theDisplay, theCmap,&cyan);
#ifdef SGI
   XParseColor(theDisplay,theCmap,"lightgreen",&mycadetblue);
#else
   XParseColor(theDisplay,theCmap,"RGBi:0.05/0.35/0.15",&mycadetblue);
#endif
   XAllocColor( theDisplay, theCmap,&mycadetblue);

   XSetForeground(theDisplay, gridGC, brown.pixel);

   xpos[1]=50; ypos[1]=theheight; xpos[2]=thewidth+50; ypos[2]=theheight;
   xpos2[1]=50; ypos2[1]=theheight+6; xpos2[2]=thewidth+50; ypos2[2]=theheight+6;
   xpos3[1]=50; ypos3[1]=10; xpos3[2]=50; ypos3[2]=theheight+10;

   XtVaSetValues(sketchpad,XmNwidth,thewidth+60,XmNheight,theheight+60,NULL);
   return sketchpad;
}
/*___________________________________________________________________________*/
void DestroyDrawingArea(void)
{
XtDestroyWidget(sketchpad);

}
/*___________________________________________________________________________*/
static void allocateBuffers(void)
{
  if(Wanal==NULL)fvec(Wanal,  Nw);
  if(Wsyn==NULL)fvec(Wsyn,  Nw);
  if(input==NULL)fvec(input,  Nw);
  if(output==NULL)fvec(output,  Nw);
  if(framebuff==NULL)framebuff =(short int *)calloc(Nw*2,sizeof(short int));
  if(frames==NULL)frames =(short int *)calloc(Nw*2,sizeof(short int));
  if(framebuff32==NULL)framebuff32 =(long int *)calloc(Nw*2,sizeof(long int));
  if(frames32==NULL)frames32 =(long int *)calloc(Nw*2,sizeof(long int));
  if(buffer==NULL)fvec(buffer,  N);
  if(channel==NULL)fvec(channel,  N+2);
  if(tempamp==NULL)fvec(tempamp,numchannels);
  if(tempfreq==NULL)fvec(tempfreq,numchannels);
  if(last==NULL)fvec(last, numchannels); 
  if(this==NULL)fvec(this, numchannels);

/* 
 if ((framebuff =(short int *)calloc(Nw*2,sizeof(short int)))==NULL) {
    fprintf(stderr,"Unable to allocate AIFF framebuffer!\n");
    exit(-1);
 if ((frames =(short int *)calloc(Nw*2,sizeof(short int)))==NULL) {
    fprintf(stderr,"Unable to allocate AIFF framebuffer!\n");
    exit(-1);
  }
*/
}
/*___________________________________________________________________________*/
static void deallocateBuffers(void)
{
if(Wanal != NULL)free(Wanal);
if(Wsyn != NULL)free(Wsyn);
if(input != NULL)free(input);
if(buffer != NULL)free(buffer);
if(channel != NULL)free(channel);
if(output != NULL)free(output);
if(tempamp != NULL)free(tempamp);
if(tempfreq != NULL)free(tempfreq);
if(last != NULL)free(last);
if(this != NULL)free(this);
if(framebuff != NULL) free(framebuff);
if(frames != NULL) free(framebuff);
if(framebuff32 != NULL) free(framebuff);
if(frames32 != NULL) free(framebuff);
Wanal=Wsyn=input=buffer=channel=output=tempamp=
	tempfreq=last=this=NULL; framebuff=NULL;
}

/*___________________________________________________________________________*/
void SetWatchCursor(w)
Widget w;
{
        static Cursor watch = (int) NULL;
	

        if(!watch)
                watch = XCreateFontCursor(XtDisplay(w),XC_watch);

        XDefineCursor(XtDisplay(w),XtWindow(w),watch);
#ifndef SGI   	
 		XRecolorCursor( XtDisplay(w), watch, &red, &gray100 );	
		
#endif

        XmUpdateDisplay(w);
}

/*_____________________________________________________________________*/
void ResetCursor(w)
Widget w;
{
        XUndefineCursor(XtDisplay(w),XtWindow(w));
#ifndef SGI
  pointCur = XCreateFontCursor(XtDisplay(w), XC_left_ptr);
  XDefineCursor(XtDisplay(w),XtWindow(w),pointCur);
  XRecolorCursor( XtDisplay(w), pointCur, &red, &gray100 );
  XSync(XtDisplay(w),0);   
#endif
        
        XmUpdateDisplay(w);
}

/*_____________________________________________________________________*/
void drawscale(void)
{
  int i, j, k, grafx, ppsec, fraction,step=1;
  char tall[10];
  float du;

  theGC=theGC0; showGC=showGC0;
  XDrawLine(theDisplay,XtWindow(sketchpad),showGC,
    40,theheight+20,thewidth+50,theheight+20);
  XDrawLine(theDisplay,bitmap,theGC,40,theheight+20,thewidth+50,theheight+20);

  XDrawLine(theDisplay,XtWindow(sketchpad),showGC,40,theheight+20,40,10);
  XDrawLine(theDisplay,bitmap,theGC,40,theheight+20,40,10);
/*b11*/
  XDrawLine(theDisplay,XtWindow(sketchpad),showGC,450,theheight+20,450,10);
  XDrawLine(theDisplay,bitmap,theGC,450,theheight+20,450,10);
/*endb11*/

 ppsec =  (int)((float)thewidth/duration);  /**SJ: 11/08/99*1/10-th of a second*/
/****0.25b11 - second vetrical scale****/
 du = duration;
 fraction = (int)(10.*duration)%10;
/*endb11*/


/*if(ppsec<64)step=2;*/
if(ppsec<30)step=2;

for (i=1; i<=(int)(duration+1.); i+=step) {
    /**SJ: 11/08/99**/
    grafx=i*ppsec+50;
 
if (step==1)
	for(j=1;j<=9;j++){
	if((i>(int)duration)&&(j>fraction))break;
	if(j%5==0)k=5;else k=0;
        XDrawLine(theDisplay,XtWindow(sketchpad),showGC,
          ppsec*(i-1)+j*ppsec/10+50,theheight+16,
	  ppsec*(i-1)+j*ppsec/10+50,theheight+20+k);
        XDrawLine(theDisplay,bitmap,theGC,
          ppsec*(i-1)+j*ppsec/10+50,theheight+16,
	  ppsec*(i-1)+j*ppsec/10+50,theheight+20+k);
	 }

if (step==2){
  if(i>1){
    XDrawLine(theDisplay,XtWindow(sketchpad),showGC,
      grafx - 3*ppsec/2,theheight+20,grafx - 3*ppsec/2,theheight+22);
    XDrawLine(theDisplay,bitmap,theGC,
      grafx - 3*ppsec/2,theheight+20,grafx - 3*ppsec/2,theheight+22);
	}
    XDrawLine(theDisplay,XtWindow(sketchpad),showGC,
      grafx - ppsec,theheight+20,grafx - ppsec,theheight+26);
    XDrawLine(theDisplay,bitmap,theGC,
      grafx - ppsec,theheight+20,grafx - ppsec,theheight+26);

    XDrawLine(theDisplay,XtWindow(sketchpad),showGC,
      grafx - ppsec/2,theheight+20,grafx - ppsec/2,theheight+22);
    XDrawLine(theDisplay,bitmap,theGC,
      grafx - ppsec/2,theheight+20,grafx - ppsec/2,theheight+22);
	}

    if(i>(int)duration)break;
    XDrawLine(theDisplay,XtWindow(sketchpad),showGC,
      grafx,theheight+14,grafx,theheight+26);
    XDrawLine(theDisplay,bitmap,theGC,
      grafx,theheight+14,grafx,theheight+26);
	/*printf("%d\n",grafx);   */

    sprintf(tall, "%d", i);
    XDrawString(theDisplay,XtWindow(sketchpad),showGC,
      grafx-5,theheight+40,tall,strlen(tall));
    XDrawString(theDisplay,bitmap,theGC,
      grafx-5,theheight+40,tall,strlen(tall));
  }


if((step==1)&&(i>1)){
   i--;

  for(j=1;j<=(int)(10.*duration)%i;j++){
	if(j%5==0)k=5;else k=0;
        XDrawLine(theDisplay,XtWindow(sketchpad),showGC,
          ppsec*i+j*ppsec/10+50,theheight+16,
	  ppsec*i+j*ppsec/10+50,theheight+20+k);
        XDrawLine(theDisplay,bitmap,theGC,
          ppsec*i+j*ppsec/10+50,theheight+16,
	  ppsec*i+j*ppsec/10+50,theheight+20+k);
	j++;
         }
      }

if(step==2)for(j=1;j<=3;j++){
if((grafx+j*ppsec/2)<(thewidth+50)){
    XDrawLine(theDisplay,XtWindow(sketchpad),showGC,
      grafx + j*ppsec/2,theheight+20,grafx + j*ppsec/2,
      j==2?theheight+26:theheight+22);
    XDrawLine(theDisplay,bitmap,theGC,
      grafx + j*ppsec/2,theheight+20,grafx + j*ppsec/2,
      j==2?theheight+26:theheight+22);
	}
     }



  for (i=1; i<=(int)(R/2000); i++) {
    grafx=theheight-(int)(i*1000./binfreq)+10;

    XDrawLine(theDisplay,XtWindow(sketchpad),showGC,35,grafx,45,grafx);
    XDrawLine(theDisplay,bitmap,theGC,35,grafx,45,grafx);
  
if(N>=1024)for(j = 9; j >= 1; j --){
    XDrawLine(theDisplay,XtWindow(sketchpad),showGC,j==5?37:40,
	grafx + (100.*j)/binfreq,42,grafx + (100.*j)/binfreq);
    XDrawLine(theDisplay,bitmap,theGC,j==5?37:40,
	grafx + (100.*j)/binfreq,42,grafx + (100.*j)/binfreq);
	}
/*b11*/
    XDrawLine(theDisplay,XtWindow(sketchpad),showGC,445,grafx,450,grafx);
    XDrawLine(theDisplay,bitmap,theGC,445,grafx,450,grafx);
/*endb11*/
    sprintf(tall, "%2d", i);
    XDrawString(theDisplay,XtWindow(sketchpad),showGC,
      2,grafx+5,tall,strlen(tall));
    XDrawString(theDisplay,bitmap,theGC,
      2,grafx+5,tall,strlen(tall));
  }
return;
}

/*______(these had to be rewritten because of a compiler problem)______*/
/*_____________________________________________________________________*/
float getfuncval(hnum)
int hnum;
{
float _x,_x1,_x0,_y,_y1,_y0;
_x=(float)(hnum*thewidth)/horiz_num+50.;
if (_x>(float)xpos[funcpt+1])if(funcpt<numsquare) funcpt++;
_x1=(float)xpos[funcpt+1];_x0 =(float)xpos[funcpt];
_y1=(float)ypos[funcpt+1];_y0 =(float)ypos[funcpt];

_y = theheight-(_y0+(_x-_x0)*(_y1-_y0)/(_x1-_x0))+10.;
/*
printf("x=%4.1f, ypos[%2d]=%4.1f, xpos[%2d]=%4.1f, ypos[%2d]=%4.1f, ypos[%2d]=%4.1f, x=%4.1f\n",\
           _x, funcpt,   _y0,   funcpt, _x0,     funcpt+1, _y1,  funcpt+1, _x1,   _y);
*/
return _y;
}

/*_____________________________________________________________________*/
float getfuncval2(hnum2)
int hnum2;
{
float _x,_x1,_x0,_y,_y1,_y0;
_x=(float)(hnum2*thewidth)/horiz_num+50.;
if (_x>(float)xpos2[funcpt2+1])if(funcpt2<numsquare2) funcpt2++;
_x1=(float)xpos2[funcpt2+1];_x0 =(float)xpos2[funcpt2];
_y1=(float)ypos2[funcpt2+1];_y0 =(float)ypos2[funcpt2];

_y = theheight-(_y0+(_x-_x0)*(_y1-_y0)/(_x1-_x0))+10.;
/*
printf("x=%4.1f, ypos[%2d]=%4.1f, xpos[%2d]=%4.1f, ypos[%2d]=%4.1f, ypos[%2d]=%4.1f, x=%4.1f\n",\
           _x, funcpt2,   _y0,   funcpt2, _x0,     funcpt2+1, _y1,  funcpt2+1, _x1,   _y);
*/
return _y;
}

/*_____________________________________________________________________*/
float getfuncval3(vnum3)
int vnum3;
{
float _x,_x1,_x0,_y,_y1,_y0;
_y=((float)(numchannels-vnum3)*theheight)/numchannels+10.;
if (_y<(float)ypos3[funcpt3-1])if(funcpt3>1) funcpt3--;
_y1=(float)ypos3[funcpt3-1];_y0 =(float)ypos3[funcpt3];
_x1=(float)xpos3[funcpt3-1];_x0 =(float)xpos3[funcpt3];

_x = _x0+(_y-_y0)*(_x1-_x0)/(_y1-_y0)-50.;
/*
printf("y=%4.1f, xpos[%2d]=%4.1f, ypos[%2d]=%4.1f, xpos[%2d]=%4.1f, ypos[%2d]=%4.1f, x=%4.1f\n",\
           _y, funcpt3,   _x0,  funcpt3, _y0, funcpt3-1, _x1,funcpt3-1, _y1,   _x);
*/
return _x;
}
/*_____________________end of rewritten code___________________________*/
/*_____________________________________________________________________*/
void AreaSet(void)
{
  int swap;

  if ((areax1==areax2) && (areay1==areay2)) {
    areat1=0; areat2=horiz_num;
    areaf1=0; areaf2=numchannels;
    return;
    }
    areat1=((areax1-50)*horiz_num)/thewidth;
    if (areat1<0) areat1=0; if (areat1>horiz_num) areat1=horiz_num;
    areat2=((areax2-50)*horiz_num)/thewidth;
    if (areat2<0) areat2=0; if (areat2>horiz_num) areat2=horiz_num;
    if (areat1>areat2) { swap=areat1; areat1=areat2; areat2=swap; }
    areaf1=theheight-areay1+10;
    if (areaf1<0) areaf1=0; if (areaf1>numchannels) areaf1=numchannels;
    areaf2=theheight-areay2+10;
    if (areaf2<0) areaf2=0; if (areaf2>numchannels) areaf2=numchannels;
    if (areaf1>areaf2) { swap=areaf1; areaf1=areaf2; areaf2=swap; }
}

/*_____________________________________________________________________*/
void AreaSet2(void)
{
    int swap;

    if ((areax21==areax22) && (areay21==areay22)) {
      areat1=0; areat2=horiz_num;
      areaf1=0; areaf2=numchannels;
      return;
      }
    areat1=((areax21-50)*horiz_num)/thewidth;
    if (areat1<0) areat1=0; if (areat1>horiz_num) areat1=horiz_num;
    areat2=((areax22-50)*horiz_num)/thewidth;
    if (areat2<0) areat2=0; if (areat2>horiz_num) areat2=horiz_num;
    if (areat1>areat2) { swap=areat1; areat1=areat2; areat2=swap; }
    areaf1=theheight-areay21+10;
    if (areaf1<0) areaf1=0; if (areaf1>numchannels) areaf1=numchannels;
    areaf2=theheight-areay22+10;
    if (areaf2<0) areaf2=0; if (areaf2>numchannels) areaf2=numchannels;
    if (areaf1>areaf2) { swap=areaf1; areaf1=areaf2; areaf2=swap; }
}

/*_____________________________________________________________________*/
void AreaSet3(void)
{
    int swap;

    if ((areax31==areax32) && (areay31==areay32)) {
      areat1=0; areat2=horiz_num;
      areaf1=0; areaf2=numchannels;
      return;
      }
    areat1=((areax31-50)*horiz_num)/thewidth;
    if (areat1<0) areat1=0; if (areat1>horiz_num) areat1=horiz_num;
    areat2=((areax32-50)*horiz_num)/thewidth;
    if (areat2<0) areat2=0; if (areat2>horiz_num) areat2=horiz_num;
    if (areat1>areat2) { swap=areat1; areat1=areat2; areat2=swap; }
    areaf1=theheight-areay31+10;
    if (areaf1<0) areaf1=0; if (areaf1>numchannels) areaf1=numchannels;
    areaf2=theheight-areay32+10;
    if (areaf2<0) areaf2=0; if (areaf2>numchannels) areaf2=numchannels;
    if (areaf1>areaf2) { swap=areaf1; areaf1=areaf2; areaf2=swap; }
}


/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
/* CALLBACK ROUTINES */

void RedrawWin(void)
{
    int i, j, grafx, grafold=-1;
    long point=0;
    XPoint list0[LSIZE],list1[LSIZE],list2[LSIZE],list3[LSIZE],list4[LSIZE];
    int c0=0,c1=0,c2=0,c3=0,c4=0;

    if(sketchpad == (Widget)NULL)return;
    XFillRectangle(theDisplay, bitmap, theGC100, 0, 0, thewidth+70, theheight+70);
    XClearArea(theDisplay, XtWindow(sketchpad), 0, 0, 0, 0, True);
    SetWatchCursor(topLevel);

    if (horiz_num > 0) drawscale();

    for (j=0; j<horiz_num; j++)
    {
     grafx = (int)(j*thewidth/horiz_num)+50;
     if (grafx!=grafold)
      {
       for (i=0; i<numchannels; i++)
	 {
/*printf("%ld\t%f\n",point,megamp[point]);*/
		if (megamp[point]>0.0000003)  /*was 0.0000012*/
	   {
             int y = theheight-(int)(megfreq[point]/binfreq)+10;
             if (megamp[point]>0.0000100) {
            ADD_POINT(grafx,y,list0,c0,showGC0,theGC0);
             } else if (megamp[point]>0.0000060){
            ADD_POINT(grafx,y,list1,c1,showGC20,theGC20);
             } else if (megamp[point]>0.0000025) {
            ADD_POINT(grafx,y,list2,c2,showGC40,theGC40);
             } else if (megamp[point]>0.0000010) {
            ADD_POINT(grafx,y,list3,c3,showGC60,theGC60);
             } else {
            ADD_POINT(grafx,y,list4,c4,showGC80,theGC80);
             }
           }
           point++;
        }
      grafold=grafx;
     }
   else point+=numchannels;
   }
   FLUSH_LIST(list0,c0,showGC0,theGC0);
   FLUSH_LIST(list1,c1,showGC20,theGC20);
   FLUSH_LIST(list2,c2,showGC40,theGC40);
   FLUSH_LIST(list3,c3,showGC60,theGC60);
   FLUSH_LIST(list4,c4,showGC80,theGC80);

/*
  for (i=0; i<numspots; i++) {
    XFillRectangle(theDisplay,bitmap,spotsGC,
      (spotsx[i]-(spotsize/2)),(spotsy[i]-(spotsize/2)),spotsize,spotsize);
*/
  for (i=numspots -1; i>numspots; i--) {
    XFillRectangle(theDisplay,bitmap,spotsGC,
      (spotsx[i]-(spotsize/2)),(spotsy[i]-(spotsize/2)),spotsize,spotsize);


  }

  ResetCursor(topLevel);
}
/*_____________________________________________________________________*/
void RepositionCF(rx,ry)
float rx;
float ry;
{
int i;
float newpos;
/*funcpt=1;funcpt2=1;funcpt3=1;*/
for( i = 1; i <= numsquare; i++){
	newpos = 50.+ (xpos[i]-50.)*rx;
	xpos[i] = (int)newpos;
	if(ry != 1.0){
		newpos = 6.+ (ypos[i]-6.)*ry;
		ypos[i] = (int)newpos;
		}
	}
for( i = 1; i <= numsquare2; i++){
	newpos = 50.+ (xpos2[i]-50.)*rx;
/*printf("##  %f\t %d\t%f\n", rx, xpos2[i], newpos);*/
	xpos2[i] = (int)newpos;
	if(ry != 1.0){
		newpos = 6.+ (ypos2[i]-6.)*ry;
		ypos2[i] = (int)newpos;
		}
	}
for( i = 1; i <= numsquare3; i++){
	newpos = 50.+ (xpos3[i]-50.)*rx;
	xpos3[i] = (int)newpos;
	}
}
/*_____________________________________________________________________*/
void RedrawFunc(void)
{
  int i;
  if(sketchpad == NULL)return;
  if (XmToggleButtonGetState(displayToggleFunc) ||
    XmToggleButtonGetState(displayToggleFuncAll)) {
    for (i=1; i<=numsquare; i++) {
      XDrawRectangle(theDisplay,XtWindow(sketchpad),funcGC,
        xpos[i]-3,ypos[i]-3,6,6);
    }
    for (i=1; i<numsquare; i++) {
      XDrawLine(theDisplay,XtWindow(sketchpad),funcGC,
        xpos[i],ypos[i],xpos[i+1],ypos[i+1]);
    }
    if (selected>0) {
      XFillRectangle(theDisplay,XtWindow(sketchpad),funcGC,
        xpos[selected]-3,ypos[selected]-3,6,6);
    }
  }
}

/*_____________________________________________________________________*/
void RedrawFunc2(void)
{
  int i;
  if(sketchpad == NULL)return;
  if (XmToggleButtonGetState(displayToggleFunc2) ||
    XmToggleButtonGetState(displayToggleFuncAll)) {
    for (i=1; i<=numsquare2; i++) {
      XDrawRectangle(theDisplay,XtWindow(sketchpad),func2GC,
        xpos2[i]-3,ypos2[i]-3,6,6);
    }
    for (i=1; i<numsquare2; i++) {
      XDrawLine(theDisplay,XtWindow(sketchpad),func2GC,
        xpos2[i],ypos2[i],xpos2[i+1],ypos2[i+1]);
    }
    if (selected2>0) {
      XFillRectangle(theDisplay,XtWindow(sketchpad),func2GC,
        xpos2[selected2]-3,ypos2[selected2]-3,6,6);
    }
  }
}

/*_____________________________________________________________________*/
void RedrawFunc3(void)
{
  int i;
  if(sketchpad == NULL)return;
  if (XmToggleButtonGetState(displayToggleFunc3) ||
    XmToggleButtonGetState(displayToggleFuncAll)) {
    for (i=1; i<=numsquare3; i++) {
      XDrawRectangle(theDisplay,XtWindow(sketchpad),func3GC,
        xpos3[i]-3,ypos3[i]-3,6,6);
    }
    for (i=1; i<numsquare3; i++) {
      XDrawLine(theDisplay,XtWindow(sketchpad),func3GC,
        xpos3[i],ypos3[i],xpos3[i+1],ypos3[i+1]);
    }
    if (selected3>0) {
      XFillRectangle(theDisplay,XtWindow(sketchpad),func3GC,
        xpos3[selected3]-3,ypos3[selected3]-3,6,6);
    }
  }
}

/*_____________________________________________________________________*/
void RedrawArea(void)
{
  int x1, x2, y1, y2, swap;
  if(sketchpad == NULL)return;
  if (XmToggleButtonGetState(displayToggleArea) ||
    XmToggleButtonGetState(displayToggleAreaAll)) {
    x1=areax1; x2=areax2; y1=areay1; y2=areay2;
    if (x1>x2) { swap=x1; x1=x2; x2=swap; }
    if (y1>y2) { swap=y1; y1=y2; y2=swap; }
    XDrawRectangle(theDisplay,XtWindow(sketchpad),func3GC,x1,y1,x2-x1,y2-y1);
  }
if (XmToggleButtonGetState(displayToggleArea)) AreaSet();
}

/*_____________________________________________________________________*/
void RedrawArea2(void)
{
  int x1, x2, y1, y2, swap;
  if(sketchpad == NULL)return;
  if (XmToggleButtonGetState(displayToggleArea2) ||
    XmToggleButtonGetState(displayToggleAreaAll)) {
    x1=areax21; x2=areax22; y1=areay21; y2=areay22;
    if (x1>x2) { swap=x1; x1=x2; x2=swap; }
    if (y1>y2) { swap=y1; y1=y2; y2=swap; }
    XDrawRectangle(theDisplay,XtWindow(sketchpad),func4GC,x1,y1,x2-x1,y2-y1);
  }
if (XmToggleButtonGetState(displayToggleArea2)) AreaSet2();
}

/*_____________________________________________________________________*/
void RedrawArea3(void)
{
  int x1, x2, y1, y2, swap;
  if(sketchpad == NULL)return;
if (XmToggleButtonGetState(displayToggleArea3) ||
    XmToggleButtonGetState(displayToggleAreaAll)) {
    x1=areax31; x2=areax32; y1=areay31; y2=areay32;
    if (x1>x2) { swap=x1; x1=x2; x2=swap; }
    if (y1>y2) { swap=y1; y1=y2; y2=swap; }
    XDrawRectangle(theDisplay,XtWindow(sketchpad),func5GC,x1,y1,x2-x1,y2-y1);
  }
if (XmToggleButtonGetState(displayToggleArea3)) AreaSet3();
}

/*_____________________________________________________________________*/
void RedrawScale(void)
{
  int i, f, tgw;
  if(sketchpad == NULL)return;
  if (XmToggleButtonGetState(displayToggleScale)==FALSE) return;
  tgw = thewidth+50 < 1600 ? thewidth+50 : 1600;
  for (i=0; gridfreqs[i]<(R/2); i++) {
    f=theheight-(int)(gridfreqs[i]/binfreq)+10;
    if (gridfreqs[i]!=0) {
    XDrawLine(theDisplay,XtWindow(sketchpad),gridGC,50,f,tgw,f);
    }
  }
}

/*_____________________________________________________________________*/
void drawscalegrid(void)
{
  int i, grafx, step=1;

  if(sketchpad == NULL)return;
  if (XmToggleButtonGetState(displayToggleGrid)==FALSE) return;
  theGC=theGC10; showGC=showGC10;
  if (duration>25.) step=2;
  if (duration>50.) step=4;
  for (i=1; i<=(int)(duration); i+=step) {
    grafx=(int)(i*thewidth/duration)+50;
    XDrawLine(theDisplay,XtWindow(sketchpad),showGC,grafx,theheight+25,grafx,15);
  }
  for (i=1; i<=(int)(R/2000); i++) {
    grafx=theheight-(int)(i*1000./binfreq)+10;
    XDrawLine(theDisplay,XtWindow(sketchpad),showGC,thewidth,grafx,45,grafx);
  }
}

/*_____________________________________________________________________*/
void RestoreWin(w, client, call)
Widget w;
XtPointer client, call;
{
if(sketchpad != NULL){
  XCopyArea(theDisplay, bitmap, XtWindow(sketchpad),
    DefaultGCOfScreen(XtScreen(sketchpad)), 0, 0, thewidth+70, theheight+70, 0, 0);
  RedrawFunc();
  RedrawFunc2();
  RedrawFunc3();
  RedrawArea();
  RedrawArea2();
  RedrawArea3();
  drawscale();
  RedrawScale();
  drawscalegrid();
}
}
/*___________________________________________________________________________*/
void ResizeWin(w, client, call)
Widget w;
XtPointer client, call;
{
return;
}
/*_____________________________________________________________________*/
/*implemented in 0.26 in order to reduce the increasing number of code lines*/
void RedrawAll(void)
{
  if (sketchpad==NULL) return;
  RedrawWin();
  RedrawFunc();
  RedrawFunc2();
  RedrawFunc3();
  RedrawArea();
  RedrawArea2();
  RedrawArea3();
  drawscale();
  RedrawScale();
}
/*_____________________________________________________________________*/
void Funckeydown(void)
{
  int i;

  if ((selected>1) && (selected<numsquare)) {
      for (i=selected; i<numsquare; i++) {
        xpos[i]=xpos[i+1]; ypos[i]=ypos[i+1];
      }
      numsquare--;
      if (selected==0) selected=0;
        else selected--;
      RestoreWin((Widget)NULL,(XtPointer)NULL,(XtPointer)NULL);
  }
}

/*_____________________________________________________________________*/
void Funckeydown2(void)
{
  int i;

  if ((selected2>1) && (selected2<numsquare2)) {
    for (i=selected2; i<numsquare2; i++) {
      xpos2[i]=xpos2[i+1]; ypos2[i]=ypos2[i+1];
    }
    numsquare2--;
    if (selected2==0) selected2=0;
      else selected2--;
    RestoreWin((Widget)NULL,(XtPointer)NULL,(XtPointer)NULL);
  }
}

/*_____________________________________________________________________*/
void Funckeydown3(void)
{
  int i;

  if ((selected3>1) && (selected3<numsquare3)) {
    for (i=selected3; i<numsquare3; i++) {
      xpos3[i]=xpos3[i+1]; ypos3[i]=ypos3[i+1];
    }
    numsquare3--;
    if (selected3==0) selected3=0;
      else selected3--;
    RestoreWin((Widget)NULL,(XtPointer)NULL,(XtPointer)NULL);
  }
}

/*_____________________________________________________________________*/
static void Keydown(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
  KeySym keysym;
  char key_string[1];
  int key_string_len, i;

  key_string_len=XLookupString((XKeyEvent *) event, key_string,
    sizeof key_string, &keysym, (XComposeStatus *) NULL);
  if ((keysym==XK_BackSpace) || (keysym==XK_Delete)) {
    if (XmToggleButtonGetState(displayToggleFunc)) Funckeydown();
    else if (XmToggleButtonGetState(displayToggleFunc2)) Funckeydown2();
    else if (XmToggleButtonGetState(displayToggleFunc3)) Funckeydown3();
  }
}

/*_____________________________________________________________________*/
void FuncGraphClick(x, y)
{
  int i, which=0, addpos;

  if (y>theheight+10) y=theheight+10;
  if (y<10) y=10;
  for (i=1; i<=numsquare; i++)
    if ((x>xpos[i]-3) && (x<xpos[i]+3)) {
      which=i;
      break;
    }
  if (which>0) selected=which;
  else if ((x>50) && (x<thewidth+50) && (numsquare<50)) {
    for (i=1; i<=numsquare; i++)
      if (x<xpos[i]) {
        addpos=i; break;
      }
    numsquare++;
    for (i=numsquare; i>addpos; i--) {
      xpos[i]=xpos[i-1]; ypos[i]=ypos[i-1];
    }
    xpos[addpos]=x; ypos[addpos]=y;
    selected=addpos;
  }
  RestoreWin((Widget)NULL,(XtPointer)NULL,(XtPointer)NULL);
}

/*_____________________________________________________________________*/
void FuncGraphClick2(x, y)
{
  int i, which=0, addpos;

  if (y>theheight+10) y=theheight+10;
  if (y<10) y=10;
  for (i=1; i<=numsquare2; i++)
    if ((x>xpos2[i]-3) && (x<xpos2[i]+3)) {
      which=i;
      break;
    }
  if (which>0) selected2=which;
  else if ((x>50) && (x<thewidth+50) && (numsquare2<50)) {
    for (i=1; i<=numsquare2; i++)
      if (x<xpos2[i]) {
        addpos=i; break;
      }
    numsquare2++;
    for (i=numsquare2; i>addpos; i--) {
      xpos2[i]=xpos2[i-1]; ypos2[i]=ypos2[i-1];
    }
    xpos2[addpos]=x; ypos2[addpos]=y;
    selected2=addpos;
  }
  RestoreWin((Widget)NULL,(XtPointer)NULL,(XtPointer)NULL);
}

/*_____________________________________________________________________*/
void FuncGraphClick3(x, y)
{
  int i, which=0, addpos;

  if (y>theheight+10) y=theheight+10;
  if (y<10) y=10;
  for (i=1; i<=numsquare3; i++)
    if ((y>ypos3[i]-3) && (y<ypos3[i]+3)) {
      which=i;
      break;
    }
  if (which>0) selected3=which;
  else if ((y>50) && (y<theheight+50) && (numsquare3<50)) {
    for (i=1; i<=numsquare3; i++)
      if (y<ypos3[i]) {
        addpos=i; break;
      }
    numsquare3++;
    for (i=numsquare3; i>addpos; i--) {
      xpos3[i]=xpos3[i-1]; ypos3[i]=ypos3[i-1];
    }
    xpos3[addpos]=x; ypos3[addpos]=y;
    selected3=addpos;
  }
  RestoreWin((Widget)NULL,(XtPointer)NULL,(XtPointer)NULL);
}

/*_____________________________________________________________________*/
static void GraphClick(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
  int x, y, i, which=0, addpos;

  XButtonEvent *motion=(XButtonEvent *)event;
  x=motion->x; y=motion->y;

  if (XmToggleButtonGetState(displayToggleFunc)) FuncGraphClick(x, y);
  else if (XmToggleButtonGetState(displayToggleFunc2)) FuncGraphClick2(x, y);
  else if (XmToggleButtonGetState(displayToggleFunc3)) FuncGraphClick3(x, y);
}

/*_____________________________________________________________________*/
void FuncGraphDrag(x, y)
{
  if (y>theheight+10) y=theheight+10;
  if (y<10) y=10;
  if (selected>0) {
    if (selected==1) ypos[1]=y;
    else if (selected==numsquare) ypos[numsquare]=y;
    else if ((x>xpos[selected-1]) && (x<xpos[selected+1])) {
      xpos[selected]=x; ypos[selected]=y;
    }
    RestoreWin((Widget)NULL,(XtPointer)NULL,(XtPointer)NULL);
  }
}

/*_____________________________________________________________________*/
void FuncGraphDrag2(x, y)
{
  if (y>theheight+10) y=theheight+10;
  if (y<10) y=10;
  if (selected2>0) {
    if (selected2==1) ypos2[1]=y;
    else if (selected2==numsquare2) ypos2[numsquare2]=y;
    else if ((x>xpos2[selected2-1]) && (x<xpos2[selected2+1])) {
      xpos2[selected2]=x; ypos2[selected2]=y;
    }
    RestoreWin((Widget)NULL,(XtPointer)NULL,(XtPointer)NULL);
  }
}

/*_____________________________________________________________________*/
void FuncGraphDrag3(x, y)
{
  if (x>thewidth+50) x=thewidth+50;
  if (x<50) x=50;
  if (selected3>0) {
    if (selected3==1) xpos3[1]=x;
    else if (selected3==numsquare3) xpos3[numsquare3]=x;
    else if ((y>ypos3[selected3-1]) && (y<ypos3[selected3+1])) {
      xpos3[selected3]=x; ypos3[selected3]=y;
    }
    RestoreWin((Widget)NULL,(XtPointer)NULL,(XtPointer)NULL);
  }
}

/*_____________________________________________________________________*/
static void GraphDrag(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
  int x, y;

  XButtonEvent *motion=(XButtonEvent *)event;
  x=motion->x; y=motion->y;

  if (XmToggleButtonGetState(displayToggleFunc)) FuncGraphDrag(x, y);
  else if (XmToggleButtonGetState(displayToggleFunc2)) FuncGraphDrag2(x, y);
  else if (XmToggleButtonGetState(displayToggleFunc3)) FuncGraphDrag3(x, y);
}

/*_____________________________________________________________________*/
void AreaGraphClick(x, y)
{
  if (y>theheight+10) y=theheight+10;
  if (y<10) y=10;
  if (x>thewidth+50) x=thewidth+50;
  if (x<40) x=40;
  areax1=areax2=x; areay1=areay2=y;
  AreaSet();
  RestoreWin((Widget)NULL,(XtPointer)NULL,(XtPointer)NULL);
}

/*_____________________________________________________________________*/
void AreaGraphClick2(x, y)
{
  if (y>theheight+10) y=theheight+10;
  if (y<10) y=10;
  if (x>thewidth+50) x=thewidth+50;
  if (x<40) x=40;
  areax21=areax22=x; areay21=areay22=y;
  AreaSet2();
  RestoreWin((Widget)NULL,(XtPointer)NULL,(XtPointer)NULL);
}

/*_____________________________________________________________________*/
void AreaGraphClick3(x, y)
{
  if (y>theheight+10) y=theheight+10;
  if (y<10) y=10;
  if (x>thewidth+50) x=thewidth+50;
  if (x<40) x=40;
  areax31=areax32=x; areay31=areay32=y;
  AreaSet3();
  RestoreWin((Widget)NULL,(XtPointer)NULL,(XtPointer)NULL);
}

/*_____________________________________________________________________*/
static void AreaClick(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
  int x, y;

  XButtonEvent *motion=(XButtonEvent *)event;
  x=motion->x; y=motion->y;

  if (XmToggleButtonGetState(displayToggleArea)) AreaGraphClick(x, y);
  else if (XmToggleButtonGetState(displayToggleArea2)) AreaGraphClick2(x, y);
  else if (XmToggleButtonGetState(displayToggleArea3)) AreaGraphClick3(x, y);
}
/*_____________________________________________________________________*/
void paintspot(x,y)
{
if (numspots>=MAX_PAINT)return;
spotsx[numspots]=x; spotsy[numspots]=y;
spotst[numspots]=((x-50)*horiz_num)/thewidth;
spotsf[numspots]=theheight-y+10;
XFillRectangle(theDisplay,bitmap,spotsGC,(x-(spotsize/2)),(y-(spotsize/2)),spotsize,spotsize);
XFillRectangle(XtDisplay(sketchpad),XtWindow(sketchpad),spotsGC,(x-(spotsize/2)),(y-(spotsize/2)),spotsize,spotsize);
numspots++;
}
/*_____________________________________________________________________*/
void AreaGraphDrag(x, y)
{
  if (y>theheight+10) y=theheight+10;
  if (y<10) y=10;
  if (x>thewidth+50) x=thewidth+50;
  if (x<40) x=40;
  if (XmToggleButtonGetState(displayToggleSpots)==False) {
    areax2=x; areay2=y;
    RestoreWin((Widget)NULL,(XtPointer)NULL,(XtPointer)NULL);
  }
/*
else if (numspots<MAX_PAINT) {
    spotsx[numspots]=x; spotsy[numspots]=y;
    spotst[numspots]=((x-50)*horiz_num)/thewidth;
    spotsf[numspots]=theheight-y+10;
    XFillRectangle(theDisplay,bitmap,spotsGC,(x-(spotsize/2)),(y-(spotsize/2)),spotsize,spotsize);
    XFillRectangle(XtDisplay(sketchpad),XtWindow(sketchpad),spotsGC,(x-(spotsize/2)),(y-(spotsize/2)),spotsize,spotsize);
    numspots++;
  }

paintspot(x,y);
*/
}

/*_____________________________________________________________________*/
void AreaGraphDrag2(x, y)
{
  if (y>theheight+20) y=theheight+20;
  if (y<20) y=20;
  if (x>thewidth+50) x=thewidth+50;
  if (x<40) x=40;
  if (XmToggleButtonGetState(displayToggleSpots)==False) {
    areax22=x; areay22=y;
    RestoreWin((Widget)NULL,(XtPointer)NULL,(XtPointer)NULL);
  }

/*
	else if (numspots<MAX_PAINT) {
    spotsx[numspots]=x; spotsy[numspots]=y;
    spotst[numspots]=((x-50)*horiz_num)/thewidth;
    spotsf[numspots]=theheight-y+10;
    XFillRectangle(theDisplay,bitmap,spotsGC,(x-(spotsize/2)),(y-(spotsize/2)),spotsize,spotsize);
    XFillRectangle(XtDisplay(sketchpad),XtWindow(sketchpad),spotsGC,(x-(spotsize/2)),(y-(spotsize/2)),spotsize,spotsize);
    numspots++;
  }

paintspot(x,y);
*/
}

/*_____________________________________________________________________*/
void AreaGraphDrag3(x, y)
{
  if (y>theheight+20) y=theheight+20;
  if (y<20) y=20;
  if (x>thewidth+50) x=thewidth+50;
  if (x<40) x=40;
  if (XmToggleButtonGetState(displayToggleSpots)==False) {
    areax32=x; areay32=y;
    RestoreWin((Widget)NULL,(XtPointer)NULL,(XtPointer)NULL);
  }
/*
	else if (numspots<MAX_PAINT) {
    spotsx[numspots]=x; spotsy[numspots]=y;
    spotst[numspots]=((x-50)*horiz_num)/thewidth;
    spotsf[numspots]=theheight-y+10;
    XFillRectangle(theDisplay,bitmap,spotsGC,(x-(spotsize/2)),(y-(spotsize/2)),spotsize,spotsize);
    XFillRectangle(XtDisplay(sketchpad),XtWindow(sketchpad),spotsGC,(x-(spotsize/2)),(y-(spotsize/2)),spotsize,spotsize);
    numspots++;
  }

paintspot(x,y);
*/
}
/*_____________________________________________________________________*/
void AreaSpotsDrag(x, y)
{
  if (y>theheight+20) y=theheight+20;
  if (y<20) y=20;
  if (x>thewidth+50) x=thewidth+50;
  if (x<40) x=40;
  if (XmToggleButtonGetState(displayToggleSpots))

  if (numspots<MAX_PAINT) paintspot(x,y);
}
/*_____________________________________________________________________*/
void AreaDrag(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
  int x, y;
  XButtonEvent *motion=(XButtonEvent *)event;

  x=motion->x; y=motion->y;

       if (XmToggleButtonGetState(displayToggleSpots))AreaSpotsDrag(x, y);
  else if (XmToggleButtonGetState(displayToggleArea)) AreaGraphDrag(x, y);
  else if (XmToggleButtonGetState(displayToggleArea2)) AreaGraphDrag2(x, y);
  else if (XmToggleButtonGetState(displayToggleArea3)) AreaGraphDrag3(x, y);
}

/*_____________________________________________________________________*/
void Cancel(w, client, call)
Widget w;
XtPointer client, call;
{
  Widget dialog=(Widget) client;
  XtUnmanageChild(dialog);
}

/*_____________________________________________________________________*/
/*Legacy code from Ceres & Ceres2 - deactivated in Ceres3 since v.0.26a2*/
void ShowHelp(w, client, call)
Widget w;
XtPointer client, call;
{
  Widget dialog=(Widget) client;
  XtManageChild(dialog);
}
/*_____________________________________________________________________*/
void ShowHtmlHelp(w, client, call)
Widget w;
XtPointer client, call;
{
XmUpdateDisplay(topLevel);
system("netscape");
printf("Starting HTML help\
 for Ceres3...\n");

}

/*_____________________________________________________________________*/
void PreGrid(Widget w, XtPointer client, XtPointer call)
{
Boolean tvalue = XmToggleButtonGetState(w);
pre_grid = tvalue;
/*printf("pre_grid = %d\n",(int)pre_grid);*/
XtVaSetValues(gridToggleMajor,XmNsensitive, pre_grid,NULL);
XtVaSetValues(gridToggleMinor,XmNsensitive, pre_grid,NULL);
XtVaSetValues(gridToggleAltd,XmNsensitive, pre_grid,NULL);
XtVaSetValues(gridTogglePenta,XmNsensitive, pre_grid,NULL);
XtVaSetValues(gridToggleMLT,XmNsensitive, pre_grid,NULL);
XtVaSetValues(gridToggleHarm,XmNsensitive, pre_grid,NULL);
XtVaSetValues(gridRadio,XmNsensitive, pre_grid,NULL);
XtVaSetValues(gridHSOption,XmNsensitive, pre_grid,NULL);
XtVaSetValues(gridLTOption,XmNsensitive, pre_grid,NULL);
XtVaSetValues(gridTextfield2,XmNsensitive, pre_grid,NULL);
}

void UsrGrid(Widget w, XtPointer client, XtPointer call)
{
Boolean tvalue = XmToggleButtonGetState(w);
usr_grid = tvalue;
/*printf("usr_grid = %d\n",(int)usr_grid);*/
XtVaSetValues(_1,XmNsensitive, usr_grid,NULL);
XtVaSetValues(_m2,XmNsensitive, usr_grid,NULL);
XtVaSetValues(_M2,XmNsensitive, usr_grid,NULL);
XtVaSetValues(_m3,XmNsensitive, usr_grid,NULL);
XtVaSetValues(_M3,XmNsensitive, usr_grid,NULL);
XtVaSetValues(_p4,XmNsensitive, usr_grid,NULL);
XtVaSetValues(_A4,XmNsensitive, usr_grid,NULL);
XtVaSetValues(_p5,XmNsensitive, usr_grid,NULL);
XtVaSetValues(_m6,XmNsensitive, usr_grid,NULL);
XtVaSetValues(_M6,XmNsensitive, usr_grid,NULL);
XtVaSetValues(_m7,XmNsensitive, usr_grid,NULL);
XtVaSetValues(_M7,XmNsensitive, usr_grid,NULL);
XtVaSetValues(gridRadio2,XmNsensitive, usr_grid,NULL);
}
/*_____________________________________________________________________*/
void ShowInfo(w, client, call)
Widget w;
XtPointer client, call;
{
if(helpOn)XtUnmanageChild(creditsBox);
  XtManageChild(aboutBox);helpOn = TRUE;
}
void InfoOk(w, client, call)
Widget w;
XtPointer client, call;
{
helpOn = FALSE;
XtUnmanageChild(aboutBox);
}
/*_____________________________________________________________________*/
void ShowCredits(w, client, call)
Widget w;
XtPointer client, call;
{
if(helpOn)XtUnmanageChild(aboutBox);
  XtManageChild(creditsBox);helpOn = TRUE;
}
void CreditsOk(w, client, call)
Widget w;
XtPointer client, call;
{
helpOn = FALSE;
XtUnmanageChild(creditsBox);
}

/*___________AUXILLIARY CERES3-Specific MATH STUFF_____________________*/
/*_____________________________________________________________________*/
/*__________________AREA FIND__________________________________________*/
void areafind(left,right,down,up)
int *left, *right, *down, *up;
{
Boolean isarea=False;
 if(isarea = XmToggleButtonGetState(displayToggleArea))goto proceed;
 if(isarea = XmToggleButtonGetState(displayToggleArea2))goto proceed;
 if(isarea = XmToggleButtonGetState(displayToggleArea3))goto proceed;

proceed:
if(isarea){ *left = areat1; *right = areat2; *down = areaf1; *up = areaf2;}
else{*left = 0; *right = horiz_num; *down = 0; *up = numchannels-1;}

}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
float ampdb(float avalue)	
{
 if( avalue<=0. ) return -120.;
 else avalue = 10.*log10(avalue) - 12.;
 return avalue;
 }
/*_____________________________________________________________________*/
/*__________________________________dbamp______________________________*/
/*double*/float dbamp(float db) /*converts db to amplitudes*/
{
#ifdef SGI
	return powf(10.,((db -12.)/20.));
#else	
	return pow(10.,((db -12.)/20.));
#endif

}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
float cent2fact(cent)
float cent;
{
float c;
c= cent/1200.;
#ifdef SGI
return powf(2.,c);
#else
return pow(2.,c);
#endif
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
float pitch2freq(s)
char *s;
{
float r;
float o;
char c;
/*55.0 = A0 ; equal temperament = 1.0594631*/
if ((s[0]=='c')||(s[0]=='C'))r=32.703;
if( ((s[0]=='c')||(s[0]=='C'))&&(s[1]=='b') )r=30.8677;
if( ((s[0]=='c')||(s[0]=='C'))&&(s[1]=='#') )r=34.6478;

if((s[0]=='d')||(s[0]=='D'))r=36.7081;
if( ((s[0]=='d')||(s[0]=='D'))&&(s[1]=='b') )r=34.6478;
if( ((s[0]=='d')||(s[0]=='D'))&&(s[1]=='#') )r=38.8909;

if  ((s[0]=='e')||(s[0]=='E')) r=41.2034;
if( ((s[0]=='e')||(s[0]=='E'))&&(s[1]=='b') )r=38.8909;
if( ((s[0]=='e')||(s[0]=='E'))&&(s[1]=='#') )r=43.6535;

if ((s[0]=='f')||(s[0]=='F')) r=43.6535; 
if (((s[0]=='f')||(s[0]=='F'))&&(s[1]=='b') )r=41.2034;
if (((s[0]=='f')||(s[0]=='F'))&&(s[1]=='#') )r=46.2493;

if ((s[0]=='g')||(s[0]=='G')) r=48.999;
if (((s[0]=='g')||(s[0]=='G'))&&(s[1]=='b') )r=46.2493;
if (((s[0]=='g')||(s[0]=='G'))&&(s[1]=='#') )r=51.913;

if ((s[0]=='a')||(s[0]=='A')) r=55.0;
if (((s[0]=='a')||(s[0]=='A'))&&(s[1]=='b') )r=51.913;
if (((s[0]=='a')||(s[0]=='A'))&&(s[1]=='#') )r=58.2705;

if ((s[0]=='b')||(s[0]=='B')) r=61.7354;
if (((s[0]=='b')||(s[0]=='B'))&&(s[1]=='b') )r=58.2705;
if (((s[0]=='b')||(s[0]=='B'))&&(s[1]=='#') )r=65.4064;


c = strlen(s)-1;
if(c>0){
if(s[c]=='0')o=1.;if(s[c]=='1')o=2.;if(s[c]=='2')o=4.;
if(s[c]=='3')o=8.;if(s[c]=='4')o=16.;if(s[c]=='5')o=32.;
if(s[c]=='6')o=64.;if(s[c]=='7')o=128.;if(s[c]=='8')o=256.;
if(s[c]=='9')o=512.;
if( (s[c]=='1')&&(s[c-1]=='-') )o=.5;
/*
printf("%d\t%f\t%f\t%f\n", c,r,o,r*o);
*/
return r*(float)o;
}
else return 440.;
}

/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

Boolean ratioOk(q,tr)
float q, tr;
{
if((q>1.)&&(q<tr))return True;
if((1./q)<tr)return True;
return False;
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void resetCF(one, two, three)
Boolean one, two, three;
{
        if(one){
/*
	  if((xpos[1]!=50)&&(ypos[1]!=theheight)&&\
	    (xpos[2]!=50+thewidth)&&(ypos[2]!=ypos[1])&&\
		(numsquare!=2))
*/
          xpos[1]=50; ypos[1]=theheight;
  	  xpos[2]=50+thewidth; ypos[2]=ypos[1];  	
  	  numsquare=2; selected=0;
	 /* printf("%d\t%d\n",thewidth,theheight); */
	    	
	  }

        if(two){
/*
	  if((xpos2[1]!=50)&&(ypos2[1]!=theheight+6)&&\
	    (xpos2[2]!=50+thewidth)&&(ypos2[2]!=ypos2[1])&&\
		(numsquare!=2))
*/
          xpos2[1]=50; ypos2[1]=theheight+6;
  	  xpos2[2]=50+thewidth; ypos2[2]=ypos2[1];  	
  	  numsquare2=2; selected=0;
	 /* printf("%d\t%d\n",thewidth>0?thewidth:0,theheight);*/
	   	
	  }
	if(three){
         xpos3[1]=50; ypos3[1]=10;
	 xpos3[2]=50; ypos3[2]=theheight+10;
         numsquare3 = 2; selected=0;
	 }
}

/*_______________________FILE MENU CALLBACKS___________________________*/
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

void Load(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(loadFileBox);    
  if(XtIsManaged(infoStereoRadio))XtUnmanageChild(infoStereoRadio);
}

/*___________________________________________________________*/
void GetFileInfo(w, client, call)
Widget w;
XtPointer client, call;
{
  XmString text;
  char  str[100],test[100];
  int rcode, R, fd, ok; 
/*
#ifdef SGI  
  int vers;
#else  
  long vers;
#endif
*/
  int l;
 DIR *dirp;
  char *filename=XmTextGetString(w);


  if (dirp=opendir(filename)) {
    closedir(dirp);
    return;
  }

/*
strcpy(test, filename);
l=strlen(test);
if(test[l-1]=='/'){
    XtManageChild(fileWarning);
    XtFree(filename);	
    return;
    }
*/


 fd=open(filename,O_RDONLY);
 if (fd==-1) {
 if(stereo == 0)
    if(XtIsManaged(infoStereoRadio))XtUnmanageChild(infoStereoRadio);
    text=XmStringCreateSimple("Can't open file");
    XtVaSetValues(infoL1,XmNlabelString,text,NULL); XmStringFree(text);
    text=XmStringCreateSimple(" ");
    XtVaSetValues(infoL2,XmNlabelString,text,NULL); XmStringFree(text);
    text=XmStringCreateSimple(" ");
    XtVaSetValues(infoL3,XmNlabelString,text,NULL); XmStringFree(text);
    XtFree(filename);
    return;
  }
/*-
#ifndef SNDLIB 
*/
/*- 
  infile=AFopenfd(fd, "r",  AF_NULL_FILESETUP);
*/
ok = reach_soundfile(&samps_per_frame, &R, /*&compression,*/
	&filefmt, &samp_type, /*& vers,*/ &bits_per_samp,&framecnt,  filename,  fd);


/*-*/
  if (/*infile==NULL*/!ok) {
    if(XtIsManaged(infoStereoRadio))XtUnmanageChild(infoStereoRadio);
    text=XmStringCreateSimple("Not a soundfile");
    XtVaSetValues(infoL1,XmNlabelString,text,NULL); XmStringFree(text);
    text=XmStringCreateSimple(" ");
    XtVaSetValues(infoL2,XmNlabelString,text,NULL); XmStringFree(text);
    text=XmStringCreateSimple(" ");
    XtVaSetValues(infoL3,XmNlabelString,text,NULL); XmStringFree(text);
    XtFree(filename);
    return;
  }
/*-

  samps_per_frame   = AFgetchannels(infile, AF_DEFAULT_TRACK);
  R                 = (int)AFgetrate(infile, AF_DEFAULT_TRACK);
  compression       = AFgetcompression(infile, AF_DEFAULT_TRACK);
  filefmt           = AFgetfilefmt(infile, &vers);   
  AFgetsampfmt(infile, AF_DEFAULT_TRACK, &samp_type, &bits_per_samp);
  framecnt          = AFgetframecnt(infile,  AF_DEFAULT_TRACK);
  AFclosefile(infile);
*/

  strcpy(str,"File Format:  ");
  
  
  if (filefmt==1/*AF_FILE_AIFFC*/){
  if(XtIsManaged(infoStereoRadio))XtUnmanageChild(infoStereoRadio);
		strcat(str,"SGI/Apple AIFC");/*1*/
		stereo = 0;
		}
    else if (filefmt==2/*AF_FILE_AIFF*/) strcat(str,"SGI/Apple AIFF");/*2*/
#ifdef SGI
    else if (filefmt==3/*AF_FILE_NEXTSND*/) strcat(str,"NeXT/Sun (snd)");/*3*/
    else if (filefmt==4/*AF_FILE_WAVE*/) strcat(str,"Windows Wave");/*4*/
	else if (filefmt==5/*AF_FILE_BICSF*/) strcat(str,"BICSF");/*5*/
	else if (filefmt==8/*AF_FILE_SOUNDESIGNER2*/) strcat(str,"Sound Designer 2");/*8*/
#elif SGI_LIBAUDIOFILE
    else if (filefmt==3/*AF_FILE_NEXTSND*/) strcat(str,"NeXT/Sun (snd)");/*3*/
    else if (filefmt==4/*AF_FILE_WAVE*/) strcat(str,"Windows Wave");/*4*/
	else if (filefmt==5/*AF_FILE_BICSF*/) strcat(str,"BICSF");/*5*/
#elif LIBSNDFILE
    else if (filefmt==3/*AF_FILE_NEXTSND*/) strcat(str,"NeXT/Sun (snd)");/*3*/
    else if (filefmt==4/*AF_FILE_WAVE*/) strcat(str,"Windows Wave");/*4*/
	else if (filefmt==5/*AF_FILE_BICSF*/) strcat(str,"BICSF");/*5*/
#endif
      else {
		strcat(str,"Unknown format");
		if(XtIsManaged(infoStereoRadio))XtUnmanageChild(infoStereoRadio);
		stereo = 0;
		}
  if (samps_per_frame==1){
  if(XtIsManaged(infoStereoRadio))XtUnmanageChild(infoStereoRadio);
		strcat(str,", Mono.");
		stereo = 0;
		}
    else if (samps_per_frame==2){ 
		if(!XtIsManaged(infoStereoRadio))XtManageChild(infoStereoRadio);
		strcat(str,", Stereo.");
		if(XmToggleButtonGetState(infoLToggle)==1) stereo = 1;
		if(XmToggleButtonGetState(infoRToggle)==1) stereo = 2;
		if(XmToggleButtonGetState(infoLRToggle)==1)stereo = 3;
		}
      else if (samps_per_frame==4){
		if(XtIsManaged(infoStereoRadio))XtUnmanageChild(infoStereoRadio);
		strcat(str,", Quad (unsupported).");
		stereo = 0;
		}
  text=XmStringCreateSimple(str);
  XtVaSetValues(infoL1,XmNlabelString,text,NULL); XmStringFree(text);
#ifdef SGI  
  sprintf(str,"Size:  \t%d frames, %.2f seconds.",framecnt,(double)framecnt/R);
#else
  sprintf(str,"Size:  %d frames, %.2f seconds.",framecnt,(double)framecnt/R);
#endif  
  text=XmStringCreateSimple(str);
  XtVaSetValues(infoL2,XmNlabelString,text,NULL); XmStringFree(text);
#ifdef SGI  
  sprintf(str,"Sampling rate:  \t%d Hz.",R);
#else  
  sprintf(str,"Sampling rate:  %d Hz.",R);
#endif
  text=XmStringCreateSimple(str);
  XtVaSetValues(infoL3,XmNlabelString,text,NULL); XmStringFree(text);
/*-*/
/*
close_soundfile(afname, fd);
*/
 /* AFclosefile(infile);*/
/*-*/
  close(fd);
  XtFree(filename);
}
/*________________________________________________________________________________*/
/*obsoleted in favor of analyze_soundfile(), because of using too many SGI system
	specific variables and calls, which prevented from portability (v.027a6, S.J.)
	*/
/*
void analyze (infile, name, fd)
AFfilehandle infile;
char *name;
int fd;
{
  XPoint list0[LSIZE],list1[LSIZE],list2[LSIZE],list3[LSIZE],list4[LSIZE];
  int c0=0,c1=0,c2=0,c3=0,c4=0;
  int in=-Nw,  i, j=0, eof=0, grafx, grafold=-1;
  long point=0;
  float ampsum = 0.;
  float avgbinamp = 0;
  float rx, ry;


  XFillRectangle(XtDisplay(sketchpad), bitmap, theGC100,
    0, 0, thewidth+70, theheight+70);
  XClearArea(XtDisplay(sketchpad), XtWindow(sketchpad), 0, 0, 0, 0, True);

  drawscale();
  eof=0; si_valid=-1;


  while (!eof) {

    in+=D;
    eof=shiftin(input,  Nw,  D, name, fd);

    fold(input,  Wanal,  Nw,  buffer,  N,  in);

    rfft(buffer,  N2,  FORWARD);

    convert(buffer,  channel,  N2,  D,  R);

    grafx = (int)(j++*thewidth/(float)horiz_num)+50;

    for (i=0; i<numchannels; i++) {
        megamp[point]=channel[i+i];
        megfreq[point]=channel[i+i+1];
        point++;
    }


    if (grafx!=grafold) {
      point-=numchannels;
        for (i=0; i<numchannels; i++) {
          if (megamp[point]>0.0000003) {
            int y = theheight-(int)(megfreq[point]/binfreq)+10;
            if (megamp[point]>0.0000100) {

         ADD_POINT(grafx,y,list0,c0,showGC0,theGC0);
            } else if (megamp[point]>0.0000060){
          ADD_POINT(grafx,y,list1,c1,showGC20,theGC20);
            } else if (megamp[point]>0.0000025) {
          ADD_POINT(grafx,y,list2,c2,showGC40,theGC40);
             } else if (megamp[point]>0.0000010) {
          ADD_POINT(grafx,y,list3,c3,showGC60,theGC60);

            } else {

          ADD_POINT(grafx,y,list4,c4,showGC80,theGC80);

            }
          }
          point++;
        }
      grafold=grafx;
    }

  }

  FLUSH_LIST(list0,c0,showGC0,theGC0);
  FLUSH_LIST(list1,c1,showGC20,theGC20);
  FLUSH_LIST(list2,c2,showGC40,theGC40);
  FLUSH_LIST(list3,c3,showGC60,theGC60);
  FLUSH_LIST(list4,c4,showGC80,theGC80);


point = 0; avgbinamp = 0.;
for(i=0; i < horiz_num; i++){  ampsum = 0.;
   for(j=0;j<numchannels;j++)ampsum+=megamp[point+j]*megamp[point+j];
   avgamp[i]  = ampsum/(float)numchannels;
   avgbinamp += avgamp[i];
   avgamp[i]  = sqrt(avgamp[i]);
   point+=numchannels;


   }
   avgbinamp = sqrt(avgbinamp/(float)horiz_num);
   printf("Analysis: average bin amplitude: %g\n",avgbinamp);

return;
}
*/
/*________________________________________________________________________________*/
void analyze_soundfile (char* name, int fd, int samps_per_frame, int bits_per_sample,int stm)
{
  XPoint list0[LSIZE],list1[LSIZE],list2[LSIZE],list3[LSIZE],list4[LSIZE];
  int c0=0,c1=0,c2=0,c3=0,c4=0;
  int in=-Nw,  i, j=0, eof=0, grafx, grafold=-1;
  long point=0;
  float ampsum = 0.;
  float avgbinamp = 0;
  float rx, ry;


  XFillRectangle(XtDisplay(sketchpad), bitmap, theGC100,
    0, 0, thewidth+70, theheight+70);
  XClearArea(XtDisplay(sketchpad), XtWindow(sketchpad), 0, 0, 0, 0, True);

  drawscale();
  eof=0; si_valid=-1;
  frames = framebuff;
  frames32 = framebuff32;
  
    printf("Bits_per_sample:  %d\n", bits_per_sample);  /**/

  while (!eof) {

    in+=D;

	if(bits_per_sample == 16)
    eof=rd_shiftin(input,  Nw,  D, frames, samps_per_frame, name, fd, &si_valid, stm);

	if((bits_per_sample == 24)||(bits_per_sample == 32))
    eof=rdl_shiftin(input,  Nw,  D, frames32, samps_per_frame, bits_per_sample, name, fd,
		 &si_valid, stm);


    fold(input,  Wanal,  Nw,  buffer,  N,  in);

    rfft(buffer,  N2,  FORWARD);

    convert(buffer,  channel,  N2,  D,  R);

    grafx = (int)(j++*thewidth/(float)horiz_num)+50;

    for (i=0; i<numchannels; i++) {
        megamp[point]=channel[i+i];
        megfreq[point]=channel[i+i+1];
        point++;
    }


    if (grafx!=grafold) {
      point-=numchannels;
        for (i=0; i<numchannels; i++) {
          if (megamp[point]>0.0000003) {
            int y = theheight-(int)(megfreq[point]/binfreq)+10;
            if (megamp[point]>0.0000100) {

         ADD_POINT(grafx,y,list0,c0,showGC0,theGC0);
            } else if (megamp[point]>0.0000060){
          ADD_POINT(grafx,y,list1,c1,showGC20,theGC20);
            } else if (megamp[point]>0.0000025) {
          ADD_POINT(grafx,y,list2,c2,showGC40,theGC40);
             } else if (megamp[point]>0.0000010) {
          ADD_POINT(grafx,y,list3,c3,showGC60,theGC60);

            } else {

          ADD_POINT(grafx,y,list4,c4,showGC80,theGC80);

            }
          }
          point++;
        }
      grafold=grafx;
    }

  }

  FLUSH_LIST(list0,c0,showGC0,theGC0);
  FLUSH_LIST(list1,c1,showGC20,theGC20);
  FLUSH_LIST(list2,c2,showGC40,theGC40);
  FLUSH_LIST(list3,c3,showGC60,theGC60);
  FLUSH_LIST(list4,c4,showGC80,theGC80);

/*  rightbins(); */


/*
	XtManageChild(sketchpad);
*/




point = 0; avgbinamp = 0.;
for(i=0; i < horiz_num; i++){  ampsum = 0.;
   for(j=0;j<numchannels;j++)ampsum+=megamp[point+j]*megamp[point+j];
   avgamp[i]  = ampsum/(float)numchannels;
   avgbinamp += avgamp[i];
   avgamp[i]  = sqrt(avgamp[i]);
   point+=numchannels;


   }
   avgbinamp = sqrt(avgbinamp/(float)horiz_num);
   printf("Analysis: average bin amplitude: %g\n",avgbinamp);

return;
}



/*__________________THIS_ONE DOES THE LOAD-DRAWING_____________________*/
void LoadOk(w, client, call)
Widget w;
XtPointer client, call;
{
    FILE *undofile, *redofile;
  XmFileSelectionBoxCallbackStruct
    *calldata=(XmFileSelectionBoxCallbackStruct*) call;
  char *filename, *valstring, comm[100];
  int fd, ok,dummy ;
  static XmStringCharSet charset =
                           (XmStringCharSet) XmSTRING_DEFAULT_CHARSET;
  XPoint list0[LSIZE],list1[LSIZE],list2[LSIZE],list3[LSIZE],list4[LSIZE];
  int c0=0,c1=0,c2=0,c3=0,c4=0;
  int in=-Nw,  i, j=0, eof=0, grafx, grafold=-1;
  long point=0;
  float ampsum = 0.;
  float avgbinamp = 0;
  float rx, ry;


  if((undofile=fopen("ceres_undo","r"))!=NULL)remove("ceres_undo");
  if((redofile=fopen("ceres_redo","r"))!=NULL)remove("ceres_redo");


 if(!XmStringGetLtoR(calldata->value, charset, &filename))return;

  XtUnmanageChild(loadFileBox); 
  valstring=XmTextGetString(displayTextfield);
  thewidth=atoi(valstring);
  XtFree(valstring);

  XmUpdateDisplay(w);
  SetWatchCursor(topLevel);
  XmUpdateDisplay(topLevel);
/*-
  infile=AFopenfile(filename, "r", in_AFsetup);
*/
fd=open(filename,O_RDONLY);
ok = reach_soundfile(&samps_per_frame, &R, /*&compression,*/
	&filefmt, &samp_type, /*& vers,*/ &bits_per_samp,&framecnt,  filename,  		
	fd);
  if (/*infile==NULL*/!ok) {
	if (fd != -1)close(fd);
    ResetCursor(topLevel);
    XtManageChild(fileWarning);
    XtFree(filename);
	ResetCursor(topLevel);
    return;
  }
/*
  AFclosefile(infile);
*/
close(fd);

  if (megfreq!=NULL) free(megfreq);
  if (megamp!=NULL)  free(megamp);
  if (avgamp!=NULL)  free(avgamp);
  if (fundarray!=NULL)  free(fundarray);
  if (interpol!=NULL)  free(interpol);
  megfreq=megamp=avgamp=NULL;
  fundarray=interpol=NULL;



/*============================================================*/
/*========New in v_0.27: independent sketchpad initialization==========*/

	if((sketchpad == (Widget)NULL)||( N == 0 )) N = GetFFTfromMenu();

	if(Nw==0)Nw= GetWinSizeFromMenu(N);
	if(D ==0)D = GetWinStepFromMenu(Nw);
	if(theheight> 0)oldheight= theheight;
	fftt = False;
	setFFTRadio(N, fftt);

	if(Nw < N) Nw = N;
	N2=N>>1; theheight = N2 + 1;  
	Nw2=Nw>>1;
if((D>Nw/2)||(D<Nw/16))D= Nw>>3;
    numchannels=N2+1;
printf("%d\t%d\t%d\n", N, Nw, D);

    printf("Number of phase vocoder channels: %d\n", numchannels);
    in = -Nw;

printf("thewidth = %d\n", thewidth);

setUpWindow( thewidth, theheight, &iwidth,
	 &iheight, &fwidth);
  I=D;     /* Interpolation factor */
  P=1.;    /* Oscbank pitch factor */
  synt=0.; /* Synthesis treshold */

  obank=0.;
  fast = 0;
    if(!XtIsManaged(frame))XtManageChild(frame);
	if(sketchpad == (Widget)NULL){
	sketchpad = CreateDrawingArea();
	
	XtAppAddActions(app_context, actions, XtNumber(actions));
	XtOverrideTranslations(sketchpad,XtParseTranslationTable(drawTranslations));
	XtAddCallback(sketchpad,XmNexposeCallback,RestoreWin,0);  
	XtAddCallback(sketchpad,XmNresizeCallback,ResizeWin,0);
	XtVaSetValues(sketchpad, XmNwidth,thewidth+60,
		XmNheight,theheight+60,NULL);
			
	XtVaSetValues(mainWindow,XmNwidth, iwidth, XmNheight, iheight,
 		/*VertScrollBar*XmNvalue, iheight,*/NULL);
 /*	return;*/
 	
 	XtManageChild(sketchpad);
 	XmUpdateDisplay(mainWindow);	
	makewindows(Wanal,  Wsyn,  Nw,  N,  I);
	RestoreWin((Widget)NULL,(XtPointer)NULL,(XtPointer)NULL);
	sethotcolors();
	}
	else {  

	XtVaSetValues(sketchpad, XmNwidth,thewidth+60,
		XmNheight,theheight+60,NULL);

    if(!XtIsManaged(sketchpad)){
    
    	XtVaSetValues(mainWindow,XmNwidth, iwidth, XmNheight, iheight,
 		/*VertScrollBar*XmNvalue, iheight,*/NULL);    
    
	XtManageChild(sketchpad);
		
	}
	


/*reposition and redraw control functions*/
	if(oldwidth <= 0) {rx=1.;} else rx = (float)thewidth/ (float)oldwidth; 
	if(oldheight <= 0){ry=1.;} else ry = (float)theheight/(float)oldheight;
	if(rx != 1. || ry != 1.)RepositionCF(rx,ry);



	printf("rx = %f\try = %f\n",rx, ry);
  	/*XtRealizeWidget(topLevel);*/
	RestoreWin((Widget)NULL,(XtPointer)NULL,(XtPointer)NULL);
/*	ResizeWin(); */
	}
/*  RedrawWin();*/
 
	/*=============end of sketchpad initialization======================*/
	/*============================================================*/

XmUpdateDisplay(topLevel);
  makewindows(Wanal,  Wsyn,  Nw,  N,  I);


/*-*/
fd=open(filename,O_RDONLY);
reach_soundfile(&samps_per_frame, &R, /*&compression,*/
	&filefmt, &samp_type, /*& vers,*/ &bits_per_samp,&framecnt,  filename,  		
	fd);
close(fd);

/*-
infile=AFopenfile(filename, "r", in_AFsetup);
  samps_per_frame   = AFgetchannels(infile, AF_DEFAULT_TRACK);
  R                 = (int)AFgetrate(infile, AF_DEFAULT_TRACK);
  compression       = AFgetcompression(infile, AF_DEFAULT_TRACK);
  filefmt           = AFgetfilefmt(infile, &vers);
  AFgetsampfmt(infile, AF_DEFAULT_TRACK, &samp_type, &bits_per_samp);
  framecnt          = AFgetframecnt(infile,  AF_DEFAULT_TRACK);
AFclosefile(infile);
*/
  horiz_num = ((framecnt/D)+(Nw/D));
  if (numchannels*horiz_num > 64000000) {
    ResetCursor(topLevel);
    XtManageChild(sizeWarning);
    goto failure;
  }
  duration = (float)framecnt/R;
  binfreq = (float)R/N;



  fvec(megfreq, numchannels*horiz_num);
  if (megfreq==NULL) {
    ResetCursor(topLevel);
    XtManageChild(sizeWarning);
    goto failure;
  }
  fvec(megamp, numchannels*horiz_num);
  if (megamp==NULL) {
    ResetCursor(topLevel);
    XtManageChild(sizeWarning);
    goto failure;
  }

  fvec(avgamp, horiz_num);
  if (avgamp==NULL) {
    ResetCursor(topLevel);
    XtManageChild(sizeWarning);
    goto failure;
  }
  fvec(fundarray, horiz_num);
  if (fundarray==NULL) {
    ResetCursor(topLevel);
    XtManageChild(sizeWarning);
    goto failure;
  }
  fvec(interpol, horiz_num);
  if (interpol==NULL) {
    ResetCursor(topLevel);
    XtManageChild(sizeWarning);
    goto failure;
  }

  areat1=0; areat2=horiz_num;
  areaf1=0; areaf2=numchannels;

/* all resources allocated, finally analyze the file */
/*-*/
/*-*/
 rd_open_soundfile( filename, fd);

/*-
  infile=AFopenfile(filename, "r", in_AFsetup);
*/
/*-*/
#ifdef MACOSX
XtVaSetValues(mainWindow,XmNwidth, iwidth, XmNheight, iheight,
 		/*VertScrollBar*XmNvalue, iheight,*/NULL);
XmUpdateDisplay(topLevel);
#endif

  analyze_soundfile(filename,fd, samps_per_frame, bits_per_samp, stereo);
/*-
  analyze(infile);
*/
/*-*/
  close_soundfile(filename, fd, 'i');
/*-
  AFclosefile(infile);
*/
/* to display name of file */
  strcpy(comm,"ceres3: ");
  strcat(comm,filename);	

  XtVaSetValues(topLevel,XmNtitle,comm,NULL);

  strcpy(curr,filename);

  failure:

/* end of new code */

  XtFree(filename);
  fileDirty = FALSE;
  oldN = N; oldNw = Nw;
  oldwidth = thewidth;
  oldheight = theheight;

/*XmUpdateDisplay(topLevel);*//**/
/*
  RedrawFunc();
  RedrawFunc2();
  RedrawFunc3();
  RedrawArea();
  RedrawArea2();
  RedrawArea3();

  RedrawAll();
*/
  ResetCursor(topLevel);
}
/*_____________________________________________________________________*/
void new_(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(newForm);
}


/*__________________THIS_ONE DOES THE NEW-DRAWING_____________________*/

void new_Ok(w, client, call)
Widget w;
XtPointer client, call;
{
    FILE *undofile, *redofile;
    char *valstring, comm[100];
    float val;
    long point=0; int i, j = 0;
    int c0=0,c1=0,c2=0,c3=0,c4=0;
    int grafx, grafold=-1;
    float rx, ry, ampsum = 0.;
	XPoint list0[LSIZE],list1[LSIZE],list2[LSIZE],list3[LSIZE],list4[LSIZE];


  valstring=XmTextGetString(newTextField);
  val = (float)atof(valstring);
  if(val <=0.1)val = 0.1;
  if(val >=60.)val = 60.;


  if((undofile=fopen("ceres_undo","r"))!=NULL)remove("ceres_undo");
  if((redofile=fopen("ceres_redo","r"))!=NULL)remove("ceres_redo");

/*============================================================*/
/*========New in v_0.27: independent sketchpad initialization==========*/

 valstring=XmTextGetString(displayTextfield);
 thewidth = atoi(valstring);	

	if((sketchpad == (Widget)NULL)||( N == 0 )){
	 N = GetFFTfromMenu();
	if(Nw==0)Nw= GetWinSizeFromMenu(N);
	if(D ==0)D = GetWinStepFromMenu(Nw);
	/*if(theheight> 0)oldheight= theheight;*/
	fftt = False;
	setFFTRadio(N, fftt);
	}
	if(Nw < N) Nw = N;
	N2=N>>1; theheight = N2 + 1;  
	Nw2=Nw>>1;
if((D>Nw/2)||(D<Nw/16))D= Nw>>3;
    numchannels=N2+1;
if(I==0)I=D;
printf("%d\t%d\t%d\n", N, Nw, D);

    printf("Number of phase vocoder channels: %d\n", numchannels);
   /* in = -Nw;*/

printf("thewidth = %d\t theheight = %d\n", thewidth,theheight);

setUpWindow( thewidth, theheight, &iwidth,
	 &iheight, &fwidth);
    if(!XtIsManaged(frame))XtManageChild(frame);
	if(sketchpad == (Widget)NULL){
	sketchpad = CreateDrawingArea();
	XtAppAddActions(app_context, actions, XtNumber(actions));
	XtOverrideTranslations(sketchpad,XtParseTranslationTable(drawTranslations));
	XtAddCallback(sketchpad,XmNexposeCallback,RestoreWin,0);  
	XtAddCallback(sketchpad,XmNresizeCallback,ResizeWin,0);
	XtManageChild(sketchpad);
	XtVaSetValues(mainWindow,XmNwidth, iwidth, XmNheight, iheight,
 		/*VertScrollBar*XmNvalue, iheight,*/NULL);
	makewindows(Wanal,  Wsyn,  Nw,  N,  I);
	RestoreWin((Widget)NULL,(XtPointer)NULL,(XtPointer)NULL);
	sethotcolors();

	}
	else {  

	XtVaSetValues(sketchpad, XmNwidth,thewidth+60,
		XmNheight,theheight+60,NULL);
    if(!XtIsManaged(frame))XtManageChild(frame);
    if(!XtIsManaged(sketchpad)){
	XtManageChild(sketchpad);
    	XtVaSetValues(mainWindow,XmNwidth, iwidth, XmNheight, iheight,
 		/*VertScrollBar*XmNvalue, iheight,*/NULL);
	}

  	/*XtRealizeWidget(topLevel);*/
	RestoreWin((Widget)NULL,(XtPointer)NULL,(XtPointer)NULL);
	ResizeWin((Widget)NULL,(XtPointer)NULL,(XtPointer)NULL);
	}	

	
XmUpdateDisplay(topLevel);
/*================end of sketchpad initialization===================*/
/*============================================================*/ 
/*printf("ypos[1] = %d\typos2[1] = %d\n",ypos[1],ypos2[1]);*/
  XtUnmanageChild(newForm); XmUpdateDisplay(w);
  SetWatchCursor(topLevel);
/*reposition and redraw control functions*/
	if(oldwidth <= 0.) {rx=1.;} else rx = (float)thewidth/ (float)oldwidth; 
	if(oldheight <= 0.){ry=1.;} else ry = (float)theheight/(float)oldheight;
	if(rx != 1. || ry != 1.)RepositionCF(rx,ry);


/*-*/
switch (rN) {
	case 0:  R = 44100; break;
	case 1:  R = 48000; break;
	case 2:  R = 22050; break;
	default: R = 44100; break;
}
hack_soundinfo(&samps_per_frame, &R, 
	&filefmt, &samp_type, &bits_per_samp,&framecnt, &val);
/*
  samps_per_frame   = 1;
  R                 = 44100;
  compression       = AF_COMPRESSION_NONE;
  filefmt           = AF_FILE_AIFF;
  samp_type         = AF_SAMPFMT_TWOSCOMP;
  bits_per_samp     = 16;
  framecnt          = (long)(val*R)+1;
*/
/*-*/
  horiz_num = ((framecnt/D)+(Nw/D));
  if (numchannels*horiz_num > 64000000) {
    ResetCursor(topLevel);
    XtManageChild(sizeWarning);
    return;
  }
  duration = (float)framecnt/R;
  binfreq = (float)R/N;

  printf("\nScratch pad binfreq : %f Hertz\n", binfreq); 

  if (megfreq!=NULL) free(megfreq);
  if (megamp!=NULL)  free(megamp);
  if (avgamp!=NULL)  free(avgamp);
  if (fundarray!=NULL)  free(fundarray);
  if (interpol!=NULL)  free(interpol);
  megfreq=megamp=avgamp=NULL;
printf("Deallocated\n");
  fvec(megfreq, numchannels*horiz_num);
  if (megfreq==NULL) {
    ResetCursor(topLevel);
    XtManageChild(sizeWarning);
    return;
  }
  fvec(megamp, numchannels*horiz_num);
  if (megamp==NULL) {
    ResetCursor(topLevel);
    XtManageChild(sizeWarning);
    return;
  }

  fvec(avgamp, horiz_num);
  if (avgamp==NULL) {
    ResetCursor(topLevel);
    XtManageChild(sizeWarning);
    return;
  }

   fvec(fundarray, horiz_num);
  if (fundarray==NULL) {
    ResetCursor(topLevel);
    XtManageChild(sizeWarning);
    return;
  }
  fvec(interpol, horiz_num);
  if (interpol==NULL) {
    ResetCursor(topLevel);
    XtManageChild(sizeWarning);
    return;
  }
printf("Reallocated\n");
  areat1=0; areat2=horiz_num;
  areaf1=0; areaf2=numchannels;


  XFillRectangle(XtDisplay(sketchpad), bitmap, theGC100,
    0, 0, thewidth+70, theheight+70);
  XClearArea(XtDisplay(sketchpad), XtWindow(sketchpad), 0, 0, 0, 0, True);

  drawscale();

  while (point<(long)horiz_num*numchannels) {

    grafx = (int)(j++*thewidth/horiz_num)+50;
    for (i=0; i<numchannels; i++) {
        if(mN==0){megfreq[point]=((float)i+.5)*binfreq;
		   megamp[point]=.000002;
		}
	else if(mN==1){megfreq[point]=(rand()/(float)RAND_MAX)*22050.;
		  megamp[point]=.0000025*(rand()/(float)RAND_MAX);
		}
	/*
	if(i>=numchannels-2)printf("%d\t%ld\t%f\n",i,point,megamp[point]);
	*/
        point++;
       }
    if (grafx!=grafold) {
      point-=numchannels;
        for (i=0; i<numchannels; i++) {
          if (megamp[point]>0.0000003) {
            int y = theheight-(int)(megfreq[point]/binfreq)+10;
            if (megamp[point]>0.0000100) {
           ADD_POINT(grafx,y,list0,c0,showGC0,theGC0);
            } else if (megamp[point]>0.0000060){
           ADD_POINT(grafx,y,list1,c1,showGC20,theGC20);
            } else if (megamp[point]>0.0000025) {
           ADD_POINT(grafx,y,list2,c2,showGC40,theGC40);
             } else if (megamp[point]>0.0000010) {
            ADD_POINT(grafx,y,list3,c3,showGC60,theGC60);

            } else {
           ADD_POINT(grafx,y,list4,c4,showGC80,theGC80);
            }
          }
          point++;
        }
      grafold=grafx;
    }
  }
  FLUSH_LIST(list0,c0,showGC0,theGC0);
  FLUSH_LIST(list1,c1,showGC20,theGC20);
  FLUSH_LIST(list2,c2,showGC40,theGC40);
  FLUSH_LIST(list3,c3,showGC60,theGC60);
  FLUSH_LIST(list4,c4,showGC80,theGC80);



point = 0;
for(i=0; i < horiz_num; i++){  ampsum = 0.;
   for(j=0;j<numchannels;j++)ampsum+=megamp[point+j]*megamp[point+j];
   avgamp[i] = sqrt(ampsum)/sqrt((float)numchannels);point+=numchannels;
  /* printf("%f\n",avgamp[i]);  */
   }
   /*
  for(j=numchannels-1;j<numchannels;j++)for(i=0; i < horiz_num; i++)printf(">>%ld\t%f\n",j+numchannels*i,megamp[j+numchannels*i]);
*/
/*
 if(oldwidth <= 0.) {rx=1.;} else rx = (float)thewidth/ (float)oldwidth; 
 if(oldheight <= 0.){ry=1.;} else ry = (float)theheight/(float)oldheight;
 if(rx != 1. || ry != 1.)RepositionCF(rx,ry);
*/
  oldwidth = thewidth;
  oldheight = theheight;

 strcpy(comm,"ceres3: ");
  strcat(comm,"New");
  XtVaSetValues(topLevel,XmNtitle,comm,NULL);
printf("ypos[1] = %d\typos2[1] = %d\n",ypos[1],ypos2[1]);
  rightbins();
  RestoreWin((Widget)NULL,(XtPointer)NULL,(XtPointer)NULL);
  RedrawFunc();
  RedrawFunc2();
  RedrawFunc3();
  RedrawArea();
  RedrawArea2();
  RedrawArea3();
  ResetCursor(topLevel);
}

/*_____________________________________________________________________*/
void amptrack(left,right,down,up)
int left,right,down,up;
{
float ampsum; int i, j;
long point = left*numchannels;
for(i=left; i < right; i++){  ampsum = 0.;
   for(j=down;j<up;j++)ampsum+=megamp[point+j]*megamp[point+j];
   avgamp[i] = sqrt(ampsum)/sqrt((float)numchannels);point+=numchannels;
/*   printf("#%f\n",avgamp[i]);  */
   }
}

/*_____________________________________________________________________*/

void Image(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(imageFileBox);
}

/*_______________THIS IS THE IMAGE_LOAD DRAWING ROUTINE________________*/
/*_____________________________________________________________________*/
void ImageOk(w, client, call)
Widget w;
XtPointer client, call;
{
  XmFileSelectionBoxCallbackStruct
    *calldata=(XmFileSelectionBoxCallbackStruct*) call;
  char *filename, *valstring, line[200], comm[100];
  XPoint list0[LSIZE],list1[LSIZE],list2[LSIZE],list3[LSIZE],list4[LSIZE];
  int c0=0,c1=0,c2=0,c3=0,c4=0;
  static XmStringCharSet charset =
                           (XmStringCharSet) XmSTRING_DEFAULT_CHARSET;
  int i, j=0, grafx, grafold=-1, x, y, xc, yc, valR, valG, valB, ny,nny;
  long point=0;
  FILE *infile;
  float fr, fny;

  float ampsum = 0.;
  Boolean neg = XmToggleButtonGetState(imageToggle);
  Boolean r = XmToggleButtonGetState(imageToggleR);
  Boolean g = XmToggleButtonGetState(imageToggleG);
  Boolean b = XmToggleButtonGetState(imageToggleB);
  Boolean full = XmToggleButtonGetState(imageToggleFull);
  float rx, ry;


/*============================================================*/
/*========New in v_0.27: independent sketchpad initialization==========*/

 valstring=XmTextGetString(displayTextfield);
 thewidth = atoi(valstring);	

	if((sketchpad == (Widget)NULL)||( N == 0 )){
	 N = GetFFTfromMenu();
	if(Nw==0)Nw= GetWinSizeFromMenu(N);
	if(D ==0)D = GetWinStepFromMenu(Nw);
	/*if(theheight> 0)oldheight= theheight;*/
	fftt = False;
	setFFTRadio(N, fftt);
	}
	if(Nw < N) Nw = N;
	N2=N>>1; theheight = N2 + 1;  
	Nw2=Nw>>1;
if((D>Nw/2)||(D<Nw/16))D= Nw>>3;
    numchannels=N2+1;
printf("%d\t%d\t%d\n", N, Nw, D);

    printf("Number of phase vocoder channels: %d\n", numchannels);
   /* in = -Nw;*/

printf("thewidth = %d\n", thewidth);

setUpWindow( thewidth, theheight, &iwidth,
	 &iheight, &fwidth);
    if(!XtIsManaged(frame))XtManageChild(frame);
	if(sketchpad == (Widget)NULL){
	sketchpad = CreateDrawingArea();
	XtAppAddActions(app_context, actions, XtNumber(actions));
	XtOverrideTranslations(sketchpad,XtParseTranslationTable(drawTranslations));
	XtAddCallback(sketchpad,XmNexposeCallback,RestoreWin,0);  
	XtAddCallback(sketchpad,XmNresizeCallback,ResizeWin,0);
	XtManageChild(sketchpad);
	XtVaSetValues(mainWindow,XmNwidth, iwidth, XmNheight, iheight,
 		/*VertScrollBar*XmNvalue, iheight,*/NULL);
	makewindows(Wanal,  Wsyn,  Nw,  N,  I);
	RestoreWin((Widget)NULL,(XtPointer)NULL,(XtPointer)NULL);
	sethotcolors();

	}
	else {  

	XtVaSetValues(sketchpad, XmNwidth,thewidth+60,
		XmNheight,theheight+60,NULL);
    if(!XtIsManaged(frame))XtManageChild(frame);
    if(!XtIsManaged(sketchpad)){
	XtManageChild(sketchpad);
    	XtVaSetValues(mainWindow,XmNwidth, iwidth, XmNheight, iheight,
 		/*VertScrollBar*XmNvalue, iheight,*/NULL);
	}

  	/*XtRealizeWidget(topLevel);*/
	RestoreWin((Widget)NULL,(XtPointer)NULL,(XtPointer)NULL);
	ResizeWin((Widget)NULL,(XtPointer)NULL,(XtPointer)NULL);
	}	
	


/*================end of sketchpad initialization===================*/
/*============================================================*/ 

  XtUnmanageChild(imageFileBox);
  SetWatchCursor(topLevel);


  XmUpdateDisplay(topLevel);

  if(!XmStringGetLtoR(calldata->value, charset, &filename))return;

  infile=fopen(filename, "r");
  if (infile==NULL) {
    ResetCursor(topLevel);
    XtManageChild(fileWarning);
    XtFree(filename);
    return;
  }

  fgets(line, 200, infile); /* P3 */
/*  fgets(line, 200, infile); */
/* # CREATOR */
  fgets(line, 200, infile); if (line[0]=='#') fgets(line, 200, infile);
  sscanf(line,"%d %d",&x,&y); printf("%d %d\n",x,y);
  fgets(line, 200, infile);
/*-*/
switch (rN) {
	case 0:  R = 44100; break;
	case 1:  R = 48000; break;
	case 2:  R = 22050; break;
	default: R = 44100; break;
}
hack_soundinfo(&samps_per_frame, &R, /*&compression,*/
	&filefmt, &samp_type, &bits_per_samp, NULL, NULL);

/*
  samps_per_frame   = 1;
  R                 = 44100;
  compression       = AF_COMPRESSION_NONE;
  filefmt           = AF_FILE_AIFF;
  samp_type         = AF_SAMPFMT_TWOSCOMP;
  bits_per_samp     = 16;
*/
/*-*/
  horiz_num=x;
  framecnt=(horiz_num-(Nw/D))*D;
  if (numchannels*horiz_num > 32000000) {
    ResetCursor(topLevel);
    XtManageChild(sizeWarning);
    fclose(infile);
    XtFree(filename);
    return;
  }
  duration = (float)framecnt/R;
  binfreq = (float)R/N;
  if (megfreq!=NULL) free(megfreq);
  if (megamp!=NULL) free(megamp);
  if(avgamp!=NULL) free(avgamp);
  if(fundarray!=NULL) free(fundarray);
  if(interpol!=NULL) free(interpol);
  megfreq=megamp=avgamp=fundarray=interpol=NULL;
  fvec(megfreq, numchannels*horiz_num);
  if (megfreq==NULL) {
    ResetCursor(topLevel);
    XtManageChild(sizeWarning);
    fclose(infile);
    XtFree(filename);
    return;
  }
  fvec(megamp, numchannels*horiz_num);
  if (megamp==NULL) {
    ResetCursor(topLevel);
    XtManageChild(sizeWarning);
    fclose(infile);
    XtFree(filename);
    return;
  }
  fvec(avgamp, horiz_num);
  if (avgamp==NULL) {
    ResetCursor(topLevel);
    XtManageChild(sizeWarning);
    fclose(infile);
    XtFree(filename);
    return;
  }
  fvec(fundarray, horiz_num);
  if (fundarray==NULL) {
    ResetCursor(topLevel);
    XtManageChild(sizeWarning);
    fclose(infile);
    XtFree(filename);
    return;
  }
  fvec(interpol, horiz_num);
  if (interpol==NULL) {
    ResetCursor(topLevel);
    XtManageChild(sizeWarning);
    fclose(infile);
    XtFree(filename);
    return;
  }
  areat1=0; areat2=horiz_num;
  areaf1=0; areaf2=numchannels;
/*  area x1=areax2; areay1=areay2;*/

  XFillRectangle(XtDisplay(sketchpad), bitmap, theGC100,
    0, 0, thewidth+70, theheight+70);
  XClearArea(XtDisplay(sketchpad), XtWindow(sketchpad), 0, 0, 0, 0, True);

  drawscale();
if(full){
  ny = numchannels/y; fny = numchannels/(float)y;
  nny = y*ny;
  }else{
  ny = 1; fny = 1.; nny = numchannels;
  }

  fr=(y*fny+1.)*binfreq; point=0;
  for (xc=0; xc<x; xc++) for (yc=0; yc<numchannels; yc++) megfreq[point++]=50.;
	/*if(ny == 0)ny=1; printf("%d\n",ny);*/

  for (yc=0; yc</*y*/numchannels; yc+=ny/*yc++*/) {
    fr-=fny*binfreq;
    for (i=0; i<x; i++) {
        fscanf(infile,"%d %d %d", &valR, &valG, &valB);
	if(neg){
        valR=255-valR; valG=255-valG; valB=255-valB;
		}
		if(!r)valR=127; if(!g)valG=127; if(!b)valB=127;
	/*printf("%d\t%d\t%d\n", valR, valG, valB);*/
        /*if (y-yc<numchannels-2)*/ 
	if ((nny-yc<numchannels-2)&&(nny-yc>=0))
	{
          megamp[(nny-yc)+i*numchannels]=(float)valR*(float)valG*(float)valB
            *0.000000000001;
          megfreq[(nny-yc)+i*numchannels]=fr+rand()/RAND_MAX*binfreq;
	if(i<2)printf("%d\t%d\n", i*numchannels+nny-yc,ny);
        }
    }
  }
  for (xc=0; xc<x; xc++) {
    grafx = (int)(j++*thewidth/horiz_num)+50;
    if (grafx!=grafold) {
      point=xc*numchannels;
        for (i=0; i<numchannels; i++) {
          if (megamp[point]>0.0000003) {
            int y = theheight-(int)(megfreq[point]/binfreq)+10;
            if (megamp[point]>0.0000100) {
           ADD_POINT(grafx,y,list0,c0,showGC0,theGC0);
            } else if (megamp[point]>0.0000040){
           ADD_POINT(grafx,y,list1,c1,showGC20,theGC20);
            } else if (megamp[point]>0.0000015) {
           ADD_POINT(grafx,y,list2,c2,showGC40,theGC40);
            } else if (megamp[point]>0.0000010) {
           ADD_POINT(grafx,y,list3,c3,showGC60,theGC60);

            } else {
           ADD_POINT(grafx,y,list4,c4,showGC80,theGC80);
            }
          }
          point++;
        }
      grafold=grafx;
    }
  }
  FLUSH_LIST(list0,c0,showGC0,theGC0);
  FLUSH_LIST(list1,c1,showGC20,theGC20);
  FLUSH_LIST(list2,c2,showGC40,theGC40);
  FLUSH_LIST(list3,c3,showGC60,theGC60);
  FLUSH_LIST(list4,c4,showGC80,theGC80);

  rightbins();

  fclose(infile);

point = 0;
for(i=0; i < horiz_num; i++){  ampsum = 0.;
   for(j=0;j<numchannels;j++)ampsum+=megamp[point+j]*megamp[point+j];
   avgamp[i] = sqrt(ampsum)/sqrt((float)numchannels);point+=numchannels;
  /* printf("%f\n",avgamp[i]);  */
   }

/* to display name of file */
  strcpy(comm,"ceres3: ");
  strcat(comm,filename);
  XtVaSetValues(topLevel,XmNtitle,comm,NULL);
/* end of new code */
  XtFree(filename);
  fileDirty = FALSE;
  RedrawFunc();
  RedrawFunc2();
  RedrawFunc3();
  RedrawArea();
  RedrawArea2();
  RedrawArea3();
  ResetCursor(topLevel);
}

/*___________________________________________________________________*/
/* This is a modal dialog which forces user to answer a question
 * Source code mostly stolen from O'Reilly's: "Motif Programming 
 * Manual" ISBN 1-56592-016-3
 * Use: in danger of accidental file overwriting (SJ)
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
int AskUser(parent,question)
Widget parent;
char *question;
{
static Widget dialog;
XmString text, yes, no;
static int answer;
extern void response();
extern XtAppContext app_context;

if(!dialog){
/*	puts("Dialog_init");*/
	dialog=XmCreateWarningDialog(parent,"dialog",NULL,0);
	yes = XmStringCreateLocalized("Yes");
	no  = XmStringCreateLocalized("No");
	text = XmStringCreateLocalized("Warning!");
	XtVaSetValues(dialog,
			XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL,
			XmNokLabelString, yes,
			XmNcancelLabelString, no,
			XmNdialogTitle, text,
			XmNwidth, 200,
			NULL);
	XtSetSensitive(
		XmMessageBoxGetChild(dialog,
			XmDIALOG_HELP_BUTTON),False);
	temp=XmMessageBoxGetChild(dialog,
		XmDIALOG_HELP_BUTTON);
	XtUnmanageChild(temp);
	
	
	XtAddCallback (dialog, XmNokCallback, response, &answer);
	XtAddCallback (dialog, XmNcancelCallback, response, &answer);
	XmStringFree(yes);
	XmStringFree(no);
	}
/*puts("Dialog_init'd");*/

answer =0;
text = XmStringCreateLocalized (question);
XtVaSetValues(dialog,
	XmNmessageString,	text,
	NULL);

XmStringFree(text);
XtManageChild(dialog);
XtPopup(XtParent(dialog), XtGrabNone);

    /*simulate mainLoop while !getting an answer*/
while(answer==0)
	XtAppProcessEvent(app_context, XtIMAll);
    /*don't leave the dialog hanging once the answer is given*/	
    XtPopdown(XtParent(dialog));
    XSync(XtDisplay(dialog),0);
    XmUpdateDisplay(parent);
    return answer;
}
/*_____________________________________________________________________*/
void response(w,client,call)
Widget w;
XtPointer client;
XtPointer call;
{
int *answer = (int *)client;
XmAnyCallbackStruct *cbs = (XmAnyCallbackStruct *)call;
	switch(cbs->reason){
		case XmCR_OK:
			*answer = YES;
			break;
		case XmCR_CANCEL:
			*answer = NO;
			break;
		default:
			return;
		}
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void Save(w, client, call)
Widget w;
XtPointer client, call;
{ 
  XtManageChild(saveFileBox);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

void SaveOk(w, client, call)
Widget w;
XtPointer client, call;
{

  XmFileSelectionBoxCallbackStruct
    *calldata=(XmFileSelectionBoxCallbackStruct*)call;
  char *filename, comm[100],test[100],*valstring;
  static XmStringCharSet charset =
                           (XmStringCharSet) XmSTRING_DEFAULT_CHARSET;
  static int I_I,l;
  int on=(-Nw*I)/D, in=-Nw, i, j, exists, ok;
  long point=0;
  float val, *h;
  FILE *testfile;
  Boolean overwrtWarn;
  Boolean scaled = XmToggleButtonGetState(syntToggle);
  float synth = 0.;

  /***************************************/
  int st[2];
  float art;
  XmString text, text1;
  /***************************************/


  SetWatchCursor(topLevel);
  
  if((megamp==NULL)||(megfreq==NULL)){
	printf("Ceres3: Error: Nothing to synthesize from\n");
		goto goodbye;
		}

  XmStringGetLtoR(calldata->value, charset, &filename);

  XtUnmanageChild(saveFileBox); XmUpdateDisplay(w);

/*----->warn before overwriting!*/
if(overwrtWarn=XmToggleButtonGetState(displayToggleOverwrite)){
  strcpy(test, filename);
  l=strlen(test);
  if(test[l-1]=='/'){
      XtManageChild(fileWarning);
      XtFree(filename);
      ResetCursor(topLevel);
      return;
      }
  testfile=fopen(filename,"r" );
  if(testfile==NULL)goto s_file_;
  else{
      fclose(testfile);
      puts("closed");
      if(AskUser(w,"File exists. Overwrite it?")==YES)
	    {
      	remove(test);
        }
      else{
	XtFree(filename);
	printf("Ceres3: overwrite cancelled\n");
	ResetCursor(topLevel);
	return;
        }
      }
s_file_:
;
}
/*------------------------------->*/
 /*remove if exists*/

/*-*/
setup_outfile(1, R, /*compression,*/ filefmt, /* Mono out */
	 samp_type,bits_per_samp);
/*-
  out_AFsetup=AFnewfilesetup();
  AFinitchannels(out_AFsetup, AF_DEFAULT_TRACK, 1);  
  AFinitrate(out_AFsetup, AF_DEFAULT_TRACK, R);
  AFinitcompression(out_AFsetup, AF_DEFAULT_TRACK, compression);
  AFinitfilefmt(out_AFsetup, filefmt);
  AFinitsampfmt(out_AFsetup, AF_DEFAULT_TRACK, samp_type, bits_per_samp);
*/
/*-*/

exists = tst_open_soundfile(filename,0);/* don't mix! */
if(exists == 1)remove(filename);
/*
 outfile=AFopenfile(filename, "r", out_AFsetup); 
  if(outfile !=NULL){
      AFclosefile(outfile);
      remove(filename);
      }
*/
/*-*/

/*-*/
   ok = wr_open_soundfile(filename, 0);

/*-
  outfile = af_wr_open_soundfile(filename, 0);
*/
/*-
  outfile=AFopenfile(filename, "w", out_AFsetup);
*/

/*this has to be done with ok flag*/
/*if  (outfile==NULL)*/ if(ok == 0) {
	  printf("Ceres3: NULL: Cannot create file\n");
    ResetCursor(topLevel);
    XtManageChild(writeWarning);
    XtFree(filename);
    return;
  }

/*---->compute synthesis treshold*/
  amptrack(0,horiz_num,0,numchannels);
  for(i=0;i<horiz_num;i++)synth += avgamp[i]*avgamp[i];
  synth = sqrt(synth/(float)horiz_num);
  printf("Average amplitude: %g\n",synth);
 
  valstring=XmTextGetString(syntTextfield);
  val = atof(valstring);if(val<0.)val=0.;
  printf("Percentage treshold: %f\n",val);

  XtFree(valstring);
  synth *= 0.01*val;synt = synth;
  printf("Resynthesis treshold: %g\n",synt);

  
    fvec(h, numchannels+1);
/* *this code implements frequency sensitive resynt. tresh.* */
    if(scaled){funcpt3 = numsquare3;
     for (j=0; j<numchannels; j++){
	 h[j]=synt*(400.- getfuncval3(j))/400.;
	 if(h[j]<0.)h[j]=0.;if(h[j]>1.)h[j]=1.;
 	/* printf("%d\t%f\n",j,h[j]);*/
         }
    }else{
    for (j=0; j<numchannels; j++){
	 h[j]=synt;
 	/* printf("%d\t%f\n",j,h[j]);*/
         }
    }
/*******************************************************/
 art = 100./(float)(horiz_num);
 st[0]=-1;st[1]=0;
if(update=XmToggleButtonGetState(displayToggleUpdate)){
	/*printf(">>>%d\n",(int)update);*/
 text= XmStringCreateLocalized("Synth & Save...");
 text1=XmStringCreateLocalized("In Progress...");
 XtVaSetValues(progressBox,XmNdialogTitle,text,
	XmNmessageString,text1,NULL,NULL);
 XtVaSetValues(progressBar, XmNvalue, 0, NULL);
 XtManageChild(progressBox);
 
 
  while (XtAppPending(app_context)) {
     XtAppProcessEvent(app_context,XtIMXEvent|XtIMTimer|XtIMAlternateInput);
  }
  
}
/*******************************************************/
 /*______________________________*/
  
  for (j=0; j<horiz_num; j++) {	  
    
/*intermediate updates: don'freeze the app while working*/
if(update){
  st[1]=(int)(art*j);
  if(st[1]!=st[0]){	  
	XtVaSetValues(progressBar, XmNvalue, st[1], NULL);	
        /*XmUpdateDisplay(topLevel);*/
		st[0]=st[1];
  		}
     /* XSync(XtDisplay(progressBox),0);*/
      XmUpdateDisplay(topLevel);
      }
/*******************************************************/

  if(va_tstretch)I_I=(int)interpol[j];
      else I_I=I;
      on+=I_I; in+=D;
      for (i=0; i<numchannels; i++) {
        channel[i+i]=megamp[point];
        channel[i+i+1]=megfreq[point];
        point++;
        }
        if (obank) {
	  if(j==0)for (i=0; i<N2+1; i++) {
          lastfreq[i]=channel[i+i+1];
          lastamp[i]=channel[i+i];
	      }
	  /*synt modified to be an array*/
		  if(fast){
		  oscbank_fast(channel, N2, R, I_I, output, 1., /*synt*/h);
		  goto shout;
		  }
		  oscbank(channel, N2, R, I_I, output, 1., /*synt*/h);
		  shout:
		  if(bits_per_samp == 16)
            wr_shiftout(output,  Nw,  I_I, in+Nw2+D , framebuff, filename, 0);
		  if((bits_per_samp == 16)||(bits_per_samp == 16))
            wrl_shiftout(output,  Nw,  I_I, in+Nw2+D , framebuff32, bits_per_samp, filename, 0);
/*-
          shiftout(output,  Nw,  I_I,  in+Nw2+D);
*/
        }else {
          unconvert(channel,  buffer,  N2,  I_I,  R, horiz_num, j);
          rfft(buffer,  N2,  INVERSE);
          overlapadd(buffer,  N,  Wsyn,  output,  Nw,  on);
		  if(bits_per_samp == 16)
            wr_shiftout(output,  Nw,  I_I,  on, framebuff, filename, 0);
		  if((bits_per_samp == 24)||(bits_per_samp == 32))
            wrl_shiftout(output,  Nw,  I_I, in+Nw2+D , framebuff32, bits_per_samp, filename, 0);
/*-
          shiftout(output,  Nw,  I_I,  on);
*/
      }
  }
 /*
  free(lastamp);free(lastfreq);free(index);
 */
/****************************************/
if(update){
	XtUnmanageChild(progressBox);
	XmStringFree(text);
	}
/****************************************/

  free(h); 

  close_soundfile( filename, 0, 'o');
/*-
  AFclosefile(outfile);
*/
/*-*/
/* to display name of file */
  strcpy(comm,"ceres3: ");
  strcat(comm,filename);
  strcpy(curr,filename);
  XtVaSetValues(topLevel,XmNtitle,comm,NULL);
/* end of new code */
  XtFree(filename);
  fileDirty = FALSE;
  goodbye:  
  ResetCursor(topLevel);

}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void Play(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(playFileBox);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
/*New PlayOk and Playcurrent callbacks using text field typed arbitrary 
    name for a playback engine. from 0.26a3*/
void PlayOk(w, client, call)
Widget w;
XtPointer client, call;
{

  XmFileSelectionBoxCallbackStruct
    *calldata=(XmFileSelectionBoxCallbackStruct*) call;
  char *filename, streng[100], *valstring, s[20];
  static XmStringCharSet charset =
                           (XmStringCharSet) XmSTRING_DEFAULT_CHARSET;


  XmStringGetLtoR(calldata->value, charset, &filename);

	/*read the default playback engine from the "Settings>FFT/Play" menu*/
  valstring=XmTextGetString(playTextfield);
  strcpy(s,valstring); 
    /*just a fool-proof check of enternig 'rm' as play command*/
 if(strncmp(s, "rm",2)==0){
#ifdef POWERPC
  	strcpy(streng,"sndplay");
#elif CMIX
  	strcpy(streng,"cmixplay");
#elif SND
  	strcpy(streng,"sndplay");
#elif SNDFILEPLAY
	strcpy(streng,"sndfile-play");
#elif SGI
  	strcpy(streng,"sfplay");
#else  	
  	strcpy(streng,"play");  	
#endif
 }else
  strcpy(streng,valstring);
  strcat(streng," ");
  strcat(streng, filename);
  strcat(streng," &");
  system(streng);

/*--------------------*/


  XtFree(filename); XtFree(valstring);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void Playcurrent(w, client, call)
Widget w;
XtPointer client, call;
{
  char streng[100], *valstring;

if(curr==NULL){
	printf(">Error: No current soundfile\n");
	goto out;
	}
  printf(">Playing Current file: %s\n", curr);

  valstring=XmTextGetString(playTextfield);
    /*another fool-proof check*/
 if(strncmp(valstring, "rm",2)==0)
#ifdef POWERPC
  	strcpy(streng,"sndplay");
#elif CMIX
  	strcpy(streng,"play");
#elif SND
  	strcpy(streng,"sndplay");
#elif SNDFILEPLAY
	strcpy(streng,"sndfile-play");
#elif SGI
  	strcpy(streng,"sfplay");
#else  	
  	strcpy(streng,"play");  	  	
#endif
 else
  strcpy(streng,valstring);
  strcat(streng," ");
  strcat(streng, curr);
  strcat(streng," &");
  system(streng);
out:
  XtFree(valstring);
;
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

void Preview(w, client, call)
Widget w;
XtPointer client, call;
{
  pid_t pid;
/*
  ALconfig out_c;
  ALport out_port;
*/
/*-*/
  char *valstring;
  static int I_I,l;
  int on, in, i, i2, j, ok;
  long point=0;
  float val, *h;

/*channel, buffer,and other downsized preview stuff*/

  Boolean scaled = XmToggleButtonGetState(syntToggle);
  float synth = 0.;

  if((megamp==NULL)||(megfreq==NULL)){
	printf("Ceres3: Error: Nothing to play from\n");
		goto goodbye;
		}

 SetWatchCursor(topLevel);
 XmUpdateDisplay(w);
 on=(-Nw*I)/D; in=-Nw;
  printf("Previewing\n");  
/*------------------------------->*/
/*-*/
   I_I=I;
  ok = init_live(I_I);

/*-
  out_c = alNewConfig();
  alSetQueueSize(out_c, I_I);
  alSetSampFmt(out_c,AL_SAMPFMT_FLOAT);
  alSetChannels(out_c, 1);
  out_port =  alOpenPort("Ceres3 Preview", "w", out_c);
*/
/*-*/
if(!ok)goto goodbye;
/*-
 if(!out_port)printf("Couldn't open input port: %s\n",alGetErrorString(oserror()));
*/
/*---->compute synthesis treshold*/
  amptrack(0,horiz_num,0,numchannels);
  for(i=0;i<horiz_num;i++)synth += avgamp[i]*avgamp[i];
  synth = sqrt(synth/(float)horiz_num);
  printf("Average amplitude: %g\n",synth);
 
  valstring=XmTextGetString(syntTextfield);
  val = atof(valstring)*2.;if(val<0.)val=0.;
  printf("Percentage treshold: %f\n",val);

  XtFree(valstring);
  synth *= 0.01*val;synt = synth;
  printf("Resynthesis treshold: %g\n",synt);

  
    fvec(h, numchannels+1);
/* *this code implements frequency sensitive resynt. tresh.* */
    if(scaled){funcpt3 = numsquare3;
     for (j=0; j<numchannels; j++){
	 h[j]=synt*(400.- getfuncval3(j))/400.;
	 if(h[j]<0.)h[j]=0.;if(h[j]>1.)h[j]=1.;
 	/* printf("%d\t%f\n",j,h[j]);*/
         }
    }else{
    for (j=0; j<numchannels; j++){
	 h[j]=synt;
 	/* printf("%d\t%f\n",j,h[j]);*/
         }
    }

 /*______________________________*/
  
  for (j=0; j<horiz_num; j++) {

  if(va_tstretch)I_I=(int)interpol[j];

      on+=I_I; in+=D;
      for (i=0; i<numchannels; i++) {
        channel[i+i]=megamp[point];
        channel[i+i+1]=megfreq[point];
        point++;
        }
/*no oscillator bank stuff in preview*/
          unconvert(channel,  buffer,  N2,  I_I,  R, horiz_num, j);

          rfft(buffer,  N2,  INVERSE);

          overlapadd(buffer,  N,  Wsyn,  output,  Nw,  on); 
/*-*/
          shiftout_live(output,  Nw,  I,  I_I,  on);
/*-
          shiftout_to_port(output,  Nw, I, I_I,  on, out_port);
*/
  }

  free(h); 
/*-*/
  close_live();

/*-
  j = alClosePort(out_port);
  j = alFreeConfig(out_c);
*/
  goodbye:  
  ResetCursor(topLevel);

}
/*___________________IMPORT-EXPORT-CALLBACKS___________________________*/
/*_____________________________________________________________________*/
void Loadfunc(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(loadfuncFileBox);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void LoadfuncOk(w, client, call)
Widget w;
XtPointer client, call;
{
  XmFileSelectionBoxCallbackStruct
    *calldata=(XmFileSelectionBoxCallbackStruct*) call;
  char *filename, test[100];
/*  struct stat s_buf; */
  char comm[100], p1c[MAXNODES], p2c[MAXNODES], p3c[MAXNODES];
  int i, i2, i3, ii;
  int p1i, p2i, p3i, p4i, p5i, p6i, max, min;
  FILE *infile;
  int l;
  Boolean tooMuch;
  static XmStringCharSet charset =
                           (XmStringCharSet) XmSTRING_DEFAULT_CHARSET;


 if(sketchpad == (Widget)NULL){
	printf("Error: nothing to import to\n");
	XtUnmanageChild(loadareaFileBox);
	return;
	}
  if(!XmStringGetLtoR(calldata->value, charset, &filename))return;
  XtUnmanageChild(loadfuncFileBox);

strcpy(test, filename);
l=strlen(test);
if(test[l-1]=='/'){
    XtManageChild(fileWarning);
    XtFree(filename);	
    return;
    }

/*
if(stat(filename, &s_buf)==-1)return;
else if((s_buf.st_mode & S_IFMT) == S_IFDIR){
printf("It's a folder\n");return;
}
*/
  infile=fopen(filename, "r");
  if (infile==NULL) {
    XtManageChild(fileWarning);
    XtFree(filename);
    return;
  }

  SetWatchCursor(topLevel);
  while (!feof(infile)) {
    fscanf(infile, "%s", comm);
    if (feof(infile)) break;
    if (strcasecmp(comm, "controlgraph1:")==0) {
	/*if theheight matches, if normalize is on*/
      ii=0;tooMuch = False;

      read1:
      max = 0;
      for (i=1; i<MAXNODES; i++) {
	if(!tooMuch){
        fscanf(infile, "%s", p1c);          /*was &p1c*/
        if (strcasecmp(p1c, "end")==0) break;
        p1i=atoi(p1c);
        fscanf(infile, "%d", &p2i); if(p2i>max)max=p2i;
        if (p1i<50) p1i=50;
        if (p1i>=thewidth+50){
		p1i=thewidth+50;
		tooMuch = True;
		}
        /*if (p2i<20) p2i=20; */
        /*if (p2i>theheight+20) p2i=theheight+20;*/
        xpos[i]=p1i;
        ypos[i]=p2i;
        numsquare=i;
	}
	else fscanf(infile, "%s", p1c);
	if (strcasecmp(p1c, "end")==0) break;
      }
      if(max>theheight+10)max-=(theheight+10);
	else max = 0;
      if(max>0){min = 10;
      for(ii=1;ii<i;ii++){ypos[ii]-=max; if(ypos[ii]<min) min=ypos[ii];}
	if(min<10)for(ii=1;ii<i;ii++)if(ypos[ii]-min<theheight)ypos[ii]-=(min-10);
	for(ii=1;ii<i;ii++)if(ypos[ii]<10)ypos[i]=10;	
        }
      
    }
    else if (strcasecmp(comm, "controlgraph2:")==0) {
      ii=0;max=0;tooMuch = False;
      for (i2=1; i2<MAXNODES; i2++) {
	if(!tooMuch){
          fscanf(infile, "%s", p2c);
          if (strcasecmp(p2c, "end")==0) break;
          p3i=atoi(p2c);
          fscanf(infile, "%d", &p4i);  if(p4i>max)max=p4i;
          if (p3i<50) p3i=50;
          if (p3i>=thewidth+50){
		p3i=thewidth+50;
		tooMuch = 1;
		}
       /* if (p4i<20) p4i=20;  */
       /* if (p4i>theheight+20) p4i=theheight+20; */
        xpos2[i2]=p3i;
        ypos2[i2]=p4i;
        numsquare2=i2;
	}
	else fscanf(infile, "%s",  p2c);
	if (strcasecmp(p2c, "end")==0) break;	
      }
    if(max>theheight+10)max-=(theheight+10);
	else max = 0;
    if(max>0){min = 20;
    for(ii=1;ii<i;ii++){ypos2[ii]-=max; if(ypos2[ii]<min) min=ypos2[ii];}
	if(min<10)for(ii=1;ii<i;ii++)if(ypos2[ii]-min<theheight)ypos2[ii]-=(min-10);
	for(ii=1;ii<i;ii++)if(ypos2[ii]<10)ypos2[i]=10;	
       }

    }
    else if (strcasecmp(comm, "controlgraph3:")==0) {
      max = 0;
      for (i3=1; i3<MAXNODES; i3++) {
        fscanf(infile, "%s",  p3c);
        if (strcasecmp(p3c, "end")==0) break;
        p5i=atoi(p3c);
        fscanf(infile, "%d", &p6i);
        if (p5i<50) p5i=50;
        if (p5i>thewidth+50) p5i=thewidth+50;
        if (p6i<10) p6i=10;
        if (p6i>max)max=p6i; 
	/*printf("@%d\n",p6i);*/
        xpos3[i3]=p5i;
        ypos3[i3]=p6i;
        numsquare3=i3;
      }
     for (i3=1; i3<=numsquare3;i3++)
	ypos3[i3] = 10+(int)((ypos3[i3]-10)*theheight/(float)(max-10));
    }
  }
  fclose(infile);
  XtFree(filename);
  RedrawAll();
  ResetCursor(topLevel);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void Savefunc(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(savefuncFileBox);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void SavefuncOk(w, client, call)
Widget w;
XtPointer client, call;
{
  XmFileSelectionBoxCallbackStruct
    *calldata=(XmFileSelectionBoxCallbackStruct*) call;
  char *filename,test[100];

  static XmStringCharSet charset =
                           (XmStringCharSet) XmSTRING_DEFAULT_CHARSET;

  FILE *outfile;
  int i, i2, i3, l;

  XmStringGetLtoR(calldata->value, charset, &filename);
/*----->warn before overwriting!*/
  
  strcpy(test, filename);
  l=strlen(test);
  if(test[l-1]=='/'){
      XtManageChild(fileWarning);
      XtFree(filename);	
      return;
      }
  outfile=fopen(filename,"r" );
  if(outfile==NULL)goto s_file_;
  else{
      fclose(outfile);
      puts("closed");
      if(AskUser(w,"File exists. Overwrite it?")==YES)
	{
      	remove(test);
        }
      else{
	XtFree(filename);
	printf("Ceres3: overwrite cancelled\n");
	ResetCursor(topLevel);
	return;
        }
      }
s_file_:


  outfile=fopen(filename, "w");
  if (outfile==NULL) {
    XtManageChild(writeWarning);
    XtFree(filename);
    return;
  }

  fprintf(outfile, "controlgraph1:\n");
  for (i=1; i<=numsquare; i++)
    fprintf(outfile, "%d %d\n", xpos[i], ypos[i]);
  fprintf(outfile, "end\n\n");
  fprintf(outfile, "\n");
    fprintf(outfile, "controlgraph2:\n");
  for (i2=1; i2<=numsquare2; i2++)
    fprintf(outfile, "%d %d\n", xpos2[i2], ypos2[i2]);
  fprintf(outfile, "end\n\n");
  fprintf(outfile, "\n");
    fprintf(outfile, "controlgraph3:\n");
  for (i3=1; i3<=numsquare3; i3++)
    fprintf(outfile, "%d %d\n", xpos3[i3], ypos3[i3]);
  fprintf(outfile, "end\n\n");

  fclose(outfile);
  XtFree(filename);
  XtUnmanageChild(savefuncFileBox);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void Loadarea(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(loadareaFileBox);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void LoadareaOk(w, client, call)
Widget w;
XtPointer client, call;
{
  XmFileSelectionBoxCallbackStruct
    *calldata=(XmFileSelectionBoxCallbackStruct*) call;
  char *filename, test[100];
  char comm[10], p1c[1], p3c[1], p5c[1], p7c[1], p9c[1], p11c[1];
  int p1i, p2i, p3i, p4i, p5i, p6i, p7i, p8i, p9i, p10i, p11i, p12i, l;
  FILE *infile;

  static XmStringCharSet charset =
                           (XmStringCharSet) XmSTRING_DEFAULT_CHARSET;

 if(sketchpad == (Widget)NULL){
	printf("Error: nothing to import to\n");
    XtUnmanageChild(loadareaFileBox);
	return;
	}
  XmStringGetLtoR(calldata->value, charset, &filename);
  XtUnmanageChild(loadareaFileBox);
  strcpy(test, filename);
  l=strlen(test);
  if(test[l-1]=='/'){
    XtManageChild(fileWarning);
    XtFree(filename);	
    return;
    }
  SetWatchCursor(topLevel);
  infile=fopen(filename, "r");
  if (infile==NULL) {
    ResetCursor(topLevel);
    XtManageChild(fileWarning);
    XtFree(filename);
    return;
  }

  while (!feof(infile)) {
    fscanf(infile, "%s", comm);
    if (feof(infile)) break;
    if (strcasecmp(comm, "area1:")==0) {
      fscanf(infile, "%s",  p1c);
      if (strcasecmp(p1c, "end")==0) break;
      p1i=atoi(p1c);
      fscanf(infile, "%d", &p2i);
      fscanf(infile, "%s",  p3c);
      if (strcasecmp(p3c, "end")==0) break;
      p3i=atoi(p3c);
      fscanf(infile, "%d", &p4i);
      if (p1i<40) p1i=40;
      if (p1i>thewidth+50) p1i=thewidth+50;
      if (p2i<10) p2i=10;
      if (p2i>theheight+10) p2i=theheight+10;
      if (p3i<40) p3i=40;
      if (p3i>thewidth+50) p3i=thewidth+50;
      if (p4i<10) p4i=10;
      if (p4i>theheight+10) p4i=theheight+10;
      areax1=p1i;
      areay1=p2i;
      areax2=p3i;
      areay2=p4i;
      }
    else if (strcasecmp(comm, "area2:")==0) {
      fscanf(infile, "%s",  p5c);
      if (strcasecmp(p5c, "end")==0) break;
      p5i=atoi(p5c);
      fscanf(infile, "%d", &p6i);
      fscanf(infile, "%s",  p7c);
      if (strcasecmp(p7c, "end")==0) break;
      p7i=atoi(p7c);
      fscanf(infile, "%d", &p8i);
      if (p5i<40) p5i=40;
      if (p5i>thewidth+40) p5i=thewidth+40;
      if (p6i<10) p6i=10;
      if (p6i>theheight+10) p6i=theheight+10;
      if (p7i<40) p7i=40;
      if (p7i>thewidth+40) p7i=thewidth+40;
      if (p8i<10) p8i=10;
      if (p8i>theheight+10) p8i=theheight+10;
      areax21=p5i;
      areay21=p6i;
      areax22=p7i;
      areay22=p8i;
      }
    else if (strcasecmp(comm, "area3:")==0) {
      fscanf(infile, "%s",  p9c);
      if (strcasecmp(p9c, "end")==0) break;
      p9i=atoi(p9c);
      fscanf(infile, "%d", &p10i);
      fscanf(infile, "%s",  p11c);
      if (strcasecmp(p11c, "end")==0) break;
      p11i=atoi(p11c);
      fscanf(infile, "%d", &p12i);
      if (p9i<40) p9i=40;
      if (p9i>thewidth+40) p9i=thewidth+40;
      if (p10i<10) p10i=10;
      if (p10i>theheight+10) p10i=theheight+10;
      if (p11i<40) p11i=40;
      if (p11i>thewidth+40) p11i=thewidth+40;
      if (p12i<10) p12i=10;
      if (p12i>theheight+10) p12i=theheight+10;
      areax31=p9i;
      areay31=p10i;
      areax32=p11i;
      areay32=p12i;
      }
  }
  fclose(infile);
  XtFree(filename);
  RedrawArea();
  RedrawArea2();
  RedrawArea3();
  ResetCursor(topLevel);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void Savearea(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(saveareaFileBox);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void SaveareaOk(w, client, call)
Widget w;
XtPointer client, call;
{
  XmFileSelectionBoxCallbackStruct
    *calldata=(XmFileSelectionBoxCallbackStruct*) call;
  char *filename, test[100];

  static XmStringCharSet charset =
                           (XmStringCharSet) XmSTRING_DEFAULT_CHARSET;

  FILE *outfile;
  int l;

  XmStringGetLtoR(calldata->value, charset, &filename);
 
  strcpy(test, filename);
  l=strlen(test);
  if(test[l-1]=='/'){
      XtManageChild(fileWarning);
      XtFree(filename);	
      return;
      }
  outfile=fopen(test,"r" );
  if(outfile==NULL)goto s_file_;
  else{
      fclose(outfile);
      puts("closed");
      if(AskUser(w,"File exists. Overwrite it?")==YES)
	{
      	remove(test);
        }
      else{
	XtFree(filename);
	printf("Ceres3: overwrite cancelled\n");
	ResetCursor(topLevel);
	return;
        }
      }
s_file_:

  outfile=fopen(filename, "w");
  if (outfile==NULL) {
    XtManageChild(writeWarning);
    XtFree(filename);
    return;
  }

  fprintf(outfile, "area1:\n");
  fprintf(outfile, "%d %d\n", areax1, areay1);
  fprintf(outfile, "%d %d\n", areax2, areay2);
  fprintf(outfile, "end\n\n");
  fprintf(outfile, "\n");
  fprintf(outfile, "area2:\n");
  fprintf(outfile, "%d %d\n", areax21, areay21);
  fprintf(outfile, "%d %d\n", areax22, areay22);
  fprintf(outfile, "end\n\n");
  fprintf(outfile, "\n");
  fprintf(outfile, "area3:\n");
  fprintf(outfile, "%d %d\n", areax31, areay31);
  fprintf(outfile, "%d %d\n", areax32, areay32);
  fprintf(outfile, "end\n\n");
  fprintf(outfile, "\n");

  fclose(outfile);
  XtFree(filename);
  XtUnmanageChild(saveareaFileBox);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void FFTFile(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(fftFileBox);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void FFTFileOk(w, client, call)
Widget w;
XtPointer client, call;
{
/*add update*/
  XmFileSelectionBoxCallbackStruct
    *calldata=(XmFileSelectionBoxCallbackStruct*) call;
  char *filename, test[100];
/*  struct stat s_buf; */
  char *valstring, comm[100];
  int i,k,m;
  float win_center,d,f;
  long j,point, nc2;
  int size, stp;
  int p, max, min, rat;
  FILE *infile;
  int l;
  Boolean rightSize;
  int testheight; /*debug veriable*/
  long q,filesize;
  int grafx, grafold=-1;
  float ampsum = 0.;
  Boolean fhtCreated = FALSE;
 XPoint list0[LSIZE],list1[LSIZE],list2[LSIZE],list3[LSIZE],list4[LSIZE];
  int c0=0,c1=0,c2=0,c3=0,c4=0;
  static XmStringCharSet charset =
                           (XmStringCharSet) XmSTRING_DEFAULT_CHARSET;


  if(!XmStringGetLtoR(calldata->value, charset, &filename))return;
  XtUnmanageChild(fftFileBox);

strcpy(test, filename);
l=strlen(test);
if(test[l-1]=='/'){
    XtManageChild(fileWarning);
    XtFree(filename);	
    return;
    }
/*-*/
  samps_per_frame   = 1;
  if(R != 48000)
  R                 = 44100;
/*  compression       = AF_COMPRESSION_NONE;*//*0*/
 /* filefmt           = 2;*//*AF_FILE_AIFF*/
/*  samp_type         = 401;*//*AF_SAMPFMT_TWOSCOMP*/
  if ((bits_per_samp != 24)||(bits_per_samp != 32))
  bits_per_samp     = 16;
/*-*/
valstring=XmTextGetString(displayTextfield);
thewidth=atoi(valstring);
XtFree(valstring);
  infile=fopen(filename, "r");
  if (infile==NULL) {
    XtManageChild(fileWarning);
    XtFree(filename);
    return;
  }
  XtUnmanageChild(fftFileBox);


  SetWatchCursor(topLevel);
/*check for fft_size
   rewind FILE pointer
   start reading 
*/
/*read the half-window duration and number of frequency bins*/
back:
fscanf(infile, "%s", comm); 
if(strcmp(comm,"FFT_Size") == 0){
	fscanf(infile, "%s", comm);
	fscanf(infile, "%s", comm);
	if(strcmp(comm,"Window_Step") != 0)goto back;
	fscanf(infile, "%s", comm);
	D = (int)atoi(comm);
	fscanf(infile, "%s", comm);
	if(strcmp(comm,"time") != 0)goto back;
	fscanf(infile, "%s", comm);
	if(strcmp(comm,"amp_freq") != 0)goto back;
	fscanf(infile, "%s", comm);
	if(strcmp(comm,"pairs") != 0){
		printf("Unknown file format\n");
		return;
		}
	fhtCreated = TRUE;
	goto back;
	}
win_center = atof(comm);/*half-window*/
fscanf(infile, "%s", comm);size = atoi(comm)-1;
printf("%d\n",size);



if(!((size==128)||(size==256)||(size==512)||(size==1024)||(size==2048)||\
   (size==4096)||(size==8192)||(size==16384))){printf("Not a valid fft-file\n");
   goto end;}
printf("Previous FFT size: %d\n",N);
if((N == 0)&&(sketchpad == (Widget)NULL)){
	N2 = size; N = size<<1; fftt = False;
	numchannels = N2+1;
	}
if(size!=N2) {printf("Change FFT size to: %d to load %s\n",2*size, test);
   goto end;}
printf("FFT file: %s\nFFT size = %d\tN2 = %d\n", test,2*size, N2);
/*determine sampling rate*/
for(i = 0; i <= (N+1); i++)	fscanf(infile, "%s", comm);
rat = 2*(int)atoi(comm);
printf("FFT File Sampling Rate: %d\n",rat);

switch (rat){
	case 44100: break;
	case 48000: break;
	case 22050: break;
	default:
	printf("Unsupported Sampling Rate: %d\n", rat);
    fclose(infile);	
	ResetCursor(topLevel);
	return;
	}

rewind(infile);
Nw = N; R = rat;
  binfreq = (float)R/N;
/*determine horiz_num and numchannels*/
if(fhtCreated)for(q = 0; q < 7; q++)
	fscanf(infile, "%s", comm);

for(q=0,i=-1;;q++){
fscanf(infile, "%s", comm);
if (feof(infile))break;
if(q%(N+4)==0){
	i++;
	if(i==1)d=(float)atof(comm)-win_center;
	duration = win_center + (float)atof(comm) ;
	}
}
if(!fhtCreated){
D = (int)(d*R);
printf("Window Step: D = %d\n", D);
if(D < Nw/12)   {D = Nw/16; goto ws;}
if(D < Nw/6 )   {D = Nw/8 ; goto ws;}
if(D < Nw/3 )   {D = Nw/4 ; goto ws;}
if(D < (2*Nw)/3){D = Nw/2 ; goto ws;}
D = Nw; 
}
ws:
I = D;  
P=1.;    /* Oscbank pitch factor */
synt=0.; /* Synthesis treshold */
printf("FFT file duration: %f\n", duration);
printf("Window Step: D = %d\n", D);
filesize = ftell(infile);
/*printf("%ld\t%ld\t%d\n",q,filesize,i);*/
horiz_num = i;
if(horiz_num == -1){
	printf("FFT file read error\n");
    fclose(infile);	
	return;
	}
/*duration *=(2.*(float)(i-1));*/

/*for some weired reason all these huge arrays have to 
  *be allocated before the sketchpad widget is created(??!)
  *     *     *     *     *     *     *     *     *     *     *     *     *     */ 
framecnt  = (long)(duration*R)+1;
  if (megfreq!=NULL) free(megfreq);
  if (megamp!=NULL)  free(megamp);
  if (avgamp!=NULL)  free(avgamp);
  if (fundarray!=NULL)  free(fundarray);
  if (interpol!=NULL)  free(interpol);
  megfreq=megamp=avgamp=NULL;
  interpol=fundarray=NULL;

  fvec(megfreq, numchannels*horiz_num);
  if (megfreq==NULL) {
    fclose(infile);
    ResetCursor(topLevel);
    XtManageChild(sizeWarning);
    return;
  }
  fvec(megamp, numchannels*horiz_num);
  if (megamp==NULL) {
    fclose(infile);
    ResetCursor(topLevel);
    XtManageChild(sizeWarning);
    return;
  }

  fvec(avgamp, horiz_num);
  if (avgamp==NULL) {
    fclose(infile);
    ResetCursor(topLevel);
    XtManageChild(sizeWarning);
    return;
  }

   fvec(fundarray, horiz_num);
  if (fundarray==NULL) {
    fclose(infile);
    ResetCursor(topLevel);
    XtManageChild(sizeWarning);
    return;
  }
  fvec(interpol, horiz_num);
  if (interpol==NULL) {
    ResetCursor(topLevel);
    XtManageChild(sizeWarning);
    return;
  }

/*compute new D*/
/*compute new I*/
/*============================================================*/
/*========New in v_0.27: independent sketchpad initialization==========*/
/*
	if(Nw==0)Nw= GetWinSizeFromMenu(N);
	if(D ==0)D = GetWinStepFromMenu(Nw);
*/


	if(theheight <= 1)theheight = N2 + 1;
	fftt = False;
	setFFTRadio(N, fftt);

setUpWindow( thewidth, theheight, &iwidth,
	 &iheight, &fwidth);
	/*if(theheight> 0)oldheight= theheight;*/
if(!XtIsManaged(frame))XtManageChild(frame);
if(sketchpad == (Widget)NULL){
	sketchpad = CreateDrawingArea();
    XtAppAddActions(app_context, actions, XtNumber(actions));
    XtOverrideTranslations(sketchpad,XtParseTranslationTable(drawTranslations));
    XtAddCallback(sketchpad,XmNexposeCallback,RestoreWin,0);  
    XtAddCallback(sketchpad,XmNresizeCallback,ResizeWin,0);
	XtManageChild(sketchpad);
	XtVaSetValues(mainWindow,XmNwidth, iwidth, XmNheight, iheight,
 		/*VertScrollBar*XmNvalue, iheight,*/NULL);
	makewindows(Wanal,  Wsyn,  Nw,  N,  I);
	RestoreWin((Widget)NULL,(XtPointer)NULL,(XtPointer)NULL);
	sethotcolors();
	}else{
	XtVaSetValues(sketchpad, XmNwidth,thewidth+60,
		XmNheight,theheight+60,NULL);
    if(!XtIsManaged(frame))XtManageChild(frame);
    if(!XtIsManaged(sketchpad)){
	XtManageChild(sketchpad);

    XtVaSetValues(mainWindow,XmNwidth, iwidth, XmNheight, iheight,
 		/*VertScrollBar*XmNvalue, iheight,*/NULL);
	}
    RestoreWin((Widget)NULL,(XtPointer)NULL,(XtPointer)NULL);

	}
XmUpdateDisplay(topLevel);
/*================end of sketchpad initialization===================*/
/*============================================================*/ 

drawscale();

  areat1=0; areat2=horiz_num;
  areaf1=0; areaf2=numchannels;


  XFillRectangle(XtDisplay(sketchpad), bitmap, theGC100,
    0, 0, thewidth+70, theheight+70);
  XClearArea(XtDisplay(sketchpad), XtWindow(sketchpad), 0, 0, 0, 0, True);
  drawscale();
rewind(infile);

if(fhtCreated)for(q = 0; q < 7; q++)
	fscanf(infile, "%s", comm);

  q = -1; j = 0; point = 0; nc2 = (numchannels<<1) + 2;
/*counter j tracks useful data, counter q tracks garbage as well*/
/*advance counter j only when encountering amp and freq data*/
  while (!feof(infile)) {
    fscanf(infile, "%s", comm);
		q++; 
		if(q%nc2 > 1){j++;point = (j-1)>>1;
 		   if (point>(long)horiz_num*numchannels)goto end;
		   if(j%2==1){
				if(fhtCreated) megamp[point]=atof(comm)/2.e10;
				else megamp[point]=atof(comm)/2.e5;
				}			
		   else {
				f = atof(comm);				
				megfreq[point]=f;
				}
           }
			else printf("%ld  %d  %d  %ld  %s\n",q,nc2,m,q%nc2, comm);
  }


  point = 0; j = 0;

  stp = thewidth/(float)horiz_num; stp *= .5;

 while (point<(long)horiz_num*numchannels) {
    grafx = (int)(j++*thewidth/(float)horiz_num)+stp+50;
/*	printf("%d\t%d\n",j,grafx);*/
    for (i=0; i<numchannels; i++)point++;

    if (grafx!=grafold) {
      point-=numchannels;
        for (i=0; i<numchannels; i++) {
          if (megamp[point]>0.0000003) {
            int y = theheight-(int)(megfreq[point]/binfreq)+10;
            if (megamp[point]>0.0000100) {
           ADD_POINT(grafx,y,list0,c0,showGC0,theGC0);
            } else if (megamp[point]>0.0000060){
           ADD_POINT(grafx,y,list1,c1,showGC20,theGC20);
            } else if (megamp[point]>0.0000025) {
           ADD_POINT(grafx,y,list2,c2,showGC40,theGC40);
             } else if (megamp[point]>0.0000010) {
            ADD_POINT(grafx,y,list3,c3,showGC60,theGC60);

            } else {
           ADD_POINT(grafx,y,list4,c4,showGC80,theGC80);
            }
          }
          point++;
        }
      grafold=grafx;
    }
 }  

  FLUSH_LIST(list0,c0,showGC0,theGC0);
  FLUSH_LIST(list1,c1,showGC20,theGC20);
  FLUSH_LIST(list2,c2,showGC40,theGC40);
  FLUSH_LIST(list3,c3,showGC60,theGC60);
  FLUSH_LIST(list4,c4,showGC80,theGC80);



point = 0;
for(i=0; i < horiz_num; i++){  ampsum = 0.;
   for(j=0;j<numchannels;j++)ampsum+=megamp[point+j]*megamp[point+j];
   avgamp[i] = sqrt(ampsum)/sqrt((float)numchannels);point+=numchannels;
  /* printf("%f\n",avgamp[i]);  */
   }
   /*
  for(j=numchannels-1;j<numchannels;j++)for(i=0; i < horiz_num; i++)printf(">>%ld\t%f\n",j+numchannels*i,megamp[j+numchannels*i]);
*/
 strcpy(comm,"ceres3: ");
  strcat(comm,filename);
  XtVaSetValues(topLevel,XmNtitle,comm,NULL);

  rightbins();
  end:;
  
  fhtCreated = FALSE;
  fclose(infile);
  XtFree(filename);
  RedrawAll();
  ResetCursor(topLevel);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void Tofft(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(tofftFileBox);
}

/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

void TofftOk(w, client, call)
Widget w;
XtPointer client, call;
{
/*add update*/
  XmFileSelectionBoxCallbackStruct
    *calldata=(XmFileSelectionBoxCallbackStruct*) call;
  char *filename,test[100];
  static XmStringCharSet charset =
                           (XmStringCharSet) XmSTRING_DEFAULT_CHARSET;
  FILE *scorefile;
  int i, j,l;
  long point;
  float t_step;
  float  first_step;

  int art1,art2,arf1,arf2;

  if((megfreq == NULL)||(megamp == NULL)){
    printf("Nothing to export\n");
	XtUnmanageChild(w);
	return;
	}

  areafind(&art1,&art2,&arf1,&arf2);
  XmStringGetLtoR(calldata->value, charset, &filename);
  strcpy(test, filename);
  l=strlen(test);

  XtUnmanageChild(tofftFileBox);

  if(test[l-1]=='/'){
    XtManageChild(fileWarning);
    XtFree(filename);	
    return;
    }
 scorefile=fopen(filename,"r" );
  if(scorefile==NULL)goto s_file_;
  else{
      fclose(scorefile);
      puts("closed");
      if(AskUser(w,"File exists. Overwrite it?")==YES)
	    {
      	remove(filename);
        }
      else{
	XtFree(filename);
	printf("Ceres3: overwrite cancelled\n");
	ResetCursor(topLevel);
	return;
        }
      }
s_file_:
SetWatchCursor(topLevel);
printf("%d\t%f\t%f\n",horiz_num,duration/(float)horiz_num, D/(float)R);
  scorefile=fopen(filename,"w");
  if (scorefile==NULL) {
    XtManageChild(csoundWarning);
    XtFree(filename);
    return;
  }
t_step = duration/(float)horiz_num;
/*t_step = D/(float)R;*/
first_step = .5*Nw/(float)R;
/*  fprintf(scorefile,"; Scorefile written by CERES3\n"); */
for(i = 0, point = 0; i < horiz_num; i++){
  fprintf(scorefile,"\n\n");
  fprintf(scorefile,"%8.4f\t%d\n",i*t_step + first_step, numchannels);
	for(j = 0; j < numchannels; j ++)
		fprintf(scorefile,"%9.6f\t%8.2f\n",2.e5*(megamp[point+j]),
			megfreq[point+j]);
  point+=numchannels;
  }
  fprintf(scorefile,"\n");

  fclose(scorefile);
  XtFree(filename);
  ResetCursor(topLevel);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

void Tocsound(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(tocsoundFileBox);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

void TocsoundOk(w, client, call)
Widget w;
XtPointer client, call;
{
  XmFileSelectionBoxCallbackStruct
    *calldata=(XmFileSelectionBoxCallbackStruct*) call;
  char *filename,test[100];
  static XmStringCharSet charset =
                           (XmStringCharSet) XmSTRING_DEFAULT_CHARSET;
  FILE *scorefile;
  int i, j,l;
  long point;
  float distance=stretchfac*duration/(float)horiz_num;
  float dur=stretchfac/binfreq;
  float onset;
  int art1,art2,arf1,arf2;

  if((megamp == NULL)||(megfreq == NULL)){
	XtUnmanageChild(w); 
	return;
	}

  areafind(&art1,&art2,&arf1,&arf2);
  XmStringGetLtoR(calldata->value, charset, &filename);
  strcpy(test, filename);
  l=strlen(test);
  if(test[l-1]=='/'){
    XtManageChild(fileWarning);
    XtFree(filename);	
    return;
    }
 scorefile=fopen(filename,"r" );
  if(scorefile==NULL)goto s_file_;
  else{
      fclose(scorefile);
      puts("closed");
      if(AskUser(w,"File exists. Overwrite it?")==YES)
		{
      	remove(filename);
		}
      else{
	XtFree(filename);
	printf("Ceres3: overwrite cancelled\n");
	ResetCursor(topLevel);
	return;
        }
      }
s_file_:

  scorefile=fopen(filename,"w");
  if (scorefile==NULL) {
    XtManageChild(csoundWarning);
    XtFree(filename);
    return;
  }

/*  fprintf(scorefile,"; Scorefile written by CERES3\n"); */

  point=art1*numchannels;
  for (i=art1; i<art2; i++) {
     onset=i*distance;
     for (j=0; j<numchannels; j++) {
       if ((megamp[point]>0.) && (megfreq[point]>20.))
         fprintf(scorefile,"i1    %8.4f    %8.4f    %7.2f    %7.2f\n",
           onset, dur, megamp[point]*10000000., megfreq[point]);
       point++;
     }
  }

  fprintf(scorefile,"e\n");

  fclose(scorefile);
  XtFree(filename);
  XtUnmanageChild(w);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void Toparmerud(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(toparmerudFileBox);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void ToparmerudOk(w, client, call)
Widget w;
XtPointer client, call;
{
  XmFileSelectionBoxCallbackStruct
    *calldata=(XmFileSelectionBoxCallbackStruct*) call;
  char *filename, *valstring,test[100];
  static XmStringCharSet charset =
                           (XmStringCharSet) XmSTRING_DEFAULT_CHARSET;
  FILE *scorefile;
  int i, j, k, l, strings, state, maxpoint;
  long point=0;
  float distance=stretchfac*duration/(float)horiz_num;
  float dur=stretchfac/binfreq;
  float onset, saveamp;
  float triglevel, gatetime, resontime, strfrq, range, maxamp, timeren;

  if((megamp == NULL)||(megfreq == NULL)){
	XtUnmanageChild(w); 
	return;
	}

  XmStringGetLtoR(calldata->value, charset, &filename);

  strcpy(test, filename);
  l=strlen(test);
  if(test[l-1]=='/'){
    XtManageChild(fileWarning);
    XtFree(filename);	
    return;
    }
  scorefile=fopen(filename,"r" );
  if(scorefile==NULL)goto s_file_;
  else{
      fclose(scorefile);
      puts("closed");
      if(AskUser(w,"File exists. Overwrite it?")==YES)
	{
      	remove(filename);
        }
      else{
	XtFree(filename);
	printf("Ceres3: overwrite cancelled\n");
	ResetCursor(topLevel);
	return;
        }
      }
s_file_:

  scorefile=fopen(filename,"w");
  if (scorefile==NULL) {
    XtManageChild(csoundWarning);
    XtFree(filename);
    return;
  }

  valstring=XmTextGetString(parmT1);
  triglevel=atof(valstring);
  valstring=XmTextGetString(parmT2);
  gatetime=atof(valstring);
  valstring=XmTextGetString(parmT3);
  strings=atoi(valstring);
  valstring=XmTextGetString(parmT4);
  resontime=atof(valstring);

  strfrq=30.;
  for (i=0; i<strings*8; i++) {
    state=0;
#ifdef SGI
    range=(strfrq*powf(2., (float)strings/12.)-strfrq)/2.;
#else
    range=(strfrq*pow(2., (float)strings/12.)-strfrq)/2.;
#endif
    for (j=0; j<horiz_num; j++) {
      point=j*numchannels;
      maxamp=-100.; maxpoint=-1;
      for (k=0; k<numchannels; k++) {
        if ((megfreq[point]>strfrq-range) && (megfreq[point]<strfrq+range)
        && (megamp[point]*10000000.>triglevel)) {
          if (megamp[point]>maxamp) {
            maxamp=megamp[point]; maxpoint=point;
          }
        }
        point++;
      }
      if (state==0) {
        if (maxpoint>-1) {
          saveamp=maxamp*10000000.;
          onset=j*distance;
          state=1;
        }
      } else if (state==1) {
        if (maxpoint==-1) {
          fprintf(scorefile,"i1    %8.4f    %8.4f    %7.2f    %7.2f\n",
            onset, (resontime>j*distance-onset?resontime:j*distance-onset),
            saveamp, strfrq);
          state=2; timeren=0.;
        }
      } else {
        timeren+=distance;
        if (timeren>gatetime) state=0;
      }
    }
#ifdef SGI
    strfrq*=powf(2., 1./(float)strings);
#else
    strfrq*=pow(2., 1./(float)strings);
#endif
  }

  fprintf(scorefile,"e\n");
  XtFree(valstring);
  fclose(scorefile);
  XtFree(filename);
  XtUnmanageChild(w);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void Topeak(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(topeakFileBox);
}

void TopeakOk(w, client, call)
Widget w;
XtPointer client, call;
{
  XmFileSelectionBoxCallbackStruct
    *calldata=(XmFileSelectionBoxCallbackStruct*) call;
  char *filename, test[100];
  static XmStringCharSet charset =
                           (XmStringCharSet) XmSTRING_DEFAULT_CHARSET;
  FILE *scorefile;
  int i, j, l, keep;
  long point;
  float distance=stretchfac*duration/(float)horiz_num;
  float dur=stretchfac/binfreq;
  float onset;
 int art1,art2,arf1,arf2;

  if((megamp == NULL)||(megfreq == NULL)){
	XtUnmanageChild(w); 
	return;
	}

 areafind(&art1,&art2,&arf1,&arf2);

  XmStringGetLtoR(calldata->value, charset, &filename);
  strcpy(test, filename);
  l=strlen(test);
  if(test[l-1]=='/'){
    XtManageChild(fileWarning);
    XtFree(filename);	
    return;
    }
 scorefile=fopen(filename,"r" );
  if(scorefile==NULL)goto s_file_;
  else{
      fclose(scorefile);
      puts("closed");
      if(AskUser(w,"File exists. Overwrite it?")==YES)
	{
      	remove(filename);
        }
      else{
	XtFree(filename);
	printf("Ceres3: overwrite cancelled\n");
	ResetCursor(topLevel);
	return;
        }
      }
s_file_:

  scorefile=fopen(filename,"w");
  if (scorefile==NULL) {
    XtManageChild(csoundWarning);
    XtFree(filename);
    return;
  }

  point=art1*numchannels;
  for (i=art1; i<art2; i++) {
     onset=i*distance;
     for (j=0; j<numchannels; j++) {
       keep=0; if (j==0) keep=1; else {
       if ((megamp[point-1]<megamp[point]) && (megamp[point+1]<megamp[point]))
         keep=1; }
       if ((megamp[point]>0.000001) && (megfreq[point]>20.) && keep)
         fprintf(scorefile,"%8.4f    %7.2f    %7.2f\n",
           onset, megamp[point]*10000000., megfreq[point]);
       point++;
     }
  }

  fclose(scorefile);
  XtFree(filename);
  XtUnmanageChild(topeakFileBox);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void Tostf(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(tostfFileBox);
}

/*______________Inventor file export - improved for v.0.27a12_____________*/
void TostfOk(w, client, call)
Widget w;
XtPointer client, call;
{
  XmFileSelectionBoxCallbackStruct
    *calldata=(XmFileSelectionBoxCallbackStruct*) call;
  char *filename, test[100];
  static XmStringCharSet charset =
                           (XmStringCharSet) XmSTRING_DEFAULT_CHARSET;
  FILE *stffile;
  int i, j, l, hori;
  int istep, jstep, fraction;
  long tot, point=0;

  istep = jstep = 1;

  if((megamp == NULL)||(megfreq == NULL)){
	XtUnmanageChild(w); 
	return;
	}

  if(XmToggleButtonGetState(stfFullToggle) == 1) fraction = 1;
  else if(XmToggleButtonGetState(stfThirdToggle) == 1) fraction = 3;
  else if(XmToggleButtonGetState(stfSixthToggle) == 1) fraction = 6;
  else fraction = 2;
  tot = horiz_num * numchannels;


  XmStringGetLtoR(calldata->value, charset, &filename);
  strcpy(test, filename);
  l=strlen(test);
  if(test[l-1]=='/'){
    XtManageChild(fileWarning);
    XtFree(filename);	
    return;
    }
 stffile=fopen(filename,"r" );
  if(stffile==NULL)goto s_file_;
  else{
      fclose(stffile);
      puts("closed");
      if(AskUser(w,"File exists. Overwrite it?")==YES)
		{
      	remove(filename);
        }
      else{
	XtFree(filename);
	printf("Ceres3: overwrite cancelled\n");
	ResetCursor(topLevel);
	return;
        }
      }
s_file_:

  stffile=fopen(filename,"w");
  if (stffile==NULL) {
    XtManageChild(stfWarning);
    XtFree(filename);
    return;
  }
  hori=horiz_num/4-1;

  fprintf(stffile, "#Inventor V2.0 ascii\n");
  fprintf(stffile, "Separator {\n");
  fprintf(stffile, "  DirectionalLight { direction  -1 -1 -0.9  }\n");

  fprintf(stffile, "  Separator {\n");
  fprintf(stffile, "    Material {\n");
  fprintf(stffile, "        diffuseColor [ .6 .8 0.5 ]\n");
  fprintf(stffile, "        specularColor [ .1 .1 .1 ]\n");
  fprintf(stffile, "        shininess 0.99\n");
  fprintf(stffile, "        transparency 0.0\n");
  fprintf(stffile, "    }\n");
  fprintf(stffile, "    Coordinate3 {\n");
  fprintf(stffile, "      point [\n");


  for (i=0; i<hori; i += istep) {
    point=i*4*numchannels;
	if (point >= tot) break;
    for (j=3; j<numchannels/fraction; j += jstep) {
#ifdef EXPORT_TRUEFRQ
      fprintf(stffile, "%d %.2f %5.2f, ", i*50, megfreq[point++],
        megamp[point++]*10000000.);
#else
      fprintf(stffile, "%d %d %5.2f, ", i*50, j*50,
        megamp[point++]*10000000.);
#endif
    }
    fprintf(stffile, "\n");
  }

  fprintf(stffile, "      ]\n");
  fprintf(stffile, "    }\n");
  fprintf(stffile, "    ShapeHints {\n");
  fprintf(stffile, "      vertexOrdering CLOCKWISE\n");
  fprintf(stffile, "    }\n");
  fprintf(stffile, "    Transform {\n");
  fprintf(stffile, "	  scaleFactor	%f 1. 3.35\n", ((float)numchannels/fraction)/hori);
  fprintf(stffile, "  	}\n");
  fprintf(stffile, "    QuadMesh {\n");
  fprintf(stffile, "      verticesPerColumn %d\n", hori);
  fprintf(stffile, "      verticesPerRow    %d\n", numchannels/fraction-3);
  fprintf(stffile, "    }\n");
  fprintf(stffile, "  }\n");

  fprintf(stffile, "}\n");


  fclose(stffile);
  XtFree(filename);
  XtUnmanageChild(w);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void Toltas(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(toltasFileBox);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void ToltasOk(w, client, call)
Widget w;
XtPointer client, call;
{
  XmFileSelectionBoxCallbackStruct
    *calldata=(XmFileSelectionBoxCallbackStruct*) call;
  char *filename, test[100];
  static XmStringCharSet charset =
                           (XmStringCharSet) XmSTRING_DEFAULT_CHARSET;
  FILE *ltasfile;
  int i, j, l;
  long point;

  XmStringGetLtoR(calldata->value, charset, &filename);
  strcpy(test, filename);
  l=strlen(test);
  if(test[l-1]=='/'){
    XtManageChild(fileWarning);
    XtFree(filename);	
    return;
    }
 ltasfile=fopen(filename,"r" );
  if(ltasfile==NULL)goto s_file_;
  else{
      fclose(ltasfile);
      puts("closed");
      if(AskUser(w,"File exists. Overwrite it?")==YES)
	{
      	remove(filename);
        }
      else{
	XtFree(filename);
	printf("Ceres3: overwrite cancelled\n");
	ResetCursor(topLevel);
	return;
        }
      }
s_file_:

  ltasfile=fopen(filename,"w");
  if (ltasfile==NULL) {
    XtManageChild(ltasWarning);
    XtFree(filename);
    return;
  }

 point=4*numchannels;
 for (j=0; j<numchannels; j++)
   fprintf(ltasfile,"%f\n",megamp[point++]*10000);

  fclose(ltasfile);
  XtFree(filename);
  XtUnmanageChild(toltasFileBox);
}

/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void Sculpt(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(sculptFileBox);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void sculptOk(w, client, call)
Widget w;
XtPointer client, call;
{
/*add update*/
  XmFileSelectionBoxCallbackStruct
    *calldata=(XmFileSelectionBoxCallbackStruct*) call;
  char *filename, *valstring,test[100];
  int l;
  long point;
  long points, pts, p, pp, partials, pa,pt,startoff,min;
  static XmStringCharSet charset =
                           (XmStringCharSet) XmSTRING_DEFAULT_CHARSET;

  FILE *scorefile,*testfile;
  size_t size;
  double valval;
  float maxamp, tresh, mindur, maxjmp;
  float t, t0, a, f, q;
  long i,j,k;
  long ht;
  long  *npoints = NULL;
  long int *firstpt = NULL;
  
  Boolean overwrtWarn;
  Boolean newpt = False;
  Boolean no_of = False;
  int art1,art2,arf1,arf2;
  
  areafind(&art1,&art2,&arf1,&arf2);

  XmStringGetLtoR(calldata->value, charset, &filename);

 
  valstring=XmTextGetString(sculptA);
  valval = atof(valstring);
  valval = fabs(valval);
  tresh=-1*(float)valval;
  XtFree(valstring);
  valstring=XmTextGetString(sculptD);
  valval = atof(valstring);
  valval = fabs(valval);
  mindur=(float)valval;
  pts = (long)(mindur*horiz_num/duration + .5);
  XtFree(valstring);
/*
  valstring=XmTextGetString(sculptB);
  maxbrk=fabs(atof(valstring));
  bp =  (long)(maxbrk*horiz_num/duration + .5);
  printf("#%f\t%d\n",maxbrk,bp); 
  XtFree(valstring);
*/

  valstring=XmTextGetString(sculptFJ);
  valval = atof(valstring);
  valval = fabs(valval);
  maxjmp=(float)valval;
  maxjmp=cent2fact(maxjmp);
  XtFree(valstring);

  no_of = XmToggleButtonGetState(sculptToggle);

 XtUnmanageChild(sculptFileBox);
 XmUpdateDisplay(topLevel);

 if((megamp==NULL)||(megfreq==NULL))return;

  strcpy(test, filename);
  l=strlen(test);
  if(test[l-1]=='/'){
    XtManageChild(fileWarning);
    XtFree(filename);	
    return;
    }

/*----->warn before overwriting!*/
if(overwrtWarn=XmToggleButtonGetState(displayToggleOverwrite)){
  strcpy(test, filename);
  l=strlen(test);
  if(test[l-1]=='/'){
      XtManageChild(fileWarning);
      XtFree(filename);
      ResetCursor(topLevel);
      return;
      }
  testfile=fopen(filename,"r" );
  if(testfile==NULL)goto s_file_;
  else{
      fclose(testfile);
      puts("closed");
      if(AskUser(w,"File exists. Overwrite it?")==YES)
	{
      	remove(test);
        }
      else{
	XtFree(filename);
	printf("Ceres3: overwrite cancelled\n");
	ResetCursor(topLevel);
	return;
        }
      }
s_file_: ;
}
/*------------------------------->*/
  
  scorefile=fopen(filename,"w");
  if (scorefile==NULL) {
    XtManageChild(csoundWarning);
    XtFree(filename);
    return;
  }

  printf("Ceres3:PARTIALS EXPORT LOG:\n");


	/****compute the criteria for extraction*****/
  maxamp = 0.;
  startoff = 0;
  point = art1*numchannels;

  min = horiz_num;
  for(i=art1; i<art2; i++){
	for(j=arf1;j<arf2;j++)
        if(megamp[point+j]>maxamp){
		maxamp=megamp[point+j];
                if(i<min)min=i;
		}
     point+=numchannels;
     }
/* printf("Maxamp = %f\n",maxamp); */

 tresh = dbamp(tresh);


 printf("-------%f\n",tresh);
/* printf("%ld\n",min);*/
 if(no_of)startoff=min;

 tresh = maxamp*tresh;
 printf("Search pts.= %ld\n",horiz_num*numchannels);

 printf("Max. amp.  = %f\n",maxamp);

 printf("Treshold   = %12.10f\n",tresh);

 printf("Min. dur.  = %ld points\n",pts);

 printf("Max. jmp.  = %f  \n",maxjmp);

 printf("============================\n");

  points = 0;
  point = art1*numchannels;
  
  for(i=art1; i<art2; i++){
	for(j=arf1;j<arf2;j++)
        if(megamp[point+j]>tresh)points++;
     point+=numchannels;
     }
printf("Points: %ld\n",points);

partials = -1;
point = art1*numchannels;newpt=False;


for(j = arf1; j<arf2-1; j++){
    for(i = art1; i < art2-pts; i++){
	on:
	if(i>=art2-2)goto _break;
	if((megamp[point+j+(i-art1)*numchannels])>=tresh){
		for(k=1,p=1;k<art2-i;k++){
				if(p>=pts){
					if(megamp[point+j+numchannels*(k+i-art1)]>=tresh){
						if(p==pts){
							partials++;	
							}
						if(p>pts){
							q=megfreq[point+j+numchannels*(k+i-art1)]/megfreq[point+j+numchannels*(k-1+i-art1)];
							if(!ratioOk(q,maxjmp)){i+=k;p=0;goto on;}
							}
						p++;
						}else{
							i+=k;p=0;goto on;
							}
				}else{					
					if(megamp[point+j+numchannels*(k+i-art1)]>=tresh){
						p++;
						}else{
							i+=k;p=0;goto on;
						}
				}
			 if((k+i)>=art2) {				
				goto _break;
				}
			}
		}
	} 
	_break: ;
}



out:
partials++;
size = (size_t)(partials+1);

npoints =(long *)calloc(size, sizeof(long));
firstpt =(long *)calloc(size, sizeof(long));


if(partials == 0)goto eXiT;

pa = -1;
point = art1*numchannels;newpt=False ;




for(j = arf1; j<arf2-1; j++){
    for(i = art1; i < art2-pts; i++){
	on2:
	if(i>=art2-2)goto __break;
	if((megamp[point+j+(i-art1)*numchannels])>=tresh){
		for(k=1,p=1;k<art2-i;k++){
				if(p>=pts){
					if(megamp[point+j+numchannels*(k+i-art1)]>=tresh){
						if(p==pts){
							firstpt[++pa]=point+j+numchannels*(i-art1+k-p);
							npoints[pa]=(long)p;
							/* printf("%ld\t%ld\t%ld\t%ld\n",j,i,pa,npoints[pa]); */
							}
						if(p>pts){
							q=megfreq[point+j+numchannels*(k+i-art1)]/megfreq[point+j+numchannels*(k-1+i-art1)];
							if(!ratioOk(q,maxjmp)){i+=k;p=0;goto on2;}
							}
						npoints[pa]=(long)p;
						p++;
						}else{
							i+=k;p=0;goto on2;
							}
				}else{
					if(megamp[point+j+numchannels*(k+i-art1)]>=tresh){
						p++;newpt=True;
						}else{
							newpt=False;i+=k;p=0;goto on2;
						}
				}
			if((k+i)>=art2) {
				
				goto __break;
				}
			}
		}
	} 
	__break: ;

}







 eXiT:

 printf("Partials: %ld\n",partials);
/*
 for(pp=0;pp<partials;pp++)
	 printf("Partial # %5ld --> %5ld pts. starting @ %ld\n",\
			 pp,(long)npoints[pp],firstpt[pp]);
 */
 fprintf(scorefile,"( PARTIALS %ld\n", partials);
 

  for(pp=0;pp<partials;pp++){
    fprintf(scorefile,"( POINTS %ld\n", npoints[pp]);
    pt=firstpt[pp]; ht = (long)(pt/(float)numchannels);   
/*    printf("$$%ld\t%ld\t%ld\n",pp,pt,ht);*/
    for(p=0; p<npoints[pp]; p++){
	
	fprintf(scorefile,"%f\t%f\t%f\n",\
		(float)(ht+p-startoff)*(duration/horiz_num),\
		megfreq[pt+numchannels*p] ,\
		24.+ampdb(megamp[pt+numchannels*p]));

	 if(((long)ht+p-startoff)>(long)horiz_num);
/*
	printf("**%ld  %ld\t%f  %f\n",pp, ht+p-startoff,megfreq[pt+numchannels*p],\
			 1000*megamp[pt+numchannels*p]);
*/			 
	}		
  fprintf(scorefile,")\n");
  }
 
  printf("Exported to: %s\n\n",filename);
  fprintf(scorefile,")\n");
 
  if(firstpt != NULL){free(firstpt);/*printf("fpf\n");*/}
  if(npoints != NULL){free(npoints);/*printf("npf\n");*/}
  
  fclose(scorefile);
  XtFree(filename);

}
/*____________________________________________________________________*/
void CloseW(w, client, call)
Widget w;
XtPointer client, call;
{
if(sketchpad == (Widget)NULL)return;
if(!XtIsManaged(sketchpad))return;
XtManageChild(closeWarning);
}
/*____________________________________________________________________*/
void CloseIt(w, client, call)
Widget w;
XtPointer client, call;
{
FILE *undofile, *redofile;
  if((undofile=fopen("ceres_undo","r"))!=NULL)remove("ceres_undo");
  if((redofile=fopen("ceres_redo","r"))!=NULL)remove("ceres_redo");

/*
deallocateBuffers();

	if (bitmap  !=  (Pixmap)NULL)XFreePixmap(theDisplay,bitmap);
	if (spotsmap != (Pixmap)NULL)XFreePixmap(theDisplay,spotsmap);
*/

/*XFreeColormap( theDisplay, theCmap);*/
/*
XCloseDisplay (XtDisplay(sketchpad));
XFreePixmap( theDisplay, bitmap);XFreePixmap( theDisplay, spotsmap);*/



  if (megfreq!=NULL) free(megfreq);
  if (megamp!=NULL)  free(megamp);
  if (avgamp!=NULL)  free(avgamp);
  if (fundarray!=NULL)  free(fundarray);
  if (interpol!=NULL)  free(interpol);
  megfreq=megamp=avgamp=NULL;
  fundarray=interpol=NULL;
/*printf("##_ %d\t%d\n",oldIwidth,oldIheight);*/

resetCF(True,True,True);
XSync(XtDisplay(mainWindow),0);
if(sketchpad!=(Widget)NULL){
XFillRectangle(theDisplay, bitmap, theGC100, 0, 0, thewidth+70, theheight+70);
XClearArea(theDisplay, XtWindow(sketchpad), 0, 0, 0, 0, True);

XtUnmanageChild(sketchpad);
XtUnmanageChild(frame);
#ifdef SGI
XtVaSetValues(mainWindow,XmNwidth, 400, XmNheight, 25,NULL);
#else
XtVaSetValues(mainWindow,XmNwidth, 400, XmNheight, 35,NULL);
#endif

XmUpdateDisplay(mainWindow);


/*
XUnloadFont(theDisplay,font_info->fid);
*/
/*
if(theGC != NULL)XFreeGC( theDisplay, theGC );  
if(showGC != NULL)XFreeGC( theDisplay, showGC );
if(theGC0 != NULL)XFreeGC( theDisplay, theGC0 ); 
if(showGC0 != NULL)XFreeGC( theDisplay, showGC0 );
if(theGC20 != NULL)XFreeGC( theDisplay, theGC20 ); 
if(showGC20 != NULL)XFreeGC( theDisplay, showGC20 );
if(theGC40 != NULL)XFreeGC( theDisplay, theGC40 ); 
if(showGC40 != NULL)XFreeGC( theDisplay, showGC40 );
if(theGC60 != NULL)XFreeGC( theDisplay, theGC60 ); 
if(showGC60 != NULL)XFreeGC( theDisplay, showGC60 );
if(theGC80 != NULL)XFreeGC( theDisplay, theGC80 ); 
if(showGC80 != NULL)XFreeGC( theDisplay, showGC80 );
if(theGC100 != NULL)XFreeGC( theDisplay, theGC100 ); 
if(showGC100 != NULL) XFreeGC( theDisplay, showGC100 );
if(funcGC != NULL) XFreeGC( theDisplay, funcGC);  
if(func2GC != NULL) XFreeGC( theDisplay, func2GC); 
if(func3GC != NULL) XFreeGC( theDisplay, func3GC); 
if(func4GC != NULL) XFreeGC( theDisplay, func4GC); 
if(func5GC != NULL) XFreeGC( theDisplay, func5GC); 
if(gridGC != NULL)XFreeGC( theDisplay, gridGC);
if(spotsGC != NULL)XFreeGC( theDisplay, spotsGC); 
if(showGC10 !=NULL)XFreeGC( theDisplay, showGC10);
if(spectGC != NULL)XFreeGC( theDisplay, spectGC);
*/
/*
XtDestroyWidget(sketchpad);

sketchpad = (Widget)NULL;
*/
}


}


/*This 3-step quit sequence replaces the original "Quit" since 0.25.2 (27-07-00)
  * Modified in 0.26.a2 for more consistent behaviour and stdout messages
  * */
/*_____________________________________________________________________*/
void quitTheProgram(void)
{
  FILE *undofile, *redofile;
  printf("\
Exiting CERES3...\n\
================================================\n"
  );
if(megamp==NULL && megfreq==NULL)goto theExit; 
  if((undofile=fopen("ceres_undo","r"))!=NULL)remove("ceres_undo");
  if((redofile=fopen("ceres_redo","r"))!=NULL)remove("ceres_redo");
  theExit:
  exit(0);
}
/*_____________________________________________________________________*/

void Quit(w, client, call)
Widget w;
XtPointer client, call;
{
Boolean WarnOnQuit = False;
if(WarnOnQuit = XmToggleButtonGetState(displayToggleQuit)){
if(megamp==NULL && megfreq==NULL)goto quit_lbl;
XtManageChild(quitWarning);
}else{
quit_lbl:
quitTheProgram();
}
}
/*_____________________________________________________________________*/

void QuitOk(w, client, call)
Widget w;
XtPointer client, call;
{
quitTheProgram();
}

/*_____________EDIT CALLBACKS_(as of Ceres3)___________________________*/
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void create_undofile(name, t1, f1, t2, f2)
char* name;
int t1, f1, t2, f2;
{
FILE *undofile;
long point;
int p, q; 

undofile=fopen("ceres_undo", "w");
if(undofile == NULL){ResetCursor(topLevel);return; }


 fprintf(undofile,"%d\n",N);
 fprintf(undofile,"%d\t%d\n",t1,t2);
 fprintf(undofile,"%d\t%d\n",f1,f2);

for(p = t1; p < t2; p++)
  for(q = f1; q < f2; q++)
	{
	point = q + numchannels*p;
       /* fprintf(undofile,"%ld\t%ld\t%ld\t",p,q,point);*/
	fprintf(undofile,"%f\t%f\n",megamp[point],megfreq[point]);
        /*
        printf("%ld\t%ld\t%ld\t",p,q,point);
	printf("%f\t%f\n",megamp[point],megfreq[point]);
	*/
	}


 strcpy(the_latest,name);
 fclose(undofile);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void Undo(w, client, call)
Widget w;
XtPointer client, call;
{
 FILE *undofile, *redofile;
 Boolean undo_redoAllowed;
 long point;
 int p, q, n, art1, art2, arf1, arf2, t1, t2, f1, f2;
 float tempmp, tempfrq;
 char utext[10];
 char streng[100];

 undo_redoAllowed=XmToggleButtonGetState(allowUndoToggle);
 if(!undo_redoAllowed){
    printf("Can't Undo\n");
    XtManageChild(undoWarning);
    return;
    }

if(paintstuff == TRUE){t1 = kt1;t2 = kt2; f1 = kf1; f2 = kf2;}
else{
     areafind(&art1,&art2,&arf1,&arf2);
     t1 = art1; t2 = art2; f1 = arf1; f2 = arf2;
    }

 undofile=fopen("ceres_undo", "r");
 if (undofile==NULL) {
    XtManageChild(fileWarning);
    return;
   }

/*create and write REDO file*/
XmUpdateDisplay(w);
SetWatchCursor(topLevel);
   printf(">%s\n", the_latest);

 fscanf(undofile,"%d", &n);
 if(n!=N){
  fclose(undofile);
  printf(">FFT size error!\n");
  ResetCursor(topLevel);return;}

 fscanf(undofile,"%d", &t1);  fscanf(undofile,"%d", &t2);
 fscanf(undofile,"%d", &f1);  fscanf(undofile,"%d", &f2);
 fclose(undofile);

if(paintstuff == False){art1 = t1; art2 = t2; arf1 = f1; arf2 = f2;}
/* printf("%d %d %d %d\n",art1,art2,arf1,arf2); */

if((t2>horiz_num)||(f2>numchannels)){
  printf(">AREA SIZE ERROR\n");
  ResetCursor(topLevel);return;}

redofile=fopen("ceres_redo", "w");

fprintf(redofile,"%d\n",N);
fprintf(redofile,"%d\t%d\n",t1,t2);
fprintf(redofile,"%d\t%d\n",f1,f2);
for(p = t1; p < t2; p++)
  for(q = f1; q < f2; q++)
	{
	point = q + numchannels*p;
       /* fprintf(redofile,"%ld\t%ld\t%ld\t",p,q,point);*/
	fprintf(redofile,"%f\t%f\n",megamp[point],megfreq[point]);
        /*
        printf("%ld\t%ld\t%ld\t",p,q,point);
	printf("%f\t%f\n",megamp[point],megfreq[point]);
	*/
	}
fclose(redofile);

undofile=fopen("ceres_undo", "r");
fscanf(undofile,"%d",&n);
fscanf(undofile,"%d", &t1);  fscanf(undofile,"%d", &t2);
fscanf(undofile,"%d", &f1);  fscanf(undofile,"%d", &f2);
for(p = t1; p < t2; p++)
  for(q = f1; q < f2; q++)
	{
	point = (long)(q + numchannels*p);
   /*     printf("\t\t%d %d %ld\n",p,q,point);      */
	fscanf(undofile,"%f",&tempmp);
        fscanf(undofile,"%f",&tempfrq);
   /*     printf("%ld\t%f\t%f\n", point, tempmp, tempfrq);   */
        megamp[point]=tempmp;
	megfreq[point]=tempfrq;
        /*
        printf("%ld\t%ld\t%ld\t",p,q,point);
	printf("%f\t%f\n",megamp[point],megfreq[point]);
	*/
	}



  printf(">DONE\n");
  fclose(undofile);
  system("rm -f ceres_undo");
  strcpy(the_latest,"undo");

  RedrawAll();
  ResetCursor(topLevel);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void Redo(w, client, call)
Widget w;
XtPointer client, call;
{
FILE *redofile;
FILE *undofile;
 Boolean undo_redoAllowed;
 long point;
 int p, q, n, art1, art2, arf1, arf2;
 float temp_amp, temp_freq;

 undo_redoAllowed=XmToggleButtonGetState(allowUndoToggle);
 if(!undo_redoAllowed){
    printf("Can't Redo\n");
    XtManageChild(undoWarning);
    return;
    }

 redofile=fopen("ceres_redo", "r");
 if (redofile==NULL) {
    XtManageChild(fileWarning);
    return;
  }

XmUpdateDisplay(w);
SetWatchCursor(topLevel);

fscanf(redofile,"%d", &n);
 if(n!=N){
  fclose(redofile);
  printf(">FFT size error!\n");
  ResetCursor(topLevel);return;}
fscanf(redofile,"%d", &art1);  fscanf(redofile,"%d", &art2);
fscanf(redofile,"%d", &arf1);  fscanf(redofile,"%d", &arf2);
fclose(redofile);

/*printf(">%s\n",the_latest); */



if((undofile=fopen("ceres_undo", "w"))==NULL)
	{printf("NULL"); ResetCursor(topLevel); return;};
fprintf(undofile,"%d\n",N);
fprintf(undofile,"%d\t%d\n",art1,art2);
fprintf(undofile,"%d\t%d\n",arf1,arf2);
/*
 printf("(%d\t%d)\n",art1,art2);
 printf("(%d\t%d)\n",arf1,arf2);
*/
for(p = art1; p < art2; p++)
  for(q = arf1; q < arf2; q++)
	{
	point = (long)q + (long)numchannels*(long)p;

	fprintf(undofile,"%f\t%f\n",megamp[point],megfreq[point]);
        /*
        printf("%ld\t%ld\t%ld\t",p,q,point);
	printf("%f\t%f\n",megamp[point],megfreq[point]);
	*/
	}
fclose(undofile);
 
redofile=fopen("ceres_redo", "r");

printf("#");
fscanf(redofile, "%d",&n);
fscanf(redofile,"%d%d",&art1,&art2);
fscanf(redofile,"%d%d",&arf1,&arf2);

for(p = art1; p < art2; p++)
  for(q = arf1; q < arf2; q++)
	{
	point = (long)q + (long)numchannels*(long)p;
   /*   printf("\t\t%d %d %ld\n",p,q,point);     */
	fscanf(redofile,"%f",&temp_amp);
        fscanf(redofile,"%f",&temp_freq);
   /*     printf("%ld\t%f\t%f\n", point, tempmp, tempfrq);   */
        megamp[point]=temp_amp;
	megfreq[point]=temp_freq;
        /*
        printf("%ld\t%ld\t%ld\t",p,q,point);
	printf("%f\t%f\n",megamp[point],megfreq[point]);
	*/
	}
fclose(redofile);

  system("rm -f ceres_redo");

  strcpy(the_latest,"redo");
  RedrawAll();
  ResetCursor(topLevel);

}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void Copy(w, client, call)
Widget w;
XtPointer client, call;
{
 FILE *undofile;
 long p,q,point;

 if(megamp==NULL||megfreq==NULL)
   {printf(">Nothing to copy from\n"); ResetCursor(topLevel); return;}
	paintstuff = False;
 if((areat1==areat2)||(areaf1==areaf2))
    {printf(">Nothing to copy\n"); ResetCursor(topLevel); return;}
 undofile=fopen("ceres_undo", "w");

/*
 printf("(%d\t%d)\n",areat1,areat2);
 printf("(%d\t%d)\n",areaf1,areaf2);
 printf("(%d\t%d)\n",thewidth,horiz_num);
 */

 XmUpdateDisplay(w);
 SetWatchCursor(topLevel);

 if(undofile == NULL)return;
 printf(">%s\n",the_latest);
 fprintf(undofile, "%d\n",N);
 fprintf(undofile,"%d\t%d\n",areat1,areat2);
 fprintf(undofile,"%d\t%d\n",areaf1,areaf2);
 /*   print of cvmon
(0      1093)
(0      513)
(400    1093)
>COPY
*/
for(p = areat1; p < areat2; p++)
  for(q = areaf1; q < areaf2; q++)
	{
	point = q + numchannels*p;
       /* fprintf(undofile,"%ld\t%ld\t%ld\t",p,q,point);*/
	fprintf(undofile,"%f\t%f\n",megamp[point],megfreq[point]);
        /*
        printf("%ld\t%ld\t%ld\t",p,q,point);
	printf("%f\t%f\n",megamp[point],megfreq[point]);
	*/
	}


 strcpy(the_latest,"copy");
 fclose(undofile);
 ResetCursor(topLevel);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void Cut(w, client, call)
Widget w;
XtPointer client, call;
{
FILE *undofile;
long p,q,point;
 if((areat1==areat2)||(areaf1==areaf2))
    {printf(">Nothing to cut\n"); ResetCursor(topLevel); return;}

 if(megamp==NULL||megfreq==NULL)
   {printf(">Nothing to copy from\n"); ResetCursor(topLevel); return;}

	paintstuff = False;
 XmUpdateDisplay(w);
 SetWatchCursor(topLevel);


 printf("%s\n",the_latest);

undofile=fopen("ceres_undo", "w");
if(undofile == NULL){ResetCursor(topLevel);return; }
 /*
 printf("(%d\t%d)\n",areat1,areat2);
 printf("(%d\t%d)\n",areaf1,areaf2);
 printf("(%d\t%d)\n",thewidth,horiz_num);
 */


 fprintf(undofile,"%d\n",N);
 fprintf(undofile,"%d\t%d\n",areat1,areat2);
 fprintf(undofile,"%d\t%d\n",areaf1,areaf2);
 /*   print of cvmon
(0      1093)
(0      513)
(400    1093)
>COPY
*/
for(p = areat1; p < areat2; p++)
  for(q = areaf1; q < areaf2; q++)
	{
	point = q + numchannels*p;
       /* fprintf(undofile,"%ld\t%ld\t%ld\t",p,q,point);*/
	fprintf(undofile,"%f\t%f\n",megamp[point],megfreq[point]);
        megamp[point]=0.0;
        /*
        printf("%ld\t%ld\t%ld\t",p,q,point);
	printf("%f\t%f\n",megamp[point],megfreq[point]);
	*/
	}


 strcpy(the_latest,"cut");
 fclose(undofile);
 RedrawAll();
 ResetCursor(topLevel);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void Paste(w, client, call)
Widget w;
XtPointer client, call;
{
 FILE *undofile;
 FILE *redofile;
 int p, q, n, art1, art2, arf1, arf2;
 float tempmp, tempfrq;
 long point;
 Boolean undo_redoAllowed;
 char streng[100];

 if(megamp==NULL||megfreq==NULL)
   {printf(">Nothing to paste into\n"); ResetCursor(topLevel); return;}

 undo_redoAllowed=XmToggleButtonGetState(allowUndoToggle);
 if(!undo_redoAllowed){
     printf("Can't Redo\n");
    ResetCursor(topLevel);
    XtManageChild(undoWarning);
    return;
    }
	paintstuff = False;
 if(strcmp(the_latest,"paste")!=0){
 undofile=fopen("ceres_undo", "r");
 if (undofile==NULL)
    {printf(">Nothing to paste\n"); ResetCursor(topLevel); return;}
  fclose(undofile);

  strcpy(streng,"mv -f");
  strcat(streng, " ceres_undo");
  strcat(streng, " ceres_redo");
  printf("%s\n",streng);
  system(streng);
  }

 redofile=fopen("ceres_redo", "r");
 if (redofile==NULL)
    {printf(">Nothing to paste\n"); ResetCursor(topLevel); return;}

  fscanf(redofile,"%d", &n);
 if(n!=N){
  fclose(redofile);
  printf(">FFT size error!\n");
  ResetCursor(topLevel);return;}
 fscanf(redofile,"%d", &art1);  fscanf(redofile,"%d", &art2);
 fscanf(redofile,"%d", &arf1);  fscanf(redofile,"%d", &arf2);
 printf(">%s\n",the_latest);
 fclose(redofile);



 undofile=fopen("ceres_undo", "w");

 if (undofile==NULL)
    {printf(">Can't create undo file\n"); ResetCursor(topLevel); return;}

fprintf(undofile,"%d\n",N);
fprintf(undofile,"%d\t%d\n",areat1,areat1 + art2-art1);
fprintf(undofile,"%d\t%d\n",arf1,arf2);

for(p = 0; p < art2-art1; p++)
  for(q = arf1; q < arf2; q++)
	{
	point = (long)(q + numchannels*(areat1+p));
       /* fprintf(undofile,"%ld\t%ld\t%ld\t",p,q,point);*/
	fprintf(undofile,"%f\t%f\n",megamp[point],megfreq[point]);
        /*
        printf("%ld\t%ld\t%ld\t",p,q,point);
	printf("%f\t%f\n",megamp[point],megfreq[point]);
	*/
	}
 fclose(undofile);printf(">UNDOFILE_CLOSED\n");

  redofile=fopen("ceres_redo", "r");
 if (redofile==NULL) {
    ResetCursor(topLevel);
    XtManageChild(fileWarning);
    return;
   }


XmUpdateDisplay(w);
SetWatchCursor(topLevel);
   printf(">PASTE\n");

 fscanf(redofile,"%d", &n);
 fscanf(redofile,"%d", &art1);  fscanf(redofile,"%d", &art2);
 fscanf(redofile,"%d", &arf1);  fscanf(redofile,"%d", &arf2);
/* fscanf(redofile,"%s", utext);  */
/* printf("%d %d %d %d\n",art1,art2,arf1,arf2); */

if(((areat1+art2-art1)>horiz_num)||((arf2-arf1+areaf1)>numchannels)){
  fclose(redofile);
  ResetCursor(topLevel);return;}

for(p = 0; p < art2-art1; p++)
  for(q = arf1; q < arf2; q++)
	{
	point = (long)(q + numchannels*(areat1+p));
   /*  printf("#\t%d %d %ld\n",p,q,point); */
	fscanf(redofile,"%f",&tempmp);
        fscanf(redofile,"%f",&tempfrq);
    /*  printf("%ld\t%f\t%f\n", point, tempmp, tempfrq); */
        megamp[point]=tempmp;
	megfreq[point]=tempfrq;
        /*
        printf("%ld\t%ld\t%ld\t",p,q,point);
	printf("%f\t%f\n",megamp[point],megfreq[point]);
	*/
	}

strcpy(the_latest, "paste");
printf(">DONE\n");



 fclose(redofile);
 RedrawAll();
 ResetCursor(topLevel); 

}

/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

void Extract(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(extractForm);
}
/*_____________________________________________________________________*/

/*This algorithm extracts fundamental frequency by inspecting
    possible regularities in frequency differences among spectral 
    peaks of a single analysis frame and eliminating extremes (as of
    v. 0.26). It also extracts average frame and bin amplitudes (as
    of v. 0.25 */

void extractOk(w, client, call)
Widget w;
XtPointer client, call;
{
Boolean amplit,fundam,spect,probf,estimf,found;
char* valstring;
register int i,j,k,p,q;
int step,v_step,num,b, num_har,dif_size,probint;
static int l;
static long point,maxnum;
float segment, factor,temp, ampcfact,prob,errmrg, 
	f_lo,f_hi,harm_fact;
register float f,max, a;
float *avgspect   = NULL;
/*float *fundarray  = NULL;*/
float *difarray   = NULL;
float *probarray  = NULL;
float *harmarray  = NULL;
int   *chosen	  = NULL;
float *lookuparray= NULL;
long  *maxarray   = NULL;

Boolean zeroError = False;
Boolean noisy = False;
Boolean full_area = False;
amplit =  XmToggleButtonGetState(extractToggle1);

fundam =  XmToggleButtonGetState(extractToggle2);
estimf =  XmToggleButtonGetState(extractToggle3);
probf  =  XmToggleButtonGetState(extractToggle4);

spect  =  XmToggleButtonGetState(extractToggle6);


if(XmToggleButtonGetState(displayToggleArea)==False)
 if(XmToggleButtonGetState(displayToggleArea2)==False)
  if(XmToggleButtonGetState(displayToggleArea3)==False){
  areat1=0; areat2=horiz_num;
  areaf1=0; areaf2=numchannels;
  full_area = True;
  }
printf("Extract: horiz_num = %d\tnumchannels = %d\n",horiz_num,numchannels);
printf("Extract: the width = %d\n",thewidth);
printf("Extract: areat1    = %d\tareat2      = %d\n",areat1,areat2);
printf("Extract: areaf1    = %d\tareaf2      = %d\n",areaf1,areaf2);
b=0;

valstring=XmTextGetString(extractTextfield); /*get the number of points*/
num = atoi(valstring); if(num<2)num = 2; if(num>MAXNODES-3)num = MAXNODES-3;
XtFree(valstring);

valstring=XmTextGetString(extractTextfield2);
f_lo = atof(valstring); 
XtFree(valstring);
valstring=XmTextGetString(extractTextfield3);
f_hi = atof(valstring);
XtFree(valstring);
if (f_lo <20.)f_lo=20.;
if (f_hi >20000.)f_hi=20000.;
if (f_lo > f_hi)f_lo = f_hi;

valstring=XmTextGetString(extractTextfield4);
prob = .01*atof(valstring); 
XtFree(valstring);
valstring=XmTextGetString(extractTextfield5);
num_har = (int)atoi(valstring); 
XtFree(valstring);
valstring=XmTextGetString(extractTextfield6);
if(strcmp(valstring, "bin")==0)  errmrg = binfreq;
if(strcmp(valstring, "bin/2")==0)errmrg = binfreq*.5;
else errmrg = atof(valstring); 
XtFree(valstring);
if (prob < .000001)prob=.000001;
if (prob > 1.)prob=1.;
if (num_har < 2.)num_har=2;
if (num_har > numchannels)num_har=numchannels;
if (errmrg < 0.)errmrg = .0;
if (errmrg > f_lo)errmrg = f_lo;


segment = (float)(areat2-areat1);
factor =  (float)thewidth/(float)horiz_num;
/*step = (int)(segment*factor/(float)num +.5);*//**factor*/

step = (int)(segment/**factor*//(float)(num - 1));
/*this prevents core dumps on fewer frames than points*/
if(step==0)step=1;if(num>(int)segment)num=(int)segment;

if((megamp==NULL)||(megfreq==NULL)||(avgamp==NULL)){
	printf(">Error: Nothing to extract.\n");
	return;
	}

XtUnmanageChild(extractForm);
SetWatchCursor(topLevel);

resetCF(amplit, fundam, spect);

XmUpdateDisplay(topLevel);
if((areat1>0)&&(areat2<=horiz_num-step))b=1;
/*
printf(">Extract: step = %d\t#%d\t%d\n",step,areat1,areat2);
*/



/*FIRST extract fundamental to allow read probability from CF1*/
/*for noisy sounds with low probability, large number of harmonics
   and high error margin values entered, the program will compute the
   peak spectral activity for each time slice */
/*for smooth, pitched sounds those parameters (higher probability, 
   lower error margin and fewer harmonics) will direct the two-step
   elimination algorithm toward more precise fundamental extraction*/
/*for completely inharmonic noisy sound a separate algorithm is
   implemented since 0.26a4
*/
if(fundam){
/*add update*/
		if (mEH==0) harm_fact = 1.;/*whole*/
		if (mEH==1) harm_fact = 1.5;/*odd*/	
		if (mEH==2){harm_fact = 1.; noisy = TRUE;}
	printf("\nExtract fundamental : ------\n");
	printf("Number of harmonics:\t %d\n",num_har);
	if(!estimf)
	printf("Inspect frequencies:  %7.1f to %7.1f (Hz)\n",f_lo,f_hi);
	if(!probf)
	printf("Probability        :\t%6.2f\n",prob);
	printf("Margin of error    :\t%5.1f (Hz)\n",errmrg);
	/*allocate the array for candidates num_har*sizeof(float)*/
    if(fundarray!=NULL)free(fundarray); 
	fvec(harmarray,num_har);
	lvec(maxarray,num_har);
	fvec(lookuparray, numchannels);
	f=0.; dif_size = 0;
	for(j = 0; j < num_har-1; j++)
		for(k = j; k<num_har; k++)dif_size++;
	fvec(difarray,dif_size+1);
	/*allocate the horizontal fundamental estimation array*/
	fvec(fundarray,horiz_num);
	fvec(probarray,horiz_num);
    ivec(chosen, 2*numchannels);



	for(i = 0; i < horiz_num; i++){ point = i*numchannels;
	for(j = 0; j < numchannels; j++)
		lookuparray[j] = megamp[point+j];
	/*read estimated fund from CF2 into fundarray*/
       if(estimf){
		fundarray[i]=binfreq*getfuncval2(i);
		/*printf("frequency = %f\n",fundarray[i]);*/
		}else fundarray[i]=f;
	/*read probability from CF1 */

	if(probf){
		probarray[i]=getfuncval2(i)/(float)(N/2);
		}else probarray[i]=prob;

    /*read n strongest bins into the candidates array*/
		for (k=0; k<num_har; k++) { 
			max = 0.; maxnum = 0;
			for(j = 0; j < numchannels; j++){
			if(lookuparray[j]>=max){
				maxnum = point+j;
				max = lookuparray[j];	
				}
			}

		harmarray[k] = megfreq[maxnum];
		maxarray[k] = maxnum;
		lookuparray[maxnum-point]= -1.;
		/*printf("# %d\t%d\t%f\t%ld\n",i,k,harmarray[k],maxarray[k]);*/
		}

/*sort candidates in ascending frequency order*/
		max = 0.; maxnum = 0;
		for(k=0;k<num_har;k++)
			for(j=0;j<num_har-1;j++){
			if(maxarray[j]>maxarray[j+1]){
				maxnum = maxarray[j];maxarray[j]=maxarray[j+1]; maxarray[j+1]=maxnum;
				max = harmarray[j];harmarray[j]=harmarray[j+1]; harmarray[j+1] =max;
				}
			}
		
		f = 0.; a = 1e-32;
		if (noisy)for(k=0,j=0;k<num_har;k++){
			if(harmarray[k]>=f_lo && harmarray[k]<=f_hi){
			f+=harmarray[k]*maxarray[k]; a+= maxarray[k];j++;
			}
			f= f/a; goto join_lbl;
			}
				

/*
for(k=0;k<num_har;k++)printf("@ %d\t%d\t%ld\t%8.2f\t%8.2f\t%5.2f\n",i,k,maxarray[k],\
			megfreq[maxarray[k]], harmarray[k],100000.*megamp[maxarray[k]],\
			harmarray[k]);
*/
	/*subtract  freqs in the candidates array*/
	for(j = 0, 	l = 0; j < num_har-1; j++)
		for(k=j+1;k<num_har;k++){
		difarray[l]=harmarray[k]-harmarray[j];l++;
/*printf(" dif[%d] = %8.2f\n",l,difarray[l]);*/
		}
	/*compare diferences  w. estimated fundarray values*/
	/*this, however won't work with very noisy, inharmonically structured 
		  sounds, with almost no probability that the strongest partials would
		  have harmonic relationship of any kind; another algorithm for those
		  very noisy sounds has to be implemented (SJ, Dec. 00, v.0.26a2). */
	for(j = 0, l = 0, f = 0.; j < dif_size; j++){ 
			if (estimf){if((difarray[j]>(fundarray[i]-errmrg)) && \
				(difarray[j] < (fundarray[i]+errmrg))){
				f +=difarray[j]*difarray[j];
		    	l++;
				}
			}
			else{/*
			if(noisy){
				f +=megfreq[maxnum]*megfreq[maxnum];
				l++;
				}
			else */if((difarray[j]>f_lo) && (difarray[j] < f_hi)){
				f +=difarray[j]*difarray[j];
		    	l++;
				}
		    }
		}
	f = sqrt(fabs(f)/(float)l);
join_lbl:
	if (f > f_hi) f = f_hi;
	if (f < f_lo) f = f_lo;
if(l==0 && !noisy){
	f = .5*(f_hi + f_lo);
	/*printf("First elimination: %8.2f (interpolated)\t",f);*/
	}
else /*printf("First elimination: %8.2f\t",f)*/;

	/*compute back the closest candidates, introduce margin, prob.*/
	for(j = 0, l = 0; j < dif_size; j++)
		if(fabs(difarray[j]-f)<=errmrg)l++;

  /*(probability for given i)*num_har*/	
	probint = (int)(probarray[i]*(float)num_har);
/*printf("%d\t%d\n",probint,l);*/
	if(l >= probint){
  
	for(j = 0, k = 0; j < dif_size; j++)
		if(fabs(difarray[j]-f)<=errmrg)chosen[k++]=j;
	for(j = 0, f = 0.; j < l; j++)
		f +=difarray[chosen[j]]*difarray[chosen[j]];
	f = sqrt(f/(float)j);

	f = f/harm_fact;


/*printf("Second elimination: %8.2f\t",f);*/
	}else{
		if (i>0){
			if((f > f_lo)&&(f < f_hi))
				f=(1.-probarray[i])*fundarray[i-1]+f*(probarray[i]);
			else f = fundarray[i-1];
		   /* printf("EE: Extrapolating %8.2f\t",f);			*/
			}
		else {
			f  =  (f_hi+f_lo)/2.; zeroError = True;
			}
		}

	/*what if  func-estim f0 ?*/
	if(estimf);
	/*update the fund. array*/
	fundarray[i]=f;

  /*printf("%d\n", i);*/
  }/* end  i loop */

if (zeroError)
	if((fundarray[1]>f_lo)&&(fundarray[1]<f_hi))
	if((fundarray[2]>f_lo)&&(fundarray[2]<f_hi))
	fundarray[0]=2.*fundarray[1]-fundarray[2];

	/*map fundarray values into cf-2*/
    j = 1;
  for(i = areat1; i < areat2; i+=step){
	p = (int)((float)i*factor)+50;
	q = theheight+10 -(int)(fundarray[i]/binfreq);
	if(p<50)p=50;
	if(p>thewidth+50/*-step*/)p=thewidth+50;
	if(q<20)q=20;
	if (q>theheight+10) q=theheight+10;

	xpos2[j]  = p;
	ypos2[j]  = q;
        numsquare2 = j;
       /* printf("%d\t%d\n",j,xpos2[j]); */
	if((full_area)&&(j == num)){
		xpos2[j]  = thewidth+50;
		ypos2[j]  = theheight+10 -(int)(fundarray[horiz_num]/binfreq);
       	numsquare2 = j;		
		break;
		}
	j++;
	if((i>areat2-step)&&(p<(thewidth+50))){
		p = thewidth+50; q = theheight;
		xpos2[j]  = p;
		ypos2[j]  = q;
       	numsquare2 = j;		
	 }
  }/*end 2nd "for i-loop */
	if(areat2<horiz_num){
		p=thewidth+50; q = theheight;
		xpos2[j]  = p;
		ypos2[j]  = q;
       		numsquare2 = j;
	}
  free(chosen);
  free(difarray);
  if(probf)free(probarray);
  free(lookuparray);
  free(maxarray); 
  free(harmarray); 

 }/*end fundam*/




if(amplit){

	/*reset CF1*/

    amptrack(areat1,areat2,areaf1,areaf2);
	ampcfact = 1000.*pow(theheight,1.5)*iheight/512.;
	
	j = 1+b;

    for(i = areat1; i <= areat2; i+=step){
	/*printf("#%d\t%f\n",i,avgamp[i]);*/
	p = (int)((float)i*factor)+50;
	q = theheight+10 -(int)(ampcfact*avgamp[i]);
	if(p<50)p=50;
	if(p>thewidth+50/*-step*/)p=thewidth+50;
	if(q<20)q=20;
	if (q>theheight+10) q=theheight+10;

	xpos[j]  = p;
	ypos[j]  = q;
        numsquare = j;
        printf("F1:  %d\t%d\n",j,xpos[j]); 
	if((full_area)&&(j == num)){
		xpos[j]  = thewidth+50;
		ypos[j]  = theheight+10 -(int)(ampcfact*avgamp[horiz_num]);
       	numsquare = j;		
		break;
		}
	j++;
	if((i>areat2-step)&&(p<(thewidth+50))){
		p = thewidth+50; q = theheight;
		xpos[j]  = p;
		ypos[j]  = q;
       	numsquare = j;		
      }
    } /*end of "for i" - loop*/

	if(areat2<horiz_num){
		p=thewidth+50; q = theheight;
		xpos[j]  = p;
		ypos[j]  = q;
       	numsquare = j;
      }
		
       
/*     if(p>areat2-step) xpos[j]=areat2;
     if(p>thewidth+50-step) xpos[j]=thewidth+50;
*/

}
 

if(spect){ fvec(avgspect, numchannels+1); max = 0.;
	printf("\n>Extract spectrum: %d\t%d\t%d\t%d\n",areat1,areat2,areaf1,areaf2);
    point  = numchannels*areat1;
    v_step = (int)((float)(areaf2-areaf1)/(float)num /* +.5*/);

    for(j = areaf1; j<areaf2; j++){
	for(i = areat1; i < areat2; i++){
         temp = 1000.*megamp[point+j+numchannels*(i-areat1)]; temp*=temp;
         avgspect[j]+= temp;
	 }
        avgspect[j]=sqrt(avgspect[j]);
	if(avgspect[j]>max)max=avgspect[j];
    }
    if(max<=0.)goto I_failed;

    for(j=areaf1;j<areaf2;j++){avgspect[j]/=max;
/*    printf("#%d\t%f\n",j,avgspect[j]);*/
	}
    if(areaf2 > 0)b=1;
    j=1+b;

    factor = (float)theheight/(float)numchannels;
	printf("Vertical scaling factor = %f\n", factor);

    for(i=areaf2-v_step;i>areaf1 ; i-=v_step)
	{
	  q = 20 + theheight-(int)(factor*(float)i); 
	  temp=0.;
	/*compute RMS spectrum of the segment*/
	  if(i>areaf1+v_step)
	     for(k=i+v_step/2;k>i-v_step/2;k--)
		temp = temp + (avgspect[k]*avgspect[k]);

      p = 50+(int)(400.*(1.-sqrt(temp/v_step)));
	  xpos3[j]=p;
	  ypos3[j]=q-10;
	  numsquare3 = j;j++;
	}/*end of 3rd i-loop*/
	
    if(i>0){
	xpos3[j]=50;
	ypos3[j]=theheight+10;
	numsquare3= j;
	}

   xpos3[1]=xpos3[2];
   xpos3[numsquare3]=xpos3[numsquare3-1];


    I_failed:
    free(avgspect);/*avgspect==NULL;*/
    }
  RedrawAll();
  ResetCursor(topLevel);

}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void Controlfunction(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(controlfunctionForm);
}
/*_____________________________________________________________________*/
void controlfunctionOk(w, client, call)
Widget w;
XtPointer client, call;
{
Boolean funcsel, funcsel2, funcsel3, slide, scale,
	shift, mirror, retro, add, mult, repl, reset,map;
char *valstring;
int o, p, q, s, s3, r, t, max, min, off, tempx,tempy,sh;
float m,n,corr;
float *aps, *ord;


valstring=XmTextGetString(controlfunctionTextfield);

m = .01*(float)atof(valstring);
s = (int)(m*(float)theheight);
s3= (int)(m*400.);
corr = (float)horiz_num/(float)thewidth;
if (m>5.) m=5.; if (m<0.)m*=-1.;
XtFree(valstring);
valstring=XmTextGetString(controlfunctionTextfield2);
sh = atoi(valstring); XtFree(valstring);


funcsel =  XmToggleButtonGetState(displayToggleFunc);   funcpt=1;
funcsel2=  XmToggleButtonGetState(displayToggleFunc2);  funcpt2=1;
funcsel3=  XmToggleButtonGetState(displayToggleFunc3);  funcpt3=1;
slide   =  XmToggleButtonGetState(controlfunctionSlideToggle);
scale   =  XmToggleButtonGetState(controlfunctionScaleToggle);
shift   =  XmToggleButtonGetState(controlfunctionShiftToggle);
mirror  =  XmToggleButtonGetState(controlfunctionMirrorToggle);
retro   =  XmToggleButtonGetState(controlfunctionRetroToggle);
mult    =  XmToggleButtonGetState(controlfunctionMultToggle);
add     =  XmToggleButtonGetState(controlfunctionAddToggle);
repl    =  XmToggleButtonGetState(controlfunctionReplToggle);
reset   =  XmToggleButtonGetState(controlfunctionResetToggle);
map     =  XmToggleButtonGetState(controlfunctionMapToggle);


max = 0;   min = theheight;

/*scanf("%d",&off); */
off=50;
/*printf("%d\n",areat2);*/
if(funcsel){
if(scale){
	for (p=1; p<=numsquare; p++){
	r=(int)(m*(theheight-ypos[p]+20)); /*20 ?*/
	if(r>max)max=r;
	} if(max>theheight)m*=(float)theheight/(float)max;
      }
if(slide){
        for (p=1; p<=numsquare; p++){
        r=ypos[p]-s; if(r>max)max=r;if(r<min)min=r;
        } if(max-theheight>0)s+=(max-theheight-10);
	  if(min<0)s+=min-20;
	}
     }

if(funcsel2){
if(scale){
	for (p=1; p<=numsquare2; p++){
	r=(int)(m*(theheight-ypos2[p]+20)); if(r>max)max=r;  /*20 ?*/
	} if(max>theheight)m*=(float)theheight/(float)max;
      }
if(slide){
        for (p=1; p<=numsquare2; p++){
        r=ypos2[p]-s; if(r>max)max=r; if(r<min)min=r;
/*printf("%d\n",min); */
        } if(max-theheight>0)s+=(max-theheight-10);
	  if(min<0)s+=min-20;
/*printf("#%d\n",s);*/
	}
     }

if(funcsel)if(!repl)if(!reset)if(!shift)if(!retro)if(!map)
  for (p=1; p<=numsquare; p++) {
    if(slide){
      q=ypos[p]-s; if (q<20) q=20;
      if (q>theheight+20) q=theheight+20;
      }
    if(scale){
      q=theheight-ypos[p]+20; q*=m; q=theheight-q+20;
      if (q<10) q=10; if (q>theheight+20) q=theheight+20;
      }
    if(mirror) q= theheight+10-(ypos[p]);
    if(mult){ o =(int)((float)(xpos[p]-off)*corr);
	/*printf("MULT:\t%d\n",o);*/
	q=20+(int)(getfuncval2(o)*(float)(theheight-ypos[p])/(float)(theheight+20));
        q=theheight+20-q;
	}
    if(add){o = (int)( (float)(xpos[p]-off)*corr ); if(o>=horiz_num)o=horiz_num-1;
	q=ypos[p]-(int)getfuncval2( o );	
	}
    if(q<10)q=10; if(q>theheight)q=theheight;
    ypos[p]=q;
    /*printf("%d\t%d\t%d\t%d\t%d\n",p,ypos[p],o,(int)getfuncval2( o ),q);*/
  }
             /**/
if(funcsel2)if(!repl)if(!reset)if(!shift)if(!retro)if(!map)
  for (p=1; p<=numsquare2; p++) {
    if(slide){
      q=ypos2[p]-s; if (q<20) q=20;
      if (q>theheight+20) q=theheight+20;
      }
    if(scale){
      q=theheight-ypos2[p]+20; q*=m; q=theheight-q+20;
      if (q<10) q=10; if (q>theheight+20) q=theheight+20;
      }
    if(mirror) q= theheight+10-(ypos2[p]);
    if(mult){ o =(int)((float)(xpos[p]-off)*corr);
	q=20+(int)(getfuncval(o)*(float)(theheight-ypos2[p])/(float)(theheight+20));
	q=theheight+20-q;
	}
    if(add){ o = (int)((float)(xpos2[p]-off)*corr); if(o>=horiz_num)o=horiz_num-1;
        q=ypos2[p]-(int)getfuncval( o );
	}
    if(q<10)q=10;if(q>theheight)q=theheight;
    /*printf("%d\t%d\t%d\t%d\t%d\n",p,ypos2[p],o,(int)getfuncval( o ),q);*/
    ypos2[p]=q;
  }

if(funcsel3)if(!repl)if(!reset)if(!shift)if(!retro)if(!map){
	/*test for, catch and fix out-of-range values*/
		for(p=1;p<=numsquare3;p++){
		    if(xpos3[p]<0)xpos3[p]=0;
		    if(xpos3[p]>450)xpos3[p]=450;
		    }
	/*end test*/
	if(mirror){
	max = 0;
	for(p=1;p<=numsquare3;p++)if(xpos3[p]>max)max=xpos3[p];/*unnecessary code*/
	for(p=1;p<=numsquare3;p++){xpos3[p]=50+450-xpos3[p];
		if(xpos3[p]<50)xpos3[p]=50;
		}
		}

	if(slide){
		/*printf("slide3\n");*/
	if(s3>0){min = 450;
		for(p=1;p<=numsquare3;p++)if(xpos3[p]<min)min=xpos3[p];
		if(s3>min)s3=min-50;
		}
	if(s3<0){max = 0;
		for(p=1;p<=numsquare3;p++)if(xpos3[p]>max)max=xpos3[p];
		if(-1*s3+max>450)s3=max-450;
		}
	for(p=1;p<=numsquare3;p++)xpos3[p]-=s3;	
		}

	if(scale){
		/*printf("scale3\n");*/
	/*b11*/
                if(m<0)m*=-1;  max = 0;
		for(p=1;p<=numsquare3;p++)if(450-xpos3[p]>max)max=450-xpos3[p];
		if(m*max>400.)m=m*(400./(m*(float)max));
		for(p=1;p<=numsquare3;p++)xpos3[p]=(int)(450.-m*(450.-(float)xpos3[p]));
	/*endb11*/
		}
		
	}

if(repl){
   if(funcsel)for(p=1;p<=numsquare2;p++){
	xpos[p]=xpos2[p];
	ypos[p]=ypos2[p];
        numsquare=p;
        }
   if(funcsel2)for(p=1;p<=numsquare;p++){
	xpos2[p]=xpos[p];
	ypos2[p]=ypos[p];
        numsquare2=p;
        }
}

if(reset){
        if(funcsel){
		resetCF(True, False, False);	    	
		}
        if(funcsel2){
		resetCF(False, True, False);
		}
		if(funcsel3){
		resetCF(False, False, True);
	 	}
     }

  if(retro){
     if(funcsel){ for(p=1;p<=numsquare/2;p++){
           /* tempx = xpos[p];xpos[p]=xpos[numsquare-p+1];xpos[numsquare-p+1]=tempx;*/
            tempy = ypos[p];ypos[p]=ypos[numsquare-p+1];ypos[numsquare-p+1]=tempy;
	    }
	}
     if(funcsel2){ for(p=1;p<=numsquare2/2;p++){
            /*tempx = xpos2[p];xpos2[p]=xpos2[numsquare2-p+1];xpos2[numsquare2-p+1]=tempx;*/
            tempy = ypos2[p];ypos2[p]=ypos2[numsquare2-p+1];ypos2[numsquare2-p+1]=tempy;
	    }
	}
     if(funcsel3){ for(p=1;p<=numsquare3/2;p++){
            tempx = xpos3[p];xpos3[p]=xpos3[numsquare3-p+1];xpos3[numsquare3-p+1]=tempx;
            /*tempy = ypos3[p];ypos3[p]=ypos3[numsquare3-p+1];ypos3[numsquare3-p+1]=tempy;*/
	    }
	}
  }

  if(shift){

    /* printf("#%d\n",sh);*/
     if(funcsel){
	  if(sh<0)for(q=0;q<sh*(-1);q++){
	    tempy = ypos[1];
            for(p=1;p<numsquare;p++)ypos[p]=ypos[p+1];
	  ypos[numsquare]= tempy;
	  }
	  if(sh>0)for(q=0;q<sh;q++){
	    tempy = ypos[numsquare];
            for(p=numsquare;p>1;p--)ypos[p]=ypos[p-1];
	  ypos[1]= tempy;
	  }
	}
     if(funcsel2){
	  if(sh<0)for(q=0;q<sh*(-1);q++){
	    tempy = ypos2[1];
            for(p=1;p<numsquare2;p++)ypos2[p]=ypos2[p+1];
	  ypos2[numsquare2]= tempy;
	}
	if(sh>0)for(q=0;q<sh;q++){
	  tempy = ypos2[numsquare2];
          for(p=numsquare2;p>1;p--)ypos2[p]=ypos2[p-1];
	  ypos2[1]= tempy;
	  }
	}
     if(funcsel3){
	if(sh<0)for(q=0;q<sh*(-1);q++){
	  tempx = xpos3[numsquare3];
          for(p=numsquare3;p>1;p--)xpos3[p]=xpos3[p-1];
	  xpos3[1]= tempx;
	 }
	if(sh>0)for(q=0;q<sh;q++){
	  tempx = xpos3[1];
          for(p=1;p<numsquare3;p++)xpos3[p]=xpos3[p+1];
	  xpos3[numsquare3]= tempx;
	 }
      }
  }
/*Map*/
if(map){
    if(funcsel2){fvec(aps,numsquare3+1);fvec(ord,numsquare3+1);
	printf("Map: 3->2\n");
	for(p=1;p<=numsquare3;p++){
		aps[p]=1.-(ypos3[numsquare3-p+1]-10)/(float)theheight;
		ord[p]=1.-(xpos3[numsquare3-p+1]-50)/400.;
		if(ord[p]<0.)ord[p]=0.;if(ord[p]>1.)ord[p]=1.;
		/*printf("$%d\t%f\t%f\n",p,aps[p],ord[p]);*/
		}
	for(p=1;p<=numsquare3;p++){
		xpos2[p]=50+(int)(thewidth*aps[p]);
		ypos2[p]=10+(int)((1.-ord[p])*(float)theheight);
		numsquare2=p;
		/*printf("#%d\t%d\t%d\n",p,xpos2[p],ypos2[p]);*/
		}
	free(aps);free(ord);		
    }
    else if(funcsel3){fvec(aps,numsquare2+1);fvec(ord,numsquare2+1);
    	printf("Map: 2->3\n");
	for(p=1;p<=numsquare2;p++){
		aps[p]=(xpos2[p]-50)/(float)thewidth;
		ord[p]=1.-(ypos2[p]-10)/(float)theheight;
		if(ord[p]<0.)ord[p]=0.;if(ord[p]>1.)ord[p]=1.;
		/*printf("$%d\t%f\t%f\n",p,aps[p],ord[p]);*/
		}
	for(p=1;p<=numsquare2;p++){
		xpos3[p]=50+(int)(400.*(1.-ord[numsquare2-p+1]));
		ypos3[p]=10+(int)((1.-aps[numsquare2-p+1])*(float)theheight);
		numsquare3=p;
		/*printf("#%d\t%d\t%d\n",p,xpos3[p],ypos3[p]);*/
		}
	free(aps);free(ord);
    }
    else printf("Error: Control function 2 or 3 must be active\n");
   
  }
  fin:
  printf(">Edit control functions: done\n");

RedrawAll();
}

/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

void SpotsRestart(w, client, call)
Widget w;
XtPointer client, call;
{
  numspots=0;
  RedrawWin();
}

/*______________________________________________________________________*/
/*rewritten for v. 0.27, implementing area-strict conformance and fixing
 * an inacurate filtering bug due to  paint-spot overlapping
*     *     *     *     *     *     *     *     *     *     *     *     *     *     */
void SpotsKeep(w, client, call)
Widget w;
XtPointer client, call;
{

  long point=0;
  int i, j, k, f, t;
  Boolean undo_redoAllowed;

  printf("%d\t%d\t%d\t%d\n", kt1,kf1,kt2,kf2);
if(undo_redoAllowed=XmToggleButtonGetState(allowUndoToggle)){
	paintstuff = True;
	create_undofile("keep", kt1,kf1,kt2,kf2);
	}
  for (i=0; i<numspots; i++) {
    for (j=-(spotsize/2); j<(spotsize-(spotsize/2)); j++) {
      f=spotsf[i]+j;
      if ((f>kf1) && (f<kf2)) {
        for (k=-(spotsize/2); k<(spotsize-(spotsize/2)); k++) {
          t=spotst[i]+k;
			/*temporary neg. value*/
			/*don't flip-flop already negative values (v.0.27)*/
          if ((t>=kt1) && (t<kt2) && (megamp[t*numchannels+f] >=0.))
            megamp[t*numchannels+f]=-megamp[t*numchannels+f];
        }
      }
    }
  }

point = kt1*numchannels;
  for (i=kt1; i<kt2; i++) {
    for (j=kf1; j<kf2; j++) {
      megamp[point+j]=(megamp[point+j]<0?-megamp[point+j]:0.);
    /*  point++;*/
    }
  point+=numchannels;
  }
  RedrawWin();
}

/*_________________________________________________________________________________*/
/*rewritten for v. 0.27, implementing area-strict conformance 
  *     *     *     *     *     *     *     *     *     *     *     *     *     *     */
void SpotsRemove(w, client, call)Widget w;
XtPointer client, call;
{
  long point=0;
  int i, j, k, f, t;
  Boolean undo_redoAllowed;

if(undo_redoAllowed=XmToggleButtonGetState(allowUndoToggle)){
	paintstuff = True;
	create_undofile("remv",kt1,kf1,kt2,kf2);
	}
  for (i=0; i<numspots; i++) {
    for (j=-(spotsize/2); j<(spotsize-(spotsize/2)); j++) {
      f=spotsf[i]+j;
      if ((f>kf1) && (f<kf2)) {
        for (k=-(spotsize/2); k<(spotsize-(spotsize/2)); k++) {
          t=spotst[i]+k;
          if ((t>=kt1) && (t<kt2))
            megamp[t*numchannels+f]=0.;
        }
      }
    }
  }

  RedrawWin();
}

/*_______________________GRID GENERATION CALLBACKS_____________________*/
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

void makepenta(w, client, call)
Widget w;
XtPointer client, call;
{
  char *valstring;
  char s[10],t[10];
  float val;
  int i;
  float f;

  valstring=XmTextGetString(gridTextfield);
  strcpy(s,valstring);
  if(isdigit(s[0])) val = atof(valstring); else val = pitch2freq(s);
  XtFree(valstring);
  gridfreqs[0]=val;

  valstring=XmTextGetString(gridTextfield2);
  strcpy(t,valstring);
  XtFree(valstring);

if(((atoi(t)-1)%5)==0)
 {
  default_grid:
  gridfreqs[1]=gridfreqs[0]*etM2;
  gridfreqs[2]=gridfreqs[0]*etM3;
  gridfreqs[3]=gridfreqs[0]*etP5;
  gridfreqs[4]=gridfreqs[0]*etM6;
  goto generate;
 }
else if(((atoi(t)-1)%5)==1)
 {
  gridfreqs[1]=gridfreqs[0]*etM2;
  gridfreqs[2]=gridfreqs[0]*etP4;
  gridfreqs[3]=gridfreqs[0]*etP5;
  gridfreqs[4]=gridfreqs[0]*etm7;
  goto generate;
 }
else if(((atoi(t)-1)%5)==2)
 {
  gridfreqs[1]=gridfreqs[0]*etm3;
  gridfreqs[2]=gridfreqs[0]*etP4;
  gridfreqs[3]=gridfreqs[0]*etm6;
  gridfreqs[4]=gridfreqs[0]*etm7;
  goto generate;
 }
else if(((atoi(t)-1)%5)==3)
 {
  gridfreqs[1]=gridfreqs[0]*etM2;
  gridfreqs[2]=gridfreqs[0]*etP4;
  gridfreqs[3]=gridfreqs[0]*etP5;
  gridfreqs[4]=gridfreqs[0]*etM6;
  goto generate;
 }
else if(((atoi(t)-1)%5)==4)
 {
  gridfreqs[1]=gridfreqs[0]*etm3;
  gridfreqs[2]=gridfreqs[0]*etP4;
  gridfreqs[3]=gridfreqs[0]*etP5;
  gridfreqs[4]=gridfreqs[0]*etm7;
  goto generate;
 }
else goto default_grid;
generate:
printf("pitch grid: pentatonic\n");
  for (i=5; i<500; i++) {
    gridfreqs[i]=gridfreqs[i-5]*2.;
    numfreqs=i+1;
    if (gridfreqs[i]>23000) break;
    }
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void makemajor(w, client, call)
Widget w;
XtPointer client, call;
{
  char *valstring,s[10];
  float val;
  int i;
  float f;

  valstring=XmTextGetString(gridTextfield);
  strcpy(s,valstring);
  if(isdigit(s[0])) val = atof(valstring); else val = pitch2freq(s);
  XtFree(valstring);

  valstring=XmTextGetString(gridTextfield2);
  strcpy(s,valstring);
  XtFree(valstring);
  gridfreqs[0]=val;
if(strncmp(s,"major",5)==0||strncmp(s,"ionian",6)==0){
  gridfreqs[1]=gridfreqs[0]*etM2;
  gridfreqs[2]=gridfreqs[0]*etM3;
  gridfreqs[3]=gridfreqs[0]*etP4;
  gridfreqs[4]=gridfreqs[0]*etP5;
  gridfreqs[5]=gridfreqs[0]*etM6;
  gridfreqs[6]=gridfreqs[0]*etM7;
  printf("pitch grid: ionian\n");
  goto generate;
  }
else if(strncmp(s,"dorian",6)==0){
  gridfreqs[1]=gridfreqs[0]*etM2;
  gridfreqs[2]=gridfreqs[0]*etm3;
  gridfreqs[3]=gridfreqs[0]*etP4;
  gridfreqs[4]=gridfreqs[0]*etP5;
  gridfreqs[5]=gridfreqs[0]*etM6;
  gridfreqs[6]=gridfreqs[0]*etm7;
  printf("pitch grid: dorian\n");
  goto generate;
  }
else if(strncmp(s,"phrygian",8)==0||strncmp(s,"phrigyan",8)==0||\
   strncmp(s,"phrigian",8)==0||strncmp(s,"phrygyan",8)==0){
  gridfreqs[1]=gridfreqs[0]*etm2;
  gridfreqs[2]=gridfreqs[0]*etm3;
  gridfreqs[3]=gridfreqs[0]*etP4;
  gridfreqs[4]=gridfreqs[0]*etP5;
  gridfreqs[5]=gridfreqs[0]*etm6;
  gridfreqs[6]=gridfreqs[0]*etm7;
  printf("pitch grid: phryian\n");
  goto generate;
  }
else if(strncmp(s,"lydian",6)==0||strncmp(s,"lidyan",6)==0||\
   strncmp(s,"lydyan",6)==0||strncmp(s,"lidian",6)==0){
  gridfreqs[1]=gridfreqs[0]*etM2;
  gridfreqs[2]=gridfreqs[0]*etM3;
  gridfreqs[3]=gridfreqs[0]*etA4;
  gridfreqs[4]=gridfreqs[0]*etP5;
  gridfreqs[5]=gridfreqs[0]*etM6;
  gridfreqs[6]=gridfreqs[0]*etM7;
  printf("pitch grid: lydian\n");
  goto generate;
  }
else if(strncmp(s,"mixoly",6)==0||strncmp(s,"mixoli",6)==0||\
   strncmp(s,"myxoly",6)==0||strncmp(s,"mixoli",6)==0){
  gridfreqs[1]=gridfreqs[0]*etM2;
  gridfreqs[2]=gridfreqs[0]*etM3;
  gridfreqs[3]=gridfreqs[0]*etP4;
  gridfreqs[4]=gridfreqs[0]*etP5;
  gridfreqs[5]=gridfreqs[0]*etM6;
  gridfreqs[6]=gridfreqs[0]*etm7;
  printf("pitch grid: mixolydian\n");
  goto generate;
  }
else if(strncmp(s,"aeolian",7)==0||strncmp(s,"eolian",6)==0||\
   strncmp(s,"minor",5)==0||strncmp(s,"natural",7)==0){
  gridfreqs[1]=gridfreqs[0]*etM2;
  gridfreqs[2]=gridfreqs[0]*etm3;
  gridfreqs[3]=gridfreqs[0]*etP4;
  gridfreqs[4]=gridfreqs[0]*etP5;
  gridfreqs[5]=gridfreqs[0]*etm6;
  gridfreqs[6]=gridfreqs[0]*etm7;
  printf("pitch grid: aeolian (nat. minor)\n");
  goto generate;
  }
else if(strncmp(s,"locr",4)==0){
  gridfreqs[1]=gridfreqs[0]*etm2;
  gridfreqs[2]=gridfreqs[0]*etm3;
  gridfreqs[3]=gridfreqs[0]*etP4;
  gridfreqs[4]=gridfreqs[0]*etA4;
  gridfreqs[5]=gridfreqs[0]*etm6;
  gridfreqs[6]=gridfreqs[0]*etm7;
  printf("pitch grid: locrian\n");
  goto generate;
  }
else{
  gridfreqs[1]=gridfreqs[0]*etM2;
  gridfreqs[2]=gridfreqs[0]*etM3;
  gridfreqs[3]=gridfreqs[0]*etP4;
  gridfreqs[4]=gridfreqs[0]*etP5;
  gridfreqs[5]=gridfreqs[0]*etM6;
  gridfreqs[6]=gridfreqs[0]*etM7;
  printf("Invalid selection: generating major (ionian)\n");
  }
generate:
for (i=7; i<500; i++) {
    gridfreqs[i]=gridfreqs[i-7]*2.;
    numfreqs=i+1;
    if (gridfreqs[i]>23000) break;
    }
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void makeminor(w, client, call)
Widget w;
XtPointer client, call;
{
  char *valstring,s[10];
  float val;
  int i;
  float f;

  valstring=XmTextGetString(gridTextfield);
  strcpy(s,valstring);
  if(isdigit(s[0])) val = atof(valstring); else val = pitch2freq(s);
  XtFree(valstring);

  gridfreqs[0]=val;
  gridfreqs[1]=gridfreqs[0]*etM2;
  gridfreqs[2]=gridfreqs[0]*etm3;
  gridfreqs[3]=gridfreqs[0]*etP4;
  gridfreqs[4]=gridfreqs[0]*etP5;
  gridfreqs[5]=gridfreqs[0]*etm6;
  gridfreqs[6]=gridfreqs[0]*etM7;
  printf("pitch grid: harmonic minor\n"); 
  for (i=7; i<500; i++) {
    gridfreqs[i]=gridfreqs[i-7]*2.;
    numfreqs=i+1;
    if (gridfreqs[i]>23000) break;
    }
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void makemminor(w, client, call)
Widget w;
XtPointer client, call;
{
  char *valstring,s[10];
  float val;
  int i;
  float f;

  valstring=XmTextGetString(gridTextfield);
  strcpy(s,valstring);
  if(isdigit(s[0])) val = atof(valstring); else val = pitch2freq(s);
  XtFree(valstring);

  gridfreqs[0]=val;
  gridfreqs[1]=gridfreqs[0]*etM2;
  gridfreqs[2]=gridfreqs[0]*etm3;
  gridfreqs[3]=gridfreqs[0]*etP4;
  gridfreqs[4]=gridfreqs[0]*etP5;
  gridfreqs[5]=gridfreqs[0]*etM6;
  gridfreqs[6]=gridfreqs[0]*etM7;
printf("pitch grid: melodic minor\n");
  for (i=7; i<500; i++) {
    gridfreqs[i]=gridfreqs[i-7]*2.;
    numfreqs=i+1;
    if (gridfreqs[i]>23000) break;
    }
}


/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

void makeMLT(w, client, call)
Widget w;
XtPointer client, call;
{
/* (Ceres3:v.0.25b16-->)
 * This code generates Olivier Messiaen's Modes of Limited
 * Transposition, as described by the author in his book,
 * "Technique of my musical language"
 * */

  char *valstring,s[10],t[10];
  float val;
  int i,nd;
  float f;

  valstring=XmTextGetString(gridTextfield);
  strcpy(s,valstring);
  if(isdigit(s[0])) val = atof(valstring); else val = pitch2freq(s);

  XtFree(valstring);
  valstring=XmTextGetString(gridTextfield2);
  strcpy(t,valstring);
  XtFree(valstring);

/*--(root degree freq.)--*/
  gridfreqs[0]=val;

/*--(first mode)---------*/
if(mLT==1){
  nd = 6;
  gridfreqs[1]=gridfreqs[0]*etM2;
  gridfreqs[2]=gridfreqs[0]*etM3;
  gridfreqs[3]=gridfreqs[0]*etA4;
  gridfreqs[4]=gridfreqs[0]*etm6;
  gridfreqs[5]=gridfreqs[0]*etm7;
  goto generate;
  }

/*--(second mode)--------*/
if(mLT==2){ nd = 8;
 if(((atoi(t)-1)%2)==0)
  {
  default_grid2:
  gridfreqs[1]=gridfreqs[0]*etm2;
  gridfreqs[2]=gridfreqs[0]*etm3;
  gridfreqs[3]=gridfreqs[0]*etM3;
  gridfreqs[4]=gridfreqs[0]*etA4;
  gridfreqs[5]=gridfreqs[0]*etP5;
  gridfreqs[6]=gridfreqs[0]*etM6;
  gridfreqs[7]=gridfreqs[0]*etm7;
  goto generate;
  }
 else if(((atoi(t)-1)%2)==1)
  {
  gridfreqs[1]=gridfreqs[0]*etM2;
  gridfreqs[2]=gridfreqs[0]*etm3;
  gridfreqs[3]=gridfreqs[0]*etP4;
  gridfreqs[4]=gridfreqs[0]*etA4;
  gridfreqs[5]=gridfreqs[0]*etm6;
  gridfreqs[6]=gridfreqs[0]*etM6;
  gridfreqs[7]=gridfreqs[0]*etM7;
  goto generate;
  }
 else goto default_grid2;
}

/*--(third mode)------*/
if(mLT==3){ nd = 9;
 if(((atoi(t)-1)%3)==0)
  {
  default_grid3:
  gridfreqs[1]=gridfreqs[0]*etM2;
  gridfreqs[2]=gridfreqs[0]*etm3;
  gridfreqs[3]=gridfreqs[0]*etM3;
  gridfreqs[4]=gridfreqs[0]*etA4;
  gridfreqs[5]=gridfreqs[0]*etP5;
  gridfreqs[6]=gridfreqs[0]*etm6;
  gridfreqs[7]=gridfreqs[0]*etm7;
  gridfreqs[8]=gridfreqs[0]*etM7;
  goto generate;
  }
 if(((atoi(t)-1)%3)==1)
  {
  gridfreqs[1]=gridfreqs[0]*etm2;
  gridfreqs[2]=gridfreqs[0]*etM2;
  gridfreqs[3]=gridfreqs[0]*etM3;
  gridfreqs[4]=gridfreqs[0]*etP4;
  gridfreqs[5]=gridfreqs[0]*etA4;
  gridfreqs[6]=gridfreqs[0]*etm6;
  gridfreqs[7]=gridfreqs[0]*etM6;
  gridfreqs[8]=gridfreqs[0]*etm7;
  goto generate;
  }
 if(((atoi(t)-1)%3)==1)
  {
  gridfreqs[1]=gridfreqs[0]*etm2;
  gridfreqs[2]=gridfreqs[0]*etm3;
  gridfreqs[3]=gridfreqs[0]*etM3;
  gridfreqs[4]=gridfreqs[0]*etP4;
  gridfreqs[5]=gridfreqs[0]*etP5;
  gridfreqs[6]=gridfreqs[0]*etm6;
  gridfreqs[7]=gridfreqs[0]*etM6;
  gridfreqs[8]=gridfreqs[0]*etM7;
  goto generate;
  }
 else goto default_grid3;
}

/*--(fourth mode)------*/
if(mLT==4){ nd = 8;
 if(((atoi(t)-1)%4)==0)
  {
  default_grid4:
  gridfreqs[1]=gridfreqs[0]*etm2;
  gridfreqs[2]=gridfreqs[0]*etM2;
  gridfreqs[3]=gridfreqs[0]*etP4;
  gridfreqs[4]=gridfreqs[0]*etA4;
  gridfreqs[5]=gridfreqs[0]*etP5;
  gridfreqs[6]=gridfreqs[0]*etm6;
  gridfreqs[7]=gridfreqs[0]*etM7;
  goto generate;
  }
 else if(((atoi(t)-1)%4)==1)
  {
  gridfreqs[1]=gridfreqs[0]*etm2;
  gridfreqs[2]=gridfreqs[0]*etM3;
  gridfreqs[3]=gridfreqs[0]*etP4;
  gridfreqs[4]=gridfreqs[0]*etA4;
  gridfreqs[5]=gridfreqs[0]*etP5;
  gridfreqs[6]=gridfreqs[0]*etm7;
  gridfreqs[7]=gridfreqs[0]*etM7;
  goto generate;
  }
 else if(((atoi(t)-1)%4)==2)
  {
  gridfreqs[1]=gridfreqs[0]*etm3;
  gridfreqs[2]=gridfreqs[0]*etM3;
  gridfreqs[3]=gridfreqs[0]*etP4;
  gridfreqs[4]=gridfreqs[0]*etA4;
  gridfreqs[5]=gridfreqs[0]*etM6;
  gridfreqs[6]=gridfreqs[0]*etm7;
  gridfreqs[7]=gridfreqs[0]*etM7;
  goto generate;
  }
 else if(((atoi(t)-1)%4)==3)
  {
  gridfreqs[1]=gridfreqs[0]*etm2;
  gridfreqs[2]=gridfreqs[0]*etM2;
  gridfreqs[3]=gridfreqs[0]*etm3;
  gridfreqs[4]=gridfreqs[0]*etA4;
  gridfreqs[5]=gridfreqs[0]*etP5;
  gridfreqs[6]=gridfreqs[0]*etm6;
  gridfreqs[7]=gridfreqs[0]*etM6;
  goto generate;
  }

 else goto default_grid4;
}

/*--(fifth mode)------*/
if(mLT==5){ nd = 6;
 if(((atoi(t)-1)%3)==0)
  {
  default_grid5:
  gridfreqs[1]=gridfreqs[0]*etm2;
  gridfreqs[2]=gridfreqs[0]*etP4;
  gridfreqs[3]=gridfreqs[0]*etA4;
  gridfreqs[4]=gridfreqs[0]*etP5;
  gridfreqs[5]=gridfreqs[0]*etM7;
  goto generate;
  }
 else if(((atoi(t)-1)%3)==1)
  {
  gridfreqs[1]=gridfreqs[0]*etM3;
  gridfreqs[2]=gridfreqs[0]*etP4;
  gridfreqs[3]=gridfreqs[0]*etA4;
  gridfreqs[4]=gridfreqs[0]*etm7;
  gridfreqs[5]=gridfreqs[0]*etM7;
  goto generate;
  }
 else if(((atoi(t)-1)%4)==3)
  {
  gridfreqs[1]=gridfreqs[0]*etm2;
  gridfreqs[2]=gridfreqs[0]*etM2;
  gridfreqs[3]=gridfreqs[0]*etA4;
  gridfreqs[4]=gridfreqs[0]*etP5;
  gridfreqs[5]=gridfreqs[0]*etm6;
  goto generate;
  }
 else goto default_grid5;
}
/*--(sixth mode)------*/
if(mLT==6){ nd = 8;
 if(((atoi(t)-1)%4)==0)
  {
  default_grid6:
  gridfreqs[1]=gridfreqs[0]*etM2;
  gridfreqs[2]=gridfreqs[0]*etM3;
  gridfreqs[3]=gridfreqs[0]*etP4;
  gridfreqs[4]=gridfreqs[0]*etA4;
  gridfreqs[5]=gridfreqs[0]*etm6;
  gridfreqs[6]=gridfreqs[0]*etm7;
  gridfreqs[7]=gridfreqs[0]*etM7;
  goto generate;
  }
 else if(((atoi(t)-1)%4)==1)
  {
  gridfreqs[1]=gridfreqs[0]*etM2;
  gridfreqs[2]=gridfreqs[0]*etm3;
  gridfreqs[3]=gridfreqs[0]*etM3;
  gridfreqs[4]=gridfreqs[0]*etA4;
  gridfreqs[5]=gridfreqs[0]*etm6;
  gridfreqs[6]=gridfreqs[0]*etM6;
  gridfreqs[7]=gridfreqs[0]*etm7;
  goto generate;
  }
 else if(((atoi(t)-1)%4)==2)
  {
  gridfreqs[1]=gridfreqs[0]*etm2;
  gridfreqs[2]=gridfreqs[0]*etM2;
  gridfreqs[3]=gridfreqs[0]*etM3;
  gridfreqs[4]=gridfreqs[0]*etA4;
  gridfreqs[5]=gridfreqs[0]*etP5;
  gridfreqs[6]=gridfreqs[0]*etm6;
  gridfreqs[7]=gridfreqs[0]*etm7;
  goto generate;
  }
 else if(((atoi(t)-1)%4)==3)
  {
  gridfreqs[1]=gridfreqs[0]*etm2;
  gridfreqs[2]=gridfreqs[0]*etm3;
  gridfreqs[3]=gridfreqs[0]*etP4;
  gridfreqs[4]=gridfreqs[0]*etA4;
  gridfreqs[5]=gridfreqs[0]*etP5;
  gridfreqs[6]=gridfreqs[0]*etM6;
  gridfreqs[7]=gridfreqs[0]*etM7;
  goto generate;
  }
else goto default_grid6;
}


/*--(seventh mode)------*/
if(mLT==7){ nd = 10;
 if(((atoi(t)-1)%5)==0)
  {
  default_grid7:
  gridfreqs[1]=gridfreqs[0]*etm2;
  gridfreqs[2]=gridfreqs[0]*etM2;
  gridfreqs[3]=gridfreqs[0]*etm3;
  gridfreqs[4]=gridfreqs[0]*etP4;
  gridfreqs[5]=gridfreqs[0]*etA4;
  gridfreqs[6]=gridfreqs[0]*etP5;
  gridfreqs[7]=gridfreqs[0]*etm6;
  gridfreqs[8]=gridfreqs[0]*etM6;
  gridfreqs[9]=gridfreqs[0]*etM7;
  goto generate;
  }
 else if(((atoi(t)-1)%5)==1)
  {
  gridfreqs[1]=gridfreqs[0]*etm2;
  gridfreqs[2]=gridfreqs[0]*etM2;
  gridfreqs[3]=gridfreqs[0]*etM3;
  gridfreqs[4]=gridfreqs[0]*etP4;
  gridfreqs[5]=gridfreqs[0]*etA4;
  gridfreqs[6]=gridfreqs[0]*etP5;
  gridfreqs[7]=gridfreqs[0]*etm6;
  gridfreqs[8]=gridfreqs[0]*etm7;
  gridfreqs[9]=gridfreqs[0]*etM7;
  goto generate;
  }
 else if(((atoi(t)-1)%5)==2)
  {
  gridfreqs[1]=gridfreqs[0]*etm2;
  gridfreqs[2]=gridfreqs[0]*etm3;
  gridfreqs[3]=gridfreqs[0]*etM3;
  gridfreqs[4]=gridfreqs[0]*etP4;
  gridfreqs[5]=gridfreqs[0]*etA4;
  gridfreqs[6]=gridfreqs[0]*etP5;
  gridfreqs[7]=gridfreqs[0]*etM6;
  gridfreqs[8]=gridfreqs[0]*etm7;
  gridfreqs[9]=gridfreqs[0]*etM7;
  goto generate;
  }
 else if(((atoi(t)-1)%5)==3)
  {
  gridfreqs[1]=gridfreqs[0]*etM2;
  gridfreqs[2]=gridfreqs[0]*etm3;
  gridfreqs[3]=gridfreqs[0]*etM3;
  gridfreqs[4]=gridfreqs[0]*etP4;
  gridfreqs[5]=gridfreqs[0]*etA4;
  gridfreqs[6]=gridfreqs[0]*etm6;
  gridfreqs[7]=gridfreqs[0]*etM6;
  gridfreqs[8]=gridfreqs[0]*etm7;
  gridfreqs[9]=gridfreqs[0]*etM7;
  goto generate;
  }
 else if(((atoi(t)-1)%5)==4)
  {
  gridfreqs[1]=gridfreqs[0]*etm2;
  gridfreqs[2]=gridfreqs[0]*etM2;
  gridfreqs[3]=gridfreqs[0]*etm3;
  gridfreqs[4]=gridfreqs[0]*etM3;
  gridfreqs[5]=gridfreqs[0]*etA4;
  gridfreqs[6]=gridfreqs[0]*etP5;
  gridfreqs[7]=gridfreqs[0]*etm6;
  gridfreqs[8]=gridfreqs[0]*etM6;
  gridfreqs[9]=gridfreqs[0]*etm7;
  goto generate;
  }
  else goto default_grid7;
}
 generate:
 printf("pitch grid: limited transposition\n");
  for (i=nd; i<500; i++) {
    gridfreqs[i]=gridfreqs[i-nd]*2;
    numfreqs=i+1;
    if (gridfreqs[i]>23000) break;
    }
}

/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

void makealtd(w, client, call)
Widget w;
XtPointer client, call;
{
  char *valstring,s[10],t[10];
  float val;
  int i;
  float f;

  valstring=XmTextGetString(gridTextfield);
  strcpy(s,valstring);
  if(isdigit(s[0])) val = atof(valstring); else val = pitch2freq(s);

  XtFree(valstring);


  valstring=XmTextGetString(gridTextfield2);
  strcpy(t,valstring);
  XtFree(valstring);
  gridfreqs[0]=val;

if(((atoi(t)-1)%7)==0){
  default_grid:
  gridfreqs[1]=gridfreqs[0]*etm2;
  gridfreqs[2]=gridfreqs[0]*etm3;
  gridfreqs[3]=gridfreqs[0]*etM3;
  gridfreqs[4]=gridfreqs[0]*etA4;
  gridfreqs[5]=gridfreqs[0]*etm6;
  gridfreqs[6]=gridfreqs[0]*etm7;
  goto generate;
  }
else  if(((atoi(t)-1)%7)==1){
  gridfreqs[1]=gridfreqs[0]*etM2;
  gridfreqs[2]=gridfreqs[0]*etm3;
  gridfreqs[3]=gridfreqs[0]*etP4;
  gridfreqs[4]=gridfreqs[0]*etP5;
  gridfreqs[5]=gridfreqs[0]*etM6;
  gridfreqs[6]=gridfreqs[0]*etM7;
  goto generate;
  }
else  if(((atoi(t)-1)%7)==2){
  gridfreqs[1]=gridfreqs[0]*etm2;
  gridfreqs[2]=gridfreqs[0]*etm3;
  gridfreqs[3]=gridfreqs[0]*etP4;
  gridfreqs[4]=gridfreqs[0]*etP5;
  gridfreqs[5]=gridfreqs[0]*etM6;
  gridfreqs[6]=gridfreqs[0]*etm7;
  goto generate;
  }
else  if(((atoi(t)-1)%7)==3){
  gridfreqs[1]=gridfreqs[0]*etM2;
  gridfreqs[2]=gridfreqs[0]*etM3;
  gridfreqs[3]=gridfreqs[0]*etA4;
  gridfreqs[4]=gridfreqs[0]*etm6;
  gridfreqs[5]=gridfreqs[0]*etM6;
  gridfreqs[6]=gridfreqs[0]*etM7;
  goto generate;
  }
else  if(((atoi(t)-1)%7)==4){
  gridfreqs[1]=gridfreqs[0]*etM2;
  gridfreqs[2]=gridfreqs[0]*etM3;
  gridfreqs[3]=gridfreqs[0]*etA4;
  gridfreqs[4]=gridfreqs[0]*etP5;
  gridfreqs[5]=gridfreqs[0]*etM6;
  gridfreqs[6]=gridfreqs[0]*etm7;
  goto generate;
  }
else  if(((atoi(t)-1)%7)==5){
  gridfreqs[1]=gridfreqs[0]*etM2;
  gridfreqs[2]=gridfreqs[0]*etM3;
  gridfreqs[3]=gridfreqs[0]*etP4;
  gridfreqs[4]=gridfreqs[0]*etP5;
  gridfreqs[5]=gridfreqs[0]*etm6;
  gridfreqs[6]=gridfreqs[0]*etm7;
  goto generate;
  }
else  if(((atoi(t)-1)%7)==6){
  gridfreqs[1]=gridfreqs[0]*etM2;
  gridfreqs[2]=gridfreqs[0]*etm3;
  gridfreqs[3]=gridfreqs[0]*etP4;
  gridfreqs[4]=gridfreqs[0]*etA4;
  gridfreqs[5]=gridfreqs[0]*etm6;
  gridfreqs[6]=gridfreqs[0]*etm7;
  goto generate;
  }
else goto default_grid;
generate:
printf("pitch grid: altered\n");
  for (i=7; i<500; i++) {
    gridfreqs[i]=gridfreqs[i-7]*2;
    numfreqs=i+1;
    if (gridfreqs[i]>23000) break;
    }
}

/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

void makeharmseries(w, client, call)
Widget w;
XtPointer client, call;
{
  char *valstring,s[10];
  float val;
  int i,j,k;
  float f;

  valstring=XmTextGetString(gridTextfield);
  strcpy(s,valstring);
  if(isdigit(s[0])) val = atof(valstring); else val = pitch2freq(s);

  XtFree(valstring);
  printf("\npitch grid: ");

  gridfreqs[0]=val;
  numfreqs=1;
  if(mHS==1) {/*all*/
  printf("All harmonics\n");
  for (i=1; i<500; i++) {
    gridfreqs[i]=gridfreqs[i-1]+val;
    numfreqs=i+1;
    if (gridfreqs[i]>23000) goto theEnd;
    }
  }
  else if(mHS==2){
  gridfreqs[1]=2*val;    /*even*/  
  printf("Even harmonics\n");
  for (i=2; i<500; i++) {
    gridfreqs[i]=gridfreqs[i-1]+(2*val);
    numfreqs=i+1;
    if (gridfreqs[i]>23000) goto theEnd;
    }
  }
  else if(mHS==3){                  /*odd*/
  printf("Odd harmonics\n");
  for (i=1; i<500; i++) {
    gridfreqs[i]=gridfreqs[i-1]+(2*val);
    numfreqs=i+1;
    if (gridfreqs[i]>23000) goto theEnd;
    }
  }
  else if(mHS==4){
  printf("Prime harmonics\n");
  k = 1;
  for(i=2;i<20000;i++){
    for(j=2;j<=i;j++){/* printf("###%d\n",j);*/
        if((i%j==0)&&(j<i))goto nextNum4;
	if(i%j!=0)goto nextDen4;
	gridfreqs[k]=(float)val*(float)i;
	if(gridfreqs[k]>=23000.)goto theEnd;
	/*printf(">%d\t%d\t%f\n",k,i,gridfreqs[k]); */
	k++;
	numfreqs=k+1; break;
	nextDen4: ;
	}
    nextNum4: ;
    }
  }
  else if(mHS==5){
  printf("NonPrime harmonics\n");
  k = 1;
  for(i=2;i<20000;i++){
    for(j=2;j<=i;j++){/* printf("###%d\n",j);*/
        if((i%j==0)&&(j<i)){
		gridfreqs[k-1]=(float)val*(float)i;
		if(gridfreqs[k-1]>=23000.)goto theEnd;
		k++; numfreqs=k;
		goto NextNum5;
		}
	if(i%j!=0)goto nextnDen5;
	if(j==i) break;
	nextnDen5: ;
	}
    NextNum5: ;
    }
  }



theEnd: 
   
   
      printf("Number of grid Frequencies: %d\n", numfreqs);
/*
      for(j=0;j<numfreqs;j++)printf("Freq # %d :\t%f (Hertz)\n",j,gridfreqs[j]);
*/      
    
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void makeuser(w, client, call)
Widget w;
XtPointer client, call;
{
 int i, nd = 0;
 char *valstring, s[10];
 float val;

  valstring=XmTextGetString(gridTextfield);
  strcpy(s,valstring);
  if(isdigit(s[0])) val = atof(valstring); else val = pitch2freq(s);

  XtFree(valstring);


 i=0;
 if(XmToggleButtonGetState(_1)){ gridfreqs[i]=val;i++;}
 if(XmToggleButtonGetState(_m2)){ gridfreqs[i]=val*etm2;i++;}
 if(XmToggleButtonGetState(_M2)){ gridfreqs[i]=val*etM2;i++;}
 if(XmToggleButtonGetState(_m3)){ gridfreqs[i]=val*etm3;i++;}
 if(XmToggleButtonGetState(_M3)){ gridfreqs[i]=val*etM3;i++;}
 if(XmToggleButtonGetState(_p4)){ gridfreqs[i]=val*etP4;i++;}
 if(XmToggleButtonGetState(_A4)){ gridfreqs[i]=val*etA4;i++;}
 if(XmToggleButtonGetState(_p5)){ gridfreqs[i]=val*etP5;i++;}
 if(XmToggleButtonGetState(_m6)){ gridfreqs[i]=val*etm6;i++;}
 if(XmToggleButtonGetState(_M6)){ gridfreqs[i]=val*etM6;i++;}
 if(XmToggleButtonGetState(_m7)){ gridfreqs[i]=val*etm7;i++;}
 if(XmToggleButtonGetState(_M7)){ gridfreqs[i]=val*etM7;i++;}
 nd=i;
   for (i=nd; i<500; i++) {
    gridfreqs[i]=gridfreqs[i-nd]*2;
    numfreqs=i+1;
    if (gridfreqs[i]>23000) break;
    }
 printf("pitch grid: User mode\n");
}

/*__________________TRANSFORM CALLBACKS________________________________*/
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

void Sieve(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(sieveForm);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void SieveOk(w, client, call)
Widget w;
XtPointer client, call;
{
  int numparint, i, j, k, maxnum=1;
  long point;
  float *temp_amp, max, m, mult_pr_horiz, numpar, sievew, rscale;
  char *valstring;
  Boolean ampsel, funcsel;
  Boolean neg;
  int art1,art2,arf1,arf2;
  /***************************************/
  int st[2];
  float art;
  XmString text,text1;
  /***************************************/
  areafind(&art1,&art2,&arf1,&arf2);
  printf("%d\t%d\t%d\t%d\n", art1,art2,arf1,arf2);

 
  XmUpdateDisplay(w);
  SetWatchCursor(topLevel);

  fvec(temp_amp,numchannels);

  valstring=XmTextGetString(sieveTextfield);
  numparint=atoi(valstring); numpar=(float)numparint;
  XtFree(valstring);
  valstring=XmTextGetString(sieveTextfield2);
  mult_pr_horiz=pow(atof(valstring),duration/horiz_num);
  XtFree(valstring);
  valstring=XmTextGetString(sieveTextfield3);
  sievew=atof(valstring);   /*h-f  boost*/
  XtFree(valstring);
  ampsel=XmToggleButtonGetState(sieveToggle1);
  funcsel=XmToggleButtonGetState(sieveToggle3);
  neg = XmToggleButtonGetState(sieveToggle4);
  funcpt=1;
  rscale=(float)(arf2-arf1)/RAND_MAX;
 
/*******************************************************/
 art = 100./(float)(art2-art1);
 st[0]=-1;st[1]=0; 
if(update=XmToggleButtonGetState(displayToggleUpdate)){
 text= XmStringCreateLocalized("Sieve...");
 text1=XmStringCreateLocalized("Processing...");
 XtVaSetValues(progressBox,XmNdialogTitle,text,
		 XmNmessageString,text1,NULL,NULL);
 XtVaSetValues(progressBar, XmNvalue, 0, NULL);
 XtManageChild(progressBox);
  while (XtAppPending(app_context)) {
     XtAppProcessEvent(app_context,XtIMXEvent|XtIMTimer|XtIMAlternateInput);
  }
}
/*******************************************************/
  point=art1*numchannels;
  for (i=art1; i<art2; i++) {
/*intermediate updates don'freeze the app while working*/
if(update){
  st[1]=(int)(art*(i-art1));
  if(st[1]!=st[0]){
	XtVaSetValues(progressBar, XmNvalue, st[1], NULL);
        /*XmUpdateDisplay(topLevel);*/
	st[0]=st[1];
  	}
      XSync(XtDisplay(progressBox),0);
      XmUpdateDisplay(topLevel);
      }
/*******************************************************/

 
      if (funcsel) numparint=(int)getfuncval(i);     /*No. of partials*/
                                                     /*temp_amp re-initialization*/
      if(neg)   for (j=0; j<numchannels; j++) temp_amp[j]=megamp[point+j];
      if(!neg)  for (j=0; j<numchannels; j++) temp_amp[j]=0.;

      for (k=0; k<numparint; k++) {                  /*search for:   */
        max=0.;
        if (ampsel) for (j=arf1; j<arf2; j++)        /*loudest bins  */
	   {
	   if ((m = megamp[point+j]*(1.+sievew*j))>=max)
		 {
		  max=m;
                  maxnum=j;
           	 }
           }
        else do { maxnum=(int)((float)rand()*rscale)+arf1; } /*or choose random*/
          while (megamp[point+maxnum]==-1);

        if(!neg) temp_amp[maxnum]=megamp[point+maxnum];
	if( neg) temp_amp[maxnum]=0.;
        megamp[point+maxnum]=-1.;
      }

      for (j=arf1; j<arf2; j++) megamp[point+j]=temp_amp[j];
      point+=numchannels;
      if (!funcsel) { numpar*=mult_pr_horiz; numparint=(int)(floor(numpar));}
      if ((!ampsel) && (numparint>numchannels-10)) numparint=numchannels-10;
      
  }
/****************************************/  
if(update) XtUnmanageChild(progressBox);
  XmStringFree(text);XmStringFree(text1);
/****************************************/
  free(temp_amp);
  RedrawAll();
  ResetCursor(topLevel);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void Sshift(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(sshiftForm);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void SshiftOk(w, client, call)
Widget w;
XtPointer client, call;
{
/*add update*/
  char *valstring;
  int i, j,size;
  long point;
  float shval, shval2, shval3,mult_pr_horiz,maxamp;
  float /**avgamp,*/*spectamp;
  Boolean funcsel,funcsel2,funcsel3;
  int art1,art2,arf1,arf2;
  areafind(&art1,&art2,&arf1,&arf2);
 /* printf("##%d  %d  %d  %d\n",art1,art2,arf1,arf2);*/
  valstring=XmTextGetString(sshiftTextfield);
  shval=atof(valstring);
  XtFree(valstring);
  valstring=XmTextGetString(sshiftTextfield2);
  mult_pr_horiz=pow(atof(valstring),duration/horiz_num);
  XtFree(valstring);
  funcsel=XmToggleButtonGetState(sshiftToggle1);
  funcpt=1;
  funcsel2=XmToggleButtonGetState(sshiftToggle2);
  funcpt2=1;
  funcsel3=XmToggleButtonGetState(sshiftToggle3);
  funcpt3=numsquare3;


  XmUpdateDisplay(w);
  SetWatchCursor(topLevel);

if(funcsel2){
	amptrack(art1,art2,arf1,arf2); maxamp = 0.;
	for(i=art1; i<art2; i++){
		if(avgamp[i]>maxamp)maxamp=avgamp[i];
/*
printf("%d\t%f\t%f\t",i,avgamp[i],maxamp);
printf("\n");
*/
	  }
	}
/*allocate the 'spcetral amplitude' array and fill it with function3
    interpolated values, which conrol frequency deviation */
if(funcsel3){
	size=numchannels+1;
	fvec(spectamp, size);
	for(j=0;j<numchannels;j++){spectamp[j]=400.-getfuncval3(j);
		if(spectamp[j]<0.)spectamp[j]=0.;
/*printf("###%d\t%f\n",j,spectamp[j]);*/ }
	}

  point=art1*numchannels;
  for (i=art1; i<art2; i++) {
	  
      if (funcsel) shval2=shval*(getfuncval(i)/(float)(N/2));
        else shval2=shval;
/*if (funcsel)printf("%d\t%f\t%f\n",i, getfuncval(i),shval2);  */
      if (funcsel2){
		if((getfuncval2(i)/(float)(N/2)*maxamp)>avgamp[i])
			shval2=0.;
		else shval2*=(avgamp[i]/maxamp-(getfuncval2(i)/(float)(N/2)));
/*if (funcsel2)printf("%d\t%f\t%f\n",i, getfuncval2(i),shval2);  */
                 }
      for (j=arf1; j<arf2; j++) {
        if (funcsel3)shval3=shval2*(spectamp[j]/400.);
	    else shval3=shval2;
      megfreq[point+j]+=shval3;
        if (megfreq[point+j]<20.) megamp[point+j]*=megfreq[point+j]/20.;
      }
      point+=numchannels;
      shval*=mult_pr_horiz;
  }

if(funcsel3)free(spectamp);

  rightbins();
  RedrawAll();

  ResetCursor(topLevel);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void Sshape(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(sshapeForm);
}

void SshapeOk(w, client, call)
Widget w;
XtPointer client, call;
{
  float *h,*s,*d;
  float val, temp;
  long point;
  Boolean funcsel3,funcsel2,funcsel;
  int i, j, art1, art2, arf1, arf2;
  /***************************************/
  int st[2];
  float arf;
  XmString text,text1;
  /***************************************/
 areafind(&art1,&art2,&arf1,&arf2);


  funcsel3= XmToggleButtonGetState(sshapeToggle);
  funcsel = XmToggleButtonGetState(sshapeToggle2);
  funcsel2= XmToggleButtonGetState(sshapeToggle3);
  funcpt3= numsquare3;
  funcpt=1; funcpt2=1;
  point=art1*numchannels;
  SetWatchCursor(topLevel);

if(!funcsel3){
   printf("Error: no control selected\n");
   RedrawWin();
   ResetCursor(topLevel);
   return;
}

fvec(d,horiz_num);
if(funcsel2)for(i=0;i<horiz_num;i++){
	d[i]=2.*getfuncval2(i)/(float)(N/2);
	/*printf("dynamics = %f\n",d[i]);*/
	}
else{for(i=0;i<horiz_num;i++)d[i]=1.;/*printf("dynamics = %f\n",d[i]);*/}

if(funcsel3){ fvec(h,numchannels); fvec(s,numchannels);
	for (j=arf1; j<arf2; j++){h[j]=(400.-getfuncval3(j))/100000000.;
	/*if(h[j]<0.)h[j]=0.;printf("%d\t%f\n",j,h[j]);  */
	}
     }
 
/*compute RMS spectrum*/
for(j = arf1; j<arf2; j++){
    for(i = art1; i < art2; i++){
	/*
	if(j>=numchannels-2)
	printf("#%d\t%ld\t%f\n", j,point+j+numchannels*(i-art1),\
	megamp[point+j+numchannels*(i-art1)]);
         */
         temp = .5*megamp[point+j+numchannels*(i-art1)]; temp*=temp;
         s[j]+= temp;
	 }
        s[j]=sqrt(s[j])/sqrt(art2-art1); if(s[j]==0.)s[j]=pow(10., -10.);
	/*if(j>=numchannels-2)printf("#%d\t%f\n", j,s[j]); */
	/*if(avgspect[j]>max)max=avgspect[j];*/
    }
val = 1.;

  /*******************************************************/
 if(update=XmToggleButtonGetState(displayToggleUpdate)){
 arf = 100./(float)(arf2-arf1);
 st[0]=-1;st[1]=0;
 text= XmStringCreateLocalized("Shape...");
 text1=XmStringCreateLocalized("Processing..."); 
 XtVaSetValues(progressBox,XmNdialogTitle,text,
		 XmNmessageString,text1,NULL,NULL);
 XtVaSetValues(progressBar, XmNvalue, 0, NULL);
 XtManageChild(progressBox);
  while (XtAppPending(app_context)) {
     XtAppProcessEvent(app_context,XtIMXEvent|XtIMTimer|XtIMAlternateInput);
     }
     XtVaSetValues(progressBar, XmNvalue, st[1], NULL);
 }
  /*******************************************************/


for(j = arf1; j<arf2; j++){funcpt=1;
	
  /*intermediate updates don'freeze the app while working*/
  if(update){
  st[1]=(int)(arf*(j-arf1));
  if(st[1]!=st[0]){
	XtVaSetValues(progressBar, XmNvalue, st[1], NULL);
        /*XmUpdateDisplay(topLevel);*/
	st[0]=st[1];
  	}
      XSync(XtDisplay(progressBox),0);
      XmUpdateDisplay(topLevel);
      }
  /*******************************************************/

    for(i = art1; i < art2; i++){
         temp = megamp[point+j+numchannels*(i-art1)]/s[j];
	/*
	if(j>=numchannels-2)
	printf("$%f\t%d\t%f\t%f\n",megamp[point+j+numchannels*(i-art1)],j,s[j],temp);
	*/
	 if(funcsel){val = getfuncval(i)/(float)(N/2);if(val<0.)val=0.;}
	/*
	   printf("**%ld\t", point+j+numchannels*(i-art1));
           printf("%f\n",megamp[ point+j+numchannels*(i-art1)]);
	*/
#ifdef SGI
         megamp[point+j+numchannels*(i-art1)] = val*powf(temp,d[i])*h[j]+\
	   (1.-val)*megamp[point+j+numchannels*(i-art1)];
#else
         megamp[point+j+numchannels*(i-art1)] = val*pow(temp,d[i])*h[j]+\
	   (1.-val)*megamp[point+j+numchannels*(i-art1)];
#endif
	/*printf("%f\n",megamp[ point+j+numchannels*(i-art1)]); */
	}
    }
  printf(">Spectrum Shape\n");
  if((funcsel3)&&(h!=NULL)&&(s!=NULL)){free(h);h=NULL;free(s);s=NULL;}
  free(d);
  /****************************************/
  if(update){
    XtUnmanageChild(progressBox);
    XmStringFree(text);XmStringFree(text1);
    }
  /****************************************/
  amptrack(art1,art2,arf1,arf2);
  RedrawAll();
  ResetCursor(topLevel);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
/* BLUR: Concept and the magnificent recursion algorithm 
 * stolen from the program Ceres, v. 0.13. Code rewritten
 * for improved functionallity and musicality of use
 */

void Blur(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(blurForm);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

void BlurOk(w, client, call)
Widget w;
XtPointer client, call;
{
  char *valstring;
  int i, j, p, stepn;
  long t;
  float blurval, blurval2, *blurvalarray, *h,
  	mult_pr_horiz, ya, yf, step;
  Boolean funcsel, funcsel3;

 int art1,art2,arf1,arf2;
  /***************************************/
  int st[2];
  float arf;
  XmString text,text1;
  /***************************************/

if(megfreq==NULL || megamp==NULL){
	printf("Nothing to process\n");
	goto empty;
    }

 areafind(&art1,&art2,&arf1,&arf2);

  valstring=XmTextGetString(blurTextfield1);
  blurval2=atof(valstring);
  XtFree(valstring);
  valstring=XmTextGetString(blurTextfield2);
  mult_pr_horiz=pow(atof(valstring),duration/horiz_num);
  XtFree(valstring);
  valstring=XmTextGetString(blurTextfield3);
  step=atof(valstring); if (step==0.) step=1e-9;
  stepn=(int)((R/(float)D)/step);
  XtFree(valstring);
  funcsel = XmToggleButtonGetState(blurToggle1);
  funcsel3= XmToggleButtonGetState(blurToggle3);
  
  XmUpdateDisplay(w);
  SetWatchCursor(topLevel);
  
  funcpt=1; funcpt3=numsquare3;
  
  if(funcsel){fvec(blurvalarray, horiz_num+1);
	  for(i=0;i<horiz_num;i++){
	    blurvalarray[i]=getfuncval(i)/(float)(N/4) - 1.;
	    if(blurvalarray[i]>.999)blurvalarray[i]=.999;
	    if(blurvalarray[i]<-.999)blurvalarray[i]=-.999;
	    /*printf("Blur = %f\n",blurvalarray[i]);*/
	    }
	    }
if(funcsel3){ fvec(h,numchannels+1);
	for (j=0; j<numchannels; j++){h[j]=(400.-getfuncval3(j))/400.;
	    if(h[j]<=0.)h[j]=1e-9;
	/*printf("%d\t%f\n",j,h[j]);*/}
        }

  /*******************************************************/
 if(update=XmToggleButtonGetState(displayToggleUpdate)){
 arf = 100./(float)(arf2-arf1);
 st[0]=-1;st[1]=0;
 text= XmStringCreateLocalized("Blur...");
 text1=XmStringCreateLocalized("Processing...");
 XtVaSetValues(progressBox,XmNdialogTitle,text,
		 XmNmessageString,text1,NULL,NULL);
 XtVaSetValues(progressBar, XmNvalue, 0, NULL);
 XtManageChild(progressBox);
  while (XtAppPending(app_context)) {
     XtAppProcessEvent(app_context,XtIMXEvent|XtIMTimer|XtIMAlternateInput);
     }
     XtVaSetValues(progressBar, XmNvalue, st[1], NULL);
 }
  /*******************************************************/



    for (j=arf1; j<arf2; j++) {
	    
  /*intermediate updates don'freeze the app while working*/
  if(update){
  st[1]=(int)(arf*(j-arf1));
  if(st[1]!=st[0]){
	XtVaSetValues(progressBar, XmNvalue, st[1], NULL);
        /*XmUpdateDisplay(topLevel);*/
	st[0]=st[1];
  	}
      XSync(XtDisplay(progressBox),0);
      XmUpdateDisplay(topLevel);
      }
  /*******************************************************/
	    
      t=0;
      blurval = (funcsel ? blurvalarray[art1] : blurval2);
      if(funcsel3)blurval*=h[j];
      
      if (blurval>0.) for (i=art1; i<art2; i++) {
        p=i*numchannels+j;
        if (funcsel) blurval=blurvalarray[i]*(funcsel3?h[j]:1.);
        if (blurval>1.0) blurval=1.0;if (blurval<-1.0) blurval=-1.0;
        if (t%stepn==0) {
          ya=megamp[p]; yf=megfreq[p];
          } 
	  else {
	  if(blurval>0.){
          	ya=blurval*ya+(1.-blurval)*megamp[p]; megamp[p]=ya;
          	yf=blurval*yf+(1.-blurval)*megfreq[p]; megfreq[p]=yf;
	  	}
	  if(blurval<0.){
		ya=blurval*ya+(1.+blurval)*megamp[p]; megamp[p]=ya;
	  	}
          }
      blurval*=mult_pr_horiz; t++;
      } 
      else for (i=art1+1; i<art2; i++) {
        p=i*numchannels+j;
        if (funcsel) blurval=blurvalarray[i]*(funcsel3?h[j]:1.);
        if (blurval<-1.0) blurval=-1.0;if (blurval>1.0) blurval=1.0;
        if (t%stepn==0) {
          ya=megamp[p]; yf=megfreq[p];
          } 
	else {
	if(blurval<0.){
        	ya=blurval*ya+(1.+blurval)*megamp[p]; megamp[p]=ya;
		}
	  if(blurval>0.){
          	ya=blurval*ya+(1.-blurval)*megamp[p]; megamp[p]=ya;
          	yf=blurval*yf+(1.-blurval)*megfreq[p]; megfreq[p]=yf;
	  	}	
          }
      blurval*=mult_pr_horiz; t++;
      }
    }
  
  if(funcsel)free(blurvalarray);
  if(funcsel3)free(h);
  
  /****************************************/
  if(update){XtUnmanageChild(progressBox);
    XmStringFree(text); XmStringFree(text1);
    }
  /****************************************/
  
  rightbins();
  RedrawAll();

  ResetCursor(topLevel);
  empty: ;
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void Comb(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(combForm);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

void CombOk(w, client, call)
Widget w;
XtPointer client, call;
{
/*add update*/
  char *valstring,s[10];
  long point=0;
  int i, j, bin, basebin;
  float combval, combval2, mult_pr_horiz, comb_depth;
  Boolean funcsel;
  Boolean funcsel2;
  Boolean negative;
 int art1,art2,arf1,arf2;
 areafind(&art1,&art2,&arf1,&arf2);

  /*printf("\nbinfreq from CombOk = %f\n", binfreq);  */

  valstring=XmTextGetString(combTextfield1);
  strcpy(s,valstring);
  if(isdigit(s[0])) combval2 = atof(valstring); else combval2 = pitch2freq(s);

  /*combval2=atof(valstring);*/
  XtFree(valstring);

  valstring=XmTextGetString(combTextfield2);
  mult_pr_horiz=pow(atof(valstring),duration/horiz_num);
  XtFree(valstring);

  valstring=XmTextGetString(combTextfield3);
  comb_depth=atof(valstring);
  XtFree(valstring);

  funcsel=XmToggleButtonGetState(combToggle1);
  funcsel2=XmToggleButtonGetState(combToggle2);
/*funcpt=1;*/
  negative=XmToggleButtonGetState(combToggleInv);/*replace with proper statement*/

  XmUpdateDisplay(w);
  SetWatchCursor(topLevel);




    point=arf1 + art1*numchannels;
    funcpt=1; funcpt2 = 1; combval=combval2;


    for (i=art1; i<art2; i++) {
/*	printf("\t%d\t%d\t%d",art1, art2, i);          */
      if (funcsel) combval=1000.*getfuncval(i)/(float)(N/2);
      if (funcsel2) comb_depth=getfuncval2(i)/(float)(N/2);
/*printf("%f\n",comb_depth); */

      for (j=arf1; j<arf2; j++) {
        basebin=(int)(combval/binfreq+0.5);
        if (basebin>=numchannels) basebin=numchannels-1;
        if (basebin) {
          if(!negative)
            if (j%basebin)  megamp[point]*=(1.-comb_depth);
          if(negative)
	    if(j%basebin==0)megamp[point]*=(1.-comb_depth);
        }

        combval*=mult_pr_horiz; point++;
/*printf("\t%ld\n", point); */
      }
	point+=numchannels - arf2 + arf1;
/*	printf("\t%d\t%d\t%d\n",arf1, arf2, j);         */
    }



  RedrawAll();
  ResetCursor(topLevel);
}

/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

void Reson(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(resForm);
}

/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void ResonOk(w, client, call)
Widget w;
XtPointer client, call;
{
char *valstring, s[10];
float resval,resval2,resgain,*resvalarray, *h, mult_pr_horiz, ya, yf, step;
long p;
Boolean funcsel, funcsel3;
int art1,art2,arf1,arf2, size, i, j, k, stepn,t;
double integer;
  /***************************************/
  int st[2];
  float arf;
  XmString text,text1;
  /***************************************/
 areafind(&art1,&art2,&arf1,&arf2);

    if(XmToggleButtonGetState(gridTogglePreset)){
    if (XmToggleButtonGetState(gridTogglePenta)) makepenta(w, client, call);
    else if (XmToggleButtonGetState(gridToggleMajor)) makemajor(w, client, call);
    else if (XmToggleButtonGetState(gridToggleMinor)) makeminor(w, client, call);
    else if (XmToggleButtonGetState(gridToggleMLT)) makeMLT(w, client, call);
    else if (XmToggleButtonGetState(gridToggleAltd)) makealtd(w, client, call);
    else if (XmToggleButtonGetState(gridToggleHarm)) makeharmseries(w, client, call);
    }
    else if(XmToggleButtonGetState(gridToggleUser)){
	printf("User-defined grid\n");
        makeuser(w,client,call);
	}
   /* else PGFreqfile(w, client, call);*/
   /* else XtManageChild(gridForm); */

 /* printf("Grid OK\n");*/

  valstring=XmTextGetString(resTextfield1);
  resval2=atof(valstring);
  XtFree(valstring);
  valstring=XmTextGetString(resTextfield2);
  mult_pr_horiz=pow(atof(valstring),duration/horiz_num);
  XtFree(valstring);
  valstring=XmTextGetString(resTextfield3);
  step=atof(valstring); if (step==0.) step=1e-9;
  stepn=(int)((R/(float)D)/step);
  XtFree(valstring);
  valstring=XmTextGetString(resTextfield4);
  resgain=atof(valstring); if (resgain<1.) resgain=1.;
  XtFree(valstring);
  funcsel = XmToggleButtonGetState(resToggle1);

  funcsel3= XmToggleButtonGetState(resToggle3);
 
  funcpt = 1; funcpt3 =  numsquare3;

  XmUpdateDisplay(w);
  SetWatchCursor(topLevel);

  if(funcsel){fvec(resvalarray, horiz_num+1);
	  printf("CF 1\n");
	  for(i=0;i<horiz_num;i++){
	    resvalarray[i]=getfuncval(i)/(float)(N/2);
	    if(resvalarray[i]>.999)resvalarray[i]=.999;
	    if(resvalarray[i]<.0)resvalarray[i]=1e-9;
	    /*printf("Resonance = %f\n",resvalarray[i]);*/
	    }
	    }

 if(funcsel3){ fvec(h,numchannels+1);
	for (j=0; j<numchannels; j++){h[j]=(400.-getfuncval3(j))/400.;
	    if(h[j]<=0.)h[j]=1e-9;
	/*printf("Scaler %d\t%f\n",j,h[j]);*/}
        }

 /*printf("Valarray OK\n");*/

 p = (long)numchannels*art1; k = 0;

 /*******************************************************/
 if(update=XmToggleButtonGetState(displayToggleUpdate)){
 arf = 100./(float)(arf2-arf1);
 st[0]=-1;st[1]=0;
 text= XmStringCreateLocalized("Resonant...");
 text1=XmStringCreateLocalized("...Filtering...");
 XtVaSetValues(progressBox,XmNdialogTitle,text,
		 XmNmessageString,text1,NULL,NULL);
 XtVaSetValues(progressBar, XmNvalue, 0, NULL);
 XtManageChild(progressBox);
  while (XtAppPending(app_context)) {
     XtAppProcessEvent(app_context,XtIMXEvent|XtIMTimer|XtIMAlternateInput);
     }
     XtVaSetValues(progressBar, XmNvalue, st[1], NULL);
 }
  /**********************************************************/

 for(j=arf1;j < arf2; j++){

  /****intermediate updates don'freeze the app while working*/
  if(update){
  st[1]=(int)(arf*(j-arf1));
  if(st[1]!=st[0]){
	XtVaSetValues(progressBar, XmNvalue, st[1], NULL);
        /*XmUpdateDisplay(topLevel);*/
	st[0]=st[1];
  	}
      XSync(XtDisplay(progressBox),0);
      XmUpdateDisplay(topLevel);
      }
  /**********************************************************/

      p=art1*numchannels+j;      
      t=0;
      /*printf("%d\n",j);*/
      while(gridfreqs[k]<megfreq[p])k++;
      resval = (funcsel ? resvalarray[art1] : resval2);

     if( fabs(megfreq[p]-.5*binfreq-gridfreqs[k]) < binfreq ){
	/*printf("%d\t%f\n",k,gridfreqs[k]);*/
     for ( i = art1; i <art2; i++){
         p=i*numchannels+j;
	 if (funcsel) resval=resvalarray[i];        
	 if (t%stepn==0) {
           ya=megamp[p]; yf=megfreq[p];
           } 
	   else{
          	ya=resval*ya+(1.-resval)*megamp[p]; megamp[p]=ya*resgain;
			if(funcsel3) megamp[p]*=h[j];
          	yf=resval*yf+(1.-resval)*megfreq[p]; megfreq[p]=yf;
		}
	 resval*=mult_pr_horiz; t++;
	 } 
       k++;if(k>numfreqs)goto finish;
       }
     }
  
  finish:
  if(funcsel)free(resvalarray); 
  if(funcsel3)free(h);

  /****************************************/
  if(update){XtUnmanageChild(progressBox);
    XmStringFree(text); XmStringFree(text1);
    }
  /****************************************/

  rightbins();
  RedrawAll();

  ResetCursor(topLevel);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

void Source(w, client, call)
Widget w;
XtPointer client, call;
{

  XtManageChild(sourceForm);
;
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

void SourceOk(w, client, call)
Widget w;
XtPointer client, call;
{
/*add update*/
Boolean funcsel, funcsel2, funcsel3, loopback;
long point;
int siz;
register int i,k,l;
register long j,q;
float *amparray, *phasarray, *valarray, *valarray2, dur,v;
char *valstring,s[10],ffilname[200],*text, test[100], comm[100];
FILE *filtfile;
 int art1,art2,arf1,arf2;
 areafind(&art1,&art2,&arf1,&arf2);


  strcpy(ffilname,"./");	  
  text=XmTextGetString(sourceTextfield);
  strcat(ffilname,text);
  printf("%s\n",ffilname);

if((megfreq==NULL)||(megamp==NULL)){
	printf("No source to be filtered by %s\n", ffilname);
    return;
	}

strcpy(test, ffilname);
l=strlen(test);
if(test[l-1]=='/'){
    XtManageChild(fileWarning);
    XtFree(text);
    return;
    }  
filtfile=fopen(ffilname, "r");
  if (filtfile==NULL) {
    XtManageChild(fileWarning);
    XtFree(text);
    return;
  }
  SetWatchCursor(topLevel);
  XtFree(text);
  printf("Source Filter:\n");

if(funcsel=XmToggleButtonGetState(sourceToggle)){fvec(valarray,horiz_num);
	for(i = 0; i < horiz_num; i++){
		valarray[i]=getfuncval(i)/(float)(N/2);
 /*       printf("%d\t%f\n", i, valarray[i]);*/
		}
		}
if(funcsel2=XmToggleButtonGetState(sourceToggle2)){fvec(valarray2,horiz_num);
	for(i = 0; i < horiz_num; i++){
		valarray2[i]=getfuncval2(i)/(float)(N/2);
		}
		}
funcpt =1; funcpt2 = 1;
loopback = XmToggleButtonGetState(sourceToggle4);
fscanf(filtfile, "%s", comm); dur = atof(comm);
fscanf(filtfile, "%s", comm); siz = atoi(comm)-1;
printf("%d\n",siz);
if(!((siz==128)||(siz==256)||(siz==512)||(siz==1024)||(siz==2048)||\
   (siz==4096)||(siz==8192)||(siz==16384))){printf("Not a valid fft-file\n");
   goto end;}
if(siz!=N2) {printf("FFT size error: Source must be of same\
fft size (%d)\n",siz); 
   goto end;}
printf("FFT file: %s\nFFT size = %d\n", test,2*(siz));/*this looks strange*/
printf("Number of allowed bands: %d\n",numchannels);

printf("Interpolation method: ");
if(mSI==0)printf("arithmetic\n");
if(mSI==1)printf("geometric\n");
if(mSI==2)printf("harmonic\n");
/*XSync(XtDisplay(progressBox),0);*/


fvec(amparray,numchannels);fvec(phasarray,numchannels);
printf("Memory allocated\n");
point = 0; i = 0; j = 0; q = 0;

rewind(filtfile);

XmUpdateDisplay(topLevel) ;
/*code for arithmetic interpolation*/
if(mSI==0)
for(i=0;i<art2;i++){
    loop:
	for(k = 0; k < 4; k++){
	fscanf(filtfile, "%s", comm); 
	if (feof(filtfile)) {printf("EOF\n");
		if(loopback) {rewind(filtfile); goto loop ;}  
			goto finish;}
	}
	if(i>=art1)for(k = 0; k < siz; k++){
	fscanf(filtfile,"%f", &amparray[k]);if(feof(filtfile)) {
		printf("EOF\n");goto finish;}
	fscanf(filtfile,"%f",&phasarray[k]);if (feof(filtfile)){
		printf("EOF\n");goto finish;}
	if(k>=arf1&&k<arf2){
		if(funcsel )megamp[point+k]=valarray[i]*amparray[k]/2.e5
			+megamp[point+k]*(1.-valarray[i]);
		if(funcsel2)megfreq[point+k]=valarray2[i]*phasarray[k]
			+megfreq[point+k]*(1.-valarray2[i]);
		}
	}
	else for(k = 0; k < 2*siz; k++)fscanf(filtfile, "%s", comm);
point+=numchannels;
}

/*code for geometric interpolation*/
if(mSI==1)
for(i=0;i<art2;i++){
    loopg:
	for(k = 0; k < 4; k++){
	fscanf(filtfile, "%s", comm); 
	if (feof(filtfile)) {printf("EOF\n");
		if(loopback) {rewind(filtfile); goto loopg ;}  
			goto finish;}
	}
	if(i>=art1)for(k = 0; k <siz; k++){
	fscanf(filtfile,"%f", &amparray[k]);if(feof(filtfile)) {
		printf("EOF\n");goto finish;}
	fscanf(filtfile,"%f",&phasarray[k]);if (feof(filtfile)){
		printf("EOF\n");goto finish;}
	if(k>=arf1&&k<arf2){
#ifdef SGI
	if(funcsel ) megamp[point+k] =.64*powf((amparray[k]/2.e5),valarray[i])*
		powf(megamp[point+k],(1.-valarray[i]));
	if(funcsel2) megfreq[point+k] = powf(phasarray[k],valarray2[i])*
		powf(megfreq[point+k],(1.-valarray2[i]));
#else
	if(funcsel ) megamp[point+k] =.64*pow((amparray[k]/2.e5),valarray[i])*
		pow(megamp[point+k],(1.-valarray[i]));
	if(funcsel2) megfreq[point+k] = pow(phasarray[k],valarray2[i])*
		pow(megfreq[point+k],(1.-valarray2[i]));
#endif
		}
	}
	else for(k = 0; k < 2*siz; k++)fscanf(filtfile, "%s", comm);
point+=numchannels;
}

/*code for  harmonic interpolation*/
if(mSI==2)
for(i=0;i<art2;i++){
    looph:
	for(k = 0; k < 4; k++){
	fscanf(filtfile, "%s", comm); 
	if (feof(filtfile)) {printf("EOF\n");
		if(loopback) {rewind(filtfile); goto looph ;}  
			goto finish;}
	}
	if(i>=art1)for(k = 0; k < siz; k++){
	fscanf(filtfile,"%f", &amparray[k]);if(feof(filtfile)) {
		printf("EOF\n");goto finish;}
	fscanf(filtfile,"%f",&phasarray[k]);if (feof(filtfile)){
		printf("EOF\n");goto finish;}
	if(k>=arf1&&k<arf2){
	if(funcsel ){ v = valarray[i]/(amparray[k]/2.e5)+
		(1.-valarray[i])/megamp[point+k];
		megamp[point+k] = .7/v;
		}
	if(funcsel2){ v = valarray2[i]/phasarray[k]+
		(1.-valarray2[i])/megfreq[point+k];
		megfreq[point+k] = 1./v;
		}
	  }
	}
	else for(k = 0; k < 2*siz; k++)fscanf(filtfile, "%s", comm);
point+=numchannels;
}

  finish:
  if(funcsel) if(valarray  != NULL){free(valarray) ;/*valarray =NULL;*/}
  if(funcsel2)if(valarray2 != NULL){free(valarray2);/*valarray2=NULL;*/}
  if(amparray  !=NULL){free(amparray) ;/*amparray  = NULL;*/}
  if(phasarray !=NULL){free(phasarray);/*phasarray = NULL;*/}
	
  rightbins();
  RedrawAll();
  end:
  fclose(filtfile);
 
  ResetCursor(topLevel);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void Track(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(trackForm);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void TrackOk(w, client, call)
Widget w;
XtPointer client, call;
{
char *valstring, s[10];
float *fundamental,fraction,a,amp,stopgain,val,nf,pl,
	mult_pr_horiz, tempfreq, testsum;
long point;
Boolean funcsel2, fundarraysel,inv, rem, phase_lock = False, 
	plcf = False, quant = False;
int art1,art2,arf1,arf2, size, i, j;
double integer;
  /***************************************/
  int st[2];
  float art;
  XmString text,text1;
  /***************************************/
 areafind(&art1,&art2,&arf1,&arf2);

size = 1+art2-art1;

  valstring=XmTextGetString(trackTextfield);
  strcpy(s,valstring);
  if(isdigit(s[0])) val = atof(valstring); else val = pitch2freq(s);
   XtFree(valstring);

  valstring=XmTextGetString(trackTextfield3);
  nf = atof(valstring);
/*fool-proof*/
  nf=floor(nf); if(nf>16.)nf=16.;
  XtFree(valstring);

  valstring=XmTextGetString(trackTextfield1);
  a = atof(valstring);  if(a<0.)a=0.; if(a>.5)a=.5;

  funcsel2=XmToggleButtonGetState(trackToggle1);
  fundarraysel=XmToggleButtonGetState(trackToggle1a);
  funcpt2 = 1;
  XtFree(valstring);

  valstring=XmTextGetString(trackTextfield2);
  stopgain = atof(valstring);
  XtFree(valstring);
  
  valstring=XmTextGetString(trackTextfield4);
  mult_pr_horiz=pow(atof(valstring),duration/horiz_num);
  XtFree(valstring);

  phase_lock = XmToggleButtonGetState(trackTogglephase);
  inv	     = XmToggleButtonGetState(trackToggleinv);
  rem	     = XmToggleButtonGetState(trackToggle_rem);

if(fundarraysel)if(fundarray==NULL){
printf("Error: You have not extracted fundamental\n");
return;
}
/*---x*  fhat if fundarray contains no data?*/
testsum = 0.;
for(i=0;i<horiz_num;i++)testsum+=fundarray[i];
if(testsum < 1.){
    printf("Fundamental contains invalid or no data\n");
    printf("You should run fundamental estimation first\n");
    XtManageChild(fundWarning);
	goto cancel;
	}
XmUpdateDisplay(w);
SetWatchCursor(topLevel);


fvec(fundamental, size);
  /*******************************************************/
 if(update=XmToggleButtonGetState(displayToggleUpdate)){
 art = 100./(float)(art2-art1);
 st[0]=-1;st[1]=0;
 text= XmStringCreateLocalized("Tracking Filter");
 text1=XmStringCreateLocalized("Estimating...");
 XtVaSetValues(progressBox,XmNdialogTitle,text,
		 XmNmessageString, text1,NULL,NULL);
 XtVaSetValues(progressBar, XmNvalue, 0, NULL);
 XtManageChild(progressBox);
  while (XtAppPending(app_context)) {
     XtAppProcessEvent(app_context,XtIMXEvent|XtIMTimer|XtIMAlternateInput);
  }
}
  /*******************************************************/
/*fundamental estimation*/
if(!fundarraysel){


for(i=0;i<art2-art1;i++){
 /*intermediate updates don'freeze the app while working*/
  if(update){
  st[1]=(int)(art*(i-art1));
  if(st[1]!=st[0]){
	XtVaSetValues(progressBar, XmNvalue, st[1], NULL);
        /*XmUpdateDisplay(topLevel);*/
	st[0]=st[1];
  	}
      XSync(XtDisplay(progressBox),0);
      XmUpdateDisplay(topLevel);
      }
 /*******************************************************/

	if(funcsel2)fundamental[i]= binfreq*getfuncval2(art1+i);
	else fundamental[i]= val;
	if(fundamental[i]<binfreq/2.)fundamental[i]=binfreq/2.;
	/*printf("%d\t%f\n",art1+i, fundamental[i]);*/}
printf("\n");

  /*******************************************************/
 if(update){
 art = 100./(float)(art2-art1);
 st[0]=-1;st[1]=0;
 text1=XmStringCreateLocalized("Detecting...");
 XtVaSetValues(progressBox, XmNmessageString, text1,NULL,NULL);
 XtVaSetValues(progressBar, XmNvalue, 0, NULL);
}
  /*******************************************************/


/*fundamental detection (incl. amplit. modulation artifacts)*/
point = numchannels*art1;
for(i = art1; i<art2; i++){
	
 /*intermediate updates don'freeze the app while working*/
  if(update){
  st[1]=(int)(art*(i-art1));
  if(st[1]!=st[0]){
	XtVaSetValues(progressBar, XmNvalue, st[1], NULL);
        /*XmUpdateDisplay(topLevel);*/
	st[0]=st[1];
  	}
      XSync(XtDisplay(progressBox),0);
      XmUpdateDisplay(topLevel);
      }
 /*******************************************************/

    for(j=0;j<numchannels;j++)
    if(fabs(megfreq[point+j]-fundamental[i-art1])<=.5*binfreq){
	fundamental[i-art1] = megfreq[point+j]; amp = megamp[point+j];
	/*look for next uprward bin (increment j by 1)*/
	if(j<art2){
	/*inspect for amp, compare if > .707*fundamental_amp*/
	if(megamp[point+j+1]>.707*amp)
	/*inspect for freq, if less than halfbin apart and less than 1.1*fundamental[i-art1]*/
        if(megfreq[point+j+1]-fundamental[i-art1]<.5*binfreq)
	if(megfreq[point+j+1]/fundamental[i-art1]<1.1){
	/*if so, compute arithmetic mean (amplitude modulation) and update fundamental*/
		fundamental[i-art1]=0.5*(fundamental[i-art1]+megfreq[point+j+1]);		
	/*decrement j by 1*/
		j--;
		}
	}
         /* printf("%d\t%f\n",i, fundamental[i-art1]);*/
	 break;
	}
    point+=numchannels;
    }
}else for(i = 0; i < art2-art1; i++){fundamental[i]=fundarray[i+art1];
/*printf("%d\t%f\t%f\n", i, fundamental[i], fundarray[i+art1]);*/
 /*intermediate updates don'freeze the app while working*/
  if(update){
  st[1]=(int)(art*(i-art1));
  if(st[1]!=st[0]){
	XtVaSetValues(progressBar, XmNvalue, st[1], NULL);
        /*XmUpdateDisplay(topLevel);*/
	st[0]=st[1];
  	}
      XSync(XtDisplay(progressBox),0);
      XmUpdateDisplay(topLevel);
      }
 /*******************************************************/
}
point = numchannels*art1;

printf("Order of fundamental:\t%f\n",nf);

  /*******************************************************/
 if(update){
 art = 100./(float)(art2-art1);
 st[0]=-1;st[1]=0;
 text1= XmStringCreateLocalized("Filtering...");
 XtVaSetValues(progressBox,XmNmessageString,text1,NULL,NULL);
 XtVaSetValues(progressBar, XmNvalue, 0, NULL);
}
  /*******************************************************/


/*actual filtering*/
if(inv)
for(i = art1; i<art2; i++){
  /*intermediate updates don'freeze the app while working*/
  if(update){
  st[1]=(int)(art*(i-art1));
  if(st[1]!=st[0]){
	XtVaSetValues(progressBar, XmNvalue, st[1], NULL);
        /*XmUpdateDisplay(topLevel);*/
	st[0]=st[1];
  	}
      XSync(XtDisplay(progressBox),0);
      XmUpdateDisplay(topLevel);
      }
 /*******************************************************/	
    for(j=arf1;j<arf2;j++)
    if(megfreq[point+j]>(1.+a*a)*fundamental[i-art1]){
      if(modf(nf*megfreq[point+j]/fundamental[i-art1],&integer)<a)
	{if(phase_lock)
		megfreq[point+j]=fundamental[i-art1]*(float)integer/nf;
		megamp[point+j]*=stopgain;
		goto next1;
	}
      if(modf(nf*megfreq[point+j]/fundamental[i-art1],&integer)>1.-a)
        {if(phase_lock)
		megfreq[point+j]=fundamental[i-art1]*(float)(1+integer)/nf;
		megamp[point+j]*=stopgain;
		goto next1;
	}
	next1: ;
	}
    point+=numchannels;
    stopgain*=mult_pr_horiz;
    }
else for(i = art1; i<art2; i++){
 /*intermediate updates don'freeze the app while working*/
  if(update){
  st[1]=(int)(art*(i-art1));
  if(st[1]!=st[0]){
	XtVaSetValues(progressBar, XmNvalue, st[1], NULL);
        /*XmUpdateDisplay(topLevel);*/
	st[0]=st[1];
  	}
      XSync(XtDisplay(progressBox),0);
      XmUpdateDisplay(topLevel);
      }
 /*******************************************************/
    for(j=arf1;j<arf2;j++){
	if(rem)if(megfreq[point+j]<fundamental[i-art1])goto reject;
    	if(megfreq[point+j]>=(1.+a*a)*fundamental[i-art1]){
      	   if(modf(nf*megfreq[point+j]/fundamental[i-art1],&integer)<a)
		{if(phase_lock)
		   megfreq[point+j]=fundamental[i-art1]*(float)integer/nf;
		   goto next;
		}
      		if(modf(nf*megfreq[point+j]/fundamental[i-art1],&integer)>1.-a){
		   if(phase_lock)
			megfreq[point+j]=fundamental[i-art1]*(float)(1+integer)/nf;
			goto next;
		}
		reject:
		megamp[point+j]*=stopgain;
		next: ;
		}
	}
    point+=numchannels;
    stopgain*=mult_pr_horiz;
    }

 out:
 printf("Track-filtering...\n");
 /****************************************/
if(update){
  XtUnmanageChild(progressBox);
  XmStringFree(text);XmStringFree(text1);
  }
/****************************************/


free(fundamental);
  rightbins();
  RedrawAll();

ResetCursor(topLevel);
cancel:;
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
/*Algorithm from original Ceres modified to conform Ceres3 specific 
   AreaStrict processing and allow for controlled slope exponential growth   */

void Expo(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(expoForm);
}

void ExpoOk(w, client, call)
Widget w;
XtPointer client, call;
{
/*add update*/
  char *valstring;
  int i, j;
  long point;
  float val,f_val,*valarray,mult_pr_horiz, f, mul, slope;
  Boolean funcsel,strict;

 int art1,art2,arf1,arf2;
 areafind(&art1,&art2,&arf1,&arf2);


  strict = 0;
  valstring=XmTextGetString(expoTextfield);
  val=atof(valstring);
  XtFree(valstring);
  valstring=XmTextGetString(expoTextfield2);
  mult_pr_horiz=pow(atof(valstring),duration/horiz_num);
  XtFree(valstring);
  valstring=XmTextGetString(expoTextfield3);
  mul=atof(valstring);
  XtFree(valstring);
  valstring=XmTextGetString(expoTextfield4);
  slope=atof(valstring);
  XtFree(valstring);
  funcsel=XmToggleButtonGetState(expoToggle);
  funcpt = 1;
  strict = XmToggleButtonGetState(expoToggleStrict);

  XmUpdateDisplay(w);
  SetWatchCursor(topLevel);

if(funcsel){
  fvec(valarray,horiz_num+1);
  for(i=0;i<horiz_num;i++)valarray[i] = getfuncval(i);
  }	


  if(slope > 1.)slope = 1.; if(slope < 0.)slope*=-1.;

    point=art1*numchannels; funcpt=1;
    for (i=art1; i<art2; i++) {
      if (funcsel) { f_val = valarray[i]; if(f_val < 0.)f_val = 0.;
#ifdef SGI	
        val=powf(.00005*(float)R*f_val/(float)(N/2),slope);
#else
       val=pow(.00005*(float)R*f_val/(float)(N/2),slope);
#endif
       /* printf("%f\t%f\n",f_val,val); */
        }
      for (j=arf1; j<arf2; j++) {
        f=megfreq[point+j];
#ifdef SGI
        f=powf(f*mul, val);
#else
        f=pow(f*mul, val);
#endif
        if (f<0.) f=0.;
        if (f<20.) f*=f/20.;
        if(strict){ if((f <= (float)arf2*binfreq)&&(f >=(float)arf1*binfreq)){
              megfreq[point+j]=f;
	      }
            goto next;
	    }
        megfreq[point+j]=f;
        next: ;
      }
      point+=numchannels;
      val*=mult_pr_horiz;
    }
  if(funcsel)free(valarray); 
  rightbins();
  RedrawAll();

  ResetCursor(topLevel);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
/*SPREAD: concept,framework&layout stolen from the program Ceres, v.0.13
 * code rewritten for functionallity and musicality of use
 */

void Spread(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(spreadForm);
}

void SpreadOk(w, client, call)
Widget w;
XtPointer client, call;
{
  char *valstring;
  int i, j;
  long point;
  float val, eval, mult_pr_horiz, f, mul,*h;
  Boolean funcsel;
  Boolean funcsel2;
  Boolean funcsel3;
  Boolean strict;

 int art1,art2,arf1,arf2;

  /***************************************/
  int st[2];
  float art;
  XmString text,text1;
  /***************************************/
 areafind(&art1,&art2,&arf1,&arf2);


  valstring=XmTextGetString(spreadTextfield);
  eval=atof(valstring);
  XtFree(valstring);
  valstring=XmTextGetString(spreadTextfield2);
  mult_pr_horiz=pow(atof(valstring),duration/horiz_num);
  XtFree(valstring);
  valstring=XmTextGetString(spreadTextfield3);
  mul=atof(valstring);
  XtFree(valstring);
  funcsel=XmToggleButtonGetState(spreadToggle);
  funcsel2=XmToggleButtonGetState(spreadToggle2);
  funcsel3=XmToggleButtonGetState(spreadToggle3);
  funcpt = 1; funcpt2 = 1;funcpt3 = numsquare3;
  strict = XmToggleButtonGetState(spreadToggleStrict);

  XmUpdateDisplay(w);
  SetWatchCursor(topLevel);


    point=art1*numchannels; funcpt=1;

    if(funcsel3){
	    fvec(h, numchannels+1);
	for (j=0; j<numchannels; j++){h[j]=(400.-getfuncval3(j))/400.;
 	    /*printf("%d\t%f\n",j,h[j]);*/
            }
    	}

 /*******************************************************/
 if(update=XmToggleButtonGetState(displayToggleUpdate)){
 art = 100./(float)(art2-art1);
 st[0]=-1;st[1]=0;
 text= XmStringCreateLocalized("Spread...");
 text1= XmStringCreateLocalized("Processing...");
 XtVaSetValues(progressBox,XmNdialogTitle,text,
		 XmNmessageString,text1,NULL,NULL);
 XtVaSetValues(progressBar, XmNvalue, 0, NULL);
 XtManageChild(progressBox);
  while (XtAppPending(app_context)) {
     XtAppProcessEvent(app_context,XtIMXEvent|XtIMTimer|XtIMAlternateInput);
  }
}
  /*******************************************************/   
    
for (i=art1; i<art2; i++) {


  /*intermediate updates don'freeze the app while working*/
  if(update){
  	st[1]=(int)(art*(i-art1));
  	if(st[1]!=st[0]){
		XtVaSetValues(progressBar, XmNvalue, st[1], NULL);
        /*XmUpdateDisplay(topLevel);*/
		st[0]=st[1];
  		}
      XSync(XtDisplay(progressBox),0);
      XmUpdateDisplay(topLevel);
      }
 /*******************************************************/
	    
      if (funcsel) eval=2.*getfuncval(i)/(float)(N/2);
      if (funcsel2) mul=getfuncval(i)/(float)(N/2);
      val = eval;
      for (j=arf1; j<arf2; j++) {
        f=megfreq[point+j];
	if(funcsel3)val=eval*h[j];
#ifdef SGI
/*
 printf("%f\n",val);
*/
        f*=powf(2., val*(rand()/16384.-1.)*(1.-mul+mul*megamp[point+j]*10000.));
/*
 printf("---> %f\t%f\n",megfreq[point+j],f);
*/
#else
        f*=pow(2., val*(rand()/16384.-1.)*(1.-mul+mul*megamp[point+j]*10000.));
#endif
        if (f<0.) f=0.;
        if (f<20.) f*=f/20.;
		if(strict){
		if(f>22000.*arf2/(float)(N/2))goto skip_point;
        if(f<22000.*arf1/(float)(N/2))goto skip_point;
		}
        megfreq[point+j]=f;
        skip_point: ;
      }
      point+=numchannels;
      eval*=mult_pr_horiz;
    }


/****************************************/
if(update){
  XtUnmanageChild(progressBox);
  XmStringFree(text);XmStringFree(text1);
  }
/****************************************/
  if(funcsel3)free(h);
  rightbins();
  RedrawAll();
  ResetCursor(topLevel);
}
/*_____________________________________________________________________*/
/*WARP: introduced in v. 0.26a4;
 * randomly warps bins along horiz. axis using 
 * separate algorithms for amplitudes & phases
 */

void Warp(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(warpForm);
}

void WarpOk(w, client, call)
Widget w;
XtPointer client, call;
{
char *valstring;
int art1,art2,arf1,arf2, art;
Boolean am, phas, prob, depth, env;
float val0,val,regen,*valarray;
long point;
register long dev;
register int i, j;
long  *t = NULL;
float *a = NULL;
float *d = NULL;
float *f = NULL;
float *g = NULL;
float *h = NULL;
am=phas=prob= False;

valstring=XmTextGetString(warpTextfield);
val0  = atof(valstring); if(val0<0.)val0=0.;if(val0>1.)val0=1.;
am    = XmToggleButtonGetState (warpToggle);
phas  = XmToggleButtonGetState (warpToggle2);
prob  = XmToggleButtonGetState (warpToggle3);
depth = XmToggleButtonGetState (warpToggle4);
env   = XmToggleButtonGetState (warpToggle5);
regen = 1.;

XtFree(valstring);
XtUnmanageChild(warpForm);
XmUpdateDisplay(topLevel);
if(megfreq ==NULL)
if(megamp  ==NULL)goto nothing;
SetWatchCursor(topLevel);
areafind(&art1,&art2,&arf1,&arf2);
art = art2-art1;
lvec(t,art); fvec(a,(art+1)); fvec(f,(art+1));

if(prob){ fvec(h,numchannels+1); funcpt3 = numsquare3;
	for (j=0; j<numchannels; j++){h[j]=(400.-getfuncval3(j))/400.;
	    if(h[j]<=0.)h[j]=1e-9;
	/*printf("%d\t%f\n",j,h[j]);*/}
        }
if(depth){ fvec(d,horiz_num+1); funcpt2 = 1;
	for (i=0; i<horiz_num; i++){d[i]=getfuncval2(i)/(float)numchannels;
	    if(d[i]<=0.)d[i]=1e-9;if(d[i]>1.)d[i]=1.;
	/*printf("%d\t%f\n",i,d[i]);*/}
        }
if(env){ fvec(g,horiz_num+1); funcpt = 1;
	for (i=0; i<horiz_num; i++){g[i]=getfuncval(i)/(float)numchannels;
	    if(g[i]<=0.)g[i]=1e-9;if(g[i]>1.)g[i]=1.;
	/*printf("%d\t%f\n",i,g[i]);*/}
        }
/*begin algorithm*/
point=art1*numchannels; val = val0;
for(j=arf1;j<arf2;j++){
  if(prob)val=val0*h[j];
  for(i=0;i<art;i++){
  dev = (long)(val*(art*rand()/(float)RAND_MAX-art/2));
  if(env)dev*=g[i+art1];
  t[i]= i+dev;if(t[i]<0)t[i]*=(-1);if(t[i]>art)t[i]=2*art - t[i];
  /*printf("%d\t%ld\n",i,t[i]);*/
  t[i]*=numchannels;t[i]+=(point+j);
   if(am)a[i]=megamp[t[i]];  if(phas)f[i]=megfreq[t[i]];
  }
  if(depth)for(i=0;i<art;i++){
   if(am)megamp [i*numchannels+point+j] = a[i]*d[i+art1] +  
     megamp[i*numchannels+point+j]*(1.-d[i+art1]);
   if(phas)megfreq[i*numchannels+point+j] = f[i]*d[i+art1] + 
     megfreq[i*numchannels+point+j]*(1.-d[i+art1]);
  }
  else for(i=0;i<art;i++){
   if(am)megamp [i*numchannels+point+j] = a[i];
   if(phas)megfreq[i*numchannels+point+j] = f[i];
  }
}

/*end algorithm*/
free(t); free(a); free(f); if(prob)free(h); 
rightbins();
RedrawAll();
ResetCursor(topLevel);
nothing:
;
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void Mirror(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(mirrorForm);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void MirrorOk(w, client, call)
Widget w;
XtPointer client, call;
{
/*add update*/
  char *valstring,s[10];
  int i, j, i2, j2, i3, j3, k, k2;
  long point, point2, point3;
  float mval, mval2, mval3, mult_pr_horiz, f, f2, f3;
  Boolean funcsel, funcsel2, funcsel3;
 int art1,art2,arf1,arf2;
 areafind(&art1,&art2,&arf1,&arf2);


  valstring=XmTextGetString(mirrorTextfield);
  strcpy(s,valstring);
  if(isdigit(s[0])) mval = atof(valstring); else mval = pitch2freq(s);

 /* mval=atof(valstring); */
  XtFree(valstring);
  valstring=XmTextGetString(mirrorTextfield2);
  mult_pr_horiz=pow(atof(valstring),duration/horiz_num);
  XtFree(valstring);
  funcsel=XmToggleButtonGetState(mirrorToggle);
  funcsel2=XmToggleButtonGetState(mirrorToggle2);
  funcsel3=XmToggleButtonGetState(mirrorToggle3);
  funcpt=1, funcpt2=1, funcpt3=1;

  XmUpdateDisplay(w);
  SetWatchCursor(topLevel);

  point=art1*numchannels;
  point2=art1*numchannels;
  point3=art1*numchannels;
  if (funcsel2==FALSE && funcsel3==FALSE) {
  for (i=art1; i<art2; i++) {
      if (funcsel) mval=binfreq*getfuncval(i);
      for (j=arf1; j<arf2; j++) {
        f=megfreq[point+j];
        f=mval-(f-mval);
        if (f<0.) f=0.;
        if (f<20.) f*=f/20.;
        megfreq[point+j]=f;
      }
    point+=numchannels;
    mval*=mult_pr_horiz;
    }
  }
  else if (funcsel && funcsel2 && funcsel3==FALSE) {
    for (i=art1; i<art2; i++) {
      if (funcsel) mval=binfreq*getfuncval(i);
      for (j=arf1; j<arf2; j++) {
        f=megfreq[point+j];
        f=mval-(f-mval);
        if (f<0.) f=0.;
        if (f<20.) f*=f/20.;
        megfreq[point+j]=f;
      }
    point+=numchannels;
    mval*=mult_pr_horiz;
    }
    for (i2=art1; i2<art2; i2++) {
        mval2=binfreq*getfuncval2(i2);
        for (j2=arf1; j2<arf2; j2++) {
          f2=megfreq[point2+j2];
          f2=mval2-(f2-mval2);
          if (f2<0.) f2=0.;
          if (f2<20.) f2*=f2/20.;
          megfreq[point2+j2]=f2;
        }
    point2+=numchannels;
    mval2*=mult_pr_horiz;
    }
  }
  else if (funcsel && funcsel2 && funcsel3) {
     for (i=art1; i<art2; i++) {
      if (funcsel) mval=binfreq*getfuncval(i);
      for (j=arf1; j<arf2; j++) {
        f=megfreq[point+j];
        f=mval-(f-mval);
        if (f<0.) f=0.;
        if (f<20.) f*=f/20.;
        megfreq[point+j]=f;
      }
    point+=numchannels;
    mval*=mult_pr_horiz;
    }
    for (i2=art1; i2<art2; i2++) {
        mval2=binfreq*getfuncval2(i2);
        for (j2=arf1; j2<arf2; j2++) {
          f2=megfreq[point2+j2];
          f2=mval2-(f2-mval2);
          if (f2<0.) f2=0.;
          if (f2<20.) f2*=f2/20.;
          megfreq[point2+j2]=f2;
        }
    point2+=numchannels;
    mval2*=mult_pr_horiz;
    }
    for (i3=art1; i3<art2; i3++) {
        mval3=binfreq*getfuncval3(i3);
        for (j3=arf1; j3<arf2; j3++) {
          f3=megfreq[point3+j3];
          f3=mval3-(f3-mval3);
          if (f3<0.) f3=0.;
          if (f3<20.) f3*=f3/20.;
          megfreq[point3+j3]=f3;
        }
    point3+=numchannels;
    mval3*=mult_pr_horiz;
    }
  }
  rightbins();
  RedrawAll();
  ResetCursor(topLevel);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void Pshift(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(pitchForm);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void PshiftOk(w, client, call)
Widget w;
XtPointer client, call;
{
/*add update*/
  char *valstring;
  int i, j;
  long point;
  float fact, fact2, mult_pr_horiz, reference, diff;
  Boolean funcsel;
 int art1,art2,arf1,arf2;
 areafind(&art1,&art2,&arf1,&arf2);


  valstring=XmTextGetString(pitchTextfield);
  fact=atof(valstring);
  XtFree(valstring);
  valstring=XmTextGetString(pitchTextfield2);
  mult_pr_horiz=pow(atof(valstring),duration/horiz_num);
  XtFree(valstring);
  valstring=XmTextGetString(pitchTextfield3);
  reference=atof(valstring);
  XtFree(valstring);
  funcsel=XmToggleButtonGetState(pitchToggle1);
  funcpt=1;

  XmUpdateDisplay(w);
  SetWatchCursor(topLevel);

  point=art1*numchannels;
  for (i=art1; i<art2; i++) {
      if (funcsel) fact2=fact*(getfuncval(i)/(float)(N/2));
        else fact2=fact;
      for (j=arf1; j<arf2; j++) {
        diff=megfreq[point+j]-reference;
        megfreq[point+j]=fact2*diff+reference;
        if (megfreq[point+j]<20.) megamp[point+j]*=megfreq[point+j]/20.;
      }
      point+=numchannels;
      fact*=mult_pr_horiz;
  }
  rightbins();
  RedrawAll();

  ResetCursor(topLevel);
}
/*__The following group of functions bear new menu-name BAND FILTER____*/
/*_____________________________________________________________________*/
void Filter(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(filterForm);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
/*
open file, return number of time-slices --------------    alloc  slice array
                                                          alloc  times array
reopen file, return times, number of bands in each slice  alloc  2-D array
reopen file, return times and frequencies
*/
/*_____________________________________________________________________*/
int prepare_filterfile(md,name)
Boolean *md;
char *name;
{
/*******format of filter file:
stop  {- or nothing}
[ slices ]
( time[0] )
...
...
...
( time[1] )
...
...
****************************/

  int num_slices;
  char s[20];
  FILE *fil;

  num_slices=0; *md = True;
  fil=fopen(name,"r");
  if (fil==NULL) {
    printf("Couldn't open frequencies file\n");
    XtManageChild(fileWarning);
    return 0;
  }
  fscanf(fil,"%s",s);
  if(strncmp(s,"stop",4)!=0){*md=False; rewind(fil);}
  fscanf(fil,"%s",s);
/*printf("%s\n",s); */
  if(strncmp(s,"[",1)!=0) rewind(fil);
  else {fscanf(fil,"%s",s);fclose(fil);/*printf("%s\n",s)*/;return atoi(s);}
/*printf("%s\n",s);*/
  fclose(fil);

  return 1;
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void scan_filterfile(num_slices,times,num_bands,name)
int   num_slices;
float *times;
int   *num_bands;
char  *name;
{
FILE *fil;
char s[20];
int i,j;
fil=fopen(name,"r");

  fscanf(fil,"%s",s);                   /*get rid of 'stop' or '['*/
  if(strncmp(s,"stop",3)==!0) rewind(fil);
  fscanf(fil,"%s",s);			 /*get rid of '['*/
/*printf("%s\n",s);*/
  fscanf(fil,"%s",s);			/*get rid of 'slices'*/
  fscanf(fil,"%s",s);                   /*get rid of ']'*/

  fscanf(fil,"%s",s);			/*get rid of'('*/

for(i=0;i<num_slices;i++){
  fscanf(fil,"%s",s);times[i]=atof(s);
/*  printf("Time[%2d]:  %f\n",i,times[i]);   */
  fscanf(fil,"%s",s);			/*get rid of')'*/

  for(j=0;;j++){
    fscanf(fil,"%s",s);
    if(feof(fil))goto finished;
    if(strncmp(s,"(",1)==0)break;
    }
 num_bands[i]=j;	
/* printf("Bands[%2d]: %d\n",i,num_bands[i]); */
  }
finished:
 num_bands[i]=j; 
/* printf("Bands[%2d]: %d\n",i,num_bands[i]); */
fclose(fil);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void read_filterfile(num_slices, num_bands, freqs, name)
int     num_slices;
int   *num_bands;
float **freqs;
char   *name;
{
FILE *fil;
char s[20];
int i,j;
fil=fopen(name,"r");

  fscanf(fil,"%s",s);                   /*get rid of 'stop' or '['*/
  if(strncmp(s,"stop",3)==!0) rewind(fil);
  fscanf(fil,"%s",s);			
  fscanf(fil,"%s",s);			/*get rid of 'slices'*/
  fscanf(fil,"%s",s);                   /*get rid of ']'*/

  fscanf(fil,"%s",s);			/*get rid of'('*/

for(i=0;i<num_slices;i++){

  fscanf(fil,"%s",s);                   /*get rid of times*/
  fscanf(fil,"%s",s);			/*get rid of')'*/

  for(j=0;;j++){
    fscanf(fil,"%s",s);
    if(feof(fil))goto finished;
    if(strncmp(s,"(",1)==0)break;
    if(isdigit(s[0])) freqs[i][j] = atof(s); else freqs[i][j] = pitch2freq(s);

 /*   freqs[i][j]=atof(s); */
/*printf("freq[%2d][%2d]=%f\n",i,j,freqs[i][j]);*/
    }	
  }
finished:

fclose(fil);
 return;
}
/*_____________________________________________________________________*/
/*___________this is kept for bkwd. compatibility w. ceres2____________*/
int makefilterfile(md,name)
Boolean* md;
char   * name;
{
  int num_freqs;
  float f;
  char s[10];
  FILE *fil;


  num_freqs=0; fil=fopen(name,"r");
  if (fil==NULL) {
    printf("Couldn't open frequencies file\n");
    XtManageChild(fileWarning);
    return 0;
  }

  fscanf(fil,"%s",s);
  if(strncmp(s,"stop",4)==0){*md=True; fscanf(fil,"%s",s);}
     else *md = FALSE;
  if(strncmp(s,"[",1)==0){ fscanf(fil,"%s",s);fscanf(fil,"%s",s);}
  if(strncmp(s,"]",1)==0){fscanf(fil,"%s",s);fscanf(fil,"%s",s);fscanf(fil,"%s",s);}
  if(strncmp(s,")",1)==0) goto on;
  rewind(fil);
  if(*md)fscanf(fil,"%s",s);

  on:
  while ((!feof(fil)) && (num_freqs<100)) {

/*    fscanf(fil,"%f",&f); */
    fscanf(fil,"%s",s);
    if(isdigit(s[0])) f = atof(s); else f = pitch2freq(s);

    if (feof(fil)) break;
    filterfreqs[num_freqs++]=f;
  }
  fclose(fil);
  return num_freqs;
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void filterOk(w, client, call)
Widget w;
XtPointer client, call;
{
/*add update*/
  char *valstring,s[10],ffilname[100],*text;
  long point=0;
  float q,g,filter_lower, filter_upper;
  int i, j, k, h, ant, keep,max;
  int ppsec;
  Boolean funcsel,funcsel2 ;
  Boolean termite, from_file;


  static int num_slices  = -1;
  static float   *times  = NULL;
  static int     *steps  = NULL;
  static int     *num_bands  = NULL;

  float **freqs  = NULL;


 int art1,art2,arf1,arf2;
 areafind(&art1,&art2,&arf1,&arf2);

    valstring=XmTextGetString(filterTextfield3);
    g=atof(valstring);
    XtFree(valstring);


  point=art1*numchannels;
  funcsel2 =  XmToggleButtonGetState(filterGToggle); funcpt2 = 1;

  XmUpdateDisplay(w);
  SetWatchCursor(topLevel);
  
  /*if reading from file*********/	
  if (from_file=XmToggleButtonGetState(filterFilToggle)) {
  strcpy(ffilname,"./");	  
  text=XmTextGetString(filterTextfield4);
  strcat(ffilname,text);
  printf("%s\n",ffilname);

  num_slices=prepare_filterfile(&termite,ffilname);
/*  printf("Slices: %d\n",num_slices);  */
  if(num_slices==0){
	ResetCursor(topLevel); return;
	}
  if(num_slices==1)goto mff;

	fvec(times,num_slices);
	ivec(num_bands,num_slices);
        scan_filterfile(num_slices,times,num_bands,ffilname);
	ivec(steps,num_slices+1);

  ppsec =  (int)((float)horiz_num/duration); max = 0;
/*  printf(">>>>>>%d\n",ppsec);  */
  for(i=0;i<num_slices;i++){steps[i]=(int)((float)ppsec*times[i]);
  if(steps[i]>max) max=steps[i];
  if(steps[i] > horiz_num){
  	  steps[num_slices=i] = horiz_num;
	  break;
	  }
/*	printf("Time[%2d]: %f  Steps[%2d]: %d\n",i, times[i], i, steps[i]);   */
        }

	freqs =(float**)malloc(num_slices*sizeof(float*));
	for(i=0;i<num_slices;i++){
		freqs[i] = (float*)calloc(num_bands[i],sizeof(float)) ;
	        if (freqs[i]==NULL){
			printf("Insufficient memory\n");
                        goto I_failed;
			}
		}
	
  read_filterfile(num_slices, num_bands, freqs,ffilname); goto f;

  mff:
    ant=makefilterfile(&termite,ffilname);
/*  printf("#%d %f\n",(int)termite,g); */
  f:

    if(num_slices==1)
    if (ant>0) for (i=art1; i<art2; i++) {
       if(funcsel2)g = getfuncval2(i)/(float)(N/2);
      for (j=arf1; j<arf2; j++) {
        keep=0;
        for (k=0; k<ant; k++) {
          filter_lower=filterfreqs[k]-binfreq/2.;
          filter_upper=filterfreqs[k]+binfreq/2.;
          if ((megfreq[point+j]>=filter_lower)&& (megfreq[point+j]<=filter_upper))
		keep=1;
        }
        if(!termite){if (keep==0)megamp[point+j]*=g; }
        else {if (keep==1){megamp[point+j]*=g; printf(".");}}
      }
      point+=numchannels;
    }
    h=0;
    if(num_slices>1)
      for (i=art1; i<art2; i++) {
       if(i>=max)goto I_failed;
       if(funcsel2)g = getfuncval2(i)/(float)(N/2);
	while((steps[h+1]<i)&&(h<num_slices-1))h++;  /*is it safe?*/
/*printf("%d\t%d\t%d\t%d\n",i,h,steps[h],art2); */
	if(steps[h+1]>art2)goto I_failed;
      for (j=arf1; j<arf2; j++) {
        keep=0;
        for (k=0; k<num_bands[h]; k++) {
          filter_lower=freqs[h][k]-binfreq/2.;
          filter_upper=freqs[h][k]+binfreq/2.;
          if ((megfreq[point+j]>=filter_lower)&& (megfreq[point+j]<=filter_upper))
		keep=1;
        }
        if (keep==0){if(!termite) megamp[point+j]*=g; }
        else if(termite) megamp[point+j]*=g;
     }
     point+=numchannels;
   }

  I_failed:
  if(times!=NULL){free(times);times=NULL;}
  if(num_bands!=NULL){free(num_bands);num_bands=NULL;}
  if(steps!=NULL){free(steps);steps=NULL;}
  if(freqs!=NULL){for(i=0;i<num_slices;i++){
	free(freqs[i]);freqs[i]=NULL;
	}
    free(freqs);freqs=NULL;
    }

  } else {
/*reading from d-box & sccreen********/
    funcsel=XmToggleButtonGetState(filterQToggle);funcpt = 1;
    valstring=XmTextGetString(filterTextfield);

    strcpy(s,valstring);
    if(isdigit(s[0])) filter_lower = atof(valstring); else filter_lower = pitch2freq(s);
   /* filter_lower=atoi(valstring); */
    XtFree(valstring);
    valstring=XmTextGetString(filterTextfield2);

  strcpy(s,valstring);
  if(isdigit(s[0])) filter_upper = atof(valstring); else filter_upper = pitch2freq(s);
   /* filter_upper=atoi(valstring);*/
    XtFree(valstring);

    if(g<0.)g=0.; if(g>1.)g=1.;

    for (i=art1; i<art2; i++)
     {
      if(funcsel)q= 0.5-getfuncval(i)/(float)N;
      if(funcsel2)g = getfuncval2(i)/(float)(N/2);
/*printf("%f\n",g);*/
/*printf("%d\t%f\t\%f\n",i,getfuncval(i),q);  */
      if(filter_lower<=filter_upper)
        for (j=arf1; j<arf2; j++){
          if ((megfreq[point+j]>=filter_lower) && (megfreq[point+j]<=filter_upper)){
              if(funcsel){
		if((megfreq[point+j]<=filter_lower+q*(filter_upper-filter_lower))\
		  ||(megfreq[point+j]>filter_upper-q*(filter_upper-filter_lower)))
		goto a;
		}
           megamp[point+j]*=g;
           a: ;
	      }
           }
       if(filter_lower>filter_upper)
         for (j=arf1; j<arf2; j++){
	    if((megfreq[point+j]<filter_lower) && (megfreq[point+j]<=filter_upper))
		megamp[point+j]*=g;		
	    if((megfreq[point+j]>=filter_lower) && (megfreq[point+j]>filter_upper))
		megamp[point+j]*=g;
              if(funcsel)
		if((megfreq[point+j]<=filter_upper+q*(filter_lower-filter_upper))
		  ||(megfreq[point+j]>filter_lower-q*(filter_lower-filter_upper)))
		megamp[point+j]*=g;
					
	    }	    	
       point+=numchannels;
     }
     XtFree(valstring);
  }
if(from_file)XtFree(text);
RedrawAll();
ResetCursor(topLevel);
}
/*_________end of BAND FILTER CODE_________*/

/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

void BPFilter(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(bpfilterForm);
}
/*_____________________________________________________________________*/
/*_______debugged-0.25-b19------*/
void bpfilterOk(w, client, call)
Widget w;
XtPointer client, call;
{
/*add update*/
char *valstring;
int i,j;
float f_lo, f_hi, g;
long point;
float *h,*valarray,*valarray2;
Boolean funcsel, funcsel2, funcsel3,inv;
 int art1,art2,arf1,arf2;
 areafind(&art1,&art2,&arf1,&arf2);


if(funcsel  =  XmToggleButtonGetState(bpfilterToggle1))funcpt  = 1;
if(funcsel2 =  XmToggleButtonGetState(bpfilterToggle2))funcpt2 = 1;
if(funcsel3 =  XmToggleButtonGetState(bpfilterToggle4))funcpt3 = numsquare3;
inv	    =  XmToggleButtonGetState(bpfilterToggle3);

if((!funcsel)&&(!funcsel2)&&(!funcsel3))return;
valstring=XmTextGetString(bpfilterTextfield1);
g=atof(valstring);
XtFree(valstring);
printf(">BREAKPOINT FILTER:\n");
SetWatchCursor(topLevel);
point = art1*numchannels;
if(g<0.)g=0.; if(g>1.)g=1.;



if(funcsel3){ fvec(h,numchannels+1);
	for (j=0; j<arf2; j++){h[j]=(400.-getfuncval3(j))/400.;
	/*printf("%d\t%f\n",j,h[j]);*/}
        }
if(funcsel){fvec(valarray,horiz_num+1);
	for(i=0;i<horiz_num;i++)valarray[i]=getfuncval(i);
	}
if(funcsel2){fvec(valarray2,horiz_num+1);
	for(i=0;i<horiz_num;i++)valarray2[i]=getfuncval2(i);
	}


if(!inv){
for (i=art1; i<art2; i++) {
      if(funcsel) f_lo = valarray[i]*binfreq ; else f_lo =    0.0;
      if(funcsel2)f_hi = valarray2[i]*binfreq; else f_hi =22050.0;	
/*printf("%f\t%f\n",f_lo, f_hi);*/
      for (j=arf1; j<arf2; j++) {
/*printf("#\t%d\t%d\t%ld\n",i,j,point); */
	if((megfreq[point+j]>=f_lo)&&(megfreq[point+j]<f_hi)){
/*printf("%f\n",megfreq[point+j]);*/
		megamp[point+j] *= g;
                }
	else if(funcsel3)megamp[point+j] *= h[j];
	}
      point+=numchannels;

      }
   goto a;
   }

for (i=art1; i<art2; i++) {
      if(funcsel) f_lo = valarray[i]*binfreq ; else f_lo =    0.0;
      if(funcsel2)f_hi = valarray2[i]*binfreq; else f_hi =22050.0;
/*printf("%f\t%f\n",f_lo, f_hi);*/
      for (j=arf1; j<arf2; j++) {
/*printf("#\t%d\t%d\t%ld\n",i,j,point); */
	if(!((megfreq[point+j]>=f_lo)&&(megfreq[point+j]<f_hi))){
/*printf("%f\n",megfreq[point+j]);*/
		megamp[point+j] *=g ;
                }
        else if(funcsel3)megamp[point+j] *= h[j];
	}
      point+=numchannels;
      }

a:
if(funcsel3){free(h);h=NULL;}
if(funcsel2){free(valarray2);valarray2 = NULL;}
if(funcsel ){free(valarray );valarray  = NULL;}
printf(">BREAKPOINT FILTER DONE\n");
RedrawAll();
ResetCursor(topLevel);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void Gain(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(gainForm);
}

/*_____________________________________________________________________*/
/*--------debugged-0.25-b19------------*/
/*--------enhaneed-0.25-b21------------*/
/*--------cosmetics:  23.07.00.------------*/
/*--------negative vals:0.26b5------------*/
void GainOk(w, client, call)
Widget w;
XtPointer client, call;
{
/*add update*/
  char  *valstring;
  float *h;
  float val, val1, *valarray, b, tresh =0;
  long point;
  int i, j;
  Boolean funcsel,funcsel3,below=False;
  int art1,art2,arf1,arf2;
  areafind(&art1,&art2,&arf1,&arf2);

  funcsel = XmToggleButtonGetState(gainToggle);
  funcsel3= XmToggleButtonGetState(gainToggle3);
  below   = XmToggleButtonGetState(gainToggleT);
  
  funcpt = 1;
  funcpt3= numsquare3;
  
  point=art1*numchannels;

  valstring=XmTextGetString(gainTextfield);
  val=atof(valstring);
  XtFree(valstring);
  valstring=XmTextGetString(gainTextfield1);
  val1=.01*atof(valstring);
  XtFree(valstring);

  XmUpdateDisplay(w);
  SetWatchCursor(topLevel);
  XmUpdateDisplay(topLevel);

  amptrack(art1,art2,arf1,arf2);
  for(i=art1;i<art2;i++)tresh += avgamp[i]*avgamp[i];
  tresh = sqrt(tresh/(float)(arf2-arf1));

  printf("Average bin amplitude: %g\n",tresh);

  tresh*=val1;
  if(tresh < 10.e-16)tresh = 10.e-16;


 /*Gain*/ 


if(funcsel){
  fvec(valarray,horiz_num+1);
  for(i=0;i<horiz_num;i++) valarray[i]=2.*(getfuncval(i)/(float)(N/2));
  }	

  
if(funcsel3){ fvec(h,numchannels+1);
	for (j=arf1; j<arf2; j++){h[j]=(400.-getfuncval3(j))/400.;
	/*printf("%d\t%f\n",j,h[j]); */
	}
     }
/*printf("VALUES:\n"); */
  if(val<-1.)val=-1.;
  
  for (i=art1; i<art2; i++) {
    if(funcsel){
      val= valarray[i];
     /* if(val<0.)val=0.;
      printf("value = %f\n",val);
	*/
    }

    if(below){
	 b = tresh*(1.-val);
	 for (j=arf1; j<arf2; j++){
	  if(megamp[point+j]<tresh){
/*is this OK?*/
			if(funcsel3){
			megamp[point+j]=tresh-val*h[j]*(tresh-megamp[point+j]);
			}
/*	    megamp[point+j] = megamp[point+j]+(val-1.)*(tresh-megamp[point+j]);*/
			else megamp[point+j] = b + val*megamp[point+j];
/*      	    if(funcsel3)megamp[point+j]=megamp[point+j]+h[j]*(tresh-megamp[point+j]);	*/

			if(megamp[point+j]<0)megamp[point+j]=0.;     
	  }
      }
      }
    else for (j=arf1; j<arf2; j++){
	  if(megamp[point+j]>tresh){
		  
	    megamp[point+j] = tresh+val*(megamp[point+j]-tresh);
      	    if(funcsel3)megamp[point+j]=tresh+h[j]*(megamp[point+j]-tresh);	 
			if(megamp[point+j]<0)megamp[point+j]=0.;   
	  }
      }
    
    point+=numchannels;
  }

  if((funcsel3)&&(h!=NULL)){free(h);h=NULL;}
  if((funcsel)&&(valarray!=NULL)){free(valarray);valarray=NULL;}
  amptrack(art1,art2,0,numchannels);
  RedrawAll();
  ResetCursor(topLevel);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void Nullphase(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(nullphaseForm);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void NullphaseOk(w, client, call)
Widget w;
XtPointer client, call;
{
  long point=0;
  register int i, j;
  int art1, art2, arf1, arf2;
  float mult, multfactor,*m, *v, *h, f_lo, f_hi;
  register float f, val;
  char *valstring;
  Boolean funcsel = False;
  Boolean strictres = False;
  Boolean strictsou = False;
  Boolean funcsel2 = False;
  Boolean funcsel3 = False;

  valstring=XmTextGetString(nullphaseTextfield);
  multfactor=atof(valstring);
  XtFree(valstring);

  if(funcsel=XmToggleButtonGetState(nullphaseToggle1)){
    funcpt=1;
	fvec(m,(horiz_num+1));
    for(i=0;i<horiz_num;i++){
		m[i]=getfuncval(i)/(float)numchannels;
		if(m[i]<1.e-32)m[i] = 1.e-32;
		}
	}
  strictres=XmToggleButtonGetState(nullphaseToggle2);
  strictsou=XmToggleButtonGetState(nullphaseToggle3);
  funcsel2=XmToggleButtonGetState(nullphaseToggle4);
  funcsel3=XmToggleButtonGetState(nullphaseToggle5);
  XtUnmanageChild(nullphaseForm); RedrawWin();

  if(funcsel2=XmToggleButtonGetState(nullphaseToggle4)){
    funcpt2=1;
	fvec(h,(horiz_num+1));
    for(i=0;i<horiz_num;i++){
		h[i]=getfuncval2(i)/(float)numchannels;
		if(h[i]<1.e-32)h[i] = 1.e-32;
		}
	}
  if(funcsel3=XmToggleButtonGetState(nullphaseToggle5)){
    funcpt3=numsquare3;
	fvec(v,(numchannels+1));
    for(j=0;j<numchannels;j++){
        v[j]=(400.- getfuncval3(j))/400.;
		if(v[j]<1.e-32)v[j] = 1.e-32;
		}
	}
  areafind(&art1,&art2,&arf1,&arf2);
  point = art1*numchannels;
  val = 1.;
  if(strictres){
	f_lo = (float)binfreq*arf1;f_hi = (float)binfreq*arf2;
	for (i=art1; i<art2; i++) {
	 if(funcsel2)val = h[i];
     if (funcsel) mult=multfactor*m[i];
        else mult=multfactor;
	 if(strictsou){for (j=arf1; j<arf2; j++){
			if(funcsel3)val = h[i]*v[j];
			f = val/((j*mult)*binfreq) + (1.- val)/megfreq[point+j]; f = 1./f;
			if(f>=f_lo && f<=f_hi)megfreq[point+j]=f;
	 		}
     }else for (j=0; j<numchannels; j++){
			if(funcsel3)val = h[i]*v[j];
			f = val/((j*mult)*binfreq) + (1.- val)/megfreq[point+j]; f = 1./f;
			if(f>=f_lo && f<=f_hi)megfreq[point+j]=f;
			}
    point+=numchannels;
    } 
  goto complete;
  }
  for (i=art1; i<art2; i++) {
	 if (funcsel2)val = h[i];
     if (funcsel) mult=multfactor*m[i];
        else mult=multfactor;
     for (j=arf1; j<arf2; j++){
			if(funcsel3)val = h[i]*v[j];
			f = val/((j*mult)*binfreq) + (1.- val)/megfreq[point+j]; f = 1./f;
            megfreq[point+j]=f;			
		}
  point+=numchannels;
  }

  complete:
  if(funcsel)free(m);if(funcsel2)free(h);if(funcsel3)free(v);
  rightbins();
  RedrawAll();
}
/*The following group of functions bear menu name MOVE TO PITCH GRID*/
/*_________________OPTION MENUS CALLBACKS______________________________*/
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void LTOption(w, client, call)
Widget w;
XtPointer client, call;
{
int item_no = (int)client;
mLT=item_no+1;
/* printf("%d. Mode of Limited Transposition: ",mLT); */

/*puts(XtName(w));*/

}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void HSOption(w, client, call)
Widget w;
XtPointer client, call;
{
int item_no = (int)client;
mHS=item_no+1;
/* printf("%d. Mode : ",mHS); */

/* puts(XtName(w)); */

}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

void multOption(w, client, call)
Widget w;
XtPointer client, call;
{
int item_no = (int)client;
mO=item_no;
/* printf("%d. Mode : ",mO); */

/* puts(XtName(w)); */

}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

void nOption(w, client, call)
Widget w;
XtPointer client, call;
{
int item_no = (int)client;
mN=item_no;
/* printf("%d. Option : ",mO); */

/* puts(XtName(w)); */

}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

void rOption(w, client, call)
Widget w;
XtPointer client, call;
{
int item_no = (int)client;
rN=item_no;
/* printf("%d. Option : ",mO); */

/* puts(XtName(w)); */

}
/*_____________________________________________________________________*/

void exOption(w, client, call)
Widget w;
XtPointer client, call;
{
int item_no = (int)client;
mEH=item_no;
/* printf("%d. Option : ",mO); */

/* puts(XtName(w)); */

}
/*_____________________________________________________________________*/

void sOption(w, client, call)
Widget w;
XtPointer client, call;
{
int item_no = (int)client;
mSI=item_no;
/* printf("%d. Option : ",mO); */

/* puts(XtName(w)); */

}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

void pregridsort(float *gridfreqs, int left, int right)
{
  register int i, j;
  float x, y;

  i=left; j=right;
  x=gridfreqs[(left+right)/2];

  do {
    while (gridfreqs[i]<x && i <right) i++;
    while (x<gridfreqs[j] && j>left) j--;

    if(i<=j) {
      y=gridfreqs[i];
      gridfreqs[i]=gridfreqs[j];
      gridfreqs[j]=y;
      i++; j--;
    }
  }

  while (i<=j);

  if (left<j) pregridsort(gridfreqs, left, j);
  if (i<right) pregridsort(gridfreqs, i, right);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

void PGFreqfile(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(freqFileBox);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

void FreqfileOk(w, client, call)
Widget w;
XtPointer client, call;
{
  XmFileSelectionBoxCallbackStruct
    *calldata=(XmFileSelectionBoxCallbackStruct*) call;
  static XmStringCharSet charset =
                            (XmStringCharSet) XmSTRING_DEFAULT_CHARSET;
  char *filename, s[10];
  int i, i2, i3;
  int numfreqstemp;
  float f,a;
  FILE *infile;
  Boolean multsel;
  multsel=XmToggleButtonGetState(gridFileToggle);

  XtUnmanageChild(freqFileBox);
  SetWatchCursor(topLevel);
  XmStringGetLtoR(calldata->value, charset, &filename);

  infile=fopen(filename, "r");
  if (infile==NULL) {
    ResetCursor(topLevel);
    XtManageChild(fileWarning);
    XtFree(filename);
    return;
  }
/*
  fscanf(infile,"%s",s);
  if(strncmp(s,"!*",2)!=0)rewind(infile);
*/
  i=0;
  numfreqs=0;
  while ((!feof(infile)) && (i<500)) {
    fscanf(infile,"%s",s);
    if(isdigit(s[0])) f = atof(s); else f = pitch2freq(s);
    numfreqs=i, gridfreqs[i++]=f;
  }

  while (i<500) gridfreqs[i++]=f;

  if (multsel){
    if(mO==0)a=sqrt(2.);if(mO==1)a=2.;if(mO==2)a=3.;if(mO==3)a=4.;
    numfreqstemp=numfreqs; }
    for (i2=numfreqstemp; i2<500; i2++) {
      gridfreqs[i2]=gridfreqs[i2-numfreqstemp]*a;
      numfreqs=i2+1;
      if (gridfreqs[i2]>23000) break;

      }
/*  for (i3=0; i3<numfreqs; i3++) {
    printf("gridfreqs[%d]=%f\n", i3, gridfreqs[i3]);
    } */

  fclose(infile);
  XtFree(filename);
  fileDirty = FALSE;
  RestoreWin((Widget)NULL,(XtPointer)NULL,(XtPointer)NULL);
  ResetCursor(topLevel);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

void gridsort(float *gridfreqs2, int left, int right)
{
  register int i, j;
  float x, y;

  i=left; j=right;
  x=gridfreqs2[(left+right)/2];

  do {
    while (gridfreqs2[i]<x && i <right) i++;
    while (x<gridfreqs2[j] && j>left) j--;

    if(i<=j) {
      y=gridfreqs2[i];
      gridfreqs2[i]=gridfreqs2[j];
      gridfreqs2[j]=y;
      i++; j--;
    }
  }

  while (i<=j);

  if (left<j) gridsort(gridfreqs2, left, j);
  if (i<right) gridsort(gridfreqs2, i, right);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void Magnet(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(magnetForm);
}
/*_____________________________________________________________________*/
/*_____________________Jonathan Lee's grid magnet______________________*/
     /*apply getfuncval to valarray*/
void MagnetOk(w, client, call)
Widget w;
XtPointer client, call;
{
  int i, i2, i3, i4, i5, j, j2, j3, j4;
  int checkspot, nearest, numvoices, totalfreqs;
  float mindiff, f, proba, mult_pr_horiz, movetend, premovetend, movetendscaler;
  float voicespread[16];
  long point=0;
  char *valstring;
  Boolean funcsel, funcsel2, funcsel3;

  /***************************************/
  int st[2];
  float art;
  XmString text,text1;
  /***************************************/

  int art1,art2,arf1,arf2;
  areafind(&art1,&art2,&arf1,&arf2);


    if(XmToggleButtonGetState(gridTogglePreset)){
    if (XmToggleButtonGetState(gridTogglePenta)) makepenta(w, client, call);
    else if (XmToggleButtonGetState(gridToggleMajor)) makemajor(w, client, call);
    else if (XmToggleButtonGetState(gridToggleMinor)) makeminor(w, client, call);
    else if (XmToggleButtonGetState(gridToggleMLT)) makeMLT(w, client, call);
    else if (XmToggleButtonGetState(gridToggleAltd)) makealtd(w, client, call);
    else if (XmToggleButtonGetState(gridToggleHarm)) makeharmseries(w, client, call);
    }
    else if(XmToggleButtonGetState(gridToggleUser)){
	printf("User-defined grid\n");
        makeuser(w,client,call);
	}
   /* else PGFreqfile(w, client, call);*/
   /* else XtManageChild(gridForm); */
  valstring=XmTextGetString(magnetTextfield);
  proba=atof(valstring);
  XtFree(valstring);
  valstring=XmTextGetString(magnetTextfield2);
  mult_pr_horiz=pow(atof(valstring),duration/horiz_num);
  XtFree(valstring);
  valstring=XmTextGetString(magnetTextfield3);
  numvoices=atoi(valstring);
  XtFree(valstring);
  valstring=XmTextGetString(magnetTextfield4);
  funcsel2=XmToggleButtonGetState(magnetToggle2);
  funcpt2=1;
  funcsel3=XmToggleButtonGetState(magnetToggle3);
  funcpt3=numsquare3;

  if (atof(valstring)>=1) {
    voicespread[0]=1;
    if (numvoices>0) {
      for (i=1; i<(numvoices+1); i++) {
        voicespread[i]=voicespread[i-1]*(atof(valstring));
        }
      }
    }
  else if (atof(valstring)<1) {
    voicespread[0]=1;
    if (numvoices>0) {
      voicespread[1]=voicespread[0]*fabs((atof(valstring)));
      voicespread[3]=voicespread[0]*(1+(1+(atof(valstring))));
      for (i=2; i<(numvoices+1); i=i+2) {
        voicespread[i]=voicespread[i-2]*fabs((atof(valstring)));
        }
      for (i=5; i<(numvoices+1); i=i+2) {
        voicespread[i]=voicespread[i-2]*(1+(1+(atof(valstring))));
        }
      }
    }

  XtFree(valstring);
  funcsel=XmToggleButtonGetState(magnetToggle1);
  funcpt=1;
  totalfreqs=numfreqs*(numvoices+1);

  SetWatchCursor(topLevel);
  /*******************************************************/
 if(update=XmToggleButtonGetState(displayToggleUpdate)){
 art = 100./(float)(art2-art1);
 st[0]=-1;st[1]=0;
 text= XmStringCreateLocalized("Move to grid...");
 text1=XmStringCreateLocalized("Processing...");
 XtVaSetValues(progressBox,XmNdialogTitle,text,
		 XmNmessageString,text1,NULL,NULL);
 
 XtVaSetValues(progressBar, XmNvalue, 0, NULL);
 XtManageChild(progressBox);
  while (XtAppPending(app_context)) {
     XtAppProcessEvent(app_context,XtIMXEvent|XtIMTimer|XtIMAlternateInput);
     }
  }
 /*******************************************************/


  point=art1*numchannels;

  for (i2=0; i2<totalfreqs; i2++) {


	  
    if (numvoices==0) gridfreqs2[i2]=gridfreqs[i2];
      else gridfreqs2[i2]=voicespread[i2/numfreqs]*gridfreqs[i2%numfreqs];
    }

  gridsort(gridfreqs2, 0, totalfreqs-1);

  for (i3=0; i3<totalfreqs; i3++) {
    while (gridfreqs2[i3]==gridfreqs2[i3+1]) {
      for (i4=i3; i4<totalfreqs; i4++) {
      gridfreqs2[i4]=gridfreqs2[i4+1];
      }
    totalfreqs--;
    }
  }

/*  for (i5=0; i5<totalfreqs; i5++) {
    printf("gridfreqs2[%d]=%f\n", i5, gridfreqs2[i5]);
    } */

  for (j=art1; j<art2; j++) {

  /*intermediate updates don'freeze the app while working*/
  if(update){
  st[1]=(int)((j-art1)*art);
  if(st[1]!=st[0]){
	XtVaSetValues(progressBar, XmNvalue, st[1], NULL);
        /*XmUpdateDisplay(topLevel);*/
	st[0]=st[1];
  	}
      XSync(XtDisplay(progressBox),0);
      XmUpdateDisplay(topLevel);
      }
 /*******************************************************/

    if (funcsel) proba=getfuncval(j)/(float)(N/2);          /*********/
    if (funcsel2) premovetend=(getfuncval2(j)/(float)(N/2));/*********/
    funcpt3=numsquare3;
    for (j2=arf1; j2<arf2; j2++) {
      if ((float)rand()/RAND_MAX<proba) {
        nearest=totalfreqs-1;
        mindiff=99999.;
        for (j3=0; j3<totalfreqs; j3++) {
          f=fabs(megfreq[point+j2]-gridfreqs2[j3]);
          if (f<mindiff) {
            nearest=j3; mindiff=f;
          } else break;
        }
        if (funcsel2) {
        if (funcsel3) {
            movetendscaler=((400.-getfuncval3(j2))/400.);/*********/
		/*printf("#%f\n", movetendscaler);*/
	    if(movetendscaler<0.)movetendscaler=0.;
            movetend=premovetend*movetendscaler;
/*
        printf("premovetend=%f, movetendscaler=%f, movetend=%f\n",\
	premovetend, movetendscaler, movetend);
*/
      }
          if (funcsel3==FALSE) {
          movetend=premovetend;
          }
          if (gridfreqs2[nearest]>megfreq[point+j2])
            megfreq[point+j2]=megfreq[point+j2]+fabs(
              ((gridfreqs2[nearest]-megfreq[point+j2])*movetend));
          else if (gridfreqs2[nearest]<megfreq[point+j2])
            megfreq[point+j2]=megfreq[point+j2]-fabs(
              ((gridfreqs2[nearest]-megfreq[point+j2])*movetend));
          }
        else if (funcsel2==FALSE)
          megfreq[point+j2]=gridfreqs2[nearest];
        if (megfreq[point+j2]<20.) megamp[point+j2]*=megfreq[point+j2]/20.;
        }
    }
    point+=numchannels;
    proba*=mult_pr_horiz;
  }
  rightbins();
/****************************************/
if(update){
  XtUnmanageChild(progressBox);
  XmStringFree(text);XmStringFree(text1);
  }
/****************************************/
  RedrawWin();
  ResetCursor(topLevel);
}
/*------- end of MOVE TO PITCH GRID code--------- */
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

void Convolve(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(convolveForm);
}

/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

void ConvolveOk(w, client, call)
Widget w;
XtPointer client, call;
{
  float laplace[3][3]={
    { 0, -1,  0},
    {-1,  4, -1},
    { 0, -1,  0}};
  float mean[3][3]={
    { 0.11, 0.11, 0.11},
    { 0.11, 0.11, 0.11},
    { 0.11, 0.11, 0.11}};
  float timemean[3][3]={
    { 0., 0., 0.},
    { 0.33, 0.33, 0.33},
    { 0., 0., 0.}};
  float op[3][3];
  char *valstring,s[10],ffilname[100],*text;
  int i, j, i1, j1;
  long point;
  float sum;
 int art1,art2,arf1,arf2;
 areafind(&art1,&art2,&arf1,&arf2);

  XmUpdateDisplay(w);
  SetWatchCursor(topLevel);

  for (i=0; i<=2; i++) for (j=0; j<=2; j++) {
   if (XmToggleButtonGetState(convolveToggleLaplace)) op[i][j]=laplace[j][i];
   if (XmToggleButtonGetState(convolveToggleMean)) op[i][j]=mean[j][i];
   if (XmToggleButtonGetState(convolveToggleTimeMean)) op[i][j]=timemean[j][i];
  }

  for (j=0; j<numchannels; j++) this[j]=0.;
  point=art1*numchannels;
  for (i=art1; i<art2; i++) {
    for (j=0; j<numchannels; j++) last[j]=this[j];
    for (j=0; j<numchannels; j++) this[j]=megamp[point+j];
    for (j=arf1; j<arf2; j++) {
      sum=0.;
      for (j1=-1; j1<=1; j1++) {
        if ((j+j1>=0) && (j+j1<numchannels))
          sum+=op[0][j1+1]*last[j+j1];
      }
      for (j1=-1; j1<=1; j1++) {
        if ((j+j1>=0) && (j+j1<numchannels))
          sum+=op[1][j1+1]*this[j+j1];
      }
      for (j1=-1; j1<=1; j1++) {
        if ((i+1<horiz_num) && (j+j1>=0) && (j+j1<numchannels))
          sum+=op[2][j1+1]*megamp[point+numchannels+j+j1];
      }
      if (sum>=0.) megamp[point+j]=sum;
    }
    point+=numchannels;
  }
  RedrawWin();
  ResetCursor(topLevel);
}

/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void Trpeaks(w, client, call)
Widget w;
XtPointer client, call;
{
  long point=0;
  int i, j, keep;
  float *temp_amp;

 int art1,art2,arf1,arf2;
 areafind(&art1,&art2,&arf1,&arf2);

  fvec(temp_amp,numchannels);

  point=art1*numchannels;
  for (i=art1; i<art2; i++) {
     for (j=arf1; j<arf2; j++) temp_amp[j]=megamp[point+j];
     for (j=arf1; j<arf2-1; j++) {
       keep=0; if (j==arf1) keep=1; else {
         if ((temp_amp[j-1]<temp_amp[j]) && (temp_amp[j+1]<temp_amp[j]))
           keep=1;
       }
       if ((temp_amp[j]<=0.000001) || (megfreq[point+j]<20.) || (keep==0))
          megamp[point+j] = 0.;
     }
     point += numchannels;
  }
  free(temp_amp);

  RedrawAll();
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void LTAS(w, client, call)
Widget w;
XtPointer client, call;
{
  int i, j, art1,art2,arf1,arf2;
  float middleamp, middlefreq;

  areafind(&art1,&art2,&arf1,&arf2);
  for (j=arf1; j<arf2; j++) {
    middleamp=middlefreq=0.;
    for (i=art1; i<art2; i++) {
      middleamp+=megamp[i*numchannels+j];
      middlefreq+=megfreq[i*numchannels+j];
    }
    middleamp/=(art2-art1);
    middlefreq/=(art2-art1);
    for (i=art1; i<art2; i++) {
      megamp[i*numchannels+j]=middleamp;
      megfreq[i*numchannels+j]=middlefreq;
    }
  }
  RedrawAll();
}

/*____________Settings Menu CALLBACKS__________________________________*/
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void Settings(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(settingsForm);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

void SettingsOk(w, client, call)
Widget w;
XtPointer client, call;
{
  char *valstring;
  Boolean obanksel, varstrsel;
  int i;

  valstring=XmTextGetString(settingsTextfield);
  stretchfac=atof(valstring);
/*see time variable stretching*/
  XtFree(valstring);
  I=(int)(D*stretchfac);

  obanksel=((XmToggleButtonGetState(settingsToggle2))||
		(XmToggleButtonGetState(settingsToggle3)));
  if (obanksel) {
	obank=1;
	fast = (int)(XmToggleButtonGetState(settingsToggle3));
	}
	else obank=0;

  varstrsel=XmToggleButtonGetState(interpolToggle);
  if (varstrsel){ va_tstretch=1;funcpt = 1;
     for(i=0;i<horiz_num;i++){interpol[i]=2.*getfuncval(i)/(float)(N/2);
        if((interpol[i]>.94)&&(interpol[i]<1.06))interpol[i]=1.;
	}
     for(i=0;i<horiz_num;i++){if(interpol[i]<1.)interpol[i] = interpol[i]*.5+.5;
			     else interpol[i] = interpol[i]*2.-1;
        }
     for(i=0;i<horiz_num;i++)interpol[i] *= D;
	/*
     for(i=0;i<horiz_num;i++)printf("%f\n",interpol[i]);
     */
   }
  else va_tstretch=0;
}

/*_____________________________________________________________________*/
/*_____________________________________________________________________*/


int GetFFTfromMenu(void)
{
int n;
  if (XmToggleButtonGetState(FFTToggle512))  n = 512;
  else if (XmToggleButtonGetState(FFTToggle1024)) n = 1024;
  else if (XmToggleButtonGetState(FFTToggle2048)) n = 2048;
  else if (XmToggleButtonGetState(FFTToggle4096)) n = 4096;
  else if (XmToggleButtonGetState(FFTToggle8192)) n = 8192;
return n;
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
int GetWinSizeFromMenu(n)
int n;
{
int nw;
float f;
char *valstring, s[12];
  if (XmToggleButtonGetState(winSizeToggle)){
    valstring=XmTextGetString(winSizeTextfield);
	strcpy(s,valstring);
	XtFree(valstring);
	if(isdigit(s[0])){
		if(strstr(s, ".")){
			f = atof(s);
			nw = 5*(int)(R/f);
			}
		else nw=atoi(s);    	  
	} else {	
	f = pitch2freq(s);
printf ("%f\n", f);
	/*IRCAM's Redundancy formula:  f =5*R/Nw*/
	nw = 5*(int)(R/f);
	}
    printf("Exact window size for \"%s\" = %6.5f Hz: %d\n", s, f, nw);
	if(nw < n)nw = n;if(nw > 4*n)nw = 4*n;
	if(nw%2 != 0 )nw++;
    printf("Nearest possible window size for \"%s\": %d\n",s, nw);
	return nw;
    }
 
  if (XmToggleButtonGetState(WindowToggle512)) nw=512;
  else if (XmToggleButtonGetState(WindowToggle1024)) nw=1024;
  else if (XmToggleButtonGetState(WindowToggle2048)) nw=2048;
  else if (XmToggleButtonGetState(WindowToggle4096)) nw=4096;
  else if (XmToggleButtonGetState(WindowToggle8192)) nw=8192;
  else if (XmToggleButtonGetState(WindowToggle16384)) nw=16384;
  if(nw < n) nw = n;if(nw > 4*n)nw = 4*n;

return nw;
}

/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
int GetWinStepFromMenu(nw)
int nw;
{
  if (XmToggleButtonGetState(OverlapToggle2)) return nw/2;
  else if (XmToggleButtonGetState(OverlapToggle4)) return nw/4;
  else if (XmToggleButtonGetState(OverlapToggle8)) return nw/8;
  else if (XmToggleButtonGetState(OverlapToggle16)) return nw/16;
return nw/32;  
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void setFFTRadio (int value, Boolean state)
{
 Boolean one, two, three, four, five;
	one = two = three = four = five = False;
	if(value == 512)one = True;if(value == 1024)two = True;
	if(value == 2048)three = True;if(value == 4096)four = True;
	if(value == 8192)five = True;

  XtVaSetValues(FFTToggle512,XmNset, one,XmNsensitive,state,NULL);
  XtVaSetValues(FFTToggle1024,XmNset, two,XmNsensitive,state,NULL);
  XtVaSetValues(FFTToggle2048,XmNset, three,XmNsensitive,state,NULL);
  XtVaSetValues(FFTToggle4096,XmNset, four,XmNsensitive,state,NULL);
  XtVaSetValues(FFTToggle8192,XmNset, five, XmNsensitive,state,NULL);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

void Analy(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(analyForm);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

void AnalyOk(w, client, call)
Widget w;
XtPointer client, call;
{
char * valstring;
  if((valstring=XmTextGetString(displayTextfield))!=NULL)
  thewidth=atoi(valstring); 
XtFree(valstring);
  /*makewindows(Wanal,  Wsyn,  Nw,  N,  I);*/;
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void FFT(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(FFTForm);
}
/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

void FFTOk(w, client, call)
Widget w;
XtPointer client, call;
{
  char *valstring;
  char s[10];
  float f;
/*
  valstring=XmTextGetString(displayTextfield);
  thewidth=atoi(valstring);
  XtFree(valstring);

  if (XmToggleButtonGetState(FFTToggle512)) N=512;
  else if (XmToggleButtonGetState(FFTToggle1024)) N=1024;
  else if (XmToggleButtonGetState(FFTToggle2048)) N=2048;
  else if (XmToggleButtonGetState(FFTToggle4096)) N=4096;
  else if (XmToggleButtonGetState(FFTToggle8192)) N=8192;
*/
  if (XmToggleButtonGetState(winSizeToggle)){
    valstring=XmTextGetString(winSizeTextfield);
	strcpy(s,valstring);
	if(isdigit(s[0])){
		if(strstr(s, ".")){
			f = atof(s);
			Nw = 5*(int)(R/f);
			}
		else Nw=atoi(s);    	  
	} else {	
	f = pitch2freq(s);
printf ("%f\n", f);
	/*IRCAM's Redundancy formula:  f =5*R/Nw*/
	Nw = 5*(int)(R/f);
	}
	XtFree(valstring);
    printf("Exact window size for \"%s\" = %6.5f Hz: %d\n", s, f, Nw);
	if(Nw < N)Nw = N;if(Nw > 4*N)Nw = 4*N;
	if(Nw%2 != 0 )Nw++;
    printf("Nearest possible window size for \"%s\": %d\n",s, Nw);
	goto overlap;
    }
 
  if (XmToggleButtonGetState(WindowToggle512)) Nw=512;
  else if (XmToggleButtonGetState(WindowToggle1024)) Nw=1024;
  else if (XmToggleButtonGetState(WindowToggle2048)) Nw=2048;
  else if (XmToggleButtonGetState(WindowToggle4096)) Nw=4096;
  else if (XmToggleButtonGetState(WindowToggle8192)) Nw=8192;
  else if (XmToggleButtonGetState(WindowToggle16384)) Nw=16384;

overlap:
  if (XmToggleButtonGetState(OverlapToggle2)) D=Nw/2;
  else if (XmToggleButtonGetState(OverlapToggle4)) D=Nw/4;
  else if (XmToggleButtonGetState(OverlapToggle8)) D=Nw/8;
  else if (XmToggleButtonGetState(OverlapToggle16)) D=Nw/16;
  else if (XmToggleButtonGetState(OverlapToggle32)) D=Nw/32;



 N2=N>>1; theheight = N2 + 1;
  I=D;     
  P=1.;   
  synt=0.; 

  obank=0.;
  fast = 0;	
}

/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

void setgreycolors(void)
{
   if (farge==1) return;
   if (sketchpad==NULL) return;
   XSetForeground(theDisplay, theGC0, gray0.pixel);
   XSetForeground(theDisplay, showGC0, gray0.pixel);

   XSetForeground(theDisplay, showGC10, gray20.pixel);

   XSetForeground(theDisplay, theGC20, gray20.pixel);
   XSetForeground(theDisplay, showGC20, gray20.pixel);

   XSetForeground(theDisplay, theGC40, gray40.pixel);
   XSetForeground(theDisplay, showGC40, gray40.pixel);

   XSetForeground(theDisplay, theGC60, gray60.pixel);
   XSetForeground(theDisplay, showGC60, gray60.pixel);
   /**/
   XSetForeground(theDisplay, theGC80, gray80.pixel);
   XSetForeground(theDisplay, showGC80, gray80.pixel);
   /**/
   XSetForeground(theDisplay, theGC100, gray100.pixel);
   XSetForeground(theDisplay, showGC100, gray100.pixel);

   XtVaSetValues(sketchpad,XmNbackground, gray100.pixel,NULL);
   XSetForeground(theDisplay, funcGC, red.pixel);
   XSetForeground(theDisplay, func2GC, green.pixel);
   XSetForeground(theDisplay, func3GC, blue.pixel);
   XSetForeground(theDisplay, func4GC, brown.pixel);
   XSetForeground(theDisplay, func5GC, purple.pixel);
   XSetForeground(theDisplay, spotsGC, darkblue.pixel);
   RedrawWin(); farge=1;
}

/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

void sethotcolors(void)
{
   if (farge==2) return;
   if (sketchpad==NULL) return;
   XSetForeground(theDisplay, theGC0, gray100.pixel);
   XSetForeground(theDisplay, showGC0, gray100.pixel);
	/*WHY IS theGC10 MISSING?*/
   XSetForeground(theDisplay, showGC10, gray60.pixel);

   XSetForeground(theDisplay, theGC20, yellow.pixel);
   XSetForeground(theDisplay, showGC20, yellow.pixel);

   XSetForeground(theDisplay, theGC40, orange.pixel);
   XSetForeground(theDisplay, showGC40, orange.pixel);

   XSetForeground(theDisplay, theGC60, red.pixel);
   XSetForeground(theDisplay, showGC60, red.pixel);

   XSetForeground(theDisplay, theGC80, darkred.pixel);
   XSetForeground(theDisplay, showGC80, darkred.pixel);


   XSetForeground(theDisplay, theGC100, gray0.pixel);
   XSetForeground(theDisplay, showGC100, gray0.pixel);

   XtVaSetValues(sketchpad,XmNbackground, gray0.pixel,NULL);
   XSetForeground(theDisplay, funcGC, purple.pixel);/*____darkblue WAS_TOO_DARK_____*/
   XSetForeground(theDisplay, func2GC, blue.pixel);
   XSetForeground(theDisplay, func3GC, cyan.pixel);/*____lightblue_WAS_TOO_WHITE_____*/
   XSetForeground(theDisplay, func4GC, lightblue.pixel);
   XSetForeground(theDisplay, func5GC, mycadetblue.pixel);
   XSetForeground(theDisplay, spotsGC, green.pixel);
   RedrawWin(); farge=2;
}

/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

void setcoldcolors(void)
{
   if (farge==3) return;
   if (sketchpad==NULL) return;
   XSetForeground(theDisplay, theGC0, gray100.pixel);
   XSetForeground(theDisplay, showGC0, gray100.pixel);

   XSetForeground(theDisplay, showGC10, gray60.pixel);

   XSetForeground(theDisplay, theGC20, lightblue.pixel);
   XSetForeground(theDisplay, showGC20, lightblue.pixel);

   XSetForeground(theDisplay, theGC40, blue.pixel);
   XSetForeground(theDisplay, showGC40, blue.pixel);

   XSetForeground(theDisplay, theGC60, darkblue.pixel);
   XSetForeground(theDisplay, showGC60, darkblue.pixel);
/*
 XSetForeground(theDisplay, theGC60,dodgerblue4.pixel);
 XSetForeground(theDisplay, showGC60,dodgerblue4.pixel);
*/
   XSetForeground(theDisplay, theGC80, midnightblue.pixel);
   XSetForeground(theDisplay, showGC80, midnightblue.pixel);

   XSetForeground(theDisplay, theGC100, gray0.pixel);
   XSetForeground(theDisplay, showGC100, gray0.pixel);
   XtVaSetValues(sketchpad,XmNbackground, gray0.pixel,NULL);
   XSetForeground(theDisplay, funcGC, red.pixel);
   XSetForeground(theDisplay, func2GC, orange.pixel);
   XSetForeground(theDisplay, func3GC, yellow.pixel);
   XSetForeground(theDisplay, func4GC, brown.pixel);
   XSetForeground(theDisplay, func5GC, purple.pixel);
   XSetForeground(theDisplay, spotsGC, green.pixel);
   RedrawWin(); farge=3;
}

/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void Displaymenu(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(displayForm);
}

/*_____________________________________________________________________*/
/*_____________________________________________________________________*/
void DisplayOk(w, client, call)
Widget w;
XtPointer client, call;
{
  char *valstring;
  valstring=XmTextGetString(displayTextfield);
 /*thewidth=atoi(valstring);*/
  XtFree(valstring);
  valstring=XmTextGetString(spotsTextfield);
  spotsize=atoi(valstring);
  XtFree(valstring);

  if (XmToggleButtonGetState(displayToggleSpots)==False) {
    if (numspots) farge=-1;
    numspots=0;
  }else{
    if ( XmToggleButtonGetState(displayToggleArea ))RedrawArea();
	if ( XmToggleButtonGetState(displayToggleArea2))RedrawArea2();
	if ( XmToggleButtonGetState(displayToggleArea3))RedrawArea3();
printf("Areas:=======================\n \
      %d  %d\t %d  %d\n ",areat1, areaf1, areat2, areaf2);
/*keep last area values for spots processing*/
	kt1 = areat1; kf1 = areaf1; kt2 = areat2; kf2 = areaf2;
  }
  if (XmToggleButtonGetState(displayToggleGrey)) setgreycolors();
  if (XmToggleButtonGetState(displayToggleHot)) sethotcolors();
  if (XmToggleButtonGetState(displayToggleCold)) setcoldcolors();

  if (XmToggleButtonGetState(displayToggleFuncAll)) {
    RedrawFunc();
    RedrawFunc2();
    RedrawFunc3();
    }
}

/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

void Gridmenu(w, client, call)
Widget w;
XtPointer client, call;
{
  XtManageChild(gridForm);
}

/*_____________________________________________________________________*/
/*_____________________________________________________________________*/

void GridmenuOk(w, client, call)
Widget w;
XtPointer client, call;
{
    if (XmToggleButtonGetState(freqfile))PGFreqfile(w, client, call);
    else if(XmToggleButtonGetState(gridTogglePreset)){
    	if (XmToggleButtonGetState(gridTogglePenta)) makepenta(w, client, call);
   	else if (XmToggleButtonGetState(gridToggleMajor)) makemajor(w, client, call);
    	else if (XmToggleButtonGetState(gridToggleMinor)) makeminor(w, client, call);
    	else if (XmToggleButtonGetState(gridToggleMLT)) makeMLT(w, client, call);
    	else if (XmToggleButtonGetState(gridToggleAltd)) makealtd(w, client, call);
    	else if (XmToggleButtonGetState(gridToggleHarm)) makeharmseries(w, client, call);

        }
    else if(XmToggleButtonGetState(gridToggleUser)){
	printf("User-defined grid\n");
        makeuser(w,client,call);
	}
  RestoreWin((Widget)NULL,(XtPointer)NULL,(XtPointer)NULL);
}


/*________>>>>>>>>>>>>>>>_________________________________________*/
/*________________________________________________________________*/
int define_funcnodes(p1i,p2i)
int*p1i,*p2i;
{
int i;
printf(">Defining Nodes: %d\n",horiz_num/MAXNODES);
return horiz_num/MAXNODES;

/*
      for (i=1; i<MAXNODES; i++) {
        fscanf(infile, "%s", &p1i);
        if (strcasecmp(p1c, "end")==0) break;
        p1i=atoi(p1c);
        fscanf(infile, "%d", &p2i);
        if (p1i<50) p1i=50;
        if (p1i>thewidth+50) p1i=thewidth+50;
        if (p2i<20) p2i=20;
        if (p2i>theheight+20) p2i=theheight+20;
        xpos[i]=p1i;
        ypos[i]=p2i;
*/
}
/*_________________________________________________________________*/

void setUpWindow(int thewidth, int theheight, int*iwidth,
	 int* iheight, float* fwidth)
{
	if (thewidth < 400) thewidth = 400;
	if (thewidth > 1600) thewidth = 1600;
	*fwidth = (float)thewidth;
#ifdef SGI
  if (thewidth+65> 1000)*iwidth = 1000;
  	else *iwidth = thewidth+65;
  if (theheight + 89 > 710)*iheight = 710;
	else *iheight = theheight+89;
#else
  if (thewidth+65 > 1000)*iwidth = 1000;
  	else *iwidth = thewidth+65;
  if (theheight + 95 > 710)*iheight = 710;
	else *iheight = theheight+95;
#endif

return ;
}
/*_________________________________________________________________*/
int fix_size(char* name, int value, int param)
{
if (strcmp (name, "N") == 0)
	{    
	if ((value!=512) && (value!=1024) && (value!=2048) && (value!=4096) && (value!=8192)&&(value!=16384))
	 {
	 if(value >= 256)
		{
		if(value < 768)
			{ printf("Illegal value for FFT size. Selected 512.\n"); value=512;}
		if((value > 768)&&(value < 1536))
			{ printf("Illegal value for FFT size. Selected 1024.\n"); value=1024;}
		if((value > 1536)&&(value < 3072))
			{ printf("Illegal value for FFT size. Selected 2048.\n"); value=2048;}
		if((value > 3072)&&(value < 6144))
			{  printf("Illegal value for FFT size. Selected 4096.\n"); value=4096;}
		if((value > 6144)&&(value <12288))
			{ printf("Illegal value for FFT size. Selected 8192.\n"); value=8192;}
		if(value >12288)
			{ printf("Illegal value for FFT size. Selected 16384.\n"); value=16384;}		
		}
		else{
			printf("Illegal value for FFT size. Selected 1024.\n"); value=1024;
			}
      }
	return value;
	}
if (strcmp (name, "Nw") == 0)
	{
	if (value < param)return param;
	if (value > 32768)return 32768;
	return value;
	}
if (strcmp (name, "D") == 0)
	{   
	if ((value==param/2) || (value==param/4) || (value==param/8) || 
		(value==param/16) || (value==param/32))return value;
	if(value >= param/3)return param/2;
	if((value >= param/6)&&(value < param/3))return param/4;
	if((value >= param/12)&&(value < param/6))return param/8;
	if((value >= param/24)&&(value < param/12))return param/16;	
	if((value >= param/48)&&(value < param/124))return param/32;	
    printf("Illegal value for Window step. Selected 128.\n"); return param/8;
	}
printf ("Error: Check code. Substituting for default 512\n");
return 512;
}
/*________<<<<<<MAIN_______________________________________________*/
/*_________________________________________________________________*/
/*_________________________________________________________________*/
/*_________________________________________________________________*/
/*_________________________________________________________________*/

int main(argc, argv)
int    argc;
char **argv;
{
XmString text;
XmString helptext;
Arg menuargs[10];
int n1, n2;


  /* INITIALIZE PHASE VOCODER */
  /* no matter if the parameters are read from the 
      * command line or the icon is double-clicked, the
      * phase vocoder requires fool-proof initialization
      *    *    *    *    *    *    *    *    *    *    *    *    *    *    */

  /* argv[1] --------> FFT length N */
 N=0;


  if (argc==2 || argc==3 || argc==4 || argc==5 || argc==6)
   {
    N  = atoi(argv[1]);
	N  = fix_size("N",N,0);
	Nw = N;
	D  = Nw/8;
    }


  /* argv[2] --------> Window size Nw */
  if(Nw<N)Nw=N;
  if (argc==3 || argc==4 || argc==5 || argc==6) {
    Nw=atoi(argv[2]);
	Nw = fix_size("Nw",Nw,N);
	D  = Nw/8;
  }

  /*  argv[3] --------> Window Step*/
  D=Nw/8;
  if (argc==4 || argc==5 || argc==6) {
    D=(atoi(argv[3]));
	D = fix_size("D", D, Nw);
  }



  I=D;     /* Interpolation factor */
  P=1.;    /* Oscbank pitch factor */
  synt=0.; /* Synthesis treshold */
  obank=0.;
  fast = 0;
  N2=N>>1; theheight =N2 +1 ;
  spotsize=3;


/* argv[4] -------------> main GUI window width */
  thewidth=700;

  if ((argc==5)||(argc==6)) {
    thewidth=atoi(argv[4]);
    if (thewidth > 1600) {
        printf("Illegal value for graphic width. Selected 1600.\n"); 
	thewidth=1600;
    }
    if (thewidth < 400) {
        printf("Illegal value for graphic width. Selected 400.\n"); 
	thewidth=400;
    }
  }
  fwidth = (float)thewidth;
/*printf("fwidth=%f\n",fwidth);*/
  Nw2=Nw>>1;
  numchannels=N/2+1;

  fvec(Wanal,  16384);
  fvec(Wsyn,  16384);
  fvec(input,  16384);
  fvec(buffer,  8192);
  fvec(channel,  8194);
  fvec(output,  8192);
  fvec(tempamp,4097);
  fvec(tempfreq,4097);
  fvec(last, 4097); fvec(this, 4097);

  if ((framebuff =(short int *)calloc(32768,sizeof(short int)))==NULL) {
    fprintf(stderr,"Unable to allocate AIFF framebuffer!\n");
    exit(-1);
  }

  if ((framebuff32 =(long int *)calloc(32768,sizeof(long int)))==NULL) {
    fprintf(stderr,"Unable to allocate AIFF framebuffer!\n");
    exit(-1);
  }


  printf("\
================================================\n\
Starting Ceres3...\nFFT size=%d. Window size=%d. \nWindow step=%d. Image width=%d.\n",N,Nw,D,thewidth);


#ifdef SGI
  if (thewidth+65> 1000)iwidth = 1000;
  	else iwidth = thewidth+56;
  if (theheight + 89 > 710)iheight = 710;
	else iheight = theheight+75;
#else
  if (thewidth+65 > 1000)iwidth = 1000;
  	else iwidth = thewidth+65;
  if (theheight + 95 > 710)iheight = 710;
	else iheight = theheight+95;
#endif

  stereo = 0;
/*
setUpWindow( thewidth, theheight, &iwidth,
	 &iheight, &fwidth);
*/
/* ________________ INITIALIZE X __________________*/



 XtSetLanguageProc(NULL, (XtLanguageProc)NULL, NULL);
/*
  topLevel=XtVaAppInitialize(&app_context,"Ceres3",NULL,0,&argc,argv,NULL,NULL);
*/


  topLevel=XtVaOpenApplication(&app_context, "Ceres3", NULL, 0, &argc, argv, 
		fallbackResources, applicationShellWidgetClass, 
		XmNallowShellResize, True, NULL);

  dw = XmGetXmDisplay(XtDisplay(topLevel));

  XtVaSetValues(dw, XmNdragInitiatorProtocolStyle, XmDRAG_NONE, NULL);

  printf("Initializing GUI");
  /* CREATE MAIN WINDOW & IMMEDIATE CHILDREN */
  mainWindow=XtVaCreateManagedWidget("mainWindow",
    xmMainWindowWidgetClass,topLevel,
    XmNscrollingPolicy, XmAUTOMATIC,
    NULL);
  n1 = 0;
 /* XtSetArg(menuargs[n1], XmNshadowThickness, 2); n1++;*/
 /* XtSetArg(menuargs[n1], XmNmarginHeight, -1); n1++;*/

/*
#ifdef SGI
  menuBar=XmCreateMenuBar(mainWindow,"menuBar",menuargs,n1+1);
#else
*/
  
  menuBar=XmCreateMenuBar(mainWindow,"menuBar",NULL,0);
/*
#endif
*/
  XtManageChild(menuBar);

  frame=XtVaCreateManagedWidget("frame",
	xmFrameWidgetClass,mainWindow,
	NULL);


 /* XtVaSetValues(VertScrollBar,XmNvalue, iheight, NULL);*/
  XmMainWindowSetAreas(mainWindow, menuBar, NULL, NULL, NULL, frame);

if(argv[1]==NULL)
#ifdef SGI
  XtVaSetValues(mainWindow,XmNwidth, 400, XmNheight, 17,NULL);
#else
  XtVaSetValues(mainWindow,XmNwidth, 400, XmNheight, 35,NULL);
#endif 
else 

  XtVaSetValues(mainWindow,XmNwidth, iwidth, XmNheight, iheight, 
	/*VertScrollBar*XmNvalue, iheight,*/NULL);
	


printf(". ");
  /*++++++++++++++++++++ CREATE a DrawigArea widget+++++++++++++++++++++ */
if(argv[1] != NULL){
   if(sketchpad == (Widget)NULL)sketchpad = CreateDrawingArea();
   XtAppAddActions(app_context, actions, XtNumber(actions));
   XtOverrideTranslations(sketchpad,XtParseTranslationTable(drawTranslations));
   XtAddCallback(sketchpad,XmNexposeCallback,RestoreWin,0);
   XtAddCallback(sketchpad,XmNresizeCallback,ResizeWin,0);
   XtManageChild(sketchpad);
   firstrun = True;
 }

/*______________________#MENU WIDGETS__________________________________*/
/*_____________________________________________________________________*/

printf(". ");
 /* CREATE FILE MENU */
  fileButton=XtVaCreateManagedWidget(
    "fileButton",xmCascadeButtonWidgetClass,menuBar,
	XmNmnemonic,XStringToKeysym("F"),
	XmNmarginHeight, -1,NULL);
 text=XmStringCreateLocalized("File");
 /* text=XmStringCreate("File", "TAG"); */
  XtVaSetValues(fileButton,XmNlabelString,text,NULL);

  fileMenu=XmCreatePulldownMenu(menuBar,"fileMenu",NULL,0);
  XtVaSetValues(fileButton,XmNsubMenuId,fileMenu,NULL);


  /* CREATE NEW BUTTON */
  newButton=XtVaCreateManagedWidget(
    "newButton",xmPushButtonWidgetClass,fileMenu,XmNmnemonic,XStringToKeysym("N"),XmNaccelerator,"Ctrl<Key>N",
    XmNacceleratorText,XmStringCreateLocalized("Ctrl+N"),NULL);
  text=XmStringCreateLocalized("New");
  XtVaSetValues(newButton,XmNlabelString,text,NULL);

  newForm=XmCreateBulletinBoardDialog(mainWindow,"newForm",NULL,0); 
  newOkButton=XtVaCreateManagedWidget("newOk",xmPushButtonWidgetClass,
    newForm,NULL);
  text=XmStringCreateLocalized("OK");
  XtVaSetValues(newOkButton,XmNlabelString,text,XmNx,50,XmNy,130,
    XmNwidth,90,NULL);
  newCancelButton=XtVaCreateManagedWidget("newCancel",
    xmPushButtonWidgetClass,newForm,NULL);
  text=XmStringCreateLocalized("Cancel");
  XtVaSetValues(newCancelButton,XmNlabelString,text,XmNx,200,XmNy,130,NULL);
  text=XmStringCreateSimple("New Analysis Scratchpad");
  XtVaSetValues(newForm,XmNdialogTitle,text,
   XmNcancelButton,newCancelButton,
    XmNdefaultButton,newOkButton,NULL);
  
  
 
  newTextField=XtVaCreateManagedWidget("newTextfield",
    xmTextFieldWidgetClass,newForm,NULL);
  XtVaSetValues(newTextField,XmNwidth,80,XmNx,210,XmNy,15,
    XmNvalue,"5.0",NULL);
  newLabel=XtVaCreateManagedWidget("newLabel",xmLabelWidgetClass,
    newForm,NULL);
  text=XmStringCreateLocalized("Duration (sec.):");
  XtVaSetValues(newLabel,XmNlabelString,text,XmNx,0,XmNy,19,NULL);

  newLabel1=XtVaCreateManagedWidget("newLabel1",xmLabelWidgetClass,
    newForm,NULL);
  text=XmStringCreateLocalized("Spectral Template");
  XtVaSetValues(newLabel1,XmNlabelString,text,XmNx,0,XmNy,55,NULL);

  newLabel2=XtVaCreateManagedWidget("newLabel2",xmLabelWidgetClass,
    newForm,NULL);
  text=XmStringCreateLocalized("Sampling Rate (kHz)");
  XtVaSetValues(newLabel2,XmNlabelString,text,XmNx,0,XmNy,90,NULL);
  

 newM=XtVaCreateManagedWidget("newM", xmRowColumnWidgetClass,newForm,NULL);
 XtVaSetValues(newM,XmNx,185,NULL);

 newMmode=XmStringCreateLocalized("->");
 smo=XmStringCreateLocalized("harm.");		
 noi=XmStringCreateLocalized("noise");
 r44=XmStringCreateLocalized("44.1  ");
 r48=XmStringCreateLocalized("48.0  ");
 r22=XmStringCreateLocalized("22.05 ");

 newMOption=XmVaCreateSimpleOptionMenu(newM,"newMOption",newMmode,':', 0,nOption,
	XmVaPUSHBUTTON,smo, NULL,NULL,NULL,
    XmVaPUSHBUTTON,noi, NULL,NULL,NULL,
	NULL);
 newROption=XmVaCreateSimpleOptionMenu(newM,"newROption",newMmode,':', 0,rOption,
	XmVaPUSHBUTTON,r44, NULL,NULL,NULL,
    XmVaPUSHBUTTON,r48, NULL,NULL,NULL,
    XmVaPUSHBUTTON,r22, NULL,NULL,NULL,
	NULL);

XmStringFree(newMmode); XmStringFree(smo);XmStringFree(noi);
XmStringFree(r44);XmStringFree(r48);XmStringFree(r22);
XtManageChild(newMOption);
XtManageChild(newROption);

   XtVaSetValues(newM,XmNx,180,XmNy,45,NULL);


  
  XtAddCallback(newOkButton,XmNactivateCallback,new_Ok,NULL);

  XtAddCallback(newButton,XmNactivateCallback,new_,0);

  


  /* CREATE LOAD & ANALYZE BUTTON */
  load=XtVaCreateManagedWidget("load",xmPushButtonWidgetClass,fileMenu,
	XmNmnemonic,XStringToKeysym("o"),XmNaccelerator,"Ctrl<Key>O",
        XmNacceleratorText,XmStringCreateLocalized("Ctrl+O"),NULL);
  text=XmStringCreateLocalized("Load & Analyze");
  XtVaSetValues(load,XmNlabelString,text,NULL);

  loadFileBox=XmCreateFileSelectionDialog(mainWindow,"load",NULL,0);
  temp=XmFileSelectionBoxGetChild(loadFileBox,XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(temp);
  text=XmStringCreateSimple("Load & Analyze");
# ifdef SGI
  XtVaSetValues(loadFileBox,XmNdialogTitle,text,
    XmNwidth,300,NULL);
#else
  XtVaSetValues(loadFileBox,XmNdialogTitle,text,
    XmNwidth,500,NULL);
#endif

  fileInfoRC=XtVaCreateManagedWidget("fileInfoRC",xmRowColumnWidgetClass,
    loadFileBox,NULL);
  loadSepar1=XtVaCreateManagedWidget("loadSepar1",xmSeparatorWidgetClass,
    fileInfoRC,NULL);
  text=XmStringCreateLocalized("(File Info:)");
  infoL1=XtVaCreateManagedWidget("infoL1",xmLabelWidgetClass,
    fileInfoRC,XmNlabelString,text,NULL);
  text=XmStringCreateLocalized(" ");
  infoL2=XtVaCreateManagedWidget("infoL2",xmLabelWidgetClass,
    fileInfoRC,XmNlabelString,text,NULL);
  infoL3=XtVaCreateManagedWidget("infoL3",xmLabelWidgetClass,
    fileInfoRC,XmNlabelString,text,NULL);

  infoStereoRadio=XtVaCreateManagedWidget("infoStereoRadio",xmRowColumnWidgetClass,
    fileInfoRC,XmNpacking, XmPACK_COLUMN, XmNnumColumns, 3, NULL);
  XtVaSetValues(infoStereoRadio,XmNradioBehavior,True,NULL);

  infoLToggle=XtVaCreateManagedWidget("infoLToggle",
    xmToggleButtonWidgetClass,infoStereoRadio,NULL);
  text=XmStringCreateLocalized("L");
  XtVaSetValues(infoLToggle,XmNlabelString,text,XmNset,False,NULL);
  infoRToggle=XtVaCreateManagedWidget("infoRToggle",
    xmToggleButtonWidgetClass,infoStereoRadio,NULL);
  text=XmStringCreateLocalized("R");
  XtVaSetValues(infoRToggle,XmNlabelString,text,XmNset,False,NULL);
  infoLRToggle=XtVaCreateManagedWidget("infoLRToggle",
    xmToggleButtonWidgetClass,infoStereoRadio,NULL);
  text=XmStringCreateLocalized("L+R");
  XtVaSetValues(infoLRToggle,XmNlabelString,text,XmNset,True,NULL);


  loadFileInfo=XmFileSelectionBoxGetChild(loadFileBox,XmDIALOG_TEXT);
  XtAddCallback(loadFileInfo,XmNvalueChangedCallback,GetFileInfo,NULL);
  text=XmStringCreateSimple("."); 
/*
  loadSepar2=XtVaCreateManagedWidget("loadSepar2",xmSeparatorWidgetClass,
    fileInfoRC,NULL);
*/
  XtVaSetValues(loadFileBox,XmNdirectory,text,NULL);
  XtAddCallback(loadFileBox,XmNcancelCallback,Cancel,loadFileBox);
  XtAddCallback(loadFileBox,XmNokCallback,LoadOk,NULL);
  XtAddCallback(load,XmNactivateCallback,Load,NULL);


  /* CREATE SYNTH & SAVE BUTTON */
  save=XtVaCreateManagedWidget(
	"save",xmPushButtonWidgetClass,fileMenu,XmNmnemonic,XStringToKeysym("S"),
	XmNaccelerator,"Ctrl<Key>S",
    XmNacceleratorText,XmStringCreateLocalized("Ctrl+S"),NULL);
  text=XmStringCreateLocalized("Synth & Save");
  XtVaSetValues(save,XmNlabelString,text,NULL);

  saveFileBox=XmCreateFileSelectionDialog(mainWindow,"saveFileBox",NULL,0);
  temp=XmFileSelectionBoxGetChild(saveFileBox,XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(temp);
  text=XmStringCreateSimple("Synth & Save");
# ifdef SGI
  XtVaSetValues(saveFileBox,XmNdialogTitle,text,
    XmNwidth,300,NULL);
# else
  XtVaSetValues(saveFileBox,XmNdialogTitle,text,
    XmNwidth,500,NULL);
#endif
  text=XmStringCreateSimple(".");
  XtVaSetValues(saveFileBox,XmNdirectory,text,NULL);
  XtAddCallback(saveFileBox,XmNcancelCallback,Cancel,saveFileBox);
  XtAddCallback(saveFileBox,XmNokCallback,SaveOk,NULL);
  XtAddCallback(save,XmNactivateCallback,Save,NULL);





  /* CREATE PLAY BUTTON */
  play=XtVaCreateManagedWidget(
    "play",xmPushButtonWidgetClass,fileMenu,XmNmnemonic,XStringToKeysym("P"),XmNaccelerator,"Ctrl<Key>P",
    XmNacceleratorText,XmStringCreateLocalized("Ctrl+P"),NULL);
  text=XmStringCreateLocalized("Play...");
  XtVaSetValues(play,XmNlabelString,text,NULL);

  playFileBox=XmCreateFileSelectionDialog(mainWindow,"playFileBox",NULL,0);
  temp=XmFileSelectionBoxGetChild(playFileBox,XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(temp);
  text=XmStringCreateSimple("Play");
# ifdef SGI
  XtVaSetValues(playFileBox,XmNdialogTitle,text,
    XmNwidth,300,NULL);
# else
  XtVaSetValues(playFileBox,XmNdialogTitle,text,XmNautoUnmanage,False,
    XmNwidth,500,NULL);
#endif
  text=XmStringCreateSimple(".");
  XtVaSetValues(playFileBox,XmNdirectory,text,NULL);
  XtAddCallback(playFileBox,XmNcancelCallback,Cancel,playFileBox);
  XtAddCallback(playFileBox,XmNokCallback,PlayOk,NULL);
  XtAddCallback(play,XmNactivateCallback,Play,NULL);
  
   /* CREATE PLAY CURRENT BUTTON */
  playcurrent=XtVaCreateManagedWidget(
    "playcurrent",xmPushButtonWidgetClass,fileMenu,XmNmnemonic,XStringToKeysym("P"),XmNaccelerator,"<Key>P",
    XmNacceleratorText,XmStringCreateLocalized("P"),NULL);
  text=XmStringCreateLocalized("Play current");
  XtVaSetValues(playcurrent,XmNlabelString,text,NULL);
  XtAddCallback(playcurrent,XmNactivateCallback,Playcurrent,0);

  /* CREATE PREVIEW  CURRENT BUTTON */
  preview=XtVaCreateManagedWidget(
    "preview",xmPushButtonWidgetClass,fileMenu,XmNmnemonic,XStringToKeysym("P"),XmNaccelerator,"Shift<Key>P",
    XmNacceleratorText,XmStringCreateLocalized("Shift+P"),NULL);
  text=XmStringCreateLocalized("Preview");
  XtVaSetValues(preview,XmNlabelString,text,NULL);
  XtAddCallback(preview,XmNactivateCallback,Preview,0);

    /* CREATE IMPORT SUB-MENU */
  importButton=XtVaCreateManagedWidget(
    "importButton",xmCascadeButtonWidgetClass,/*menuBar*/fileMenu,NULL);
  text=XmStringCreateLocalized("Import");
  XtVaSetValues(importButton,XmNlabelString,text,NULL);
  importMenu=XmCreatePulldownMenu(fileMenu/*menuBar*/,"importMenu",NULL,0);
  XtVaSetValues(importButton,XmNsubMenuId,importMenu,NULL);

  /* CREATE LOAD CONTROL FUNCTION DATA BUTTON */
  loadfunc=XtVaCreateManagedWidget(
    "loadfunc",xmPushButtonWidgetClass,importMenu,NULL);
  text=XmStringCreateLocalized("Control function data");
  XtVaSetValues(loadfunc,XmNlabelString,text,NULL);

  loadfuncFileBox=XmCreateFileSelectionDialog(mainWindow,"loadfuncFileBox",NULL,0);
  temp=XmFileSelectionBoxGetChild(loadfuncFileBox,XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(temp);
  text=XmStringCreateSimple("Import control function data");
# ifdef SGI
  XtVaSetValues(loadfuncFileBox,XmNdialogTitle,text,
    XmNwidth,300,NULL);
# else
  XtVaSetValues(loadfuncFileBox,XmNdialogTitle,text,
    XmNwidth,500,NULL);
#endif
  text=XmStringCreateSimple(".");   /* "/ceres/" */
  XtVaSetValues(loadfuncFileBox,XmNdirectory,text,NULL);
  XtAddCallback(loadfuncFileBox,XmNcancelCallback,Cancel,loadfuncFileBox);
  XtAddCallback(loadfuncFileBox,XmNokCallback,LoadfuncOk,NULL);
  XtAddCallback(loadfunc,XmNactivateCallback,Loadfunc,NULL);


  /* CREATE LOAD AREA DATA BUTTON */
  loadarea=XtVaCreateManagedWidget(
    "loadarea",xmPushButtonWidgetClass,importMenu,NULL);
  text=XmStringCreateLocalized("Area data");
  XtVaSetValues(loadarea,XmNlabelString,text,NULL);

  loadareaFileBox=XmCreateFileSelectionDialog(mainWindow,"loadareaFileBox",NULL,0);
  temp=XmFileSelectionBoxGetChild(loadareaFileBox,XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(temp);
  text=XmStringCreateSimple("Import edit area data");
# ifdef SGI
  XtVaSetValues(loadareaFileBox,XmNdialogTitle,text,
    XmNwidth,300,NULL);
# else
  XtVaSetValues(loadareaFileBox,XmNdialogTitle,text,
    XmNwidth,500,NULL);
# endif
  text=XmStringCreateSimple("."); /*"/ceres/"*/
  XtVaSetValues(loadareaFileBox,XmNdirectory,text,NULL);
  XtAddCallback(loadareaFileBox,XmNcancelCallback,Cancel,loadareaFileBox);
  XtAddCallback(loadareaFileBox,XmNokCallback,LoadareaOk,NULL);
  XtAddCallback(loadarea,XmNactivateCallback,Loadarea,NULL);


 /* CREATE LOAD FFT DATA BUTTON */
  fftFile=XtVaCreateManagedWidget(
    "fftFile",xmPushButtonWidgetClass,importMenu,NULL);
  text=XmStringCreateLocalized("FFT Analysis data");
  XtVaSetValues(fftFile,XmNlabelString,text,NULL);

  fftFileBox=XmCreateFileSelectionDialog(mainWindow,"fftFileBox",NULL,0);
  temp=XmFileSelectionBoxGetChild(fftFileBox,XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(temp);
  text=XmStringCreateSimple("Import FFT sonogram analysis data");
# ifdef SGI
  XtVaSetValues(fftFileBox,XmNdialogTitle,text,
    XmNwidth,300,NULL);
# else
  XtVaSetValues(fftFileBox,XmNdialogTitle,text,
    XmNwidth,500,NULL);
# endif
  text=XmStringCreateSimple("."); /*"/ceres/"*/
  XtVaSetValues(fftFileBox,XmNdirectory,text,NULL);
  XtAddCallback(fftFileBox,XmNcancelCallback,Cancel,fftFileBox);
  XtAddCallback(fftFileBox,XmNokCallback,FFTFileOk,NULL);
  XtAddCallback(fftFile,XmNactivateCallback,FFTFile,NULL);

   /*Create IMPORT SEPARATOR*/

  importSepar = XtVaCreateManagedWidget("importSepar", xmSeparatorWidgetClass,
    importMenu, XmNorientation, XmHORIZONTAL, XmNy, 70, XmNwidth, 110, NULL);

   /* CREATE IMPORT IMAGE BUTTON */
  loadimage=XtVaCreateManagedWidget(
    "loadimage",xmPushButtonWidgetClass,importMenu,NULL);
  text=XmStringCreateLocalized("PBM ascii image");
  XtVaSetValues(loadimage,XmNlabelString,text,NULL);

  imageFileBox=XmCreateFileSelectionDialog(mainWindow,"imageFileBox",NULL,0);
  temp=XmFileSelectionBoxGetChild(imageFileBox,XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(temp);
  text=XmStringCreateSimple("Import PBM ascii image");
# ifdef SGI
  XtVaSetValues(imageFileBox,XmNdialogTitle,text,
    XmNwidth,330,NULL);
# else
  XtVaSetValues(imageFileBox,XmNdialogTitle,text,
    XmNwidth,550,NULL);
#endif


  imageRadio=XtVaCreateManagedWidget("imageRadio",xmRowColumnWidgetClass,
    imageFileBox,XmNpacking, XmPACK_COLUMN, XmNnumColumns, 5, NULL);
  XtVaSetValues(imageRadio,XmNradioBehavior,False,NULL);
  imageToggle=XtVaCreateManagedWidget("imageToggle",
    xmToggleButtonWidgetClass,imageRadio,NULL);
  text=XmStringCreateLocalized("Neg.");
  XtVaSetValues(imageToggle,XmNlabelString,text,XmNset,False,NULL);

  imageToggleFull=XtVaCreateManagedWidget("imageToggleFull",
    xmToggleButtonWidgetClass,imageRadio,NULL);
  text=XmStringCreateLocalized("Full");
  XtVaSetValues(imageToggleFull,XmNlabelString,text,XmNset,True,NULL);

  imageToggleR=XtVaCreateManagedWidget("imageToggleR",
    xmToggleButtonWidgetClass,imageRadio, NULL);
  text=XmStringCreateLocalized("R");
  XtVaSetValues(imageToggleR,XmNlabelString,text,XmNset,True, NULL);

  imageToggleG=XtVaCreateManagedWidget("imageToggleG",
    xmToggleButtonWidgetClass,imageRadio,  NULL);
  text=XmStringCreateLocalized("G");
  XtVaSetValues(imageToggleG,XmNlabelString,text,XmNset,True, NULL);

  imageToggleB=XtVaCreateManagedWidget("imageToggleB",
    xmToggleButtonWidgetClass,imageRadio, NULL);
  text=XmStringCreateLocalized("B");
  XtVaSetValues(imageToggleB,XmNlabelString,text,XmNset,True, NULL);

  XtAddCallback(imageFileBox,XmNcancelCallback,Cancel,imageFileBox);
  XtAddCallback(imageFileBox,XmNokCallback,ImageOk,NULL);
  XtAddCallback(loadimage,XmNactivateCallback,Image,NULL);


    /*_____________CREATE EXPORT SUB-MENU____________________________*/
  exportButton=XtVaCreateManagedWidget(
    "exportButton",xmCascadeButtonWidgetClass,/*menuBar*/fileMenu,NULL);
  text=XmStringCreateLocalized("Export");
  XtVaSetValues(exportButton,XmNlabelString,text,NULL);
  exportMenu=XmCreatePulldownMenu(fileMenu/*menuBar*/,"exportMenu",NULL,0);
  XtVaSetValues(exportButton,XmNsubMenuId,exportMenu,NULL);


  /* CREATE SAVE CONTROL FUNCTION DATA BUTTON */
  savefunc=XtVaCreateManagedWidget(
    "savefunc",xmPushButtonWidgetClass,exportMenu,NULL);
  text=XmStringCreateLocalized("Control function data");
  XtVaSetValues(savefunc,XmNlabelString,text,NULL);

  savefuncFileBox=XmCreateFileSelectionDialog(mainWindow,"savefuncFileBox",NULL,0);
  temp=XmFileSelectionBoxGetChild(savefuncFileBox,XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(temp);
  text=XmStringCreateSimple("Save control function data");
# ifdef SGI
  XtVaSetValues(savefuncFileBox,XmNdialogTitle,text,
    XmNwidth,300,NULL);
# else
  XtVaSetValues(savefuncFileBox,XmNdialogTitle,text,
    XmNwidth,500,NULL);
# endif
  text=XmStringCreateSimple("."); /*"/ceres/"*/
  XtVaSetValues(savefuncFileBox,XmNdirectory,text,NULL);
  XtAddCallback(savefuncFileBox,XmNcancelCallback,Cancel,savefuncFileBox);
  XtAddCallback(savefuncFileBox,XmNokCallback,SavefuncOk,NULL);
  XtAddCallback(savefunc,XmNactivateCallback,Savefunc,NULL);  


  /* CREATE SAVE AREA DATA BUTTON */
  savearea=XtVaCreateManagedWidget(
    "savearea",xmPushButtonWidgetClass,exportMenu,NULL);
  text=XmStringCreateLocalized("Area data");
  XtVaSetValues(savearea,XmNlabelString,text,NULL);

  saveareaFileBox=XmCreateFileSelectionDialog(mainWindow,"saveareaFileBox",NULL,0);
  temp=XmFileSelectionBoxGetChild(saveareaFileBox,XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(temp);
  text=XmStringCreateSimple("Save area data");
# ifdef SGI
  XtVaSetValues(saveareaFileBox,XmNdialogTitle,text,
    XmNwidth,300,NULL);
# else
  XtVaSetValues(saveareaFileBox,XmNdialogTitle,text,
    XmNwidth,500,NULL);
# endif
  text=XmStringCreateSimple(".");/*"/ceres/"*/
  XtVaSetValues(saveareaFileBox,XmNdirectory,text,NULL);
  XtAddCallback(saveareaFileBox,XmNcancelCallback,Cancel,saveareaFileBox);
  XtAddCallback(saveareaFileBox,XmNokCallback,SaveareaOk,NULL);
  XtAddCallback(savearea,XmNactivateCallback,Savearea,NULL);

  /* CREATE FFT BUTTON  */
  tofft=XtVaCreateManagedWidget(
    "tofft",xmPushButtonWidgetClass,exportMenu,NULL);
  text=XmStringCreateLocalized("FFT Analysis data");
  XtVaSetValues(tofft,XmNlabelString,text,NULL);

  tofftFileBox=XmCreateFileSelectionDialog(mainWindow,
    "tofftFileBox",NULL,0);
  temp=XmFileSelectionBoxGetChild(tofftFileBox,XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(temp);
  text=XmStringCreateSimple("Export FFT sonogram analysis data");
# ifdef SGI
  XtVaSetValues(tofftFileBox,XmNdialogTitle,text,
    XmNwidth,300,NULL);
# else
  XtVaSetValues(tofftFileBox,XmNdialogTitle,text,
    XmNwidth,500,NULL);
# endif
  XtAddCallback(tofftFileBox,XmNcancelCallback,Cancel,tofftFileBox);
  XtAddCallback(tofftFileBox,XmNokCallback,TofftOk,NULL);
  XtAddCallback(tofft,XmNactivateCallback,Tofft,NULL);

   /*Create EXPORT SEPARATOR*/

  exportSepar = XtVaCreateManagedWidget("exportSepar", xmSeparatorWidgetClass,
    exportMenu, XmNorientation, XmHORIZONTAL, XmNy, 70, XmNwidth, 110, NULL);


   /* CREATE CSOUND BUTTON  */
  tocsound=XtVaCreateManagedWidget(
    "tocsound",xmPushButtonWidgetClass,exportMenu,NULL);
  text=XmStringCreateLocalized("Csound scorefile");
  XtVaSetValues(tocsound,XmNlabelString,text,NULL);

  tocsoundFileBox=XmCreateFileSelectionDialog(mainWindow,
    "tocsoundFileBox",NULL,0);
  temp=XmFileSelectionBoxGetChild(tocsoundFileBox,XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(temp);
  text=XmStringCreateSimple("Export Csound score file");
# ifdef SGI
  XtVaSetValues(tocsoundFileBox,XmNdialogTitle,text,
    XmNwidth,300,NULL);
# else
  XtVaSetValues(tocsoundFileBox,XmNdialogTitle,text,
    XmNwidth,500,NULL);
# endif
  XtAddCallback(tocsoundFileBox,XmNcancelCallback,Cancel,tocsoundFileBox);
  XtAddCallback(tocsoundFileBox,XmNokCallback,TocsoundOk,NULL);
  XtAddCallback(tocsound,XmNactivateCallback,Tocsound,NULL);

  /* CREATE CSOUND OPENING WARNING */
  csoundWarning=XmCreateWarningDialog(mainWindow,"csoundWarning",NULL,0);
  temp=XmMessageBoxGetChild(csoundWarning,XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(temp);
  temp=XmMessageBoxGetChild(csoundWarning,XmDIALOG_CANCEL_BUTTON);
  XtUnmanageChild(temp);
  text=XmStringCreateSimple("Error!");
  XtVaSetValues(csoundWarning,XmNdialogTitle,text,
    XmNwidth,400,NULL);
  text=XmStringCreateSimple("Can't open file");
  XtVaSetValues(csoundWarning,XmNmessageString,text,NULL);


  /* CREATE PARMERUD BUTTON */
  toparmerud=XtVaCreateManagedWidget(
    "toparmerud",xmPushButtonWidgetClass,exportMenu,NULL);
  text=XmStringCreateLocalized("Parmerud Csound scorefile");
  XtVaSetValues(toparmerud,XmNlabelString,text,NULL);

  toparmerudFileBox=XmCreateFileSelectionDialog(mainWindow,
    "toparmerudFileBox",NULL,0);
  temp=XmFileSelectionBoxGetChild(toparmerudFileBox,XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(temp);
  text=XmStringCreateSimple("Export Parmerud Csound score file");
# ifdef SGI
  XtVaSetValues(toparmerudFileBox,XmNdialogTitle,text,
    XmNwidth,300,NULL);
# else
  XtVaSetValues(toparmerudFileBox,XmNdialogTitle,text,
    XmNwidth,400,NULL);
 # endif
  parmerudRowCol=XtVaCreateManagedWidget("parmerudRowCol",xmRowColumnWidgetClass,
    toparmerudFileBox,NULL);
  text=XmStringCreateLocalized("Trigging threshold");
  parmL1=XtVaCreateManagedWidget("parmL1",xmLabelWidgetClass,
    parmerudRowCol,XmNlabelString,text,NULL); XmStringFree(text);
  parmT1=XtVaCreateManagedWidget("parmT1",
    xmTextFieldWidgetClass,parmerudRowCol,NULL);
  XtVaSetValues(parmT1,XmNwidth,100,XmNvalue,"10",NULL);
  text=XmStringCreateLocalized("Hysteresis time");
  parmL2=XtVaCreateManagedWidget("parmL2",xmLabelWidgetClass,
    parmerudRowCol,XmNlabelString,text,NULL); XmStringFree(text);
  parmT2=XtVaCreateManagedWidget("parmT2",
    xmTextFieldWidgetClass,parmerudRowCol,NULL);
  XtVaSetValues(parmT2,XmNwidth,100,XmNvalue,"1",NULL);
  text=XmStringCreateLocalized("Strings per octave");
  parmL3=XtVaCreateManagedWidget("parmL3",xmLabelWidgetClass,
    parmerudRowCol,XmNlabelString,text,NULL); XmStringFree(text);
  parmT3=XtVaCreateManagedWidget("parmT3",
    xmTextFieldWidgetClass,parmerudRowCol,NULL);
  XtVaSetValues(parmT3,XmNwidth,100,XmNvalue,"6",NULL);
  text=XmStringCreateLocalized("Resonance time");
  parmL4=XtVaCreateManagedWidget("parmL4",xmLabelWidgetClass,
    parmerudRowCol,XmNlabelString,text,NULL); XmStringFree(text);
  parmT4=XtVaCreateManagedWidget("parmT4",
    xmTextFieldWidgetClass,parmerudRowCol,NULL);
  XtVaSetValues(parmT4,XmNwidth,100,XmNvalue,"1",NULL);
  XtAddCallback(toparmerudFileBox,XmNcancelCallback,Cancel,toparmerudFileBox);
  XtAddCallback(toparmerudFileBox,XmNokCallback,ToparmerudOk,NULL);
  XtAddCallback(toparmerud,XmNactivateCallback,Toparmerud,NULL);


  /* CREATE PEAK BUTTON */
  topeak=XtVaCreateManagedWidget(
    "topeak",xmPushButtonWidgetClass,exportMenu,NULL);
  text=XmStringCreateLocalized("Spectral peaks");
  XtVaSetValues(topeak,XmNlabelString,text,NULL);

  topeakFileBox=XmCreateFileSelectionDialog(mainWindow,
    "topeakFileBox",NULL,0);
  temp=XmFileSelectionBoxGetChild(topeakFileBox,XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(temp);
  text=XmStringCreateSimple("Export spectral peaks");
# ifdef SGI
  XtVaSetValues(topeakFileBox,XmNdialogTitle,text,
    XmNwidth,300,NULL);
# else
  XtVaSetValues(topeakFileBox,XmNdialogTitle,text,
    XmNwidth,500,NULL);
# endif
  XtAddCallback(topeakFileBox,XmNcancelCallback,Cancel,topeakFileBox);
  XtAddCallback(topeakFileBox,XmNokCallback,TopeakOk,NULL);
  XtAddCallback(topeak,XmNactivateCallback,Topeak,NULL);


  /* CREATE SCULPT BUTTON */

  sculpt=XtVaCreateManagedWidget(
    "sculpt",xmPushButtonWidgetClass,exportMenu,NULL);
  text=XmStringCreateLocalized("IRCAM partials");
  XtVaSetValues(sculpt,XmNlabelString,text,NULL);

  sculptFileBox=XmCreateFileSelectionDialog(mainWindow,
    "sculptFileBox",NULL,0);
  temp=XmFileSelectionBoxGetChild(sculptFileBox,XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(temp);
  text=XmStringCreateSimple("Export IRCAM partials file");
  XtVaSetValues(sculptFileBox,XmNdialogTitle,text,
    XmNwidth,360,NULL);
  sculptRowCol=XtVaCreateManagedWidget("sculptRowCol",xmRowColumnWidgetClass,
    sculptFileBox,NULL);

  text=XmStringCreateLocalized("Relative amplitude detection threshold (dB)");
  sculptAL=XtVaCreateManagedWidget("sculptAL",xmLabelWidgetClass,
    sculptRowCol,XmNlabelString,text,NULL); XmStringFree(text);
  sculptA=XtVaCreateManagedWidget("sculptA",
    xmTextFieldWidgetClass,sculptRowCol,NULL);
  XtVaSetValues(sculptA,XmNwidth,100,XmNvalue,"-20",NULL);



  text=XmStringCreateLocalized("Min. duration of partials (sec)");
  sculptDL=XtVaCreateManagedWidget("sculptDL",xmLabelWidgetClass,
    sculptRowCol,XmNlabelString,text,NULL); XmStringFree(text);
  sculptD=XtVaCreateManagedWidget("sculptD",
    xmTextFieldWidgetClass,sculptRowCol,NULL);
  XtVaSetValues(sculptD,XmNwidth,100,XmNvalue,"0.1",NULL);

/*
  text=XmStringCreateLocalized("Maximum break between partials (sec)");
  sculptBL=XtVaCreateManagedWidget("sculptBL",xmLabelWidgetClass,
    sculptRowCol,XmNlabelString,text,NULL); XmStringFree(text);
  sculptB=XtVaCreateManagedWidget("sculptB",
    xmTextFieldWidgetClass,sculptRowCol,NULL);
  XtVaSetValues(sculptB,XmNwidth,100,XmNvalue,"0.04",NULL);
*/

  text=XmStringCreateLocalized("Max. frequency jump between points (cents)");
  sculptFJL=XtVaCreateManagedWidget("sculptFJL",xmLabelWidgetClass,
    sculptRowCol,XmNlabelString,text,NULL); XmStringFree(text);
  sculptFJ=XtVaCreateManagedWidget("sculptFJ",
    xmTextFieldWidgetClass,sculptRowCol,NULL);
  XtVaSetValues(sculptFJ,XmNwidth,100,XmNvalue,"1200",NULL);

  sculptToggle=XtVaCreateManagedWidget("sculptToggle",
    xmToggleButtonWidgetClass,sculptRowCol,NULL);
  text=XmStringCreateLocalized("Ignore start time offset");
  XtVaSetValues(sculptToggle,XmNlabelString,text,XmNset,False,
   /* XmNy,200,*/NULL);


  XtAddCallback(sculptFileBox,XmNcancelCallback,Cancel,sculptFileBox);
  XtAddCallback(sculptFileBox,XmNokCallback,sculptOk,NULL);
  XtAddCallback(sculpt,XmNactivateCallback,Sculpt,NULL);

  /* CREATE STF BUTTON */
  tostf=XtVaCreateManagedWidget(
    "tostf",xmPushButtonWidgetClass,exportMenu,NULL);
  text=XmStringCreateLocalized("Inventor visualization file");
  XtVaSetValues(tostf,XmNlabelString,text,NULL);

  tostfFileBox=XmCreateFileSelectionDialog(mainWindow,
    "tostfFileBox",NULL,0);
  temp=XmFileSelectionBoxGetChild(tostfFileBox,XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(temp);
  text=XmStringCreateSimple("Export STF visualization file");

  stfRC=XtVaCreateManagedWidget("stfRC",xmRowColumnWidgetClass,
    tostfFileBox,NULL);
 stfFractionRadio=XtVaCreateManagedWidget("stfFractionRadio",xmRowColumnWidgetClass,
    stfRC,XmNpacking, XmPACK_COLUMN, XmNnumColumns, 4, NULL);
  XtVaSetValues(stfFractionRadio,XmNradioBehavior,True,NULL);

  stfFullToggle=XtVaCreateManagedWidget("stfFullToggle",
    xmToggleButtonWidgetClass,stfFractionRadio,NULL);
  text=XmStringCreateLocalized("Full");
  XtVaSetValues(stfFullToggle,XmNlabelString,text,XmNset,False,NULL);

  stfHalfToggle=XtVaCreateManagedWidget("stfHalfToggle",
    xmToggleButtonWidgetClass,stfFractionRadio,NULL);
  text=XmStringCreateLocalized("Half");
  XtVaSetValues(stfHalfToggle,XmNlabelString,text,XmNset,True,NULL);

  stfThirdToggle=XtVaCreateManagedWidget("stfThirdToggle",
    xmToggleButtonWidgetClass,stfFractionRadio,NULL);
  text=XmStringCreateLocalized("Third");
  XtVaSetValues(stfThirdToggle,XmNlabelString,text,XmNset,False,NULL);

  stfSixthToggle=XtVaCreateManagedWidget("stfThirdToggle",
    xmToggleButtonWidgetClass,stfFractionRadio,NULL);
  text=XmStringCreateLocalized("Sixth");
  XtVaSetValues(stfSixthToggle,XmNlabelString,text,XmNset,False,NULL);

# ifdef SGI
  XtVaSetValues(tostfFileBox,XmNdialogTitle,text,
    XmNwidth,300,NULL);
# else
  XtVaSetValues(tostfFileBox,XmNdialogTitle,text,
    XmNwidth,500,NULL);
#endif
  XtAddCallback(tostfFileBox,XmNcancelCallback,Cancel,tostfFileBox);
  XtAddCallback(tostfFileBox,XmNokCallback,TostfOk,NULL);
  XtAddCallback(tostf,XmNactivateCallback,Tostf,NULL);

  /* CREATE STF OPENING WARNING */
  stfWarning=XmCreateErrorDialog(mainWindow,"stfWarning",NULL,0);
  temp=XmMessageBoxGetChild(stfWarning,XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(temp);
  temp=XmMessageBoxGetChild(stfWarning,XmDIALOG_CANCEL_BUTTON);
  XtUnmanageChild(temp);
  text=XmStringCreateSimple("Error!");
  XtVaSetValues(stfWarning,XmNdialogTitle,text,
    XmNwidth,400,NULL);
  text=XmStringCreateSimple("Can't open file");
  XtVaSetValues(stfWarning,XmNmessageString,text,NULL);


  /* CREATE TOLTAS BUTTON */
  toltas=XtVaCreateManagedWidget(
    "toltas",xmPushButtonWidgetClass,exportMenu,NULL);
  text=XmStringCreateLocalized("Single LTAS frame");
  XtVaSetValues(toltas,XmNlabelString,text,NULL);

  toltasFileBox=XmCreateFileSelectionDialog(mainWindow,
    "toltasFileBox",NULL,0);
  temp=XmFileSelectionBoxGetChild(toltasFileBox,XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(temp);
  text=XmStringCreateSimple("Export single LTAS frame file");
# ifdef SGI
  XtVaSetValues(toltasFileBox,XmNdialogTitle,text,
    XmNwidth,300,NULL);
# else
  XtVaSetValues(toltasFileBox,XmNdialogTitle,text,
    XmNwidth,500,NULL);
#endif
  XtAddCallback(toltasFileBox,XmNcancelCallback,Cancel,toltasFileBox);
  XtAddCallback(toltasFileBox,XmNokCallback,ToltasOk,NULL);
  XtAddCallback(toltas,XmNactivateCallback,Toltas,NULL);


  /* CREATE LTAS OPENING WARNING */
  ltasWarning=XmCreateErrorDialog(mainWindow,"ltasWarning",NULL,0);
  temp=XmMessageBoxGetChild(ltasWarning,XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(temp);
  temp=XmMessageBoxGetChild(ltasWarning,XmDIALOG_CANCEL_BUTTON);
  XtUnmanageChild(temp);
  text=XmStringCreateSimple("Error!");
  XtVaSetValues(ltasWarning,XmNdialogTitle,text,
    XmNwidth,400,NULL);
  text=XmStringCreateSimple("Can't open file");
  XtVaSetValues(ltasWarning,XmNmessageString,text,NULL);

 /* CREATE CLOSE BUTTON */

  closeW=XtVaCreateManagedWidget(
    "close",xmPushButtonWidgetClass,fileMenu,XmNmnemonic,XStringToKeysym("W"),
     XmNaccelerator,"Ctrl<Key>W",XmNacceleratorText,XmStringCreateLocalized("Ctrl+W"),
     NULL);
  text=XmStringCreateLocalized("Close");
  XtVaSetValues(closeW,XmNlabelString,text,NULL);
  XtAddCallback(closeW,XmNactivateCallback,CloseW,0);

  /* CREATE CLOSE WARNING */
  closeWarning=XmCreateQuestionDialog(mainWindow,"closeWarning",NULL,0);
  temp=XmMessageBoxGetChild(closeWarning,XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(temp);
  text=XmStringCreateSimple("Close");
  XtVaSetValues(closeWarning,XmNdialogTitle,text,
    XmNwidth,260,NULL);
/*
  text=XmStringCreateSimple(" Quit Ceres3 now ?");
*/
text=XmStringCreateLtoR(" Close this Ceres3 session ?",XmFONTLIST_DEFAULT_TAG);
  XtVaSetValues(closeWarning,XmNmessageString,text,NULL);
  XtAddCallback(closeWarning,XmNcancelCallback,Cancel,closeWarning);
  XtAddCallback(closeWarning,XmNokCallback,CloseIt,NULL);

  /* CREATE QUIT BUTTON */
  quit=XtVaCreateManagedWidget(
    "quit",xmPushButtonWidgetClass,fileMenu,XmNmnemonic,XStringToKeysym("Q"),
     XmNaccelerator,"Ctrl<Key>Q",XmNacceleratorText,XmStringCreateLocalized("Ctrl+Q"),
     NULL);
  text=XmStringCreateLocalized("Quit");
  XtVaSetValues(quit,XmNlabelString,text,NULL);
  XtAddCallback(quit,XmNactivateCallback,Quit,0);

  /* CREATE QUIT PROGRAM WARNING */
  quitWarning=XmCreateQuestionDialog(mainWindow,"quitWarning",NULL,0);
  temp=XmMessageBoxGetChild(quitWarning,XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(temp);
  text=XmStringCreateSimple("Quit");
  XtVaSetValues(quitWarning,XmNdialogTitle,text,
    XmNwidth,250,NULL);
/*
  text=XmStringCreateSimple(" Quit Ceres3 now ?");
*/
text=XmStringCreateLtoR(" Quit Ceres3 now ?",XmFONTLIST_DEFAULT_TAG);
  XtVaSetValues(quitWarning,XmNmessageString,text,NULL);
  XtAddCallback(quitWarning,XmNcancelCallback,Cancel,quitWarning);
  XtAddCallback(quitWarning,XmNokCallback,QuitOk,NULL);

  /* CREATE FILE OPENING WARNING */
  fileWarning=XmCreateErrorDialog(mainWindow,"fileWarning",NULL,0);
  temp=XmMessageBoxGetChild(fileWarning,XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(temp);
  temp=XmMessageBoxGetChild(fileWarning,XmDIALOG_CANCEL_BUTTON);
  XtUnmanageChild(temp);
  text=XmStringCreateSimple("Error!");
  XtVaSetValues(fileWarning,XmNdialogTitle,text,
    XmNwidth,300,NULL);
  text=XmStringCreateSimple("Can't open file");
  XtVaSetValues(fileWarning,XmNmessageString,text,NULL);

  /* CREATE UNDO WARNING */
  undoWarning=XmCreateWarningDialog(mainWindow,"undoWarning",NULL,0);
  temp=XmMessageBoxGetChild(undoWarning,XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(temp);
  temp=XmMessageBoxGetChild(undoWarning,XmDIALOG_CANCEL_BUTTON);
  XtUnmanageChild(temp);
  text=XmStringCreateSimple("Error: Can't Undo!");
  XtVaSetValues(undoWarning,XmNdialogTitle,text,
    XmNwidth,320,NULL);
  text=XmStringCreateSimple("\"Undo/Redo allow\" has to be selected");
  XtVaSetValues(undoWarning,XmNmessageString,text,NULL);


  /* CREATE FILE WRITE WARNING */
  writeWarning=XmCreateErrorDialog(mainWindow,"writeWarning",NULL,0);
  temp=XmMessageBoxGetChild(writeWarning,XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(temp);
  temp=XmMessageBoxGetChild(writeWarning,XmDIALOG_CANCEL_BUTTON);
  XtUnmanageChild(temp);
  text=XmStringCreateSimple("Error!");
  XtVaSetValues(writeWarning,XmNdialogTitle,text,
    XmNwidth,400,NULL);
  text=XmStringCreateSimple("Can't write to file");
  XtVaSetValues(writeWarning,XmNmessageString,text,NULL);
 

  /* CREATE FILE SIZE WARNING */
  sizeWarning=XmCreateWarningDialog(mainWindow,"sizeWarning",NULL,0);
  temp=XmMessageBoxGetChild(sizeWarning,XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(temp);
  temp=XmMessageBoxGetChild(sizeWarning,XmDIALOG_CANCEL_BUTTON);
  XtUnmanageChild(temp);
  text=XmStringCreateSimple("Error!");
  XtVaSetValues(sizeWarning,XmNdialogTitle,text,
    XmNwidth,400,NULL);
  text=XmStringCreateLtoR(
    "Sorry, can't handle soundfiles that large",
    XmFONTLIST_DEFAULT_TAG);
  XtVaSetValues(sizeWarning,XmNmessageString,text,NULL);
  /* CREATE FUNDAMENTAL WARNING */
  fundWarning=XmCreateErrorDialog(mainWindow,"fundWarning",NULL,0);
  temp=XmMessageBoxGetChild(sizeWarning,XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(temp);
  temp=XmMessageBoxGetChild(fundWarning,XmDIALOG_CANCEL_BUTTON);
  XtUnmanageChild(temp);
  text=XmStringCreateSimple("Error!");
  XtVaSetValues(fundWarning,XmNdialogTitle,text,
    XmNwidth,300,NULL);
  text=XmStringCreateLtoR(
    "You should extract fundamental first",
    XmFONTLIST_DEFAULT_TAG);
  XtVaSetValues(fundWarning,XmNmessageString,text,NULL);

printf(". ");
 /* CREATE EDIT MENU*/
  editButton=XtVaCreateManagedWidget(
    "editButton",xmCascadeButtonWidgetClass,menuBar,
	XmNmnemonic,XStringToKeysym("E"),
	NULL);
  text=XmStringCreateLocalized("Edit");
  XtVaSetValues(editButton,XmNlabelString,text,NULL);
  editMenu=XmCreatePulldownMenu(menuBar,"editMenu",NULL,0);
  XtVaSetValues(editButton,XmNsubMenuId,editMenu,NULL);


/* CREATE Undo BUTTON */
  undo=XtVaCreateManagedWidget(
    "undo",xmPushButtonWidgetClass,editMenu,XmNmnemonic,XStringToKeysym("Z"),
	XmNaccelerator,"Ctrl<Key>Z",
    XmNacceleratorText,XmStringCreateLocalized("Ctrl+Z"),NULL);
  text=XmStringCreateLocalized("Undo");
  XtVaSetValues(undo,XmNlabelString,text,NULL);
  XtAddCallback(undo,XmNactivateCallback,Undo,0);

/* CREATE Redo BUTTON */
  redo=XtVaCreateManagedWidget(
    "redo",xmPushButtonWidgetClass,editMenu,XmNmnemonic,XStringToKeysym("Y"),XmNaccelerator,"Ctrl<Key>Y",
    XmNacceleratorText,XmStringCreateLocalized("Ctrl+Y"),NULL);
  text=XmStringCreateLocalized("Redo");
  XtVaSetValues(redo,XmNlabelString,text,NULL);
  XtAddCallback(redo,XmNactivateCallback,Redo,0);

/* CREATE Copy BUTTON */
  copy=XtVaCreateManagedWidget(
    "copy",xmPushButtonWidgetClass,editMenu,XmNmnemonic,XStringToKeysym("C"),XmNaccelerator,"Ctrl<Key>C",
    XmNacceleratorText,XmStringCreateLocalized("Ctrl+C"),NULL);
  text=XmStringCreateLocalized("Copy");
  XtVaSetValues(copy,XmNlabelString,text,NULL);
  XtAddCallback(copy,XmNactivateCallback,Copy,0);

/* CREATE Cut BUTTON */
  cut=XtVaCreateManagedWidget(
    "cut",xmPushButtonWidgetClass,editMenu,XmNmnemonic,XStringToKeysym("X"),XmNaccelerator,"Ctrl<Key>X",
    XmNacceleratorText,XmStringCreateLocalized("Ctrl+X"),NULL);
  text=XmStringCreateLocalized("Cut");
  XtVaSetValues(cut,XmNlabelString,text,NULL);
  XtAddCallback(cut,XmNactivateCallback,Cut,0);

/* CREATE Paste BUTTON */
  paste=XtVaCreateManagedWidget(
    "paste",xmPushButtonWidgetClass,editMenu,XmNmnemonic,XStringToKeysym("V"),XmNaccelerator,"Ctrl<Key>V",
    XmNacceleratorText,XmStringCreateLocalized("Ctrl+V"),NULL);
  text=XmStringCreateLocalized("Paste");
  XtVaSetValues(paste,XmNlabelString,text,NULL);
  XtAddCallback(paste,XmNactivateCallback,Paste,0);

/* CREATE Extract BUTTON */
  extract=XtVaCreateManagedWidget(
    "extract",xmPushButtonWidgetClass,editMenu,XmNmnemonic,XStringToKeysym("E"),XmNaccelerator,"Ctrl<Key>E",
    XmNacceleratorText,XmStringCreateLocalized("Ctrl+E"),NULL);
  text=XmStringCreateLocalized("Extract");
  XtVaSetValues(extract,XmNlabelString,text,NULL);


  extractForm=XmCreateBulletinBoardDialog(mainWindow,"extractForm",NULL,0);
  extractOkButton=XtVaCreateManagedWidget("extractOk",xmPushButtonWidgetClass,
    extractForm,NULL);
  text=XmStringCreateLocalized("Ok");
  XtVaSetValues(extractOkButton,XmNlabelString,text,XmNx,40,XmNy,400,
    XmNwidth,90,NULL);
  extractCancelButton=XtVaCreateManagedWidget("extractCancel",
    xmPushButtonWidgetClass,extractForm,NULL);
  text=XmStringCreateLocalized("Cancel");
  XtVaSetValues(extractCancelButton,XmNlabelString,text,XmNx,190,XmNy,400,NULL);

    text=XmStringCreateLocalized("Extract");
  XtVaSetValues(extractForm,XmNdialogTitle,text,
    XmNcancelButton,extractCancelButton,
    XmNdefaultButton,extractOkButton,NULL);

 extractLabel1=XtVaCreateManagedWidget("extractLabel1",xmLabelWidgetClass,
    extractForm,NULL);
  text=XmStringCreateLocalized("From:");
  XtVaSetValues(extractLabel1,XmNlabelString,text,XmNx,0,XmNy,0,NULL);

  extractLabel2=XtVaCreateManagedWidget("extractLabel2",xmLabelWidgetClass,
    extractForm,NULL);
  text=XmStringCreateLocalized("To:");
  XtVaSetValues(extractLabel2,XmNlabelString,text,XmNx,150,XmNy,0,NULL);

  extractToggle1=XtVaCreateManagedWidget("extractToggle1",
    xmToggleButtonWidgetClass,extractForm,XmNset,False,NULL);
  text=XmStringCreateLocalized("Amplitude              -> Control function 1");
  XtVaSetValues(extractToggle1,XmNlabelString,text,XmNset,False,
    XmNy,25,NULL);

  extractSepar0=XtVaCreateManagedWidget("extractSepar0", xmSeparatorWidgetClass,
    extractForm, XmNorientation, XmHORIZONTAL, XmNy, 52, XmNwidth, 295, NULL);

  extractToggle2=XtVaCreateManagedWidget("extractToggle2",
    xmToggleButtonWidgetClass,extractForm,XmNset,False,NULL);
  text=XmStringCreateLocalized("Fundamental         -> Control function 2");
  XtVaSetValues(extractToggle2,XmNlabelString,text,XmNset,False,
    XmNy,55,NULL);

extractTextfield2=XtVaCreateManagedWidget("extractTextfield2",
    xmTextFieldWidgetClass,extractForm,NULL);
  XtVaSetValues(extractTextfield2,XmNwidth,70,XmNx,115,XmNy,85,
    XmNvalue,"100",NULL);
  extractLabel4=XtVaCreateManagedWidget("extractLabel4",xmLabelWidgetClass,
    extractForm,NULL);
  text=XmStringCreateLocalized("Frequency:");
  XtVaSetValues(extractLabel4,XmNlabelString,text,XmNx,35,XmNy,90,NULL);

extractTextfield3=XtVaCreateManagedWidget("extractTextfield3",
    xmTextFieldWidgetClass,extractForm,NULL);
  XtVaSetValues(extractTextfield3,XmNwidth,70,XmNx,210,XmNy,85,
    XmNvalue,"1000",NULL);
  extractLabel5=XtVaCreateManagedWidget("extractLabel5",xmLabelWidgetClass,
    extractForm,NULL);
  text=XmStringCreateLocalized("-");
  XtVaSetValues(extractLabel5,XmNlabelString,text,XmNx,192,XmNy,90,NULL);

   extractToggle3=XtVaCreateManagedWidget("extractToggle3",
    xmToggleButtonWidgetClass,extractForm,NULL);
  text=XmStringCreateLocalized("Read frequency from CF-2");
  XtVaSetValues(extractToggle3,XmNlabelString,text,XmNset,False,
    XmNx, 50,XmNy,117,NULL);

extractTextfield4=XtVaCreateManagedWidget("extractTextfield4",
    xmTextFieldWidgetClass,extractForm,NULL);
  XtVaSetValues(extractTextfield4,XmNwidth,70,XmNx,210,XmNy,145,
    XmNvalue,"70",NULL);
  extractLabel6=XtVaCreateManagedWidget("extractLabel6",xmLabelWidgetClass,
    extractForm,NULL);
  text=XmStringCreateLocalized("Probability (%):");
  XtVaSetValues(extractLabel6,XmNlabelString,text,XmNx,35,XmNy,150,NULL);

   extractToggle4=XtVaCreateManagedWidget("extractToggle4",
    xmToggleButtonWidgetClass,extractForm,NULL);
  text=XmStringCreateLocalized("Read probability from CF-1");
  XtVaSetValues(extractToggle4,XmNlabelString,text,XmNset,False,
    XmNx, 50,XmNy,177,NULL);

extractTextfield6=XtVaCreateManagedWidget("extractTextfield6",
    xmTextFieldWidgetClass,extractForm,NULL);
  XtVaSetValues(extractTextfield6,XmNwidth,70,XmNx,210,XmNy,207,
    XmNvalue,"10",NULL);
  extractLabel8=XtVaCreateManagedWidget("extractLabel8",xmLabelWidgetClass,
    extractForm,NULL);
  text=XmStringCreateLocalized("Error margin (Hz):");
  XtVaSetValues(extractLabel8,XmNlabelString,text,XmNx,35,XmNy,212,NULL);

extractTextfield5=XtVaCreateManagedWidget("extractTextfield5",
    xmTextFieldWidgetClass,extractForm,NULL);
  XtVaSetValues(extractTextfield5,XmNwidth,70,XmNx,210,XmNy,240,
    XmNvalue,"16",NULL);
  extractLabel7=XtVaCreateManagedWidget("extractLabel7",xmLabelWidgetClass,
    extractForm,NULL);
  text=XmStringCreateLocalized("Number of partials:");
  XtVaSetValues(extractLabel7,XmNlabelString,text,XmNx,35,XmNy,245,NULL);


 extractM=XtVaCreateManagedWidget("extractM", 
	xmRowColumnWidgetClass,extractForm,NULL);
 
 newMmode=XmStringCreateLocalized("Harmonic series:        ");
 all=XmStringCreateLocalized("whole");		
 odd=XmStringCreateLocalized("odd");
 noi=XmStringCreateLocalized("noisy");

 extractMOption=XmVaCreateSimpleOptionMenu(extractM,"extractMOption",
	newMmode,'H', 0,exOption,
	XmVaPUSHBUTTON,all, NULL,NULL,NULL,
    XmVaPUSHBUTTON,odd, NULL,NULL,NULL,
    XmVaPUSHBUTTON,noi, NULL,NULL,NULL,
	NULL);

XmStringFree(newMmode); XmStringFree(all);XmStringFree(odd);XmStringFree(noi);
XtManageChild(extractMOption);
#ifdef SGI
XtVaSetValues(extractM,XmNx,30,XmNy,275,NULL);
#else
XtVaSetValues(extractM,XmNx,30,XmNy,272,NULL);
#endif

  extractSepar3=XtVaCreateManagedWidget("extractSepar3", xmSeparatorWidgetClass,
    extractForm, XmNorientation, XmHORIZONTAL, XmNy, 315, XmNwidth, 295, NULL);

   extractToggle6=XtVaCreateManagedWidget("extractToggle6",
    xmToggleButtonWidgetClass,extractForm,NULL);
  text=XmStringCreateLocalized("Average spectrum -> Control function 3");
  XtVaSetValues(extractToggle6,XmNlabelString,text,XmNset,False,
    XmNy,320,NULL);

   extractSepar=XtVaCreateManagedWidget("extractSepar", xmSeparatorWidgetClass,
    extractForm, XmNorientation, XmHORIZONTAL, XmNy, 350, XmNwidth, 295, NULL);
extractTextfield=XtVaCreateManagedWidget("extractTextfield",
    xmTextFieldWidgetClass,extractForm,NULL);
  XtVaSetValues(extractTextfield,XmNwidth,70,XmNx,210,XmNy,355,
    XmNvalue,"40",NULL);
  extractLabel3=XtVaCreateManagedWidget("extractLabel3",xmLabelWidgetClass,
    extractForm,NULL);
  text=XmStringCreateLocalized("Number of points:");
  XtVaSetValues(extractLabel3,XmNlabelString,text,XmNx,0,XmNy,360,NULL);
  extractSepar1=XtVaCreateManagedWidget("extractSepar1", xmSeparatorWidgetClass,
    extractForm, XmNorientation, XmHORIZONTAL, XmNy, 392, XmNwidth, 295, NULL);
  XtAddCallback(extractOkButton,XmNactivateCallback,extractOk,NULL);
  XtAddCallback(extract,XmNactivateCallback,Extract,0);

 /*CREATE CONTROL FUNCTIONS BUTTON*/
  controlfunction=XtVaCreateManagedWidget(
    "controlfunction",xmPushButtonWidgetClass,editMenu,XmNmnemonic,XStringToKeysym("f"),XmNaccelerator,"Ctrl<Key>F",
    XmNacceleratorText,XmStringCreateLocalized("Ctrl+F"),NULL);
  text=XmStringCreateLocalized("Control function");
  XtVaSetValues(controlfunction,XmNlabelString,text,NULL);

  controlfunctionForm=XmCreateBulletinBoardDialog(mainWindow,"controlfunctionForm",NULL,0);
  controlfunctionOkButton=XtVaCreateManagedWidget("controlfunctionOk",xmPushButtonWidgetClass,
    controlfunctionForm,NULL);
  text=XmStringCreateLocalized("Ok");
  XtVaSetValues(controlfunctionOkButton,XmNlabelString,text,XmNx,50,XmNy,325,
    XmNwidth,90,NULL);
  controlfunctionCancelButton=XtVaCreateManagedWidget("controlfunctionCancel",
    xmPushButtonWidgetClass,controlfunctionForm,NULL);
  text=XmStringCreateLocalized("Cancel");
  XtVaSetValues(controlfunctionCancelButton,XmNlabelString,text,XmNx,200,XmNy,325,NULL);

    text=XmStringCreateLocalized("Edit active control function");
  XtVaSetValues(controlfunctionForm,XmNdialogTitle,text,
    XmNcancelButton,controlfunctionCancelButton,
    XmNdefaultButton,controlfunctionOkButton,NULL);
    
   controlfunctionRadio=XtVaCreateManagedWidget("controlfunctionRadio",
    xmRowColumnWidgetClass,controlfunctionForm,NULL);
  XtVaSetValues(controlfunctionRadio,XmNy,10,XmNradioBehavior,True,
    XmNradioAlwaysOne,True,NULL);
  controlfunctionSlideToggle=XtVaCreateManagedWidget("Slide (by -100 - 100 %)",
    xmToggleButtonWidgetClass,controlfunctionRadio,XmNset,True,NULL);
  controlfunctionScaleToggle=XtVaCreateManagedWidget("Scale (by    0 - 500 %)",
    xmToggleButtonWidgetClass,controlfunctionRadio,/*XmNset,False,*/NULL);
  controlfunctionShiftToggle=XtVaCreateManagedWidget("Shift (by    points:  )",
    xmToggleButtonWidgetClass,controlfunctionRadio,/*XmNset,False,*/NULL);
  controlfunctionMirrorToggle=XtVaCreateManagedWidget("Mirror",
    xmToggleButtonWidgetClass,controlfunctionRadio,/*XmNset,False,*/NULL);
  controlfunctionRetroToggle=XtVaCreateManagedWidget("Retro",
    xmToggleButtonWidgetClass,controlfunctionRadio,/*XmNset,False,*/NULL);
  controlfunctionResetToggle=XtVaCreateManagedWidget("Reset",
    xmToggleButtonWidgetClass,controlfunctionRadio,/*XmNset,False,*/NULL);
  controlfunctionAddToggle=XtVaCreateManagedWidget("Add  control functions",
    xmToggleButtonWidgetClass,controlfunctionRadio,/*XmNset,False,*/NULL);
  controlfunctionMultToggle=XtVaCreateManagedWidget("Multiply  control functions",
    xmToggleButtonWidgetClass,controlfunctionRadio,/*XmNset,False,*/NULL);
  controlfunctionReplToggle=XtVaCreateManagedWidget("Replicate control functions",
    xmToggleButtonWidgetClass,controlfunctionRadio,/*XmNset,False,*/NULL);
  controlfunctionMapToggle=XtVaCreateManagedWidget("Map control functions",
    xmToggleButtonWidgetClass,controlfunctionRadio,/*XmNset,False,*/NULL);




 controlfunctionTextfield=XtVaCreateManagedWidget("controlfunctionTextfield",
    xmTextFieldWidgetClass,controlfunctionForm,NULL);
  XtVaSetValues(controlfunctionTextfield,XmNwidth,50,XmNx,265,XmNy,25,
    XmNvalue,"50",NULL);
  controlfunctionLabel=XtVaCreateManagedWidget("controlfunctionLabel",xmLabelWidgetClass,
    controlfunctionForm,NULL);
  text=XmStringCreateLocalized("By (%):");
  XtVaSetValues(controlfunctionLabel,XmNlabelString,text,XmNx,210,XmNy,30,NULL);

  controlfunctionTextfield2=XtVaCreateManagedWidget("controlfunctionTextfield2",
    xmTextFieldWidgetClass,controlfunctionForm,NULL);
  XtVaSetValues(controlfunctionTextfield2,XmNwidth,50,XmNx,265,XmNy,65,
    XmNvalue,"0",NULL);

 XtAddCallback(controlfunctionOkButton,XmNactivateCallback,controlfunctionOk,NULL);
 XtAddCallback(controlfunction,XmNactivateCallback,Controlfunction,0);


  /*_____________________ CREATE SPOTS SUB-MENU_______________________ */

  spotsButton=XtVaCreateManagedWidget(
    "spotsButton",xmCascadeButtonWidgetClass,/*menuBar*/editMenu,NULL);
  text=XmStringCreateLocalized("Paint");
  XtVaSetValues(spotsButton,XmNlabelString,text,NULL);

  spotsMenu=XmCreatePulldownMenu(/*menuBar*/editMenu,"spotsMenu",NULL,0);
  XtVaSetValues(spotsButton,XmNsubMenuId,spotsMenu,NULL);

  /*____________________ CREATE RESTART BUTTON________________________ */
  spotsRestart=XtVaCreateManagedWidget(
    "restartButton",xmPushButtonWidgetClass,spotsMenu,NULL);
  text=XmStringCreateLocalized("Restart");
  XtVaSetValues(spotsRestart,XmNlabelString,text,NULL);
  XtAddCallback(spotsRestart,XmNactivateCallback,SpotsRestart,0);

  /*____________________ CREATE KEEP BUTTON___________________________ */
  spotsKeep=XtVaCreateManagedWidget(
    "keepButton",xmPushButtonWidgetClass,spotsMenu,NULL);
  text=XmStringCreateLocalized("Keep");
  XtVaSetValues(spotsKeep,XmNlabelString,text,NULL);
  XtAddCallback(spotsKeep,XmNactivateCallback,SpotsKeep,0);

  /*____________________ CREATE REMOVE BUTTON_________________________ */
  spotsRemove=XtVaCreateManagedWidget(
    "removeButton",xmPushButtonWidgetClass,spotsMenu,NULL);
  text=XmStringCreateLocalized("Remove");
  XtVaSetValues(spotsRemove,XmNlabelString,text,NULL);
  XtAddCallback(spotsRemove,XmNactivateCallback,SpotsRemove,0);


printf(". ");
  /*______________________CREATE TRANSFORM MENU_________________________*/
  transButton=XtVaCreateManagedWidget(
    "transButton",xmCascadeButtonWidgetClass,menuBar,
	XmNmnemonic,XStringToKeysym("T"),
	NULL);
  text=XmStringCreateLocalized("Transform");
  XtVaSetValues(transButton,XmNlabelString,text,NULL);
  transMenu=XmCreatePulldownMenu(menuBar,"transMenu",NULL,0);
  XtVaSetValues(transButton,XmNsubMenuId,transMenu,NULL);


  /* CREATE SIEVE BUTTON */
  sieve=XtVaCreateManagedWidget(
    "sieve",xmPushButtonWidgetClass,transMenu,NULL);
  text=XmStringCreateLocalized("Sieve...");
  XtVaSetValues(sieve,XmNlabelString,text,NULL);

  sieveForm=XmCreateBulletinBoardDialog(mainWindow,"sieveForm",NULL,0);
  sieveOkButton=XtVaCreateManagedWidget("sieveOk",xmPushButtonWidgetClass,
    sieveForm,NULL);
  text=XmStringCreateLocalized("Ok");
  XtVaSetValues(sieveOkButton,XmNlabelString,text,XmNx,50,XmNy,250,
    XmNwidth,90,NULL);
  sieveCancelButton=XtVaCreateManagedWidget("sieveCancel",
    xmPushButtonWidgetClass,sieveForm,NULL);
  text=XmStringCreateLocalized("Cancel");
  XtVaSetValues(sieveCancelButton,XmNlabelString,text,XmNx,200,XmNy,250,NULL);

  sieveTextfield=XtVaCreateManagedWidget("sieveTextfield",
    xmTextFieldWidgetClass,sieveForm,NULL);
  XtVaSetValues(sieveTextfield,XmNwidth,80,XmNx,240,XmNy,10,
    XmNvalue,"10",NULL);
  sieveLabel1=XtVaCreateManagedWidget("sieveLabel1",xmLabelWidgetClass,
    sieveForm,NULL);
  text=XmStringCreateLocalized("Number of harmonics:");
  XtVaSetValues(sieveLabel1,XmNlabelString,text,XmNx,0,XmNy,14,NULL);

  sieveTextfield2=XtVaCreateManagedWidget("sieveTextfield2",
    xmTextFieldWidgetClass,sieveForm,NULL);
  XtVaSetValues(sieveTextfield2,XmNwidth,80,XmNx,240,XmNy,45,
    XmNvalue,"1",NULL);
  sieveLabel2=XtVaCreateManagedWidget("sieveLabel2",xmLabelWidgetClass,
    sieveForm,NULL);
  text=XmStringCreateLocalized("Multiplication pr. sec.:");
  XtVaSetValues(sieveLabel2,XmNlabelString,text,XmNx,0,XmNy,49,NULL);

  sieveToggle3=XtVaCreateManagedWidget("sieveToggle3",
    xmToggleButtonWidgetClass,sieveForm,NULL);
  text=XmStringCreateLocalized("Control function 1 -> Num. harm.");
  XtVaSetValues(sieveToggle3,XmNlabelString,text,XmNset,False,
    XmNy,80,NULL);

  sieveTextfield3=XtVaCreateManagedWidget("sieveTextfield3",
    xmTextFieldWidgetClass,sieveForm,NULL);
  XtVaSetValues(sieveTextfield3,XmNwidth,80,XmNx,240,XmNy,115,
    XmNvalue,"0",NULL);
  sieveLabel3=XtVaCreateManagedWidget("sieveLabel3",xmLabelWidgetClass,
    sieveForm,NULL);
  text=XmStringCreateLocalized("High frequency boost:");
  XtVaSetValues(sieveLabel3,XmNlabelString,text,XmNx,0,XmNy,119,NULL);

  sieveRadio=XtVaCreateManagedWidget("sieveRadio",
    xmRowColumnWidgetClass,sieveForm,NULL);
  XtVaSetValues(sieveRadio,XmNy,140,XmNradioBehavior,True,
    XmNradioAlwaysOne,True,NULL);
  sieveToggle1=XtVaCreateManagedWidget("sieveToggle1",
    xmToggleButtonWidgetClass,sieveRadio,NULL);
  text=XmStringCreateLocalized("Amplitude selection");
  XtVaSetValues(sieveToggle1,XmNlabelString,text,XmNset,True,NULL);
  sieveToggle2=XtVaCreateManagedWidget("sieveToggle2",
    xmToggleButtonWidgetClass,sieveRadio,NULL);
  text=XmStringCreateLocalized("Random selection");
  XtVaSetValues(sieveToggle2,XmNlabelString,text,NULL);

  sieveToggle4=XtVaCreateManagedWidget("sieveToggle4",
    xmToggleButtonWidgetClass,sieveForm,NULL);
  text=XmStringCreateLocalized("Invert");
  XtVaSetValues(sieveToggle4,XmNlabelString,text,XmNset,False,
    XmNx,180,XmNy,144,NULL);

  text=XmStringCreateLocalized("Sieve");
  XtVaSetValues(sieveForm,XmNdialogTitle,text,
    XmNcancelButton,sieveCancelButton,
    XmNdefaultButton,sieveOkButton,NULL);


  XtAddCallback(sieveOkButton,XmNactivateCallback,SieveOk,NULL);
  XtAddCallback(sieve,XmNactivateCallback,Sieve,0);

  
  /* CREATE SPECTRUM SHIFT BUTTON */
  sshift=XtVaCreateManagedWidget(
    "sshift",xmPushButtonWidgetClass,transMenu,NULL);
  text=XmStringCreateLocalized("Spectrum shift...");
  XtVaSetValues(sshift,XmNlabelString,text,NULL);

  sshiftForm=XmCreateBulletinBoardDialog(mainWindow,"sshiftForm",NULL,0);
  sshiftOkButton=XtVaCreateManagedWidget("sshiftOk",xmPushButtonWidgetClass,
    sshiftForm,NULL);
  text=XmStringCreateLocalized("Ok");
  XtVaSetValues(sshiftOkButton,XmNlabelString,text,XmNx,50,XmNy,160,
    XmNwidth,90,NULL);
  sshiftCancelButton=XtVaCreateManagedWidget("sshiftCancel",
    xmPushButtonWidgetClass,sshiftForm,NULL);
  text=XmStringCreateLocalized("Cancel");
  XtVaSetValues(sshiftCancelButton,XmNlabelString,text,XmNx,200,XmNy,160,NULL);

  sshiftTextfield=XtVaCreateManagedWidget("sshiftTextfield",
    xmTextFieldWidgetClass,sshiftForm,NULL);
  XtVaSetValues(sshiftTextfield,XmNwidth,80,XmNx,240,XmNy,10,
    XmNvalue,"40.0",NULL);
  sshiftLabel1=XtVaCreateManagedWidget("sshiftLabel1",xmLabelWidgetClass,
    sshiftForm,NULL);
  text=XmStringCreateLocalized("Shift value (Hz):");
  XtVaSetValues(sshiftLabel1,XmNlabelString,text,XmNx,0,XmNy,14,NULL);

  sshiftTextfield2=XtVaCreateManagedWidget("sshiftTextfield2",
    xmTextFieldWidgetClass,sshiftForm,NULL);
  XtVaSetValues(sshiftTextfield2,XmNwidth,80,XmNx,240,XmNy,45,
    XmNvalue,"1",NULL);
  sshiftLabel2=XtVaCreateManagedWidget("sshiftLabel2",xmLabelWidgetClass,
    sshiftForm,NULL);
  text=XmStringCreateLocalized("Multiplication pr. sec.:");
  XtVaSetValues(sshiftLabel2,XmNlabelString,text,XmNx,0,XmNy,49,NULL);

  sshiftToggle1=XtVaCreateManagedWidget("sshiftToggle1",
    xmToggleButtonWidgetClass,sshiftForm,NULL);
  text=XmStringCreateLocalized("Control function 1 -> Shift factor     (0-1)");
  XtVaSetValues(sshiftToggle1,XmNlabelString,text,XmNset,False,
    XmNy,80,NULL);
  sshiftToggle2=XtVaCreateManagedWidget("sshiftToggle2",
    xmToggleButtonWidgetClass,sshiftForm,NULL);
  text=XmStringCreateLocalized("Control function 2 -> Amp. sensitivity (0-1)");
  XtVaSetValues(sshiftToggle2,XmNlabelString,text,XmNset,False,
    XmNy,105,NULL);
  sshiftToggle3=XtVaCreateManagedWidget("sshiftToggle3",
    xmToggleButtonWidgetClass,sshiftForm,NULL);
  text=XmStringCreateLocalized("Control function 3 -> Freq. deviation  (0-1)");
  XtVaSetValues(sshiftToggle3,XmNlabelString,text,XmNset,False,
    XmNy,130,NULL);

  text=XmStringCreateLocalized("Spectrum shift");
  XtVaSetValues(sshiftForm,XmNdialogTitle,text,
    XmNcancelButton,sshiftCancelButton,
    XmNdefaultButton,sshiftOkButton,NULL);

  XtAddCallback(sshiftOkButton,XmNactivateCallback,SshiftOk,NULL);
  XtAddCallback(sshift,XmNactivateCallback,Sshift,0);

  /* CREATE SPECTRUM SHAPE BUTTON */
  sshape=XtVaCreateManagedWidget(
    "sshape",xmPushButtonWidgetClass,transMenu,NULL);
  text=XmStringCreateLocalized("Spectrum shape...");
  XtVaSetValues(sshape,XmNlabelString,text,NULL);

  sshapeForm=XmCreateBulletinBoardDialog(mainWindow,"sshapeForm",NULL,0);
  sshapeOkButton=XtVaCreateManagedWidget("sshapeOk",xmPushButtonWidgetClass,
    sshapeForm,NULL);
  text=XmStringCreateLocalized("Ok");
  XtVaSetValues(sshapeOkButton,XmNlabelString,text,XmNx,50,XmNy,90,
    XmNwidth,90,NULL);
  sshapeCancelButton=XtVaCreateManagedWidget("sshapeCancel",
    xmPushButtonWidgetClass,sshapeForm,NULL);
  text=XmStringCreateLocalized("Cancel");
  XtVaSetValues(sshapeCancelButton,XmNlabelString,text,XmNx,180,XmNy,90,NULL);

  sshapeToggle=XtVaCreateManagedWidget("sshapeToggle",
    xmToggleButtonWidgetClass,sshapeForm,NULL);
  text=XmStringCreateLocalized("Control function 3 -> Average spectrum");
  XtVaSetValues(sshapeToggle,XmNlabelString,text,XmNset,False,
    XmNy,10,NULL);
  sshapeToggle3=XtVaCreateManagedWidget("sshapeToggle3",
    xmToggleButtonWidgetClass,sshapeForm,NULL);
  text=XmStringCreateLocalized("Control function 2 -> Spectral dynamics");
  XtVaSetValues(sshapeToggle3,XmNlabelString,text,XmNset,False,
    XmNy,35,NULL);
  sshapeToggle2=XtVaCreateManagedWidget("sshapeToggle2",
    xmToggleButtonWidgetClass,sshapeForm,NULL);
  text=XmStringCreateLocalized("Control function 1 -> Process  depth");
  XtVaSetValues(sshapeToggle2,XmNlabelString,text,XmNset,False,
    XmNy,60,NULL);

  text=XmStringCreateLocalized("Spectrum shape");
  XtVaSetValues(sshapeForm,XmNdialogTitle,text,
    XmNcancelButton,sshapeCancelButton,
    XmNdefaultButton,sshapeOkButton,NULL);

  XtAddCallback(sshapeOkButton,XmNactivateCallback,SshapeOk,NULL);
  XtAddCallback(sshape,XmNactivateCallback,Sshape,0);


/*_____________________________________________________________________*/

  /* CREATE BLUR BUTTON */
  blur=XtVaCreateManagedWidget(
    "blur",xmPushButtonWidgetClass,transMenu,NULL);
  text=XmStringCreateLocalized("Blur...");
  XtVaSetValues(blur,XmNlabelString,text,NULL);

  blurForm=XmCreateBulletinBoardDialog(mainWindow,"blurForm",NULL,0);
  blurOkButton=XtVaCreateManagedWidget("blurOk",xmPushButtonWidgetClass,
    blurForm,NULL);
  text=XmStringCreateLocalized("Ok");
  XtVaSetValues(blurOkButton,XmNlabelString,text,XmNx,50,XmNy,180,
    XmNwidth,100,NULL);
  blurCancelButton=XtVaCreateManagedWidget("blurCancel",
    xmPushButtonWidgetClass,blurForm,NULL);
  text=XmStringCreateLocalized("Cancel");
  XtVaSetValues(blurCancelButton,XmNlabelString,text,XmNx,200,XmNy,180,NULL);

  blurTextfield1=XtVaCreateManagedWidget("blurTextfield1",
    xmTextFieldWidgetClass,blurForm,NULL);
  XtVaSetValues(blurTextfield1,XmNwidth,70,XmNx,240,XmNy,10,
    XmNvalue,"0.9",NULL);
  blurLabel1=XtVaCreateManagedWidget("blurLabel1",xmLabelWidgetClass,
    blurForm,NULL);
  text=XmStringCreateLocalized("Blur (-1 to 1):");
  XtVaSetValues(blurLabel1,XmNlabelString,text,XmNx,0,XmNy,14,NULL);

  blurTextfield2=XtVaCreateManagedWidget("blurTextfield2",
    xmTextFieldWidgetClass,blurForm,NULL);
  XtVaSetValues(blurTextfield2,XmNwidth,70,XmNx,240,XmNy,45,
    XmNvalue,"1",NULL);
  blurLabel2=XtVaCreateManagedWidget("blurLabel2",xmLabelWidgetClass,
    blurForm,NULL);
  text=XmStringCreateLocalized("Multiplication pr. sec.:");
  XtVaSetValues(blurLabel2,XmNlabelString,text,XmNx,0,XmNy,49,NULL);

  blurTextfield3=XtVaCreateManagedWidget("blurTextfield3",
    xmTextFieldWidgetClass,blurForm,NULL);
  XtVaSetValues(blurTextfield3,XmNwidth,70,XmNx,240,XmNy,80,
    XmNvalue,"0",NULL);
  blurLabel3=XtVaCreateManagedWidget("blurLabel3",xmLabelWidgetClass,
    blurForm,NULL);
  text=XmStringCreateLocalized("Re-init frequency (0 to 20):");
  XtVaSetValues(blurLabel3,XmNlabelString,text,XmNx,0,XmNy,84,NULL);

  blurToggle1=XtVaCreateManagedWidget("blurToggle1",
    xmToggleButtonWidgetClass,blurForm,NULL);
  text=XmStringCreateLocalized("Control function 1 -> Blur");
  XtVaSetValues(blurToggle1,XmNlabelString,text,XmNset,False,
    XmNy,115,NULL);
  blurToggle3=XtVaCreateManagedWidget("blurToggle3",
    xmToggleButtonWidgetClass,blurForm,NULL);
  text=XmStringCreateLocalized("Control function 3 -> Blur scaler");
  XtVaSetValues(blurToggle3,XmNlabelString,text,XmNset,False,
    XmNy,140,NULL);

  text=XmStringCreateLocalized("Dynamic Blur");
  XtVaSetValues(blurForm,XmNdialogTitle,text,
    XmNcancelButton,blurCancelButton,
    XmNdefaultButton,blurOkButton,NULL);

  XtAddCallback(blurOkButton,XmNactivateCallback,BlurOk,NULL);
  XtAddCallback(blur,XmNactivateCallback,Blur,0);

  /* CREATE BAND FILTER BUTTON */
  filter=XtVaCreateManagedWidget(
    "filter",xmPushButtonWidgetClass,transMenu,NULL);
  text=XmStringCreateLocalized("Band filter...");
  XtVaSetValues(filter,XmNlabelString,text,NULL);

  filterForm=XmCreateBulletinBoardDialog(mainWindow,"filterForm",NULL,0);
  filterOkButton=XtVaCreateManagedWidget("filterOk",xmPushButtonWidgetClass,
    filterForm,NULL);
  text=XmStringCreateLocalized("Ok");
  XtVaSetValues(filterOkButton,XmNlabelString,text,XmNx,50,XmNy,205,
    XmNwidth,90,NULL);
  filterCancelButton=XtVaCreateManagedWidget("filterCancel",
    xmPushButtonWidgetClass,filterForm,NULL);
  text=XmStringCreateLocalized("Cancel");
  XtVaSetValues(filterCancelButton,XmNlabelString,text,XmNx,200,XmNy,205,NULL);

  filterTextfield=XtVaCreateManagedWidget("filterTextfield",
    xmTextFieldWidgetClass,filterForm,NULL);
  XtVaSetValues(filterTextfield,XmNwidth,70,XmNx,240,XmNy,10,
    XmNvalue,"22000.0",NULL);
  filterLabel1=XtVaCreateManagedWidget("filterLabel1",xmLabelWidgetClass,
    filterForm,NULL);
  text=XmStringCreateLocalized("Low-pass frequency/pitch:");
  XtVaSetValues(filterLabel1,XmNlabelString,text,XmNx,0,XmNy,14,NULL);

  filterTextfield2=XtVaCreateManagedWidget("filterTextfield2",
    xmTextFieldWidgetClass,filterForm,NULL);
  XtVaSetValues(filterTextfield2,XmNwidth,70,XmNx,240,XmNy,45,
    XmNvalue,"0.0",NULL);
  filterLabel2=XtVaCreateManagedWidget("filterLabel2",xmLabelWidgetClass,
    filterForm,NULL);
  text=XmStringCreateLocalized("High-pass frequency/pitch:");
  XtVaSetValues(filterLabel2,XmNlabelString,text,XmNx,0,XmNy,49,NULL);

   filterTextfield3=XtVaCreateManagedWidget("filterTextfield3",
    xmTextFieldWidgetClass,filterForm,NULL);
  XtVaSetValues(filterTextfield3,XmNwidth,70,XmNx,240,XmNy,80,
    XmNvalue,"0.0",NULL);
  filterLabel3=XtVaCreateManagedWidget("filterLabel3",xmLabelWidgetClass,
    filterForm,NULL);
  text=XmStringCreateLocalized("Stop-band gain (0 - 1):");
  XtVaSetValues(filterLabel3,XmNlabelString,text,XmNx,0,XmNy,84,NULL);


  filterQToggle=XtVaCreateManagedWidget("filterQToggle",
    xmToggleButtonWidgetClass, filterForm, NULL);
  text=XmStringCreateLocalized("Control function 1 -> Bandwidth");
  XtVaSetValues(filterQToggle,XmNlabelString,text,XmNset,False,
    XmNy,115,NULL);

  filterGToggle=XtVaCreateManagedWidget("filterGToggle",
    xmToggleButtonWidgetClass, filterForm, NULL);
  text=XmStringCreateLocalized("Control function 2 -> Stop-band gain");
  XtVaSetValues(filterGToggle,XmNlabelString,text,XmNset,False,
    XmNy,140,NULL);


  filterFilToggle=XtVaCreateManagedWidget("filterFilToggle",
    xmToggleButtonWidgetClass, filterForm, NULL);
  text=XmStringCreateLocalized("Read  from  file:  ./");
  XtVaSetValues(filterFilToggle,XmNlabelString,text,XmNset,False,
    XmNy,170,NULL);

   filterTextfield4=XtVaCreateManagedWidget("filterTextfield4",
    xmTextFieldWidgetClass,filterForm,NULL);
  XtVaSetValues(filterTextfield4,XmNwidth,153,XmNx,160,XmNy,168,
    XmNvalue,"frequencies",NULL);
  
  text=XmStringCreateLocalized("Band filter");
  XtVaSetValues(filterForm,XmNdialogTitle,text,
    XmNcancelButton,filterCancelButton,
    XmNdefaultButton,filterOkButton,NULL);

  XtAddCallback(filterOkButton,XmNactivateCallback,filterOk,NULL);
  XtAddCallback(filter,XmNactivateCallback,Filter,0);


   /* CREATE BREAKPOINT FILTER BUTTON */
  bpfilter=XtVaCreateManagedWidget(
    "bpfilter",xmPushButtonWidgetClass,transMenu,NULL);
  text=XmStringCreateLocalized("Breakpoint filter...");
  XtVaSetValues(bpfilter,XmNlabelString,text,NULL);

  bpfilterForm=XmCreateBulletinBoardDialog(mainWindow,"bpfilterForm",NULL,0);
  bpfilterOkButton=XtVaCreateManagedWidget("bpfilterOk",xmPushButtonWidgetClass,
    bpfilterForm,NULL);
  text=XmStringCreateLocalized("Ok");
  XtVaSetValues(bpfilterOkButton,XmNlabelString,text,XmNx,50,XmNy,170,
    XmNwidth,90,NULL);
  bpfilterCancelButton=XtVaCreateManagedWidget("bpfilterCancel",
    xmPushButtonWidgetClass,bpfilterForm,NULL);
  text=XmStringCreateLocalized("Cancel");
  XtVaSetValues(bpfilterCancelButton,XmNlabelString,text,XmNx,200,XmNy,170,NULL);

  bpfilterToggle1=XtVaCreateManagedWidget("bpfilterToggle1",
    xmToggleButtonWidgetClass, bpfilterForm, NULL);
  text=XmStringCreateLocalized("Control function 1 -> Low frequency");
  XtVaSetValues(bpfilterToggle1,XmNlabelString,text,XmNset,False,
    XmNy,0,NULL);

  bpfilterToggle2=XtVaCreateManagedWidget("bpfilterToggle2",
    xmToggleButtonWidgetClass, bpfilterForm, NULL);
  text=XmStringCreateLocalized("Control function 2 -> High frequency");
  XtVaSetValues(bpfilterToggle2,XmNlabelString,text,XmNset,False,
    XmNy,35,NULL);

  bpfilterToggle3=XtVaCreateManagedWidget("bpfilterToggle3",
    xmToggleButtonWidgetClass, bpfilterForm, NULL);
  text=XmStringCreateLocalized("Mode: Stop-band/Pass-band");
  XtVaSetValues(bpfilterToggle3,XmNlabelString,text,XmNset,False,
    XmNy,60,NULL);

   bpfilterTextfield1=XtVaCreateManagedWidget("bpfilterTextfield1",
    xmTextFieldWidgetClass,bpfilterForm,NULL);
  XtVaSetValues(bpfilterTextfield1,XmNwidth,70,XmNx,240,XmNy,100,
    XmNvalue,"0.0",NULL);
  bpfilterLabel1=XtVaCreateManagedWidget("bpfilterLabel1",xmLabelWidgetClass,
    bpfilterForm,NULL);
  text=XmStringCreateLocalized("Stop-band gain (0-1):");
  XtVaSetValues(bpfilterLabel1,XmNlabelString,text,XmNx,10,XmNy,104,NULL);

  bpfilterToggle4=XtVaCreateManagedWidget("bpfilterToggle4",
    xmToggleButtonWidgetClass, bpfilterForm, NULL);
  text=XmStringCreateLocalized("Control function 3 -> Pass-band EQ");
  XtVaSetValues(bpfilterToggle4,XmNlabelString,text,XmNset,False,
    XmNy,135,NULL);

  text=XmStringCreateLocalized("Breakpoint filter");
  XtVaSetValues(bpfilterForm,XmNdialogTitle,text,
    XmNcancelButton,bpfilterCancelButton,
    XmNdefaultButton,bpfilterOkButton,NULL);

  XtAddCallback(bpfilterOkButton,XmNactivateCallback,bpfilterOk,NULL);
  XtAddCallback(bpfilter,XmNactivateCallback,BPFilter,0);

   /* CREATE COMB FILTER BUTTON */
  comb=XtVaCreateManagedWidget(
    "comb",xmPushButtonWidgetClass,transMenu,NULL);
  text=XmStringCreateLocalized("Comb filter...");
  XtVaSetValues(comb,XmNlabelString,text,NULL);

  combForm=XmCreateBulletinBoardDialog(mainWindow,"combForm",NULL,0);
  combOkButton=XtVaCreateManagedWidget("combOk",xmPushButtonWidgetClass,
    combForm,NULL);
  text=XmStringCreateLocalized("Ok");
  XtVaSetValues(combOkButton,XmNlabelString,text,XmNx,50,XmNy,200,
    XmNwidth,80,NULL);
  combCancelButton=XtVaCreateManagedWidget("combCancel",
    xmPushButtonWidgetClass,combForm,NULL);
  text=XmStringCreateLocalized("Cancel");
  XtVaSetValues(combCancelButton,XmNlabelString,text,XmNx,200,XmNy,200,NULL);

  combTextfield1=XtVaCreateManagedWidget("combTextfield1",
    xmTextFieldWidgetClass,combForm,NULL);
  XtVaSetValues(combTextfield1,XmNwidth,80,XmNx,240,XmNy,10,
    XmNvalue,"261.62",NULL);
  combLabel1=XtVaCreateManagedWidget("combLabel1",xmLabelWidgetClass,
    combForm,NULL);
  text=XmStringCreateLocalized("Fundamental frequency/pitch:");
  XtVaSetValues(combLabel1,XmNlabelString,text,XmNx,0,XmNy,14,NULL);

  combTextfield2=XtVaCreateManagedWidget("combTextfield2",
    xmTextFieldWidgetClass,combForm,NULL);
  XtVaSetValues(combTextfield2,XmNwidth,80,XmNx,240,XmNy,45,
    XmNvalue,"1",NULL);
  combLabel2=XtVaCreateManagedWidget("combLabel2",xmLabelWidgetClass,
    combForm,NULL);
  text=XmStringCreateLocalized("Multiplication pr. sec.:");
  XtVaSetValues(combLabel2,XmNlabelString,text,XmNx,0,XmNy,49,NULL);

  combTextfield3=XtVaCreateManagedWidget("combTextfield3",
    xmTextFieldWidgetClass,combForm,NULL);
  XtVaSetValues(combTextfield3,XmNwidth,80,XmNx,240,XmNy,80,
    XmNvalue,"1",NULL);
  combLabel3=XtVaCreateManagedWidget("combLabel3",xmLabelWidgetClass,
    combForm,NULL);
  text=XmStringCreateLocalized("Depth (0 - 1):");
  XtVaSetValues(combLabel3,XmNlabelString,text,XmNx,0,XmNy,84,NULL);


  combToggle1=XtVaCreateManagedWidget("combToggle1",
    xmToggleButtonWidgetClass,combForm,NULL);
  text=XmStringCreateLocalized("Control function 1 -> Fundamental (0-1000)");
  XtVaSetValues(combToggle1,XmNlabelString,text,XmNset,False,
    XmNy,115,NULL);

  combToggle2=XtVaCreateManagedWidget("combToggle2",
    xmToggleButtonWidgetClass,combForm,NULL);
  text=XmStringCreateLocalized("Control function 2 -> Depth (0 - 1)");
  XtVaSetValues(combToggle2,XmNlabelString,text,XmNset,False,
    XmNy,140,NULL);

  combToggleInv=XtVaCreateManagedWidget("combToggleInv",
    xmToggleButtonWidgetClass,combForm,NULL);
  text=XmStringCreateLocalized("Inverted comb filter");
  XtVaSetValues(combToggleInv,XmNlabelString,text,XmNset,False,
    XmNy,165,NULL);


  text=XmStringCreateLocalized("Dynamic comb filter");
  XtVaSetValues(combForm,XmNdialogTitle,text,
    XmNcancelButton,combCancelButton,
    XmNdefaultButton,combOkButton,NULL);

  XtAddCallback(combOkButton,XmNactivateCallback,CombOk,NULL);
  XtAddCallback(comb,XmNactivateCallback,Comb,0);

   /* CREATE RESONANT FILTER BUTTON */
  resfilter=XtVaCreateManagedWidget(
    "resfilter",xmPushButtonWidgetClass,transMenu,NULL);
  text=XmStringCreateLocalized("Resonant filter...");
  XtVaSetValues(resfilter,XmNlabelString,text,NULL);

 resForm=XmCreateBulletinBoardDialog(mainWindow,"resForm",NULL,0);
  resOkButton=XtVaCreateManagedWidget("resOk",xmPushButtonWidgetClass,
    resForm,NULL);
  text=XmStringCreateLocalized("Ok");
  XtVaSetValues(resOkButton,XmNlabelString,text,XmNx,50,XmNy,210,
    XmNwidth,80,NULL);
  resCancelButton=XtVaCreateManagedWidget("resCancel",
    xmPushButtonWidgetClass,resForm,NULL);
  text=XmStringCreateLocalized("Cancel");
  XtVaSetValues(resCancelButton,XmNlabelString,text,XmNx,200,XmNy,210,NULL);

  resTextfield1=XtVaCreateManagedWidget("resTextfield1",
    xmTextFieldWidgetClass,resForm,NULL);
  XtVaSetValues(resTextfield1,XmNwidth,70,XmNx,240,XmNy,10,
    XmNvalue,"0.9",NULL);
  resLabel1=XtVaCreateManagedWidget("resLabel1",xmLabelWidgetClass,
    resForm,NULL);
  text=XmStringCreateLocalized("Resonance (0 to 1):");
  XtVaSetValues(resLabel1,XmNlabelString,text,XmNx,0,XmNy,14,NULL);

  resTextfield2=XtVaCreateManagedWidget("resTextfield2",
    xmTextFieldWidgetClass,resForm,NULL);
  XtVaSetValues(resTextfield2,XmNwidth,70,XmNx,240,XmNy,45,
    XmNvalue,"1",NULL);
  resLabel2=XtVaCreateManagedWidget("resLabel2",xmLabelWidgetClass,
    resForm,NULL);
  text=XmStringCreateLocalized("Multiplication pr. sec.:");
  XtVaSetValues(resLabel2,XmNlabelString,text,XmNx,0,XmNy,49,NULL);

  resTextfield3=XtVaCreateManagedWidget("resTextfield3",
    xmTextFieldWidgetClass,resForm,NULL);
  XtVaSetValues(resTextfield3,XmNwidth,70,XmNx,240,XmNy,80,
    XmNvalue,"0",NULL);
  resLabel3=XtVaCreateManagedWidget("resLabel3",xmLabelWidgetClass,
    resForm,NULL);
  text=XmStringCreateLocalized("Re-init frequency (0 to 20):");
  XtVaSetValues(resLabel3,XmNlabelString,text,XmNx,0,XmNy,84,NULL);

  resTextfield4=XtVaCreateManagedWidget("resTextfield4",
    xmTextFieldWidgetClass,resForm,NULL);
  XtVaSetValues(resTextfield4,XmNwidth,70,XmNx,240,XmNy,115,
    XmNvalue,"2.0",NULL);
  resLabel4=XtVaCreateManagedWidget("resLabel4",xmLabelWidgetClass,
    resForm,NULL);
  text=XmStringCreateLocalized("Resonant gain factor (1 to 10):");
  XtVaSetValues(resLabel4,XmNlabelString,text,XmNx,0,XmNy,119,NULL);

  resToggle1=XtVaCreateManagedWidget("resToggle1",
    xmToggleButtonWidgetClass,resForm,NULL);
  text=XmStringCreateLocalized("Control function 1 -> Resonance");
  XtVaSetValues(resToggle1,XmNlabelString,text,XmNset,False,
    XmNy,150,NULL);

  resToggle3=XtVaCreateManagedWidget("resToggle3",
    xmToggleButtonWidgetClass,resForm,NULL);
  text=XmStringCreateLocalized("Control function 3 -> Resonant Gain EQ");
  XtVaSetValues(resToggle3,XmNlabelString,text,XmNset,False,
    XmNy,175,NULL);

  text=XmStringCreateLocalized("Resonant Filter");
  XtVaSetValues(resForm,XmNdialogTitle,text,
    XmNcancelButton,resCancelButton,
    XmNdefaultButton,resOkButton,NULL);

  XtAddCallback(resOkButton,XmNactivateCallback,ResonOk,NULL);
  XtAddCallback(resfilter,XmNactivateCallback,Reson,0);

 /* CREATE SOURCE FILTER BUTTON */
  sourceFilter=XtVaCreateManagedWidget(
    "sourceFilter",xmPushButtonWidgetClass,transMenu,NULL);
  text=XmStringCreateLocalized("Source filter...");
  XtVaSetValues(sourceFilter,XmNlabelString,text,NULL);

sourceForm=XmCreateBulletinBoardDialog(mainWindow,"sourceForm",NULL,0);
  sourceOkButton=XtVaCreateManagedWidget("sourceOk",xmPushButtonWidgetClass,
    sourceForm,NULL);
  text=XmStringCreateLocalized("Ok");
  XtVaSetValues(sourceOkButton,XmNlabelString,text,XmNx,50,XmNy,170,
    XmNwidth,80,NULL);
  sourceCancelButton=XtVaCreateManagedWidget("sourceCancel",
    xmPushButtonWidgetClass,sourceForm,NULL);
  text=XmStringCreateLocalized("Cancel");
  XtVaSetValues(sourceCancelButton,XmNlabelString,text,XmNx,200,XmNy,170,NULL);

  sourceLabel=XtVaCreateManagedWidget("sourceLabel",
    xmLabelWidgetClass, sourceForm, NULL);
  text=XmStringCreateLocalized("Filter with FFT file: ./");
  XtVaSetValues(sourceLabel,XmNlabelString,text,XmNset,False,
    XmNy,17,NULL);

   sourceTextfield=XtVaCreateManagedWidget("sourceTextfield",
    xmTextFieldWidgetClass,sourceForm,NULL);
  XtVaSetValues(sourceTextfield,XmNwidth,153,XmNx,160,XmNy,0,
    XmNvalue,"fft.text",NULL);

  sourceToggle = XtVaCreateManagedWidget("sourceToggle",
    xmToggleButtonWidgetClass, sourceForm, NULL);
  text=XmStringCreateLocalized("Control function 1 -> Amplitude");
  XtVaSetValues(sourceToggle,XmNlabelString,text,XmNset,False,
    XmNy,45,NULL);

  sourceToggle2 = XtVaCreateManagedWidget("sourceToggle2",
    xmToggleButtonWidgetClass, sourceForm, NULL);
  text=XmStringCreateLocalized("Control function 2 -> Phase");
  XtVaSetValues(sourceToggle2,XmNlabelString,text,XmNset,False,
    XmNy,70,NULL);

  sourceToggle4 = XtVaCreateManagedWidget("sourceToggle4",
    xmToggleButtonWidgetClass, sourceForm, NULL);
  text=XmStringCreateLocalized("Loop back filter file");
  XtVaSetValues(sourceToggle4,XmNlabelString,text,XmNset,False,
    XmNy,95,NULL);

 sourceM=XtVaCreateManagedWidget("sourceM", xmRowColumnWidgetClass,sourceForm,NULL);
 XtVaSetValues(sourceM,XmNx,35,NULL);

 text=XmStringCreateLocalized("Interpolation method:");
 smo=XmStringCreateLocalized("arithmetic");		
 noi=XmStringCreateLocalized("geometric");
 first=XmStringCreateLocalized("harmonic");

 sourceMOption=XmVaCreateSimpleOptionMenu(sourceM,"sourceMOption",text,'I', 0,sOption,
	XmVaPUSHBUTTON,smo, NULL,NULL,NULL,
    XmVaPUSHBUTTON,noi, NULL,NULL,NULL,
    XmVaPUSHBUTTON,first, NULL,NULL,NULL,
	NULL);

XmStringFree(text); XmStringFree(smo);XmStringFree(noi);
XmStringFree(first);
XtManageChild(sourceMOption);
#ifdef SGI
   XtVaSetValues(sourceM,XmNx,35,XmNy,120,NULL);
#else
   XtVaSetValues(sourceM,XmNx,35,XmNy,117,NULL);
#endif

  sourceSepar=XtVaCreateManagedWidget("sourceSepar", xmSeparatorWidgetClass,
    sourceForm, XmNorientation, XmHORIZONTAL, XmNy, 160, XmNwidth, 300, NULL);

  text=XmStringCreateLocalized("Source Filter");
  XtVaSetValues(sourceForm,XmNdialogTitle,text,
    XmNcancelButton,sourceCancelButton,
    XmNdefaultButton,sourceOkButton,NULL);

  XtAddCallback(sourceOkButton,XmNactivateCallback,SourceOk,NULL);
  XtAddCallback(sourceFilter,XmNactivateCallback,Source,0);

   /* CREATE TRACKING FILTER BUTTON */
  trackfilter=XtVaCreateManagedWidget(
    "trackfilter",xmPushButtonWidgetClass,transMenu,NULL);
  text=XmStringCreateLocalized("Tracking filter...");
  XtVaSetValues(trackfilter,XmNlabelString,text,NULL);

 trackForm=XmCreateBulletinBoardDialog(mainWindow,"trackForm",NULL,0);
  trackOkButton=XtVaCreateManagedWidget("trackOk",xmPushButtonWidgetClass,
    trackForm,NULL);
  text=XmStringCreateLocalized("Ok");
  XtVaSetValues(trackOkButton,XmNlabelString,text,XmNx,50,XmNy,340,
    XmNwidth,80,NULL);
  trackCancelButton=XtVaCreateManagedWidget("trackCancel",
    xmPushButtonWidgetClass,trackForm,NULL);
  text=XmStringCreateLocalized("Cancel");
  XtVaSetValues(trackCancelButton,XmNlabelString,text,XmNx,200,XmNy,340,NULL);

 trackTextfield=XtVaCreateManagedWidget("trackTextfield",
    xmTextFieldWidgetClass,trackForm,NULL);
  XtVaSetValues(trackTextfield,XmNwidth,60,XmNx,260,XmNy,5,
    XmNvalue,"C3",NULL);
  trackLabel=XtVaCreateManagedWidget("trackLabel",xmLabelWidgetClass,
    trackForm,NULL);
  text=XmStringCreateLocalized("Fundamental freq./pitch:");
  XtVaSetValues(trackLabel,XmNlabelString,text,XmNx,10,XmNy,15,NULL);

  trackRadio=XtVaCreateManagedWidget("trackRadio",
   xmRowColumnWidgetClass,trackForm,NULL); 
   XtVaSetValues(trackRadio,XmNradioBehavior,True,
    XmNradioAlwaysOne,False,XmNy,45,NULL);
  trackToggle1=XtVaCreateManagedWidget("trackToggle1",
  xmToggleButtonWidgetClass,trackRadio,NULL);
  text=XmStringCreateLocalized("Control function 2   -> Fundamental freq.");
  XtVaSetValues(trackToggle1,XmNlabelString,text,XmNset,False,
    /*XmNy,45,*/NULL);
  trackToggle1a=XtVaCreateManagedWidget("trackToggle1a",
  xmToggleButtonWidgetClass,trackRadio,NULL);
  text=XmStringCreateLocalized("Extracted fundamental-> Fundamental freq.");
  XtVaSetValues(trackToggle1a,XmNlabelString,text,XmNset,False,
    /*XmNy,70,*/NULL);
  trackTextfield3=XtVaCreateManagedWidget("trackTextfield3",
    xmTextFieldWidgetClass,trackForm,NULL);
  XtVaSetValues(trackTextfield3,XmNwidth,60,XmNx,260,XmNy,110,
    XmNvalue,"1",NULL);
  trackLabel3=XtVaCreateManagedWidget("trackLabel3",xmLabelWidgetClass,
    trackForm,NULL);
  text=XmStringCreateLocalized("Order of fundamental (1-16):");
  XtVaSetValues(trackLabel3,XmNlabelString,text,XmNx,10,XmNy,115,NULL);

  trackTextfield1=XtVaCreateManagedWidget("trackTextfield1",
    xmTextFieldWidgetClass,trackForm,NULL);
  XtVaSetValues(trackTextfield1,XmNwidth,60,XmNx,260,XmNy,145,
    XmNvalue,"0.1",NULL);
  trackLabel1=XtVaCreateManagedWidget("trackLabel1",xmLabelWidgetClass,
    trackForm,NULL);
  text=XmStringCreateLocalized("Upper harmonics bandwidth (0-0.5):");
  XtVaSetValues(trackLabel1,XmNlabelString,text,XmNx,10,XmNy,150,NULL);
  
trackSepar=XtVaCreateManagedWidget("trackSepar", xmSeparatorWidgetClass,
    trackForm, XmNorientation, XmHORIZONTAL, XmNy, 180, XmNwidth, 310, NULL);

 trackTextfield2=XtVaCreateManagedWidget("trackTextfield2",
    xmTextFieldWidgetClass,trackForm,NULL);
  XtVaSetValues(trackTextfield2,XmNwidth,60,XmNx,260,XmNy,185,
    XmNvalue,"0.01",NULL);
  trackLabel2=XtVaCreateManagedWidget("trackLabel2",xmLabelWidgetClass,
    trackForm,NULL);
  text=XmStringCreateLocalized("Stop-band rejection (1-0):");
  XtVaSetValues(trackLabel2,XmNlabelString,text,XmNx,10,XmNy,190,NULL);

  trackTextfield4=XtVaCreateManagedWidget("trackTextfield4",
    xmTextFieldWidgetClass,trackForm,NULL);
  XtVaSetValues(trackTextfield4,XmNwidth,60,XmNx,260,XmNy,220,
    XmNvalue,"1.0",NULL);
  trackLabel4=XtVaCreateManagedWidget("trackLabel4",xmLabelWidgetClass,
    trackForm,NULL);
  text=XmStringCreateLocalized("Multiplication pr. sec.:");
  XtVaSetValues(trackLabel4,XmNlabelString,text,XmNx,10,XmNy,225,NULL);
  
trackSepar1=XtVaCreateManagedWidget("trackSepar1", xmSeparatorWidgetClass,
    trackForm, XmNorientation, XmHORIZONTAL, XmNy, 255, XmNwidth, 310, NULL);
  

   trackTogglephase=XtVaCreateManagedWidget("trackTogglephase",
  xmToggleButtonWidgetClass,trackForm,NULL);
  text=XmStringCreateLocalized("Phase-lock upper harmonics");
  XtVaSetValues(trackTogglephase,XmNlabelString,text,XmNset, False,
    XmNy,260,NULL);

  trackToggleinv=XtVaCreateManagedWidget("trackToggleinv",
  xmToggleButtonWidgetClass,trackForm,NULL);
  text=XmStringCreateLocalized("Invert tracking filter");
  XtVaSetValues(trackToggleinv,XmNlabelString,text,XmNset, False,
    XmNy,285,NULL);

  trackToggle_rem=XtVaCreateManagedWidget("trackToggle_rem",
  xmToggleButtonWidgetClass,trackForm,NULL);
  text=XmStringCreateLocalized("Reject sub-frequencies");
  XtVaSetValues(trackToggle_rem,XmNlabelString,text,/*XmNset,True,*/
    XmNy,310,NULL);

  text=XmStringCreateLocalized("Tracking Filter");
  XtVaSetValues(trackForm,XmNdialogTitle,text,
    XmNcancelButton,trackCancelButton,
    XmNdefaultButton,trackOkButton,NULL);

  XtAddCallback(trackOkButton,XmNactivateCallback,TrackOk,NULL);
  XtAddCallback(trackfilter,XmNactivateCallback,Track,0);

 /* CREATE EXPO BUTTON */
  expo=XtVaCreateManagedWidget(
    "expo",xmPushButtonWidgetClass,transMenu,NULL);
  text=XmStringCreateLocalized("Exponentiate...");
  XtVaSetValues(expo,XmNlabelString,text,NULL);

  expoForm=XmCreateBulletinBoardDialog(mainWindow,"expoForm",NULL,0);
  expoOkButton=XtVaCreateManagedWidget("expoOk",xmPushButtonWidgetClass,
    expoForm,NULL);
  text=XmStringCreateLocalized("Ok");
  XtVaSetValues(expoOkButton,XmNlabelString,text,XmNx,50,XmNy,210,
    XmNwidth,80,NULL);
  expoCancelButton=XtVaCreateManagedWidget("expoCancel",
    xmPushButtonWidgetClass,expoForm,NULL);
  text=XmStringCreateLocalized("Cancel");
  XtVaSetValues(expoCancelButton,XmNlabelString,text,XmNx,200,XmNy,210,NULL);

  expoTextfield=XtVaCreateManagedWidget("expoTextfield",
    xmTextFieldWidgetClass,expoForm,NULL);
  XtVaSetValues(expoTextfield,XmNwidth,80,XmNx,240,XmNy,10,
    XmNvalue,"0.7",NULL);
  expoLabel1=XtVaCreateManagedWidget("expoLabel1",xmLabelWidgetClass,
    expoForm,NULL);
  text=XmStringCreateLocalized("Frequency exponent (0-2):");
  XtVaSetValues(expoLabel1,XmNlabelString,text,XmNx,0,XmNy,14,NULL);

  expoTextfield2=XtVaCreateManagedWidget("expoTextfield2",
    xmTextFieldWidgetClass,expoForm,NULL);
  XtVaSetValues(expoTextfield2,XmNwidth,80,XmNx,240,XmNy,45,
    XmNvalue,"1",NULL);
  expoLabel2=XtVaCreateManagedWidget("expoLabel2",xmLabelWidgetClass,
    expoForm,NULL);
  text=XmStringCreateLocalized("Multiplication pr. sec.:");
  XtVaSetValues(expoLabel2,XmNlabelString,text,XmNx,0,XmNy,49,NULL);


  expoTextfield3=XtVaCreateManagedWidget("expoTextfield3",
    xmTextFieldWidgetClass,expoForm,NULL);
  XtVaSetValues(expoTextfield3,XmNwidth,80,XmNx,240,XmNy,80,
    XmNvalue,"1",NULL);
  expoLabel3=XtVaCreateManagedWidget("expoLabel3",xmLabelWidgetClass,
    expoForm,NULL);
  text=XmStringCreateLocalized("Multiplication factor:");
  XtVaSetValues(expoLabel3,XmNlabelString,text,XmNx,0,XmNy,84,NULL);

  expoToggle=XtVaCreateManagedWidget("expoToggle",
    xmToggleButtonWidgetClass,expoForm,NULL);
  text=XmStringCreateLocalized("Control function 1 -> Exponent (0-2)");
  XtVaSetValues(expoToggle,XmNlabelString,text,XmNset,False,
    XmNy,115,NULL);

 expoTextfield4=XtVaCreateManagedWidget("expoTextfield4",
    xmTextFieldWidgetClass,expoForm,NULL);
  XtVaSetValues(expoTextfield4,XmNwidth,80,XmNx,240,XmNy,143,
    XmNvalue,"1",NULL);
  expoLabel4=XtVaCreateManagedWidget("expoLabel4",xmLabelWidgetClass,
    expoForm,NULL);
  text=XmStringCreateLocalized("    Slope factor (0.0-1.0):");
  XtVaSetValues(expoLabel4,XmNlabelString,text,XmNx,0,XmNy,149,NULL);


  expoToggleStrict=XtVaCreateManagedWidget("expoToggleStrict",
    xmToggleButtonWidgetClass,expoForm,NULL);
  text=XmStringCreateLocalized("Area Strict");
  XtVaSetValues(expoToggleStrict,XmNlabelString,text,XmNset,False,
    XmNy,173,NULL);

  text=XmStringCreateLocalized("Exponentiate");
  XtVaSetValues(expoForm,XmNdialogTitle,text,
    XmNcancelButton,expoCancelButton,
    XmNdefaultButton,expoOkButton,NULL);

  XtAddCallback(expoOkButton,XmNactivateCallback,ExpoOk,NULL);
  XtAddCallback(expo,XmNactivateCallback,Expo,0);


  /* CREATE SPREAD BUTTON */

  spread=XtVaCreateManagedWidget(
    "spread",xmPushButtonWidgetClass,transMenu,NULL);
  text=XmStringCreateLocalized("Spread...");
  XtVaSetValues(spread,XmNlabelString,text,NULL);

  spreadForm=XmCreateBulletinBoardDialog(mainWindow,"spreadForm",NULL,0);
  spreadOkButton=XtVaCreateManagedWidget("spreadOk",xmPushButtonWidgetClass,
    spreadForm,NULL);
  text=XmStringCreateLocalized("Ok");
  XtVaSetValues(spreadOkButton,XmNlabelString,text,XmNx,50,XmNy,220,
    XmNwidth,80,NULL);
  spreadCancelButton=XtVaCreateManagedWidget("spreadCancel",
    xmPushButtonWidgetClass,spreadForm,NULL);
  text=XmStringCreateLocalized("Cancel");
  XtVaSetValues(spreadCancelButton,XmNlabelString,text,XmNx,200,XmNy,220,NULL);

  spreadTextfield=XtVaCreateManagedWidget("spreadTextfield",
    xmTextFieldWidgetClass,spreadForm,NULL);
  XtVaSetValues(spreadTextfield,XmNwidth,70,XmNx,240,XmNy,10,
    XmNvalue,"0.05",NULL);
  spreadLabel1=XtVaCreateManagedWidget("spreadLabel1",xmLabelWidgetClass,
    spreadForm,NULL);
  text=XmStringCreateLocalized("Random spread (0-2 octaves):");
  XtVaSetValues(spreadLabel1,XmNlabelString,text,XmNx,0,XmNy,14,NULL);

  spreadTextfield2=XtVaCreateManagedWidget("spreadTextfield2",
    xmTextFieldWidgetClass,spreadForm,NULL);
  XtVaSetValues(spreadTextfield2,XmNwidth,70,XmNx,240,XmNy,45,
    XmNvalue,"1",NULL);
  spreadLabel2=XtVaCreateManagedWidget("spreadLabel2",xmLabelWidgetClass,
    spreadForm,NULL);
  text=XmStringCreateLocalized("Multiplication pr. sec.:");
  XtVaSetValues(spreadLabel2,XmNlabelString,text,XmNx,0,XmNy,49,NULL);

  spreadTextfield3=XtVaCreateManagedWidget("spreadTextfield3",
    xmTextFieldWidgetClass,spreadForm,NULL);
  XtVaSetValues(spreadTextfield3,XmNwidth,70,XmNx,240,XmNy,80,
    XmNvalue,"0",NULL);
  spreadLabel3=XtVaCreateManagedWidget("spreadLabel3",xmLabelWidgetClass,
    spreadForm,NULL);
  text=XmStringCreateLocalized("Amplitude sensitivity (0-1):");
  XtVaSetValues(spreadLabel3,XmNlabelString,text,XmNx,0,XmNy,84,NULL);

  spreadToggle=XtVaCreateManagedWidget("spreadToggle",
    xmToggleButtonWidgetClass,spreadForm,NULL);
  text=XmStringCreateLocalized("Control function 1 -> Spread (0-2)");
  XtVaSetValues(spreadToggle,XmNlabelString,text,XmNset,False,
    XmNy,110,NULL);

  spreadToggle2=XtVaCreateManagedWidget("spreadToggle2",
    xmToggleButtonWidgetClass,spreadForm,NULL);
  text=XmStringCreateLocalized("Control function 2 -> Ampl. sensitivity (0-1)");
  XtVaSetValues(spreadToggle2,XmNlabelString,text,XmNset,False,
    XmNy,135,NULL);

  spreadToggle3=XtVaCreateManagedWidget("spreadToggle3",
    xmToggleButtonWidgetClass,spreadForm,NULL);
  text=XmStringCreateLocalized("Control function 3 -> Freq. sensitivity (0-1)");
  XtVaSetValues(spreadToggle3,XmNlabelString,text,XmNset,False,
    XmNy,160,NULL);

  
  spreadToggleStrict=XtVaCreateManagedWidget("spreadToggleStrict",
    xmToggleButtonWidgetClass,spreadForm,NULL);
  text=XmStringCreateLocalized("Area Strict");
  XtVaSetValues(spreadToggleStrict,XmNlabelString,text,XmNset,False,
    XmNy,185,NULL);

  text=XmStringCreateLocalized("Dynamic spread");
  XtVaSetValues(spreadForm,XmNdialogTitle,text,
    XmNcancelButton,spreadCancelButton,
    XmNdefaultButton,spreadOkButton,NULL);

  XtAddCallback(spreadOkButton,XmNactivateCallback,SpreadOk,NULL);
  XtAddCallback(spread,XmNactivateCallback,Spread,0);



  /* CREATE WARP BUTTON */

  warp=XtVaCreateManagedWidget(
    "warp",xmPushButtonWidgetClass,transMenu,NULL);
  text=XmStringCreateLocalized("Warp...");
  XtVaSetValues(warp,XmNlabelString,text,NULL);

  warpForm=XmCreateBulletinBoardDialog(mainWindow,"warpForm",NULL,0);
  warpOkButton=XtVaCreateManagedWidget("warpOk",xmPushButtonWidgetClass,
    warpForm,NULL);
  text=XmStringCreateLocalized("Ok");
  XtVaSetValues(warpOkButton,XmNlabelString,text,XmNx,30,XmNy,165,
    XmNwidth,80,NULL);
  warpCancelButton=XtVaCreateManagedWidget("warpCancel",
    xmPushButtonWidgetClass,warpForm,NULL);
  text=XmStringCreateLocalized("Cancel");
  XtVaSetValues(warpCancelButton,XmNlabelString,text,XmNx,140,XmNy,165,NULL);

  warpTextfield=XtVaCreateManagedWidget("warpTextfield",
    xmTextFieldWidgetClass,warpForm,NULL);
  XtVaSetValues(warpTextfield,XmNwidth,65,XmNx,150,XmNy,10,
    XmNvalue,"0.7",NULL);
  warpLabel=XtVaCreateManagedWidget("warpLabel",xmLabelWidgetClass,
    warpForm,NULL);
  text=XmStringCreateLocalized("Warp (0-1):");
  XtVaSetValues(warpLabel,XmNlabelString,text,XmNx,0,XmNy,14,NULL);

  warpToggle=XtVaCreateManagedWidget("warpToggle",
    xmToggleButtonWidgetClass,warpForm,NULL);
  text=XmStringCreateLocalized("Warp  Amplitude Spectrum");
  XtVaSetValues(warpToggle,XmNlabelString,text,XmNset,False,
    XmNy,40,NULL);

  warpToggle2=XtVaCreateManagedWidget("warpToggle2",
    xmToggleButtonWidgetClass,warpForm,NULL);
  text=XmStringCreateLocalized("Warp Frequency Spectrum");
  XtVaSetValues(warpToggle2,XmNlabelString,text,XmNset,False,
    XmNy,65,NULL);

  warpToggle3=XtVaCreateManagedWidget("warpToggle3",
    xmToggleButtonWidgetClass,warpForm,NULL);
  text=XmStringCreateLocalized("Control function 3 -> Warp");
  XtVaSetValues(warpToggle3,XmNlabelString,text,XmNset,False,
    XmNy,90,NULL);

  warpToggle4=XtVaCreateManagedWidget("warpToggle4",
    xmToggleButtonWidgetClass,warpForm,NULL);
  text=XmStringCreateLocalized("Control function 2 -> Depth");
  XtVaSetValues(warpToggle4,XmNlabelString,text,XmNset,False,
    XmNy,115,NULL);

  warpToggle5=XtVaCreateManagedWidget("warpToggle5",
    xmToggleButtonWidgetClass,warpForm,NULL);
  text=XmStringCreateLocalized("Control function 1 -> Density");
  XtVaSetValues(warpToggle5,XmNlabelString,text,XmNset,False,
    XmNy,140,NULL);

  text=XmStringCreateLocalized("Warp");
  XtVaSetValues(warpForm,XmNdialogTitle,text,
    XmNcancelButton,warpCancelButton,
    XmNdefaultButton,warpOkButton,NULL);

  XtAddCallback(warpOkButton,XmNactivateCallback,WarpOk,NULL);
  XtAddCallback(warp,XmNactivateCallback,Warp,0);



  /* CREATE MIRROR BUTTON */
  mirror=XtVaCreateManagedWidget(
    "mirror",xmPushButtonWidgetClass,transMenu,NULL);
  text=XmStringCreateLocalized("Mirror...");
  XtVaSetValues(mirror,XmNlabelString,text,NULL);

  mirrorForm=XmCreateBulletinBoardDialog(mainWindow,"mirrorForm",NULL,0);
  mirrorOkButton=XtVaCreateManagedWidget("mirrorOk",xmPushButtonWidgetClass,
    mirrorForm,NULL);
  text=XmStringCreateLocalized("Ok");
  XtVaSetValues(mirrorOkButton,XmNlabelString,text,XmNx,50,XmNy,200,
    XmNwidth,90,NULL);
  mirrorCancelButton=XtVaCreateManagedWidget("mirrorCancel",
    xmPushButtonWidgetClass,mirrorForm,NULL);
  text=XmStringCreateLocalized("Cancel");
  XtVaSetValues(mirrorCancelButton,XmNlabelString,text,XmNx,200,XmNy,200,NULL);

  mirrorTextfield=XtVaCreateManagedWidget("mirrorTextfield",
    xmTextFieldWidgetClass,mirrorForm,NULL);
  XtVaSetValues(mirrorTextfield,XmNwidth,70,XmNx,240,XmNy,10,
    XmNvalue,"C4",NULL);
  mirrorLabel1=XtVaCreateManagedWidget("mirrorLabel1",xmLabelWidgetClass,
    mirrorForm,NULL);
  text=XmStringCreateLocalized("Frequency/pitch of mirror:");
  XtVaSetValues(mirrorLabel1,XmNlabelString,text,XmNx,0,XmNy,14,NULL);

  mirrorTextfield2=XtVaCreateManagedWidget("mirrorTextfield2",
    xmTextFieldWidgetClass,mirrorForm,NULL);
  XtVaSetValues(mirrorTextfield2,XmNwidth,70,XmNx,240,XmNy,45,
    XmNvalue,"1",NULL);
  mirrorLabel2=XtVaCreateManagedWidget("mirrorLabel2",xmLabelWidgetClass,
    mirrorForm,NULL);
  text=XmStringCreateLocalized("Multiplication pr. sec.:");
  XtVaSetValues(mirrorLabel2,XmNlabelString,text,XmNx,0,XmNy,49,NULL);

  mirrorToggle=XtVaCreateManagedWidget("mirrorToggle",
    xmToggleButtonWidgetClass,mirrorForm,NULL);
  text=XmStringCreateLocalized("Control function 1 -> Mirror");
  XtVaSetValues(mirrorToggle,XmNlabelString,text,XmNset,False,
    XmNy,80,NULL);

  mirrorToggle2=XtVaCreateManagedWidget("mirrorToggle2",
    xmToggleButtonWidgetClass,mirrorForm,NULL);
  text=XmStringCreateLocalized("Control function 2 -> 2nd Mirror");
  XtVaSetValues(mirrorToggle2,XmNlabelString,text,XmNset,False,
    XmNy,105,NULL);

  mirrorToggle3=XtVaCreateManagedWidget("mirrorToggle3",
    xmToggleButtonWidgetClass,mirrorForm,NULL);
  text=XmStringCreateLocalized("Control function 3 -> 3rd Mirror");
  XtVaSetValues(mirrorToggle3,XmNlabelString,text,XmNset,False,XmNsensitive,False,
    XmNy,130,NULL);

  text=XmStringCreateLocalized("Mirror");
  XtVaSetValues(mirrorForm,XmNdialogTitle,text,
    XmNcancelButton,mirrorCancelButton,
    XmNdefaultButton,mirrorOkButton,NULL);

  XtAddCallback(mirrorOkButton,XmNactivateCallback,MirrorOk,NULL);
  XtAddCallback(mirror,XmNactivateCallback,Mirror,0);


  /* CREATE PITCH SHIFT BUTTON */
  pshift=XtVaCreateManagedWidget(
    "pshift",xmPushButtonWidgetClass,transMenu,NULL);
  text=XmStringCreateLocalized("Pitch shift...");
  XtVaSetValues(pshift,XmNlabelString,text,NULL);


  pitchForm=XmCreateBulletinBoardDialog(mainWindow,"pitchForm",NULL,0);
  pitchOkButton=XtVaCreateManagedWidget("pitchOk",xmPushButtonWidgetClass,
    pitchForm,NULL);
  text=XmStringCreateLocalized("Ok");
  XtVaSetValues(pitchOkButton,XmNlabelString,text,XmNx,50,XmNy,170,
    XmNwidth,90,NULL);
  pitchCancelButton=XtVaCreateManagedWidget("pitchCancel",
    xmPushButtonWidgetClass,pitchForm,NULL);
  text=XmStringCreateLocalized("Cancel");
  XtVaSetValues(pitchCancelButton,XmNlabelString,text,XmNx,200,XmNy,170,NULL);

  pitchTextfield=XtVaCreateManagedWidget("pitchTextfield",
    xmTextFieldWidgetClass,pitchForm,NULL);
  XtVaSetValues(pitchTextfield,XmNwidth,80,XmNx,240,XmNy,10,
    XmNvalue,"1",NULL);
  pitchLabel1=XtVaCreateManagedWidget("pitchLabel1",xmLabelWidgetClass,
    pitchForm,NULL);
  text=XmStringCreateLocalized("Transposition factor:");
  XtVaSetValues(pitchLabel1,XmNlabelString,text,XmNx,0,XmNy,14,NULL);

  pitchTextfield2=XtVaCreateManagedWidget("pitchTextfield2",
    xmTextFieldWidgetClass,pitchForm,NULL);
  XtVaSetValues(pitchTextfield2,XmNwidth,80,XmNx,240,XmNy,45,
    XmNvalue,"1",NULL);
  pitchLabel2=XtVaCreateManagedWidget("pitchLabel2",xmLabelWidgetClass,
    pitchForm,NULL);
  text=XmStringCreateLocalized("Multiplication pr. sec.:");
  XtVaSetValues(pitchLabel2,XmNlabelString,text,XmNx,0,XmNy,49,NULL);

  pitchToggle1=XtVaCreateManagedWidget("pitchToggle1",
    xmToggleButtonWidgetClass,pitchForm,NULL);
  text=XmStringCreateLocalized("Control function 1 -> Tr. factor mult. (0-1)");
  XtVaSetValues(pitchToggle1,XmNlabelString,text,XmNset,False,
    XmNy,115,NULL);

  pitchTextfield3=XtVaCreateManagedWidget("pitchTextfield3",
    xmTextFieldWidgetClass,pitchForm,NULL);
  XtVaSetValues(pitchTextfield3,XmNwidth,80,XmNx,240,XmNy,80,
    XmNvalue,"0",NULL);
  pitchLabel3=XtVaCreateManagedWidget("pitchLabel3",xmLabelWidgetClass,
    pitchForm,NULL);
  text=XmStringCreateLocalized("Static frequency:");
  XtVaSetValues(pitchLabel3,XmNlabelString,text,XmNx,0,XmNy,84,NULL);

  text=XmStringCreateLocalized("Pitch shift");
  XtVaSetValues(pitchForm,XmNdialogTitle,text,
    XmNcancelButton,pitchCancelButton,
    XmNdefaultButton,pitchOkButton,NULL);

  XtAddCallback(pitchOkButton,XmNactivateCallback,PshiftOk,NULL);
  XtAddCallback(pshift,XmNactivateCallback,Pshift,0);


  /* CREATE GAIN BUTTON */
  gain=XtVaCreateManagedWidget(
    "gain",xmPushButtonWidgetClass,transMenu,NULL);
  text=XmStringCreateLocalized("Gain...");
  XtVaSetValues(gain,XmNlabelString,text,NULL);

  gainForm=XmCreateBulletinBoardDialog(mainWindow,"gainForm",NULL,0);
  gainOkButton=XtVaCreateManagedWidget("gainOk",xmPushButtonWidgetClass,
    gainForm,NULL);
  text=XmStringCreateLocalized("Ok");
  XtVaSetValues(gainOkButton,XmNlabelString,text,XmNx,50,XmNy,150,
    XmNwidth,90,NULL);
  gainCancelButton=XtVaCreateManagedWidget("gainCancel",
    xmPushButtonWidgetClass,gainForm,NULL);
  text=XmStringCreateLocalized("Cancel");
  XtVaSetValues(gainCancelButton,XmNlabelString,text,XmNx,180,XmNy,150,NULL);

  gainTextfield=XtVaCreateManagedWidget("gainTextfield",
    xmTextFieldWidgetClass,gainForm,NULL);
  XtVaSetValues(gainTextfield,XmNwidth,70,XmNx,200,XmNy,10,
    XmNvalue,"1",NULL);
  gainLabel=XtVaCreateManagedWidget("gainLabel",xmLabelWidgetClass,
    gainForm,NULL);
  text=XmStringCreateLocalized("Gain factor:");
  XtVaSetValues(gainLabel,XmNlabelString,text,XmNx,0,XmNy,14,NULL);

  gainTextfield1=XtVaCreateManagedWidget("gainTextfield1",
    xmTextFieldWidgetClass,gainForm,NULL);
  XtVaSetValues(gainTextfield1,XmNwidth,70,XmNx,200,XmNy,45,
    XmNvalue,"0",NULL);
  gainLabel1=XtVaCreateManagedWidget("gainLabe1l",xmLabelWidgetClass,
    gainForm,NULL);
  text=XmStringCreateLocalized("Gain treshold (%):");
  XtVaSetValues(gainLabel1,XmNlabelString,text,XmNx,0,XmNy,49,NULL);

 gainToggleT=XtVaCreateManagedWidget("gainToggleT",
    xmToggleButtonWidgetClass, gainForm, NULL);
  text=XmStringCreateLocalized("Below treshold");
  XtVaSetValues(gainToggleT,XmNlabelString,text,XmNset,False,
    XmNx, 26,XmNy,70,NULL);

gainSepar=XtVaCreateManagedWidget("gainSepar", xmSeparatorWidgetClass,
    gainForm, XmNorientation, XmHORIZONTAL, XmNy,99, XmNwidth, 260, NULL);

 gainToggle=XtVaCreateManagedWidget("gainToggle",
    xmToggleButtonWidgetClass, gainForm, NULL);
  text=XmStringCreateLocalized("Control function 1 -> Gain factor (0-2)");
  XtVaSetValues(gainToggle,XmNlabelString,text,XmNset,False,
    XmNy,100,NULL);

 gainToggle3=XtVaCreateManagedWidget("gainToggle3",
    xmToggleButtonWidgetClass, gainForm, NULL);
  text=XmStringCreateLocalized("Control function 3 -> Spectral envelope");
  XtVaSetValues(gainToggle3,XmNlabelString,text,XmNset,False,
    XmNy,125,NULL);


  text=XmStringCreateLocalized("Dynamic gain");
  XtVaSetValues(gainForm,XmNdialogTitle,text,
    XmNcancelButton,gainCancelButton,
    XmNdefaultButton,gainOkButton,NULL);

  XtAddCallback(gainOkButton,XmNactivateCallback,GainOk,NULL);
  XtAddCallback(gain,XmNactivateCallback,Gain,0);


  /* CREATE NULL PHASE BUTTON */
  nullphase=XtVaCreateManagedWidget(
    "nullphase",xmPushButtonWidgetClass,transMenu,NULL);
  text=XmStringCreateLocalized("Null phase...");
  XtVaSetValues(nullphase,XmNlabelString,text,NULL);

  nullphaseForm=XmCreateBulletinBoardDialog(mainWindow,"nullphaseForm",NULL,0);
  nullphaseOkButton=XtVaCreateManagedWidget("nullphaseOk",xmPushButtonWidgetClass,
    nullphaseForm,NULL);
  text=XmStringCreateLocalized("Ok");
  XtVaSetValues(nullphaseOkButton,XmNlabelString,text,XmNx,30,XmNy,185,
    XmNwidth,90,NULL);
  nullphaseCancelButton=XtVaCreateManagedWidget("nullphaseCancel",
    xmPushButtonWidgetClass,nullphaseForm,NULL);
  text=XmStringCreateLocalized("Cancel");
  XtVaSetValues(nullphaseCancelButton,XmNlabelString,text,XmNx,160,XmNy,185,NULL);

  nullphaseTextfield=XtVaCreateManagedWidget("nullphaseTextfield",
    xmTextFieldWidgetClass,nullphaseForm,NULL);
  XtVaSetValues(nullphaseTextfield,XmNwidth,80,XmNx,170,XmNy,10,
    XmNvalue,"2",NULL);
  nullphaseLabel1=XtVaCreateManagedWidget("nullphaseLabel1",xmLabelWidgetClass,
    nullphaseForm,NULL);
  text=XmStringCreateLocalized("Multiplier:");
  XtVaSetValues(nullphaseLabel1,XmNlabelString,text,XmNx,0,XmNy,14,NULL);

  nullphaseToggle1=XtVaCreateManagedWidget("nullphaseToggle1",
    xmToggleButtonWidgetClass,nullphaseForm,NULL);
  text=XmStringCreateLocalized("Control function 1 -> Mult. factor");
  XtVaSetValues(nullphaseToggle1,XmNlabelString,text,XmNset,False,
    XmNy,45,NULL);
  nullphaseToggle4=XtVaCreateManagedWidget("nullphaseToggle4",
    xmToggleButtonWidgetClass,nullphaseForm,NULL);
  text=XmStringCreateLocalized("Control function 2 -> Interpolation");
  XtVaSetValues(nullphaseToggle4,XmNlabelString,text,XmNset,False,
    XmNy,70,NULL);
  nullphaseToggle5=XtVaCreateManagedWidget("nullphaseToggle5",
    xmToggleButtonWidgetClass,nullphaseForm,NULL);
  text=XmStringCreateLocalized("Control function 3 -> Interpolation");
  XtVaSetValues(nullphaseToggle5,XmNlabelString,text,XmNset,False,
    XmNy,95,NULL);
 nullphaseSepar=XtVaCreateManagedWidget("nullphaseSepar",
    xmSeparatorWidgetClass,nullphaseForm, XmNorientation, XmHORIZONTAL,XmNy, 		    125, XmNwidth, 240,NULL);
  nullphaseToggle2=XtVaCreateManagedWidget("nullphaseToggle2",
    xmToggleButtonWidgetClass,nullphaseForm,NULL);
  text=XmStringCreateLocalized("Area strict out");
  XtVaSetValues(nullphaseToggle2,XmNlabelString,text,XmNset,False,
    XmNy,130,NULL);
  nullphaseToggle3=XtVaCreateManagedWidget("nullphaseToggle3",
    xmToggleButtonWidgetClass,nullphaseForm,NULL);
  text=XmStringCreateLocalized("Area strict in (if out 'on')");
  XtVaSetValues(nullphaseToggle3,XmNlabelString,text,XmNset,False,
    XmNy,155,NULL);
  text=XmStringCreateLocalized("Null phase");
  XtVaSetValues(nullphaseForm,XmNdialogTitle,text,
    XmNcancelButton,nullphaseCancelButton,
    XmNdefaultButton,nullphaseOkButton,NULL);

  XtAddCallback(nullphaseOkButton,XmNactivateCallback,NullphaseOk,NULL);
  XtAddCallback(nullphase,XmNactivateCallback,Nullphase,0);


  /* CREATE MAGNET BUTTON */
  magnet=XtVaCreateManagedWidget(
    "magnet",xmPushButtonWidgetClass,transMenu,NULL);
  text=XmStringCreateLocalized("Move to pitch grid...");
  XtVaSetValues(magnet,XmNlabelString,text,NULL);

  magnetForm=XmCreateBulletinBoardDialog(mainWindow,"magnetForm",NULL,0);
  magnetOkButton=XtVaCreateManagedWidget("magnetOk",xmPushButtonWidgetClass,
    magnetForm,NULL);
  text=XmStringCreateLocalized("Ok");
  XtVaSetValues(magnetOkButton,XmNlabelString,text,XmNx,50,XmNy,250,
    XmNwidth,90,NULL);
  magnetCancelButton=XtVaCreateManagedWidget("magnetCancel",
    xmPushButtonWidgetClass,magnetForm,NULL);
  text=XmStringCreateLocalized("Cancel");
  XtVaSetValues(magnetCancelButton,XmNlabelString,text,XmNx,200,XmNy,250,NULL);

  magnetTextfield=XtVaCreateManagedWidget("magnetTextfield",
    xmTextFieldWidgetClass,magnetForm,NULL);
  XtVaSetValues(magnetTextfield,XmNwidth,80,XmNx,270,XmNy,10,
    XmNvalue,"1",NULL);
  magnetLabel1=XtVaCreateManagedWidget("magnetLabel1",xmLabelWidgetClass,
    magnetForm,NULL);
  text=XmStringCreateLocalized("Probability:");
  XtVaSetValues(magnetLabel1,XmNlabelString,text,XmNx,0,XmNy,14,NULL);

  magnetTextfield2=XtVaCreateManagedWidget("magnetTextfield2",
    xmTextFieldWidgetClass,magnetForm,NULL);
  XtVaSetValues(magnetTextfield2,XmNwidth,80,XmNx,270,XmNy,45,
    XmNvalue,"1",NULL);
  magnetLabel2=XtVaCreateManagedWidget("magnetLabel2",xmLabelWidgetClass,
    magnetForm,NULL);
  text=XmStringCreateLocalized("Multiplication pr. sec.:");
  XtVaSetValues(magnetLabel2,XmNlabelString,text,XmNx,0,XmNy,49,NULL);

 magnetTextfield3=XtVaCreateManagedWidget("magnetTextfield3",
    xmTextFieldWidgetClass,magnetForm,NULL);
  XtVaSetValues(magnetTextfield3,XmNwidth,80,XmNx,270,XmNy,80,
    XmNvalue,"0",NULL);
  magnetLabel3=XtVaCreateManagedWidget("magnetLabel3",xmLabelWidgetClass,
    magnetForm,NULL);
  text=XmStringCreateLocalized("Number of additional voices");
  XtVaSetValues(magnetLabel3,XmNlabelString,text,XmNx,0,XmNy,84,NULL);

 magnetTextfield4=XtVaCreateManagedWidget("magnetTextfield4",
    xmTextFieldWidgetClass,magnetForm,NULL);
  XtVaSetValues(magnetTextfield4,XmNwidth,80,XmNx,270,XmNy,115,
    XmNvalue,"1.00125",NULL);
  magnetLabel4=XtVaCreateManagedWidget("magnetLabel4",xmLabelWidgetClass,
    magnetForm,NULL);
  text=XmStringCreateLocalized("Spread of voices (% of 1st voice)");
  XtVaSetValues(magnetLabel4,XmNlabelString,text,XmNx,0,XmNy,119,NULL);

  magnetToggle1=XtVaCreateManagedWidget("magnetToggle1",
    xmToggleButtonWidgetClass,magnetForm,NULL);
  text=XmStringCreateLocalized("Control function 1 -> Probability");
  XtVaSetValues(magnetToggle1,XmNlabelString,text,XmNset,False,
    XmNy,150,NULL);

  magnetToggle2=XtVaCreateManagedWidget("magnetToggle2",
    xmToggleButtonWidgetClass,magnetForm,NULL);
  text=XmStringCreateLocalized("Control function 2 -> Move tendency");
  XtVaSetValues(magnetToggle2,XmNlabelString,text,XmNset,False,
    XmNy,175,NULL);

  magnetToggle3=XtVaCreateManagedWidget("magnetToggle3",
    xmToggleButtonWidgetClass,magnetForm,NULL);
  text=XmStringCreateLocalized("Control function 3 -> CF2 Move tendency scaler ");
  XtVaSetValues(magnetToggle3,XmNlabelString,text,XmNset,False,
    XmNy,200,NULL);

  text=XmStringCreateLocalized("Move to pitch grid");
  XtVaSetValues(magnetForm,XmNdialogTitle,text,
    XmNcancelButton,magnetCancelButton,
    XmNdefaultButton,magnetOkButton,NULL);

  XtAddCallback(magnetOkButton,XmNactivateCallback,MagnetOk,NULL);
  XtAddCallback(magnet,XmNactivateCallback,Magnet,0);


  /* CREATE CONVOLVE BUTTON */
  convolveButton=XtVaCreateManagedWidget(
    "convolveButton",xmPushButtonWidgetClass,transMenu,NULL);
  text=XmStringCreateLocalized("Convolve...");
  XtVaSetValues(convolveButton,XmNlabelString,text,NULL);

  convolveForm=XmCreateBulletinBoardDialog(mainWindow,"convolveForm",NULL,0);
  convolveOkButton=XtVaCreateManagedWidget("convolveOk",xmPushButtonWidgetClass,
    convolveForm,NULL);
  text=XmStringCreateLocalized("Ok");
  XtVaSetValues(convolveOkButton,XmNlabelString,text,XmNx,50,XmNy,140,
    XmNwidth,90,NULL);
  convolveCancelButton=XtVaCreateManagedWidget("convolveCancel",
    xmPushButtonWidgetClass,convolveForm,NULL);
  text=XmStringCreateLocalized("Cancel");
  XtVaSetValues(convolveCancelButton,XmNlabelString,text,XmNx,200,XmNy,140,NULL);

  convolveRadio=XtVaCreateManagedWidget("convolveRadio",
    xmRowColumnWidgetClass,convolveForm,NULL);
  XtVaSetValues(convolveRadio,XmNy,0,XmNradioBehavior,True,
    XmNradioAlwaysOne,True,NULL);
  convolveToggleLaplace=XtVaCreateManagedWidget("convolveToggleLaplace",
    xmToggleButtonWidgetClass,convolveRadio,NULL);
  text=XmStringCreateLocalized("Laplace");
  XtVaSetValues(convolveToggleLaplace,XmNlabelString,text,XmNset,True,NULL);
  convolveToggleMean=XtVaCreateManagedWidget("convolveToggleMean",
    xmToggleButtonWidgetClass,convolveRadio,NULL);
  text=XmStringCreateLocalized("Mean");
  XtVaSetValues(convolveToggleMean,XmNlabelString,text,NULL);
  convolveToggleTimeMean=XtVaCreateManagedWidget("convolveToggleTimeMean",
    xmToggleButtonWidgetClass,convolveRadio,NULL);
  text=XmStringCreateLocalized("Time Mean");
  XtVaSetValues(convolveToggleTimeMean,XmNlabelString,text,NULL);
  convolveToggleFile=XtVaCreateManagedWidget("convolveToggleFile",
    xmToggleButtonWidgetClass,convolveRadio,NULL);
  text=XmStringCreateLocalized("Read from file: . /");
  XtVaSetValues(convolveToggleFile,XmNlabelString,text,NULL);
   convolveTextfield=XtVaCreateManagedWidget("convolveTextfield",
    xmTextFieldWidgetClass,convolveForm,NULL);
  XtVaSetValues(convolveTextfield,XmNwidth,153,XmNx,160,XmNy, 105,
    XmNvalue,"convolve",NULL);
  text=XmStringCreateLocalized("Convolve with local operator");
  XtVaSetValues(convolveForm,XmNdialogTitle,text,
    XmNcancelButton,convolveCancelButton,XmNdefaultButton,convolveOkButton,NULL);

  XtAddCallback(convolveButton,XmNactivateCallback,Convolve,0);
  XtAddCallback(convolveOkButton,XmNactivateCallback,ConvolveOk,0);


  /* CREATE TRPEAKS BUTTON */
  trpeaks=XtVaCreateManagedWidget(
    "trpeaks",xmPushButtonWidgetClass,transMenu,NULL);
  text=XmStringCreateLocalized("Keep peaks only");
  XtVaSetValues(trpeaks,XmNlabelString,text,NULL);
  XtAddCallback(trpeaks,XmNactivateCallback,Trpeaks,0);

  /* CREATE LTAS BUTTON */
  ltas=XtVaCreateManagedWidget(
    "ltas",xmPushButtonWidgetClass,transMenu,NULL);
  text=XmStringCreateLocalized("Average");
  XtVaSetValues(ltas,XmNlabelString,text,NULL);
  XtAddCallback(ltas,XmNactivateCallback,LTAS,0);



 
printf(". ");
  /*____________ CREATE SETTINGS MENU________________________ */

  settingsButton=XtVaCreateManagedWidget(
    "settingsButton",xmCascadeButtonWidgetClass,menuBar,
	XmNmnemonic,XStringToKeysym("S"),
	NULL);
  text=XmStringCreateLocalized("Settings");
  XtVaSetValues(settingsButton,XmNlabelString,text,NULL);
  settingsMenu=XmCreatePulldownMenu(menuBar,"settingsMenu",NULL,0);
  XtVaSetValues(settingsButton,XmNsubMenuId,settingsMenu,NULL);


  /*_____________ CREATE ANALYSIS BUTTON _____________________*/
  analyButton=XtVaCreateManagedWidget(
    "analyButton",xmPushButtonWidgetClass,settingsMenu,
    XmNmnemonic,XStringToKeysym("A"),XmNaccelerator,"Alt<Key>A",
    XmNacceleratorText,XmStringCreateLocalized("Alt+A"),NULL);
  text=XmStringCreateLocalized("Analysis");
  XtVaSetValues(analyButton,XmNlabelString,text,NULL);

  analyForm=XmCreateBulletinBoardDialog(mainWindow,"analyForm",NULL,0);
  XtVaSetValues(analyForm, XmNwidth, 300, NULL);
  analyOkButton=XtVaCreateManagedWidget("analyOk",xmPushButtonWidgetClass,
    analyForm,NULL);
  text=XmStringCreateLocalized("Ok");
  XtVaSetValues(analyOkButton,XmNlabelString,text,XmNx,30,XmNy,350,
    XmNwidth,80,NULL);
  analyCancelButton=XtVaCreateManagedWidget("analyCancel",
    xmPushButtonWidgetClass,analyForm,NULL);
  text=XmStringCreateLocalized("Cancel");
  XtVaSetValues(analyCancelButton,XmNlabelString,text,XmNx,125,XmNy,350,
	XmNwidth,80,NULL);

  analyLabel1=XtVaCreateManagedWidget("analyLabel1",xmLabelWidgetClass,
    analyForm,NULL);
  text=XmStringCreateLocalized("Window function:");
  XtVaSetValues(analyLabel1,XmNlabelString,text,XmNx,0,XmNy,14,NULL);

  analyRadio=XtVaCreateManagedWidget("analyRadio",
    xmRowColumnWidgetClass,analyForm,NULL);
  XtVaSetValues(analyRadio,XmNy,50,XmNradioBehavior,True,
    XmNradioAlwaysOne,True,NULL);
  analyToggleHanning=XtVaCreateManagedWidget("analyToggleHanning",
    xmToggleButtonWidgetClass,analyRadio,NULL);
  text=XmStringCreateLocalized("Hanning");
  XtVaSetValues(analyToggleHanning,XmNlabelString,text,XmNset,False,NULL);
  analyToggleHamming=XtVaCreateManagedWidget("analyToggleHamming",
    xmToggleButtonWidgetClass,analyRadio,NULL);
  text=XmStringCreateLocalized("Hamming");
  XtVaSetValues(analyToggleHamming,XmNlabelString,text,XmNset,False,NULL);
  analyToggleBartlett=XtVaCreateManagedWidget("analyToggleBartlett",
    xmToggleButtonWidgetClass,analyRadio,NULL);
  text=XmStringCreateLocalized("Bartlett");
  XtVaSetValues(analyToggleBartlett,XmNlabelString,text,XmNset,False,NULL);
  analyToggleKaiser=XtVaCreateManagedWidget("analyToggleKaiser",
    xmToggleButtonWidgetClass,analyRadio,NULL);
  text=XmStringCreateLocalized("Kaiser");
  XtVaSetValues(analyToggleKaiser,XmNlabelString,text,XmNset,True,NULL);
  analyToggleRect=XtVaCreateManagedWidget("analyToggleRect",
    xmToggleButtonWidgetClass,analyRadio,NULL);
  text=XmStringCreateLocalized("Rectangular");
  XtVaSetValues(analyToggleRect,XmNlabelString,text,NULL);
  analyToggleGauss=XtVaCreateManagedWidget("analyToggAnalyleGauss",
    xmToggleButtonWidgetClass,analyRadio,NULL);
  text=XmStringCreateLocalized("Gauss");
  XtVaSetValues(analyToggleGauss,XmNlabelString,text,XmNset,False,
   /* XmNsensitive,False,*/NULL);
  analyToggleBlackmann=XtVaCreateManagedWidget("analyToggleBlackmann",
    xmToggleButtonWidgetClass,analyRadio,NULL);
  text=XmStringCreateLocalized("Blackmann");
  XtVaSetValues(analyToggleBlackmann,XmNlabelString,text,XmNset,False,NULL);
  analyToggleWelch=XtVaCreateManagedWidget("analyToggleWelch",
    xmToggleButtonWidgetClass,analyRadio,NULL);
  text=XmStringCreateLocalized("Welch");
  XtVaSetValues(analyToggleWelch,XmNlabelString,text,XmNset,False,NULL);

  text=XmStringCreateLocalized("Analysis settings");
  XtVaSetValues(analyForm,XmNdialogTitle,text,
    XmNcancelButton,analyCancelButton,
    XmNdefaultButton,analyOkButton,NULL);

  XtAddCallback(analyOkButton,XmNactivateCallback,AnalyOk,0);
  XtAddCallback(analyButton,XmNactivateCallback,Analy,0);

  /*__________________ CREATE FFT SETTINGS BUTTON_______________________ */

  FFTButton=XtVaCreateManagedWidget(
    "FFTButton",xmPushButtonWidgetClass,settingsMenu,
	XmNmnemonic,XStringToKeysym("P"),XmNaccelerator,"Alt<Key>P",
    XmNacceleratorText,XmStringCreateLocalized("Alt+P"),NULL);
  text=XmStringCreateLocalized("FFT/Play");
  XtVaSetValues(FFTButton,XmNlabelString,text,NULL);

  FFTForm=XmCreateBulletinBoardDialog(mainWindow,"FFTForm",NULL,0);
  XtVaSetValues(FFTForm, XmNwidth, 300, NULL);
  FFTOkButton=XtVaCreateManagedWidget("FFTOk",xmPushButtonWidgetClass,
    FFTForm,NULL);
  text=XmStringCreateLocalized("Ok");
  XtVaSetValues(FFTOkButton,XmNlabelString,text,XmNx,100,XmNy,327,
    XmNwidth,90,NULL);
  FFTCancelButton=XtVaCreateManagedWidget("FFTCancel",
    xmPushButtonWidgetClass,FFTForm,NULL);
  text=XmStringCreateLocalized("Cancel");
  XtVaSetValues(FFTCancelButton,XmNlabelString,text,XmNx,250,XmNy,327,NULL);

  FFTLabel1=XtVaCreateManagedWidget("FFTLabel1",xmLabelWidgetClass,
    FFTForm,NULL);
  text=XmStringCreateLocalized("FFT Size");
  XtVaSetValues(FFTLabel1,XmNlabelString,text,XmNx,0,XmNy,14,NULL);

  FFTRadio=XtVaCreateManagedWidget("FFTRadio",
    xmRowColumnWidgetClass,FFTForm,NULL);
  XtVaSetValues(FFTRadio,XmNy,40,XmNradioBehavior,True,
    XmNradioAlwaysOne,True,NULL);
  FFTToggle512=XtVaCreateManagedWidget("FFTToggle512",
    xmToggleButtonWidgetClass,FFTRadio,NULL);
  text=XmStringCreateLocalized("512");
  XtVaSetValues(FFTToggle512,XmNlabelString,text,XmNset,False,
    XmNsensitive,fftt,NULL);
  FFTToggle1024=XtVaCreateManagedWidget("FFTToggle1024",
    xmToggleButtonWidgetClass,FFTRadio,NULL);
  text=XmStringCreateLocalized("1024");
  XtVaSetValues(FFTToggle1024,XmNlabelString,text,XmNset,True,
    XmNsensitive,fftt,NULL);
  FFTToggle2048=XtVaCreateManagedWidget("FFTToggle2048",
    xmToggleButtonWidgetClass,FFTRadio,NULL);
  text=XmStringCreateLocalized("2048");
  XtVaSetValues(FFTToggle2048,XmNlabelString,text,XmNset,False,
    XmNsensitive,fftt,NULL);
  FFTToggle4096=XtVaCreateManagedWidget("FFTToggle4096",
    xmToggleButtonWidgetClass,FFTRadio,NULL);
  text=XmStringCreateLocalized("4096");
  XtVaSetValues(FFTToggle4096,XmNlabelString,text,XmNset,False,
    XmNsensitive,fftt,NULL);
  FFTToggle8192=XtVaCreateManagedWidget("FFTToggle8192",
    xmToggleButtonWidgetClass,FFTRadio,NULL);
  text=XmStringCreateLocalized("8192");
  XtVaSetValues(FFTToggle8192,XmNlabelString,text,XmNset,False,
    XmNsensitive,fftt,NULL);

  FFTLabel2=XtVaCreateManagedWidget("FFTLabel2",xmLabelWidgetClass,
    FFTForm,NULL);
  text=XmStringCreateLocalized("Window Size");
  XtVaSetValues(FFTLabel2,XmNlabelString,text,XmNx,140,XmNy,14,NULL);

  FFTRadio2=XtVaCreateManagedWidget("FFTRadio2",
    xmRowColumnWidgetClass,FFTForm,NULL);
  XtVaSetValues(FFTRadio2,XmNx,140,XmNy,40,XmNradioBehavior,True,
    XmNradioAlwaysOne,True,NULL);
  WindowToggle512=XtVaCreateManagedWidget("WindowToggle512",
    xmToggleButtonWidgetClass,FFTRadio2,NULL);
  text=XmStringCreateLocalized("512");
  XtVaSetValues(WindowToggle512,XmNlabelString,text,XmNset,False,
    XmNsensitive,True,NULL);
  WindowToggle1024=XtVaCreateManagedWidget("WindowToggle1024",
    xmToggleButtonWidgetClass,FFTRadio2,NULL);
  text=XmStringCreateLocalized("1024");
  XtVaSetValues(WindowToggle1024,XmNlabelString,text,XmNset,True,
    XmNsensitive,True,NULL);
  WindowToggle2048=XtVaCreateManagedWidget("WindowToggle2048",
    xmToggleButtonWidgetClass,FFTRadio2,NULL);
  text=XmStringCreateLocalized("2048");
  XtVaSetValues(WindowToggle2048,XmNlabelString,text,XmNset,False,
    XmNsensitive,True,NULL);
  WindowToggle4096=XtVaCreateManagedWidget("WindowToggle4096",
    xmToggleButtonWidgetClass,FFTRadio2,NULL);
  text=XmStringCreateLocalized("4096");
  XtVaSetValues(WindowToggle4096,XmNlabelString,text,XmNset,False,
    XmNsensitive,True,NULL);
  WindowToggle8192=XtVaCreateManagedWidget("WindowToggle8192",
    xmToggleButtonWidgetClass,FFTRadio2,NULL);
  text=XmStringCreateLocalized("8192");
  XtVaSetValues(WindowToggle8192,XmNlabelString,text,XmNset,False,
    XmNsensitive,True,NULL);
  WindowToggle16384=XtVaCreateManagedWidget("WindowToggle16384",
    xmToggleButtonWidgetClass,FFTRadio2,NULL);
  text=XmStringCreateLocalized("16384");
  XtVaSetValues(WindowToggle16384,XmNlabelString,text,XmNset,False,
    XmNsensitive,True,NULL);

  FFTLabel3=XtVaCreateManagedWidget("FFTLabel3",xmLabelWidgetClass,
    FFTForm,NULL);
  text=XmStringCreateLocalized("Window overlap");
  XtVaSetValues(FFTLabel3,XmNlabelString,text,XmNx,280,XmNy,14,NULL);

  FFTRadio3=XtVaCreateManagedWidget("FFTRadio3",
    xmRowColumnWidgetClass,FFTForm,NULL);
  XtVaSetValues(FFTRadio3,XmNx,280,XmNy,40,XmNradioBehavior,True,
    XmNradioAlwaysOne,True,NULL);
  OverlapToggle2=XtVaCreateManagedWidget("OverlapToggle2",
    xmToggleButtonWidgetClass,FFTRadio3,NULL);
  text=XmStringCreateLocalized("1/2 Window size");
  XtVaSetValues(OverlapToggle2,XmNlabelString,text,XmNset,False,
    XmNsensitive,True,NULL);
  OverlapToggle4=XtVaCreateManagedWidget("OverlapToggle4",
    xmToggleButtonWidgetClass,FFTRadio3,NULL);
  text=XmStringCreateLocalized("1/4 Window size");
  XtVaSetValues(OverlapToggle4,XmNlabelString,text,XmNset,False,
    XmNsensitive,True,NULL);
  OverlapToggle8=XtVaCreateManagedWidget("OverlapToggle8",
    xmToggleButtonWidgetClass,FFTRadio3,NULL);
  text=XmStringCreateLocalized("1/8 Window size");
  XtVaSetValues(OverlapToggle8,XmNlabelString,text,XmNset,True,
    XmNsensitive,True,NULL);
  OverlapToggle16=XtVaCreateManagedWidget("OverlapToggle16",
    xmToggleButtonWidgetClass,FFTRadio3,NULL);
  text=XmStringCreateLocalized("1/16 Window size");
  XtVaSetValues(OverlapToggle16,XmNlabelString,text,XmNset,False,
    XmNsensitive,True,NULL);
  OverlapToggle32=XtVaCreateManagedWidget("OverlapToggle32",
    xmToggleButtonWidgetClass,FFTRadio3,NULL);
  text=XmStringCreateLocalized("1/32 Window size");
  XtVaSetValues(OverlapToggle32,XmNlabelString,text,XmNset,False,
    XmNsensitive,True,NULL);

 playSepar=XtVaCreateManagedWidget("playSepar",
    xmSeparatorWidgetClass,FFTForm, XmNorientation, XmHORIZONTAL,/* 
XmNx,75,*/XmNy, 228, XmNwidth, 420,NULL);

/*240, 235*/
 winSizeToggle=XtVaCreateManagedWidget("winSizeToggle",
    xmToggleButtonWidgetClass,FFTForm, XmNx,20, XmNy, 240, NULL);
  text=XmStringCreateLocalized("Exact window size / Lowest pitch:");
  XtVaSetValues(winSizeToggle,XmNlabelString,text,XmNset,False,
    XmNsensitive,True,NULL);
  winSizeTextfield=XtVaCreateManagedWidget("winSizeTextfield",
    xmTextFieldWidgetClass,FFTForm,NULL);
  XtVaSetValues(winSizeTextfield,XmNwidth,120,XmNx,270,XmNy,235,
    XmNvalue,"2048",NULL);
 playSepar1=XtVaCreateManagedWidget("playSepar1",
    xmSeparatorWidgetClass,FFTForm, XmNorientation, XmHORIZONTAL,/* 
XmNx,75,*/XmNy, 275, XmNwidth, 420,NULL);
  playLabel=XtVaCreateManagedWidget("playLabel",xmLabelWidgetClass,
    FFTForm,NULL);
  text=XmStringCreateLocalized("Sound Playback Engine:"); 
  XtVaSetValues(playLabel,XmNlabelString,text,XmNx,25,XmNy,287,NULL);

  playTextfield=XtVaCreateManagedWidget("playTextfield",
    xmTextFieldWidgetClass,FFTForm,NULL);

#ifdef POWERPC
  XtVaSetValues(playTextfield,XmNwidth,120,XmNx,270,XmNy,282,
    XmNvalue,"sndplay",NULL);
#elif CMIX
  XtVaSetValues(playTextfield,XmNwidth,120,XmNx,270,XmNy,282,
    XmNvalue,"cmixplay",NULL);
#elif SND
  XtVaSetValues(playTextfield,XmNwidth,120,XmNx,270,XmNy,282,
    XmNvalue,"sndplay",NULL);
#elif SGI
  XtVaSetValues(playTextfield,XmNwidth,120,XmNx,270,XmNy,282,
    XmNvalue,"sfplay",NULL);
#elif SNDFILEPLAY
  XtVaSetValues(playTextfield,XmNwidth,120,XmNx,270,XmNy,282,
    XmNvalue,"sndfile-play",NULL);
#else
  XtVaSetValues(playTextfield,XmNwidth,120,XmNx,270,XmNy,282,
    XmNvalue,"play",NULL);
#endif
 playSepar2=XtVaCreateManagedWidget("playSepar2",
    xmSeparatorWidgetClass,FFTForm, XmNorientation, XmHORIZONTAL,/* 
XmNx,75,*/XmNy, 322, XmNwidth, 420,NULL);

  XtAddCallback(FFTOkButton,XmNactivateCallback,FFTOk,0);
  XtAddCallback(FFTButton,XmNactivateCallback,FFT,0);

  /* CREATE RESYNT BUTTON */
  resyntButton=XtVaCreateManagedWidget(
    "resyntButton",xmPushButtonWidgetClass,settingsMenu,
  XmNmnemonic,XStringToKeysym("R"),XmNaccelerator,"Alt<Key>R",
    XmNacceleratorText,XmStringCreateLocalized("Alt+R"),NULL);
  text=XmStringCreateLocalized("Resynthesis");
  XtVaSetValues(resyntButton,XmNlabelString,text,NULL);

  settingsForm=XmCreateBulletinBoardDialog(mainWindow,"settingsForm",NULL,0);
  settingsOkButton=XtVaCreateManagedWidget("settingsOk",xmPushButtonWidgetClass,
    settingsForm,NULL);
  text=XmStringCreateLocalized("Ok");
  XtVaSetValues(settingsOkButton,XmNlabelString,text,XmNx,50,XmNy,235,
    XmNwidth,90,NULL);
  settingsCancelButton1=XtVaCreateManagedWidget("settingsCancel",
    xmPushButtonWidgetClass,settingsForm,NULL);
  text=XmStringCreateLocalized("Cancel");
  XtVaSetValues(settingsCancelButton1,XmNlabelString,text,XmNx,200,XmNy,235,NULL);

  settingsTextfield=XtVaCreateManagedWidget("settingsTextfield",
    xmTextFieldWidgetClass,settingsForm,NULL);
  XtVaSetValues(settingsTextfield,XmNwidth,70,XmNx,240,XmNy,10,
    XmNvalue,"1",NULL);
  settingsLabel1=XtVaCreateManagedWidget("settingsLabel1",xmLabelWidgetClass,
    settingsForm,NULL);
  text=XmStringCreateLocalized("Time stretch factor:");
  XtVaSetValues(settingsLabel1,XmNlabelString,text,XmNx,0,XmNy,14,NULL);

  interpolToggle=XtVaCreateManagedWidget("interpolToggle",
    xmToggleButtonWidgetClass,settingsForm,NULL);
  text=XmStringCreateLocalized("Control function 1 -> Time Stretch (0.5-3)");
  XtVaSetValues(interpolToggle,XmNlabelString,text,XmNx,25,XmNy,45,NULL);
  
 
 settingsSepar=XtVaCreateManagedWidget("settingsSepar", xmSeparatorWidgetClass,
    settingsForm, XmNorientation, XmHORIZONTAL,/* XmNx,75,*/XmNy, 75, 
    XmNwidth, 300, NULL);

   settingsRadio=XtVaCreateManagedWidget("settingsRadio",
    xmRowColumnWidgetClass,settingsForm,NULL);
  XtVaSetValues(settingsRadio,XmNy,80,XmNradioBehavior,True,
    XmNradioAlwaysOne,True,NULL);
  settingsToggle1=XtVaCreateManagedWidget("settingsToggle1",
    xmToggleButtonWidgetClass,settingsRadio,NULL);
  text=XmStringCreateLocalized("IFFT overlap-add resynth ");
  XtVaSetValues(settingsToggle1,XmNlabelString,text,NULL);
  settingsToggle2=XtVaCreateManagedWidget("settingsToggle2",
    xmToggleButtonWidgetClass,settingsRadio,NULL);
  text=XmStringCreateLocalized("Oscillator-bank resynth ");
 XtVaSetValues(settingsToggle2,XmNlabelString,text,XmNset,True,NULL);
  settingsToggle3=XtVaCreateManagedWidget("settingsToggle3",
    xmToggleButtonWidgetClass,settingsRadio,NULL);
  text=XmStringCreateLocalized("Oscillator-bank resynth (fast)");
  XtVaSetValues(settingsToggle3,XmNlabelString,text,NULL);

 syntTextfield=XtVaCreateManagedWidget("syntTextfield",
    xmTextFieldWidgetClass,settingsForm,NULL);
  XtVaSetValues(syntTextfield,XmNwidth,70,XmNx,240,XmNy,165,
    XmNvalue,"1.0", NULL);
  syntLabel=XtVaCreateManagedWidget("syntLabel",xmLabelWidgetClass,
    settingsForm,NULL);
  text=XmStringCreateLocalized("Resynthesis treshold (% avg.):");
  XtVaSetValues(syntLabel,XmNlabelString,text,XmNx,30,XmNy,175,NULL);

  syntToggle=XtVaCreateManagedWidget("syntToggle",
    xmToggleButtonWidgetClass,settingsForm,NULL);
  text=XmStringCreateLocalized("Control function 3 -> Tresh. Mult. (0-1)");
  XtVaSetValues(syntToggle,XmNlabelString,text,XmNx,25,XmNy,200,NULL);
  

  
  text=XmStringCreateLocalized("Resynthesis settings");
  XtVaSetValues(settingsForm,XmNdialogTitle,text,
    XmNcancelButton,settingsCancelButton1,
    XmNdefaultButton,settingsOkButton,NULL);

  XtAddCallback(settingsOkButton,XmNactivateCallback,SettingsOk,0);
  XtAddCallback(resyntButton,XmNactivateCallback,Settings,0);
 
  /* CREATE DISPLAY BUTTON */
  displayButton=XtVaCreateManagedWidget(
    "displayButton",xmPushButtonWidgetClass,settingsMenu,
    XmNmnemonic,XStringToKeysym("D"),XmNaccelerator,"Alt<Key>D",
    XmNacceleratorText,XmStringCreateLocalized("Alt+D"),NULL);
  text=XmStringCreateLocalized("Edit/Display");
  XtVaSetValues(displayButton,XmNlabelString,text,NULL);

  displayForm=XmCreateBulletinBoardDialog(mainWindow,"displayForm",NULL,0);
  displayOkButton=XtVaCreateManagedWidget("displayOk",xmPushButtonWidgetClass,
    displayForm,NULL);
  text=XmStringCreateLocalized("Ok");
  XtVaSetValues(displayOkButton,XmNlabelString,text,XmNx,130,XmNy,240,
    XmNwidth,90,NULL);
  displayCancelButton=XtVaCreateManagedWidget("displayCancel",
    xmPushButtonWidgetClass,displayForm,NULL);
  text=XmStringCreateLocalized("Cancel");
  XtVaSetValues(displayCancelButton,XmNlabelString,text,XmNx,290,XmNy,240,NULL);

  displaySepar = XtVaCreateManagedWidget("displaySepar", xmSeparatorWidgetClass,
    displayForm, XmNorientation, XmHORIZONTAL,/* XmNx,75,*/XmNy, 230, 
    XmNwidth, 500, NULL);


  colorRadio=XtVaCreateManagedWidget("colorRadio",
    xmRowColumnWidgetClass,displayForm,NULL);
  XtVaSetValues(colorRadio,XmNy,140,XmNradioBehavior,True,
    XmNradioAlwaysOne,True,NULL);
  displayToggleGrey=XtVaCreateManagedWidget("displayToggleGrey",
    xmToggleButtonWidgetClass,colorRadio,NULL);
  text=XmStringCreateLocalized("Grey colors");
  XtVaSetValues(displayToggleGrey,XmNlabelString,text,NULL);
  displayToggleHot=XtVaCreateManagedWidget("displayToggleHot",
    xmToggleButtonWidgetClass,colorRadio,NULL);
  text=XmStringCreateLocalized("Hot colors");
  XtVaSetValues(displayToggleHot,XmNlabelString,text,XmNset,True,NULL);
  displayToggleCold=XtVaCreateManagedWidget("displayToggleCold",
    xmToggleButtonWidgetClass,colorRadio,NULL);
  text=XmStringCreateLocalized("Cool colors");
  XtVaSetValues(displayToggleCold,XmNlabelString,text,NULL);

  funcRadio=XtVaCreateManagedWidget("funcRadio",
    xmRowColumnWidgetClass,displayForm,NULL);
  XtVaSetValues(funcRadio,XmNx,150,XmNy,140,XmNradioBehavior,True,
    XmNradioAlwaysOne,True,NULL);
  displayToggleFunc=XtVaCreateManagedWidget("displayToggleFunc",
    xmToggleButtonWidgetClass,funcRadio,NULL);
  text=XmStringCreateLocalized("Edit control function 1");
  XtVaSetValues(displayToggleFunc,XmNset,True,XmNlabelString,text,NULL);
  displayToggleFunc2=XtVaCreateManagedWidget("displayToggleFunc2",
    xmToggleButtonWidgetClass,funcRadio,/*XmNaccelerator,"Ctrl<Key>2",*/
    NULL);
  text=XmStringCreateLocalized("Edit control function 2");
  XtVaSetValues(displayToggleFunc2,XmNlabelString,text,
   /*XmNaccelerator,"Ctrl<Key>2",*/NULL);
  displayToggleFunc3=XtVaCreateManagedWidget("displayToggleFunc3",
    xmToggleButtonWidgetClass,funcRadio,NULL);
  text=XmStringCreateLocalized("Edit control function 3");
  XtVaSetValues(displayToggleFunc3,XmNlabelString,text,NULL);
  
  displayToggleFuncAll=XtVaCreateManagedWidget("displayToggleFuncAll",
    xmToggleButtonWidgetClass,displayForm,NULL);
  text=XmStringCreateLocalized("Show control functions");
  XtVaSetValues(displayToggleFuncAll,XmNset,True,XmNlabelString,text,NULL);
  
  areaRadio=XtVaCreateManagedWidget("areaRadio",
    xmRowColumnWidgetClass,displayForm,NULL);
  XtVaSetValues(areaRadio,XmNx,350,XmNy,140,XmNradioBehavior,True,
    XmNradioAlwaysOne,False,NULL);
  displayToggleArea=XtVaCreateManagedWidget("displayToggleArea",
    xmToggleButtonWidgetClass,areaRadio,NULL);
  text=XmStringCreateLocalized("Activate/edit area 1");
  XtVaSetValues(displayToggleArea,XmNlabelString,text,NULL);
  displayToggleArea2=XtVaCreateManagedWidget("displayToggleArea2",
    xmToggleButtonWidgetClass,areaRadio,NULL);
  text=XmStringCreateLocalized("Activate/edit area 2");
  XtVaSetValues(displayToggleArea2,XmNlabelString,text,NULL);
  displayToggleArea3=XtVaCreateManagedWidget("displayToggleArea3",
    xmToggleButtonWidgetClass,areaRadio,NULL);
  text=XmStringCreateLocalized("Activate/edit area 3");
  XtVaSetValues(displayToggleArea3,XmNlabelString,text,NULL);
  
  displayToggleAreaAll=XtVaCreateManagedWidget("displayToggleAreaAll",
    xmToggleButtonWidgetClass,displayForm,NULL);
  text=XmStringCreateLocalized("Show all areas");
  XtVaSetValues(displayToggleAreaAll,XmNlabelString,text,XmNy,35,NULL);

  displayToggleQuit=XtVaCreateManagedWidget("displayToggleQuit",
    xmToggleButtonWidgetClass,displayForm,NULL);
  text=XmStringCreateLocalized("Ask on quit");
  XtVaSetValues(displayToggleQuit,XmNlabelString,text,XmNset,True,XmNy,60,NULL);

  displayToggleScale=XtVaCreateManagedWidget("displayToggleScale",
    xmToggleButtonWidgetClass,displayForm,NULL);
  text=XmStringCreateLocalized("Show pitch grid");
  XtVaSetValues(displayToggleScale,XmNlabelString,text,XmNx,190,XmNy,0,NULL);
 
  displayToggleGrid=XtVaCreateManagedWidget("displayToggleGrid",
    xmToggleButtonWidgetClass,displayForm,NULL);
  text=XmStringCreateLocalized("Show display grid");
  XtVaSetValues(displayToggleGrid,XmNlabelString,text,XmNx,190,XmNy,35,NULL);

  displayToggleOverwrite=XtVaCreateManagedWidget("displayToggleOverwrite",
    xmToggleButtonWidgetClass,displayForm,NULL);
  text=XmStringCreateLocalized("Warn on overwrite");
  XtVaSetValues(displayToggleOverwrite,XmNlabelString,text,XmNset,True,XmNx,190,
    XmNy,60,NULL);  

  allowUndoToggle=XtVaCreateManagedWidget("allowUndoToggle",
    xmToggleButtonWidgetClass,displayForm,NULL);
  text=XmStringCreateLocalized("Allow Undo");
  XtVaSetValues(allowUndoToggle,XmNlabelString,text,XmNx,350,XmNy,0,NULL);
  
  displayToggleSpots=XtVaCreateManagedWidget("displayToggleSpots",
    xmToggleButtonWidgetClass,displayForm,NULL);
  text=XmStringCreateLocalized("Allow Paint");
  XtVaSetValues(displayToggleSpots,XmNlabelString,text,XmNx,350,XmNy,35,NULL);

  displayToggleUpdate=XtVaCreateManagedWidget("displayToggleUpdate",
    xmToggleButtonWidgetClass,displayForm,NULL);
  text=XmStringCreateLocalized("Update & Progress");
  XtVaSetValues(displayToggleUpdate,XmNlabelString,text,
  XmNset,True,XmNx,350,XmNy,60,NULL);
 
    displayTextfield=XtVaCreateManagedWidget("displayTextfield",
    xmTextFieldWidgetClass,displayForm,NULL);
  XtVaSetValues(displayTextfield,XmNwidth,50,XmNx,360,XmNy,100,
    XmNvalue,argc>=5?argv[4]:"700",NULL);
  displayLabel4=XtVaCreateManagedWidget("displayLabel4",xmLabelWidgetClass,
    displayForm,NULL);
  text=XmStringCreateLocalized("Display width:");
  XtVaSetValues(displayLabel4,XmNlabelString,text,XmNx,260,XmNy,107,NULL);

  text=XmStringCreateLocalized("FFT/Play settings");
  XtVaSetValues(FFTForm,XmNdialogTitle,text,
    XmNcancelButton,FFTCancelButton,
    XmNdefaultButton,FFTOkButton,NULL);


  spotsTextfield=XtVaCreateManagedWidget("spotsTextfield",
    xmTextFieldWidgetClass,displayForm,NULL);
  XtVaSetValues(spotsTextfield,XmNwidth,50,XmNx,110,XmNy,100,
    XmNvalue,"3",NULL);
  spotsLabel1=XtVaCreateManagedWidget("spotsLabel1",xmLabelWidgetClass,
    displayForm,NULL);
  text=XmStringCreateLocalized("Paint size:");
  XtVaSetValues(spotsLabel1,XmNlabelString,text,XmNx,0,XmNy,107,NULL);

  text=XmStringCreateLocalized("Edit/Display settings");
  XtVaSetValues(displayForm,XmNdialogTitle,text,
    XmNcancelButton,displayCancelButton,
    XmNdefaultButton,displayOkButton,NULL);

  XtAddCallback(displayOkButton,XmNactivateCallback,DisplayOk,0);
  XtAddCallback(displayButton,XmNactivateCallback,Displaymenu,0);


  /*_____________________ CREATE GRID BUTTON_________________________ */
  gridButton=XtVaCreateManagedWidget(
    "gridButton",xmPushButtonWidgetClass,settingsMenu,
    XmNmnemonic,XStringToKeysym("G"),XmNaccelerator,"Alt<Key>G",
    XmNacceleratorText,XmStringCreateLocalized("Alt+G"),NULL);
  text=XmStringCreateLocalized("Pitch Grid");
  XtVaSetValues(gridButton,XmNlabelString,text,NULL);

  gridForm=XmCreateBulletinBoardDialog(mainWindow,"gridForm",NULL,0);
  gridOkButton=XtVaCreateManagedWidget("gridOk",xmPushButtonWidgetClass,
    gridForm,NULL);
  text=XmStringCreateLocalized("Ok");
  XtVaSetValues(gridOkButton,XmNlabelString,text,XmNx,50,XmNy,520,
    XmNwidth,90,NULL);
  gridCancelButton=XtVaCreateManagedWidget("gridCancel",
    xmPushButtonWidgetClass,gridForm,NULL);
  text=XmStringCreateLocalized("Cancel");
  XtVaSetValues(gridCancelButton,XmNlabelString,text,XmNx,175,XmNy,520,NULL);


  modeRadio=XtVaCreateManagedWidget("modeRadio",xmRowColumnWidgetClass,gridForm,
	XmNpacking, XmPACK_COLUMN, XmNnumColumns, 3, NULL);
  XtVaSetValues(modeRadio,XmNx,35,XmNy,0,XmNradioBehavior,True,
    XmNradioAlwaysOne,True,NULL);

  gridTogglePreset=XtVaCreateManagedWidget("gridTogglePreset",
    xmToggleButtonWidgetClass,modeRadio,NULL);
  text=XmStringCreateLocalized("Preset   ");
  XtVaSetValues(gridTogglePreset,XmNlabelString,text,XmNset,True,NULL);
  XtAddCallback(gridTogglePreset,XmNvalueChangedCallback, PreGrid,NULL);

  gridToggleUser=XtVaCreateManagedWidget("gridToggleUser",
    xmToggleButtonWidgetClass,modeRadio,NULL);
  text=XmStringCreateLocalized("User");
  XtVaSetValues(gridToggleUser,XmNlabelString,text,NULL);
  XtAddCallback(gridToggleUser,XmNvalueChangedCallback, UsrGrid,NULL);

  freqfile=XtVaCreateManagedWidget("freqfile",
    xmToggleButtonWidgetClass,modeRadio,NULL);
  text=XmStringCreateLocalized("File");
  XtVaSetValues(freqfile,XmNlabelString,text,NULL);


 pgSepar0=XtVaCreateManagedWidget("pgSepar0", xmSeparatorWidgetClass,
    gridForm, XmNorientation, XmHORIZONTAL, XmNy, 43, XmNwidth, gsw, NULL);

  gridTextfield=XtVaCreateManagedWidget("gridTextfield",
    xmTextFieldWidgetClass,gridForm,NULL);
#ifdef SGI
  XtVaSetValues(gridTextfield,XmNwidth,110,XmNx,195,XmNy,48,
    XmNvalue,"C3",NULL);
#else
  XtVaSetValues(gridTextfield,XmNwidth,80,XmNx,190,XmNy,48,
    XmNvalue,"C3",NULL);
#endif

  gridLabel1=XtVaCreateManagedWidget("gridLabel1",xmLabelWidgetClass,
    gridForm,NULL);
  text=XmStringCreateLocalized("Starting Frequency/Pitch:");
  XtVaSetValues(gridLabel1,XmNlabelString,text,XmNx,0,XmNy,55,NULL);

 pgSepar1=XtVaCreateManagedWidget("pgSepar1", xmSeparatorWidgetClass,
    gridForm, XmNorientation, XmHORIZONTAL, XmNy, 83, XmNwidth, gsw, NULL);


  premode=XtVaCreateManagedWidget(
    "premode",xmLabelWidgetClass,gridForm,NULL);
  text=XmStringCreateLocalized("Preset Modes");
  XtVaSetValues(premode,XmNlabelString,text,XmNy,90,NULL);


 gridLabelMode=XtVaCreateManagedWidget("gridLabelMode",xmLabelWidgetClass,
    gridForm,NULL);
  text=XmStringCreateLocalized("Mode/Degree");
  XtVaSetValues(gridLabelMode,XmNlabelString,text,XmNx,90,XmNy,115,NULL);

  gridTextfield2=XtVaCreateManagedWidget("gridTextfield2",
    xmTextFieldWidgetClass,gridForm,NULL);
#ifdef SGI
  XtVaSetValues(gridTextfield2,XmNwidth,110,XmNx,195,XmNy,135,
    XmNvalue,"major",NULL);
#else
  XtVaSetValues(gridTextfield2,XmNwidth,80,XmNx,190,XmNy,135,
    XmNvalue,"major",NULL);
#endif

 gridLT=XtVaCreateManagedWidget("gridLT", xmRowColumnWidgetClass,gridForm,NULL);


lt_mode=XmStringCreateLocalized(":");	
first=XmStringCreateLocalized("First");
second=XmStringCreateLocalized("Second");
third=XmStringCreateLocalized("Third");
fourth=XmStringCreateLocalized("Fourth");
fifth=XmStringCreateLocalized("Fifth");
sixth=XmStringCreateLocalized("Sixth");
seventh=XmStringCreateLocalized("Seventh  ");

 gridLTOption=XmVaCreateSimpleOptionMenu(gridLT,"gridLTOption",lt_mode,';', 0,LTOption,
	XmVaPUSHBUTTON,first, NULL,NULL,NULL,
	XmVaPUSHBUTTON,second, NULL,NULL,NULL,
	XmVaPUSHBUTTON,third, NULL,NULL,NULL,
	XmVaPUSHBUTTON,fourth, NULL,NULL,NULL,
	XmVaPUSHBUTTON,fifth, NULL,NULL,NULL,
	XmVaPUSHBUTTON,sixth, NULL,NULL,NULL,
	XmVaPUSHBUTTON,seventh, NULL,NULL,NULL,
	NULL);

XmStringFree(first); XmStringFree(second);XmStringFree(third);XmStringFree(fourth);
XmStringFree(fifth);XmStringFree(sixth);XmStringFree(seventh);XmStringFree(lt_mode);

XtManageChild(gridLTOption);
#ifdef SGI
  XtVaSetValues(gridLT,XmNx,175,XmNy,255,NULL);
#else
  XtVaSetValues(gridLT,XmNx,165,XmNy,248,NULL);
#endif

gridHS=XtVaCreateManagedWidget("gridHS", xmRowColumnWidgetClass,gridForm,NULL);
 hs_mode=XmStringCreateLocalized(":");
 all=XmStringCreateLocalized("All");		
 even=XmStringCreateLocalized("Even");
 odd=XmStringCreateLocalized("Odd");
 prime=XmStringCreateLocalized("Prime     ");
 nonprime=XmStringCreateLocalized("Nonprime");

gridHSOption=XmVaCreateSimpleOptionMenu(gridHS,"gridHSOption",hs_mode,';', 0,HSOption,
	XmVaPUSHBUTTON,all, NULL,NULL,NULL,
	XmVaPUSHBUTTON,even, NULL,NULL,NULL,
	XmVaPUSHBUTTON,odd, NULL,NULL,NULL,
	XmVaPUSHBUTTON,prime, NULL,NULL,NULL,
	XmVaPUSHBUTTON,nonprime, NULL,NULL,NULL,
	NULL);


XmStringFree(all); XmStringFree(even);XmStringFree(odd);XmStringFree(prime);
XmStringFree(nonprime);XmStringFree(hs_mode);
XtManageChild(gridHSOption);
#ifdef SGI
   XtVaSetValues(gridHS,XmNx,175,XmNy,285,NULL);
#else
   XtVaSetValues(gridHS,XmNx,165,XmNy,282,NULL);
#endif
  gridRadio=XtVaCreateManagedWidget("gridRadio",
    xmRowColumnWidgetClass,gridForm,NULL);

  XtVaSetValues(gridRadio,XmNx,20,XmNy,135,XmNsensitive, pre_grid,
    XmNradioBehavior,True,XmNradioAlwaysOne,True, NULL);

  gridToggleMajor=XtVaCreateManagedWidget("gridToggleMajor",
    xmToggleButtonWidgetClass,gridRadio,NULL);
  text=XmStringCreateLocalized("Traditional Modes:");
  XtVaSetValues(gridToggleMajor,XmNlabelString,text,XmNset,True,NULL);

  gridToggleMinor=XtVaCreateManagedWidget("gridToggleMinor",
    xmToggleButtonWidgetClass,gridRadio,NULL);
  text=XmStringCreateLocalized("Harmonic Minor");
  XtVaSetValues(gridToggleMinor,XmNlabelString,text,NULL);

  gridToggleAltd=XtVaCreateManagedWidget("gridToggleAltd",
    xmToggleButtonWidgetClass,gridRadio,NULL);
  text=XmStringCreateLocalized("Heptatonic Altered:");
  XtVaSetValues(gridToggleAltd,XmNlabelString,text,NULL);


  gridTogglePenta=XtVaCreateManagedWidget("gridTogglePenta",
    xmToggleButtonWidgetClass,gridRadio,NULL);
  text=XmStringCreateLocalized("Pentatonic Modes:");
  XtVaSetValues(gridTogglePenta,XmNlabelString,text,NULL);

  gridToggleMLT=XtVaCreateManagedWidget("gridToggleMLT",
    xmToggleButtonWidgetClass,gridRadio,NULL);
  text=XmStringCreateLocalized("Lim. Transposition");
  XtVaSetValues(gridToggleMLT,XmNlabelString,text,NULL);


  gridToggleHarm=XtVaCreateManagedWidget("gridToggleHarm",
    xmToggleButtonWidgetClass,gridRadio,NULL);
  text=XmStringCreateLocalized("Harmonic Series");
  XtVaSetValues(gridToggleHarm,XmNlabelString,text,NULL);


 pgSepar=XtVaCreateManagedWidget("pgSepar", xmSeparatorWidgetClass,
    gridForm, XmNorientation, XmHORIZONTAL, XmNy, 325, XmNwidth, gsw, NULL);

  usermode=XtVaCreateManagedWidget(
    "usermode",xmLabelWidgetClass,gridForm,NULL);
  text=XmStringCreateLocalized("User Defined Eq. Temp. Intervals");
  XtVaSetValues(usermode,XmNlabelString,text,XmNy,327,NULL);


  gridRadio2=XtVaCreateManagedWidget("gridRadio2",xmRowColumnWidgetClass,gridForm,
	XmNpacking, XmPACK_COLUMN, XmNnumColumns, 4, NULL);
  XtVaSetValues(gridRadio2,XmNx,45,XmNy,350,XmNradioBehavior,False,
    /*XmNradioAlwaysOne,True,*/NULL);

 _1=XtVaCreateManagedWidget("_1",
    xmToggleButtonWidgetClass,gridRadio2,NULL);
  text=XmStringCreateLocalized("1");
  XtVaSetValues(_1,XmNlabelString,text,XmNsensitive, usr_grid,XmNset,True,NULL);

 _m2=XtVaCreateManagedWidget("_m2",
    xmToggleButtonWidgetClass,gridRadio2,NULL);
  text=XmStringCreateLocalized("m2");
  XtVaSetValues(_m2,XmNlabelString,text,XmNsensitive, usr_grid,NULL);

 _M2=XtVaCreateManagedWidget("_M2",
    xmToggleButtonWidgetClass,gridRadio2,NULL);
  text=XmStringCreateLocalized("M2");
  XtVaSetValues(_M2,XmNlabelString,text,XmNsensitive, usr_grid,NULL);

 _m3=XtVaCreateManagedWidget("_m3",
    xmToggleButtonWidgetClass,gridRadio2,NULL);
  text=XmStringCreateLocalized("m3");
  XtVaSetValues(_m3,XmNlabelString,text,XmNsensitive, usr_grid,NULL);

 _M3=XtVaCreateManagedWidget("_M3",
    xmToggleButtonWidgetClass,gridRadio2,NULL);
  text=XmStringCreateLocalized("M3");
  XtVaSetValues(_M3,XmNlabelString,text,XmNsensitive, usr_grid,NULL);

 _p4=XtVaCreateManagedWidget("_p4",
    xmToggleButtonWidgetClass,gridRadio2,NULL);
  text=XmStringCreateLocalized("p4");
  XtVaSetValues(_p4,XmNlabelString,text,XmNsensitive, usr_grid,NULL);

 _A4=XtVaCreateManagedWidget("_A4",
    xmToggleButtonWidgetClass,gridRadio2,NULL);
  text=XmStringCreateLocalized("#4");
  XtVaSetValues(_A4,XmNlabelString,text,XmNsensitive, usr_grid,NULL);

 _p5=XtVaCreateManagedWidget("_p5",
    xmToggleButtonWidgetClass,gridRadio2,NULL);
  text=XmStringCreateLocalized("p5");
  XtVaSetValues(_p5,XmNlabelString,text,XmNsensitive, usr_grid,NULL);

 _m6=XtVaCreateManagedWidget("_m6",
    xmToggleButtonWidgetClass,gridRadio2,NULL);
  text=XmStringCreateLocalized("m6");
  XtVaSetValues(_m6,XmNlabelString,text,XmNsensitive, usr_grid,NULL);

 _M6=XtVaCreateManagedWidget("_M6",
    xmToggleButtonWidgetClass,gridRadio2,NULL);
  text=XmStringCreateLocalized("M6");
  XtVaSetValues(_M6,XmNlabelString,text,XmNsensitive, usr_grid,NULL);

 _m7=XtVaCreateManagedWidget("_m7",
    xmToggleButtonWidgetClass,gridRadio2,NULL);
  text=XmStringCreateLocalized("m7");
  XtVaSetValues(_m7,XmNlabelString,text,XmNsensitive, usr_grid,NULL);

 _M7=XtVaCreateManagedWidget("_M7",
    xmToggleButtonWidgetClass,gridRadio2,NULL);
  text=XmStringCreateLocalized("M7");
  XtVaSetValues(_M7,XmNlabelString,text,XmNsensitive, usr_grid,NULL);

 pgSepar2=XtVaCreateManagedWidget("pgSepar2", xmSeparatorWidgetClass,
    gridForm, XmNorientation, XmHORIZONTAL, XmNy, 448, XmNwidth, gsw, NULL);

 
filemode=XtVaCreateManagedWidget(
    "filemode",xmLabelWidgetClass,gridForm,NULL);
  text=XmStringCreateLocalized("File Options");
  XtVaSetValues(filemode,XmNlabelString,text,XmNy,450,NULL);


  gridFileToggle=XtVaCreateManagedWidget("gridFileToggle",
    xmToggleButtonWidgetClass,gridForm,NULL);
  text=XmStringCreateLocalized("multiply frequencies");
  XtVaSetValues(gridFileToggle,XmNlabelString,text,XmNx,25,XmNy,470,NULL);

 gridM=XtVaCreateManagedWidget("gridM", xmRowColumnWidgetClass,gridForm,NULL);

 m_mode=XmStringCreateLocalized("on");
 trit=XmStringCreateLocalized("tritone");		
 oct=XmStringCreateLocalized("octave");
 twelfth=XmStringCreateLocalized("12-th");
 twoct=XmStringCreateLocalized("dbl.oct.");


gridMOption=XmVaCreateSimpleOptionMenu(gridM,"gridMOption",m_mode,':', 0,multOption,
	XmVaPUSHBUTTON,trit, NULL,NULL,NULL,
        XmVaPUSHBUTTON,oct, NULL,NULL,NULL,
	XmVaPUSHBUTTON,twelfth, NULL,NULL,NULL,
	XmVaPUSHBUTTON,twoct, NULL,NULL,NULL,
	NULL);

XmStringFree(m_mode); XmStringFree(trit);XmStringFree(oct);XmStringFree(twelfth);
XmStringFree(twoct);
XtManageChild(gridMOption);
#ifdef SGI
   XtVaSetValues(gridM,XmNx,175,XmNy,465,NULL);
#else
   XtVaSetValues(gridM,XmNx,165,XmNy,462,NULL); 
#endif
 pgSepar3=XtVaCreateManagedWidget("pgSepar3", xmSeparatorWidgetClass,
    gridForm, XmNorientation, XmHORIZONTAL, XmNy, 505, XmNwidth, gsw, NULL);

  
 /*_______________ CREATE LOAD FREQUENCIES FILE BOX___________________ */
  freqFileBox=XmCreateFileSelectionDialog(mainWindow,"freqFileBox",NULL,0);
  temp=XmFileSelectionBoxGetChild(freqFileBox,XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(temp);
  text=XmStringCreateSimple("Load pitch grid frequencies file");
  XtVaSetValues(freqFileBox,XmNdialogTitle,text,
    XmNwidth,500,NULL);
  XtAddCallback(freqFileBox,XmNcancelCallback,Cancel,freqFileBox);
  XtAddCallback(freqFileBox,XmNokCallback,FreqfileOk,NULL);
/*
  XtAddCallback(freqfile,XmNactivateCallback,PGFreqfile,NULL);
*/
/*This not particularly useful code removed in .26d10 because it
 *generated a harmless but annoying:
 *	Warning: Cannot find callback list in XtAddCallback
 * * */


  text=XmStringCreateLocalized("Pitch grid settings");
  XtVaSetValues(gridForm,XmNdialogTitle,text,
    XmNcancelButton,gridCancelButton,XmNdefaultButton,gridOkButton,NULL);

  XtAddCallback(gridButton,XmNactivateCallback,Gridmenu,0);
  XtAddCallback(gridOkButton,XmNactivateCallback,GridmenuOk,0);
 

  /*______________________CREATE PROGRESS BOX_________________________*/  
  progressBox=XmCreateWorkingDialog(mainWindow,"progressBox",NULL,0);
  temp=XmMessageBoxGetChild(progressBox,XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(temp);
  temp=XmMessageBoxGetChild(progressBox,XmDIALOG_OK_BUTTON);
  XtUnmanageChild(temp);
  temp=XmMessageBoxGetChild(progressBox,XmDIALOG_CANCEL_BUTTON);
  XtUnmanageChild(temp);

  text=XmStringCreateLocalized("...Processing...");
  XtVaSetValues(progressBox,XmNmessageString,text,NULL,NULL);

  XtSetArg(args[nargs], XmNvalue, 0); nargs++;
  XtSetArg(args[nargs], XmNorientation, XmHORIZONTAL); nargs++;
  progressBar = XmCreateScale(progressBox, "progressBar", args, nargs);
  XtManageChild(progressBar);

printf(". ");
  /*_____________________ CREATE HELP THINGS__________________________ */
  helpButton=XtVaCreateManagedWidget(
    "helpButton",xmCascadeButtonWidgetClass,menuBar,
	XmNmnemonic,XStringToKeysym("H"),NULL);
  text=XmStringCreateLocalized("Help");
  XtVaSetValues(helpButton,XmNlabelString,text,NULL);
  helpMenu=XmCreatePulldownMenu(menuBar,"helpMenu",NULL,0); 
  XtVaSetValues(helpButton,XmNsubMenuId,helpMenu,NULL);
  XtVaSetValues(menuBar,XmNmenuHelpWidget,helpButton,NULL);


/*
  help=XtVaCreateManagedWidget(
    "helpMenu",xmPushButtonWidgetClass,helpMenu,NULL);
*/
  aboutButton=XtVaCreateManagedWidget(
    "aboutButton",xmPushButtonWidgetClass,helpMenu,NULL);
  text=XmStringCreateLocalized("About...");
  XtVaSetValues(aboutButton,XmNlabelString,text,NULL);  
  XtVaSetValues(helpButton,XmNsubMenuId,helpMenu,NULL);


  aboutBox=XmCreateInformationDialog(mainWindow,"aboutBox",NULL,0);
  temp=XmMessageBoxGetChild(aboutBox,XmDIALOG_CANCEL_BUTTON);
  XtUnmanageChild(temp);
  temp=XmMessageBoxGetChild(aboutBox,XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(temp);

  text=XmStringCreateSimple("About CERES3:");
  XtVaSetValues(aboutBox,XmNdialogTitle,text,XmNwidth,250,NULL);

  helptext=XmStringCreateLtoR(
#ifdef SGI
    "Application name:     ceres3\n\
App-defaults file:     Ceres3\n\
HelpFile:About_Ceres3.html\n\
Version:                    0.27a18",
  "XmFONTLIST_DEFAULT_TAG"
#else
    "Application name:      ceres3\n\
App-defaults file:     Ceres3\n\
HelpFile:   About_Ceres3.html\n\
Version:               0.27a18",
  "XmFONTLIST_DEFAULT_TAG"
#endif
  );


  XtVaSetValues(aboutBox,XmNmessageString,helptext,NULL);
  XmStringFree(helptext);
XtAddCallback(aboutBox,XmNokCallback,InfoOk,NULL);
XtAddCallback(aboutButton,XmNactivateCallback,ShowInfo,0);

helpSepar = XtVaCreateManagedWidget("helpSepar", xmSeparatorWidgetClass,
  helpMenu, XmNorientation, XmHORIZONTAL, XmNy, 35, XmNwidth, 110, NULL);

creditsButton=XtVaCreateManagedWidget(
    "creditsButton",xmPushButtonWidgetClass,helpMenu,NULL);
  text=XmStringCreateLocalized("Credits...");
  XtVaSetValues(creditsButton,XmNlabelString,text,NULL);  
 /* XtVaSetValues(helpButton,XmNsubMenuId,helpMenu,NULL);*/


  creditsBox=XmCreateInformationDialog(mainWindow,"creditsBox",NULL,0);
  temp=XmMessageBoxGetChild(creditsBox,XmDIALOG_CANCEL_BUTTON);
  XtUnmanageChild(temp);
  temp=XmMessageBoxGetChild(creditsBox,XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(temp);

  text=XmStringCreateSimple("CERES3 Credits:");
  XtVaSetValues(creditsBox,XmNdialogTitle,text,XmNwidth,410,NULL);

  helptext=XmStringCreateLtoR(
    "CERES3 is based on CERES & CERES2 programs:\n\
        Stanko Juzbasic 2003\n\
Please send comments: stanko.juzbasic@zg.tel.hr\n\n\
CERES is a graphical sound editor working in\n\
the frequency domain.\n\
The phase vocoder core is based on code from\n\
F. Richard Moore: Elements of Computer Music\n\
        Version 0.05,    Oyvind Hammer 1995\n\
Please send comments to: oyvindha@notam.uio.no.\n\n\
CERES2 contains modifications done at the\n\
Columbia University Computer Music Center\n\
        Version 0.13,    Johnathan F. Lee 1997-8\n\
Please send comments to: jlee@music.columbia.edu\
","XmFONTLIST_DEFAULT_TAG");

  XtVaSetValues(creditsBox,XmNmessageString,helptext,NULL);
  XmStringFree(helptext);
XtAddCallback(creditsBox,XmNokCallback,CreditsOk,NULL);
XtAddCallback(creditsButton,XmNactivateCallback,ShowCredits,0);

/*
introHelpButton=XtVaCreateManagedWidget(
  "introHelpButton",xmPushButtonWidgetClass,helpMenu,NULL);
  text=XmStringCreateLocalized("CERES3 Help");
  XtVaSetValues(introHelpButton,XmNlabelString,text,NULL);  
  XtVaSetValues(introHelpButton,XmNsubMenuId,helpMenu,NULL);
  XtAddCallback(introHelpButton,XmNactivateCallback,ShowHelp,0);
*/
oldN = N; oldNw = Nw;


#ifdef SGI

  flush_all_underflows_to_zero();
#endif

  XtRealizeWidget(topLevel);
/*  if( N == 0 )N = GetFFTfromMenu();*/

printf(".\ndone\n");
if(sketchpad != (Widget)NULL){
  sethotcolors();
  RedrawWin();
  }else{
#ifndef SGI
  XtVaSetValues(mainWindow,XmNwidth, 400, XmNheight, 30,NULL);
  pointCur = XCreateFontCursor(XtDisplay(topLevel), XC_left_ptr);
  XDefineCursor(XtDisplay(topLevel),XtWindow(topLevel),pointCur);
  XRecolorCursor( XtDisplay(topLevel), pointCur, &red, &gray100 );
#endif  
  ResetCursor(topLevel);
  XmUpdateDisplay(topLevel);
  }
  
  
  
  printf("Generating default ");
  makemajor((Widget)NULL, (XtPointer)NULL, (XtPointer)NULL);
  if(argv[4] == NULL)  oldwidth = thewidth;
  makewindows(Wanal,  Wsyn,  Nw,  N,  I);
  XtAppMainLoop(app_context);
}

/* source code for Ceres3 written in Nedit
 * compiled on sgi O2 Irix 6.5 w. gcc
 * compiled on sgi O2 Irix 6.5 w. cc
 * compiled on PowerMac 7200 LinuxPPC w. gcc
 * compiled on P3 RedHatLinux w. egcs
 * compiled on PowerBookG4 MacOSX w. gcc3.3
 * GUI on sgi - Enhanced Motif 1.2.4 & 2.1
 * GUI on LinuxPPC - Motif 2.1.30
 * GUI on RedHatLinux - Motif - 2.1.30
 * GUI on MacOSX - Motif -2.2 and Apple X11
 * */
