/* lsystem2.c -- simple L-system application w/ button to start
 *
 * BGG
*/

#include <Xm/Xm.h>
#include <Xm/BulletinB.h>
#include <Xm/DrawingA.h>
#include <Xm/PushB.h>

#include <stdio.h>

#include "RTsockfuncs.h"

int theSock;
int RTpid;

Widget theDraw, topLevel;
Widget bboard, gobutton,findbutton;

GC gc;

XtAppContext app;

int checkx, checky;
int recurse_levels = 7;

main(argc,argv)
int argc;
char *argv[];
{
	XmString text;
	void GoDraw();
	void GoFind();

	/* start up the instrument */
	RTpid = RTopensocket(0, "CMIX");
	sleep(3); /* allow the process time to start */

	/* open up the socket */
	theSock = RTsock("localhost", 0);

	/* set up the instrument */
	RTsendsock("rtsetparams", theSock, 3, 22050.0, 1.0, 128.0);
	RTsendsock("load", theSock, 1, "WAVETABLE");
	RTsendsock("makegen", theSock, 7, 1.0, 24.0, 1000.0, 0.0, 1.0, 1.0, 0.0);
	RTsendsock("makegen", theSock, 8, 2.0, 10.0, 1000.0, 1.0, 0.1, 0.3, 0.02, 0.1);
	RTsendsock("print_off", theSock, 0);


	/* now do the window stuff */
	topLevel=XtVaAppInitialize(&app,"Lsystem2",
		NULL,0,&argc,argv,NULL,NULL);

	/* set up the main window */
	bboard = XtVaCreateManagedWidget("bboard",
		xmBulletinBoardWidgetClass, topLevel,
		XmNwidth, 1000, XmNheight, 700, 
		XmNmarginWidth, 0, XmNmarginHeight, 0,NULL);

	/* set up the "graphics context */
	gc = XCreateGC(XtDisplay(bboard),
		RootWindowOfScreen(XtScreen(bboard)), 0, NULL);

	/* set up the drawing area in the main window */
	theDraw = XtVaCreateManagedWidget("theDraw",
		xmDrawingAreaWidgetClass, bboard,
		XmNwidth, 1000, XmNheight, 500,
		XmNbackground, WhitePixelOfScreen(XtScreen(bboard)), NULL);

	/* set up the go button */
	text = XmStringCreateSimple("realize!");
	gobutton = XtVaCreateManagedWidget("gobutton",
		xmPushButtonWidgetClass, bboard,
		XmNlabelString, text,
		XmNx, 100, XmNy, 600, NULL);
	XtAddCallback(gobutton, XmNactivateCallback, GoDraw, NULL);

	/* set up the find button */
	text = XmStringCreateSimple("find!");
	findbutton = XtVaCreateManagedWidget("findbutton",
		xmPushButtonWidgetClass, bboard,
		XmNlabelString, text,
		XmNx, 300, XmNy, 600, NULL);
	XtAddCallback(findbutton, XmNactivateCallback, GoFind, NULL);

	XtManageChild(bboard);
	XtManageChild(theDraw);
	XtRealizeWidget(topLevel);

	XtAppMainLoop(app);
}


void GoDraw(w, client, call)
Widget w;
XtPointer client, call;
{
	int x, y, length;
	void recurse(int,int,int,int);

	x = 0;
	y = 250;
	length = 1000/3;

	/* draw the initial segment */
	XSetForeground(XtDisplay(theDraw), gc, BlackPixelOfScreen(XtScreen(bboard)) );
	XDrawLine(XtDisplay(theDraw), XtWindow(theDraw), gc, x, y, length/4, y);

	recurse(x+(length/4), y, length-50, recurse_levels-1);
}

void recurse(int x, int y, int length, int rlevel)
{
	if (rlevel == 0) return;


	XSetForeground(XtDisplay(theDraw), gc, BlackPixelOfScreen(XtScreen(bboard)) );
	XDrawLine(XtDisplay(theDraw), XtWindow(theDraw), gc, x, y, x+length, y-49);
	XDrawLine(XtDisplay(theDraw), XtWindow(theDraw), gc, x, y, x+length, y+15);
	XDrawLine(XtDisplay(theDraw), XtWindow(theDraw), gc, x, y, x+length/2, y+34);

	recurse(x+length, y-49, length-30, rlevel-1);
	recurse(x+length, y+15, length-15, rlevel-1);
	recurse(x+length/2, y+34, length/2, rlevel-1);
}

void GoFind(w, client, call)
Widget w;
XtPointer client, call;
{
	void doslices();

	checkx = 0;
	checky = 0;
	RTtimeit(0.11, doslices);
}

void doslices()
{
	XImage *xi;
	unsigned long pval;
	int i,y;
	int pvalcounter;
	float pitches[14] = { 8.00, 8.07, 7.10, 7.05, 8.03, 7.00, 9.07, 8.02, 6.03, 9.10, 6.00, 10.02, 5.08, 10.05 };

	xi = XGetImage(XtDisplay(theDraw), XtWindow(theDraw),
		checkx+10,checky, 1,30, AllPlanes, XYPixmap);

	pvalcounter = 0;
	for (y = 1; y < 29; y++) {
		pval = XGetPixel(xi, 0, y);
		if (pval == 0) {
			pvalcounter++;
		}
	}

	if (pvalcounter > 14) pvalcounter = 14;
	for (i = 0; i < pvalcounter; i++) {
		RTsendsock("WAVETABLE", theSock, 4, 0.0, 0.1, 1000.0,
				pitches[i]);
	}


	XSetForeground(XtDisplay(theDraw), gc, BlackPixelOfScreen(XtScreen(bboard)) );
	XDrawRectangle(XtDisplay(theDraw), XtWindow(theDraw), gc, checkx, checky, 15, 30);

	checky += 30;
	if (checky > 470) {
		checky = 0;
		checkx += 15;
	}
	if (checkx > 969) checkx = 0;

	XFlush(XtDisplay(theDraw));
}
