/* lsystem1.c -- simple L-system application w/ button to start
 *
 * BGG
*/

#include <Xm/Xm.h>
#include <Xm/BulletinB.h>
#include <Xm/DrawingA.h>
#include <Xm/PushB.h>

#include <stdio.h>

#include "RTsockfuncs.h"

int theSock;
int RTpid;

Widget theDraw, topLevel;
Widget bboard, gobutton,findbutton;

GC gc;

XtAppContext app;

int checkx, checky;
int recurse_levels = 7;

main(argc,argv)
int argc;
char *argv[];
{
	XmString text;
	void GoDraw();
	void GoFind();

	/* start up the instrument */
	RTpid = RTopensocket(0, "CMIX");
	sleep(3); /* allow the process time to start */

	/* open up the socket */
	theSock = RTsock("localhost", 0);

	/* set up the instrument */
	RTsendsock("rtsetparams", theSock, 2, 22050.0, 1.0);
	RTsendsock("load", theSock, 1, "WAVETABLE");
	RTsendsock("makegen", theSock, 9, 1.0, 24.0, 1000.0, 0.0, 0.0, 1.0, 1.0, 2.0, 0.0);
	RTsendsock("makegen", theSock, 4, 2.0, 10.0, 1000.0, 1.0);
//	RTsendsock("rtoutput", theSock, 1, "soundfile");
	RTsendsock("print_off", theSock, 0);


	/* now do the window stuff */
	topLevel=XtVaAppInitialize(&app,"Lsystem1",
		NULL,0,&argc,argv,NULL,NULL);

	/* set up the main window */
	bboard = XtVaCreateManagedWidget("bboard",
		xmBulletinBoardWidgetClass, topLevel,
		XmNwidth, 1000, XmNheight, 700, 
		XmNmarginWidth, 0, XmNmarginHeight, 0,NULL);

	/* set up the "graphics context */
	gc = XCreateGC(XtDisplay(bboard),
		RootWindowOfScreen(XtScreen(bboard)), 0, NULL);

	/* set up the drawing area in the main window */
	theDraw = XtVaCreateManagedWidget("theDraw",
		xmDrawingAreaWidgetClass, bboard,
		XmNwidth, 1000, XmNheight, 500,
		XmNbackground, WhitePixelOfScreen(XtScreen(bboard)), NULL);

	/* set up the go button */
	text = XmStringCreateSimple("realize!");
	gobutton = XtVaCreateManagedWidget("gobutton",
		xmPushButtonWidgetClass, bboard,
		XmNlabelString, text,
		XmNx, 100, XmNy, 600, NULL);
	XtAddCallback(gobutton, XmNactivateCallback, GoDraw, NULL);

	/* set up the find button */
	text = XmStringCreateSimple("find!");
	findbutton = XtVaCreateManagedWidget("findbutton",
		xmPushButtonWidgetClass, bboard,
		XmNlabelString, text,
		XmNx, 300, XmNy, 600, NULL);
	XtAddCallback(findbutton, XmNactivateCallback, GoFind, NULL);

	XtManageChild(bboard);
	XtManageChild(theDraw);
	XtRealizeWidget(topLevel);

	XtAppMainLoop(app);
}


void GoDraw(w, client, call)
Widget w;
XtPointer client, call;
{
	int x, y, length;
	void recurse(int,int,int,int);

	x = 0;
	y = 250;
	length = 1000/4;

	/* draw the initial segment */
	XSetForeground(XtDisplay(theDraw), gc, BlackPixelOfScreen(XtScreen(bboard)) );
	XDrawLine(XtDisplay(theDraw), XtWindow(theDraw), gc, x, y,
		length, y-20);

	recurse(x+length, y-20, length/2, recurse_levels-1);
}

void recurse(int x, int y, int length, int rlevel)
{
	if (rlevel == 0) return;


	XSetForeground(XtDisplay(theDraw), gc, BlackPixelOfScreen(XtScreen(bboard)) );
	XDrawLine(XtDisplay(theDraw), XtWindow(theDraw), gc, x, y-20, x+length, y+20);
	XDrawLine(XtDisplay(theDraw), XtWindow(theDraw), gc, x, y-20, x+length, y+30);
	XDrawLine(XtDisplay(theDraw), XtWindow(theDraw), gc, x, y-20, x+length-10, y-10);

	recurse(x+length, y+20-20, length-rlevel, rlevel-1);
	recurse(x+length, y+30-20, length/2, rlevel-1);
	recurse(x+length-10, y-10-20, length/2, rlevel-1);
}

void GoFind(w, client, call)
Widget w;
XtPointer client, call;
{
	void doslices();

	checkx = 0;
	RTtimeit(0.025, doslices);
}

void doslices()
{
	XImage *xi;
	unsigned long pval;

	xi = XGetImage(XtDisplay(theDraw), XtWindow(theDraw),
		checkx,0, 1,500, AllPlanes, XYPixmap);

	for (checky = 0; checky < 500; checky++) {
		pval = XGetPixel(xi, 0, checky);
		if (pval == 0) {
			RTsendsock("WAVETABLE", theSock, 4, 0.0, 0.04, 1000.0,
				(float)(500-checky + 100));
		}
	}

	if (++checkx > 999) {
		RTsendsock("end", theSock, 0);
		RTtimeit(0.0, doslices);
	}
}
