#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <errno.h>
#include <signal.h>
#include <sys/signal.h>
#include <sys/time.h>


#include "/usr/local/src/RTcmix-3.0.2/H/sockdefs.h"


/* RTsockfuncs.c - a set of utility functions for real-time cmix interface
   programming */

/* RTsock takes an internet hostname and the number of an RTcmix socket
   (specified by "... -s n" when invoking an instrument -- 0 is the default)
   and returns an open socket connection.  The RTcmix sockets count up from
   MYPORT (1102), defined in sockdefs.h */

int RTsock(char *ihost, int rtsno) {
	int s;
	struct sockaddr_in sss;
	struct hostent *hp;

	if( (s = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
		perror("socket");
		exit(1);
	}

	hp = gethostbyname(ihost);
	sss.sin_family = AF_INET;
	bcopy(hp->h_addr, &(sss.sin_addr.s_addr), hp->h_length);
	sss.sin_port = htons(MYPORT+rtsno);

	if(connect(s, (struct sockaddr *)&sss, sizeof(sss)) < 0) {
		perror("connect");
		exit(1);
	}
	return s;
}


/* RTopensocket - starts up the relevant cmix binary with the relevant socket 
   number (again counted up from MYPORT) and returns the process id of the
   relevant cmix process */

int RTopensocket(int socket, char *binaryname) {
	char syscall[60];
	char flags[30];
	char socknumber[10];
	char args[64];
	int pid;
	int s;
	struct sockaddr_in sss;
	struct hostent *hp;
	void parse();
	int execute();


	sprintf(syscall, "%s ", binaryname);
	sprintf(flags, "-i -n -s ");
	sprintf(socknumber, "%i", socket);
	strcat(syscall, flags);
	strcat(syscall, socknumber);
	strcat(syscall, " &");

	parse(syscall, args);
	pid = execute(args);
	printf("cmix process id is %i\n", pid);

	return(pid);
}


/* RTkillsocket closes the relevant cmix socket and kills off the relevant
   cmix process and its pid+1 child */

void RTkillsocket(int socket, int pid)
{
	char killcall[20];
	char process[5];

	close(socket);

	sprintf(killcall, "kill -9 ");
	sprintf(process, "%i", pid);
	strcat(killcall, process);
	system(killcall);
	sprintf(killcall, "kill -9 ");
	sprintf(process, "%i", pid+1);
	strcat(killcall, process);
	system(killcall);
}


/* RTsendsock takes an RTcmix scorefile command as the first arg, then
   the socket (returned by RTsock), the number of p-fields, and then
   the p-fields themselves (as doubles) */

void RTsendsock(const char *cmd, int theSock, int nargs, ...)
{
	va_list ap;
	struct sockdata ssend;
	int i;

	strcpy(ssend.name, cmd);

	va_start(ap, nargs);
	if ( (strcmp(ssend.name, "rtinput") == 0) || (strcmp(ssend.name, "rtoutput") == 0) || (strcmp(ssend.name, "load") == 0) ) {
		for (i = 0; i < nargs; i++) {
			strcpy(ssend.data.text[i], va_arg(ap, char*));
		}
	}
	else {
		for (i = 0; i < nargs; i++) {
			ssend.data.p[i] = va_arg(ap, double);
		}
	}
	va_end(ap);

	ssend.n_args = nargs;

	write(theSock, (char *)&ssend, sizeof(struct sockdata));
}


/* RTtimeit takes a floating point number of seconds (interval) and a pointer
   to a void-returning function and sets up a timer to call that function
   every interval seconds.  Setting interval to 0.0 should disable the
   timer */

void RTtimeit(float interval, void *func)
{
	struct timeval tv;
	struct itimerval itv;

	tv.tv_sec = (int)(interval);
	tv.tv_usec = (int)((interval - (float)tv.tv_sec) * 1000000.0);
	itv.it_interval = tv;
	itv.it_value = tv;
	setitimer(ITIMER_REAL, &itv, NULL);
	signal(SIGALRM, func);
}



void parse(buf, args)
char *buf;
char **args;
{
	while (*buf != NULL) {
		/* Strip whitespace.  Use nulls, so that the previous argument
		    is terminated automatically. */
		while ((*buf == ' ') || (*buf == '\t')) 
			*buf++ = NULL;

		/* Save the argument */
		*args++ = buf;

		/* Skip over the argument. */
		while ((*buf != NULL) && (*buf != ' ') && (*buf != '\t')) 
			buf++;
	}

	*args = NULL;
}


int execute(args)
char **args;
{
	int status;
	int pid;

	/* fork */
	if ((pid = fork()) < 0) {
		perror("fork");
		exit(1);
	}

	if (pid == 0) {
		execvp(*args, args);
		perror(*args);
		return(pid);
	}
}
